package software.amazon.awscdk.services.eks;

/**
 * Properties for `AlbController`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * AlbControllerVersion albControllerVersion;
 * Cluster cluster;
 * Object policy;
 * AlbControllerProps albControllerProps = AlbControllerProps.builder()
 *         .cluster(cluster)
 *         .version(albControllerVersion)
 *         // the properties below are optional
 *         .policy(policy)
 *         .repository("repository")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:54.964Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AlbControllerProps")
@software.amazon.jsii.Jsii.Proxy(AlbControllerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlbControllerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.eks.AlbControllerOptions {

    /**
     * [disable-awslint:ref-via-interface] Cluster to install the controller onto.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.Cluster getCluster();

    /**
     * @return a {@link Builder} of {@link AlbControllerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlbControllerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlbControllerProps> {
        software.amazon.awscdk.services.eks.Cluster cluster;
        software.amazon.awscdk.services.eks.AlbControllerVersion version;
        java.lang.Object policy;
        java.lang.String repository;

        /**
         * Sets the value of {@link AlbControllerProps#getCluster}
         * @param cluster [disable-awslint:ref-via-interface] Cluster to install the controller onto. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link AlbControllerProps#getVersion}
         * @param version Version of the controller. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(software.amazon.awscdk.services.eks.AlbControllerVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link AlbControllerProps#getPolicy}
         * @param policy The IAM policy to apply to the service account.
         *               If you're using one of the built-in versions, this is not required since
         *               CDK ships with the appropriate policies for those versions.
         *               <p>
         *               However, if you are using a custom version, this is required (and validated).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link AlbControllerProps#getRepository}
         * @param repository The repository to pull the controller image from.
         *                   Note that the default repository works for most regions, but not all.
         *                   If the repository is not applicable to your region, use a custom repository
         *                   according to the information here: https://github.com/kubernetes-sigs/aws-load-balancer-controller/releases.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(java.lang.String repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlbControllerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlbControllerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlbControllerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlbControllerProps {
        private final software.amazon.awscdk.services.eks.Cluster cluster;
        private final software.amazon.awscdk.services.eks.AlbControllerVersion version;
        private final java.lang.Object policy;
        private final java.lang.String repository;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.Cluster.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.policy = builder.policy;
            this.repository = builder.repository;
        }

        @Override
        public final software.amazon.awscdk.services.eks.Cluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AlbControllerVersion getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.String getRepository() {
            return this.repository;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRepository() != null) {
                data.set("repository", om.valueToTree(this.getRepository()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AlbControllerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlbControllerProps.Jsii$Proxy that = (AlbControllerProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!version.equals(that.version)) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            return this.repository != null ? this.repository.equals(that.repository) : that.repository == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
            return result;
        }
    }
}
