package software.amazon.awscdk.services.eks;

/**
 * Options for configuring an EKS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.eks.*;
 * import software.amazon.awscdk.services.iam.*;
 * KubernetesVersion kubernetesVersion;
 * Role role;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Vpc vpc;
 * CommonClusterOptions commonClusterOptions = CommonClusterOptions.builder()
 *         .version(kubernetesVersion)
 *         // the properties below are optional
 *         .clusterName("clusterName")
 *         .outputClusterName(false)
 *         .outputConfigCommand(false)
 *         .role(role)
 *         .securityGroup(securityGroup)
 *         .vpc(vpc)
 *         .vpcSubnets(List.of(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.008Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CommonClusterOptions")
@software.amazon.jsii.Jsii.Proxy(CommonClusterOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonClusterOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Kubernetes version to run in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesVersion getVersion();

    /**
     * Name for the cluster.
     * <p>
     * Default: - Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * Determines whether a CloudFormation output with the name of the cluster will be synthesized.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOutputClusterName() {
        return null;
    }

    /**
     * Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
     * <p>
     * This command will include
     * the cluster name and, if applicable, the ARN of the masters IAM role.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOutputConfigCommand() {
        return null;
    }

    /**
     * Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     * <p>
     * Default: - A role is automatically created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Security Group to use for Control Plane ENIs.
     * <p>
     * Default: - A security group is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * The VPC in which to create the Cluster.
     * <p>
     * Default: - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Where to place EKS Control Plane ENIs.
     * <p>
     * If you want to create public load balancers, this must include public subnets.
     * <p>
     * For example, to only select private subnets, supply the following:
     * <p>
     * <code>vpcSubnets: [{ subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS }]</code>
     * <p>
     * Default: - All public and private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonClusterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonClusterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonClusterOptions> {
        software.amazon.awscdk.services.eks.KubernetesVersion version;
        java.lang.String clusterName;
        java.lang.Boolean outputClusterName;
        java.lang.Boolean outputConfigCommand;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Sets the value of {@link CommonClusterOptions#getVersion}
         * @param version The Kubernetes version to run in the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(software.amazon.awscdk.services.eks.KubernetesVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link CommonClusterOptions#getClusterName}
         * @param clusterName Name for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CommonClusterOptions#getOutputClusterName}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputClusterName(java.lang.Boolean outputClusterName) {
            this.outputClusterName = outputClusterName;
            return this;
        }

        /**
         * Sets the value of {@link CommonClusterOptions#getOutputConfigCommand}
         * @param outputConfigCommand Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
         *                            This command will include
         *                            the cluster name and, if applicable, the ARN of the masters IAM role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConfigCommand(java.lang.Boolean outputConfigCommand) {
            this.outputConfigCommand = outputConfigCommand;
            return this;
        }

        /**
         * Sets the value of {@link CommonClusterOptions#getRole}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CommonClusterOptions#getSecurityGroup}
         * @param securityGroup Security Group to use for Control Plane ENIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link CommonClusterOptions#getVpc}
         * @param vpc The VPC in which to create the Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link CommonClusterOptions#getVpcSubnets}
         * @param vpcSubnets Where to place EKS Control Plane ENIs.
         *                   If you want to create public load balancers, this must include public subnets.
         *                   <p>
         *                   For example, to only select private subnets, supply the following:
         *                   <p>
         *                   <code>vpcSubnets: [{ subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS }]</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpcSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonClusterOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonClusterOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonClusterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonClusterOptions {
        private final software.amazon.awscdk.services.eks.KubernetesVersion version;
        private final java.lang.String clusterName;
        private final java.lang.Boolean outputClusterName;
        private final java.lang.Boolean outputConfigCommand;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputClusterName = software.amazon.jsii.Kernel.get(this, "outputClusterName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outputConfigCommand = software.amazon.jsii.Kernel.get(this, "outputConfigCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.clusterName = builder.clusterName;
            this.outputClusterName = builder.outputClusterName;
            this.outputConfigCommand = builder.outputConfigCommand;
            this.role = builder.role;
            this.securityGroup = builder.securityGroup;
            this.vpc = builder.vpc;
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.eks.KubernetesVersion getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Boolean getOutputClusterName() {
            return this.outputClusterName;
        }

        @Override
        public final java.lang.Boolean getOutputConfigCommand() {
            return this.outputConfigCommand;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getOutputClusterName() != null) {
                data.set("outputClusterName", om.valueToTree(this.getOutputClusterName()));
            }
            if (this.getOutputConfigCommand() != null) {
                data.set("outputConfigCommand", om.valueToTree(this.getOutputConfigCommand()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CommonClusterOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonClusterOptions.Jsii$Proxy that = (CommonClusterOptions.Jsii$Proxy) o;

            if (!version.equals(that.version)) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.outputClusterName != null ? !this.outputClusterName.equals(that.outputClusterName) : that.outputClusterName != null) return false;
            if (this.outputConfigCommand != null ? !this.outputConfigCommand.equals(that.outputConfigCommand) : that.outputConfigCommand != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.version.hashCode();
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.outputClusterName != null ? this.outputClusterName.hashCode() : 0);
            result = 31 * result + (this.outputConfigCommand != null ? this.outputConfigCommand.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
