package software.amazon.awscdk.services.eks;

/**
 * The AMI type for your node group.
 * <p>
 * GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type, which uses the
 * Amazon EKS-optimized Linux AMI with GPU support. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type, which
 * uses the Amazon EKS-optimized Linux AMI.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster = Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_21)
 *         .defaultCapacity(0)
 *         .build();
 * cluster.addNodegroupCapacity("custom-node-group", NodegroupOptions.builder()
 *         .instanceTypes(List.of(new InstanceType("m5.large")))
 *         .minSize(4)
 *         .diskSize(100)
 *         .amiType(NodegroupAmiType.AL2_X86_64_GPU)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.037Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.NodegroupAmiType")
public enum NodegroupAmiType {
    /**
     * Amazon Linux 2 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2_X86_64,
    /**
     * Amazon Linux 2 with GPU support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2_X86_64_GPU,
    /**
     * Amazon Linux 2 (ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AL2_ARM_64,
    /**
     * Bottlerocket Linux(ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET_ARM_64,
    /**
     * Bottlerocket(x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET_X86_64,
}
