/**
 * <h1>Amazon Elastic Load Balancing Construct Library</h1>
 * <p>
 * The <code>&#64;aws-cdk/aws-elasticloadbalancing</code> package provides constructs for configuring
 * classic load balancers.
 * <p>
 * <h2>Configuring a Load Balancer</h2>
 * <p>
 * Load balancers send traffic to one or more AutoScalingGroups. Create a load
 * balancer, set up listeners and a health check, and supply the fleet(s) you want
 * to load balance to in the <code>targets</code> property.
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * 
 * AutoScalingGroup myAutoScalingGroup;
 * 
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .healthCheck(HealthCheck.builder()
 *                 .port(80)
 *                 .build())
 *         .build();
 * lb.addTarget(myAutoScalingGroup);
 * lb.addListener(LoadBalancerListener.builder()
 *         .externalPort(80)
 *         .build());
 * </pre></blockquote>
 * <p>
 * The load balancer allows all connections by default. If you want to change that,
 * pass the <code>allowConnectionsFrom</code> property while setting up the listener:
 * <p>
 * <blockquote><pre>
 * SecurityGroup mySecurityGroup;
 * LoadBalancer lb;
 * 
 * lb.addListener(LoadBalancerListener.builder()
 *         .externalPort(80)
 *         .allowConnectionsFrom(List.of(mySecurityGroup))
 *         .build());
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.elasticloadbalancing;
