/**
 * <h1>Actions for AWS Elastic Load Balancing V2</h1>
 * <p>
 * This package contains integration actions for ELBv2. See the README of the <code>&#64;aws-cdk/aws-elasticloadbalancingv2</code> library.
 * <p>
 * <h2>Cognito</h2>
 * <p>
 * ELB allows for requests to be authenticated against a Cognito user pool using
 * the <code>AuthenticateCognitoAction</code>. For details on the setup's requirements,
 * read <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-authenticate-users.html#cognito-requirements">Prepare to use Amazon
 * Cognito</a>.
 * Here's an example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Object lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * 
 * Object userPool = new UserPool(this, "UserPool");
 * Object userPoolClient = UserPoolClient.Builder.create(this, "Client")
 *         .userPool(userPool)
 * 
 *         // Required minimal configuration for use with an ELB
 *         .generateSecret(true)
 *         .authFlows(Map.of(
 *                 "userPassword", true))
 *         .oAuth(Map.of(
 *                 "flows", Map.of(
 *                         "authorizationCodeGrant", true),
 *                 "scopes", List.of(cognito.getOAuthScope().getEMAIL()),
 *                 "callbackUrls", List.of(String.format("https://%s/oauth2/idpresponse", lb.getLoadBalancerDnsName()))))
 *         .build();
 * Object cfnClient = (Object)userPoolClient.getNode().getDefaultChild();
 * cfnClient.addPropertyOverride("RefreshTokenValidity", 1);
 * cfnClient.addPropertyOverride("SupportedIdentityProviders", List.of("COGNITO"));
 * 
 * Object userPoolDomain = UserPoolDomain.Builder.create(this, "Domain")
 *         .userPool(userPool)
 *         .cognitoDomain(Map.of(
 *                 "domainPrefix", "test-cdk-prefix"))
 *         .build();
 * 
 * lb.addListener("Listener", Map.of(
 *         "port", 443,
 *         "certificates", List.of(certificate),
 *         "defaultAction", AuthenticateCognitoAction.Builder.create()
 *                 .userPool(userPool)
 *                 .userPoolClient(userPoolClient)
 *                 .userPoolDomain(userPoolDomain)
 *                 .next(elbv2.ListenerAction.fixedResponse(200, Map.of(
 *                         "contentType", "text/plain",
 *                         "messageBody", "Authenticated")))
 *                 .build()));
 * 
 * CfnOutput.Builder.create(this, "DNS")
 *         .value(lb.getLoadBalancerDnsName())
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.elasticloadbalancingv2.actions;
