package software.amazon.awscdk.services.events;

/**
 * The event API Destination properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.apiKey("x-api-key", SecretValue.secretsManager("ApiSecretName")))
 *         .description("Connection with API Key x-api-key")
 *         .build();
 * ApiDestination destination = ApiDestination.Builder.create(this, "Destination")
 *         .connection(connection)
 *         .endpoint("https://example.com")
 *         .description("Calling example.com with API key x-api-key")
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.313Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.ApiDestinationProps")
@software.amazon.jsii.Jsii.Proxy(ApiDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the connection to use for the API destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IConnection getConnection();

    /**
     * The URL to the HTTP invocation endpoint for the API destination..
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

    /**
     * The name for the API destination.
     * <p>
     * Default: - A unique name will be generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiDestinationName() {
        return null;
    }

    /**
     * A description for the API destination.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The method to use for the request to the HTTP invocation endpoint.
     * <p>
     * Default: HttpMethod.POST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.HttpMethod getHttpMethod() {
        return null;
    }

    /**
     * The maximum number of requests per second to send to the HTTP invocation endpoint.
     * <p>
     * Default: - Not rate limited
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRateLimitPerSecond() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiDestinationProps> {
        software.amazon.awscdk.services.events.IConnection connection;
        java.lang.String endpoint;
        java.lang.String apiDestinationName;
        java.lang.String description;
        software.amazon.awscdk.services.events.HttpMethod httpMethod;
        java.lang.Number rateLimitPerSecond;

        /**
         * Sets the value of {@link ApiDestinationProps#getConnection}
         * @param connection The ARN of the connection to use for the API destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connection(software.amazon.awscdk.services.events.IConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getEndpoint}
         * @param endpoint The URL to the HTTP invocation endpoint for the API destination.. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getApiDestinationName}
         * @param apiDestinationName The name for the API destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiDestinationName(java.lang.String apiDestinationName) {
            this.apiDestinationName = apiDestinationName;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getDescription}
         * @param description A description for the API destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getHttpMethod}
         * @param httpMethod The method to use for the request to the HTTP invocation endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(software.amazon.awscdk.services.events.HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getRateLimitPerSecond}
         * @param rateLimitPerSecond The maximum number of requests per second to send to the HTTP invocation endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateLimitPerSecond(java.lang.Number rateLimitPerSecond) {
            this.rateLimitPerSecond = rateLimitPerSecond;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiDestinationProps {
        private final software.amazon.awscdk.services.events.IConnection connection;
        private final java.lang.String endpoint;
        private final java.lang.String apiDestinationName;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.events.HttpMethod httpMethod;
        private final java.lang.Number rateLimitPerSecond;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IConnection.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiDestinationName = software.amazon.jsii.Kernel.get(this, "apiDestinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpMethod.class));
            this.rateLimitPerSecond = software.amazon.jsii.Kernel.get(this, "rateLimitPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connection = java.util.Objects.requireNonNull(builder.connection, "connection is required");
            this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
            this.apiDestinationName = builder.apiDestinationName;
            this.description = builder.description;
            this.httpMethod = builder.httpMethod;
            this.rateLimitPerSecond = builder.rateLimitPerSecond;
        }

        @Override
        public final software.amazon.awscdk.services.events.IConnection getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.String getApiDestinationName() {
            return this.apiDestinationName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.events.HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.Number getRateLimitPerSecond() {
            return this.rateLimitPerSecond;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connection", om.valueToTree(this.getConnection()));
            data.set("endpoint", om.valueToTree(this.getEndpoint()));
            if (this.getApiDestinationName() != null) {
                data.set("apiDestinationName", om.valueToTree(this.getApiDestinationName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHttpMethod() != null) {
                data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            }
            if (this.getRateLimitPerSecond() != null) {
                data.set("rateLimitPerSecond", om.valueToTree(this.getRateLimitPerSecond()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.ApiDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiDestinationProps.Jsii$Proxy that = (ApiDestinationProps.Jsii$Proxy) o;

            if (!connection.equals(that.connection)) return false;
            if (!endpoint.equals(that.endpoint)) return false;
            if (this.apiDestinationName != null ? !this.apiDestinationName.equals(that.apiDestinationName) : that.apiDestinationName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
            return this.rateLimitPerSecond != null ? this.rateLimitPerSecond.equals(that.rateLimitPerSecond) : that.rateLimitPerSecond == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connection.hashCode();
            result = 31 * result + (this.endpoint.hashCode());
            result = 31 * result + (this.apiDestinationName != null ? this.apiDestinationName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
            result = 31 * result + (this.rateLimitPerSecond != null ? this.rateLimitPerSecond.hashCode() : 0);
            return result;
        }
    }
}
