package software.amazon.awscdk.services.fsx;

/**
 * Properties required for setting up a weekly maintenance time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * LustreMaintenanceTimeProps lustreMaintenanceTimeProps = LustreMaintenanceTimeProps.builder()
 *         .day(Weekday.MONDAY)
 *         .hour(123)
 *         .minute(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.520Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreMaintenanceTimeProps")
@software.amazon.jsii.Jsii.Proxy(LustreMaintenanceTimeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LustreMaintenanceTimeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The day of the week for maintenance to be performed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.Weekday getDay();

    /**
     * The hour of the day (from 0-24) for maintenance to be performed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getHour();

    /**
     * The minute of the hour (from 0-59) for maintenance to be performed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinute();

    /**
     * @return a {@link Builder} of {@link LustreMaintenanceTimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LustreMaintenanceTimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LustreMaintenanceTimeProps> {
        software.amazon.awscdk.services.fsx.Weekday day;
        java.lang.Number hour;
        java.lang.Number minute;

        /**
         * Sets the value of {@link LustreMaintenanceTimeProps#getDay}
         * @param day The day of the week for maintenance to be performed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder day(software.amazon.awscdk.services.fsx.Weekday day) {
            this.day = day;
            return this;
        }

        /**
         * Sets the value of {@link LustreMaintenanceTimeProps#getHour}
         * @param hour The hour of the day (from 0-24) for maintenance to be performed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hour(java.lang.Number hour) {
            this.hour = hour;
            return this;
        }

        /**
         * Sets the value of {@link LustreMaintenanceTimeProps#getMinute}
         * @param minute The minute of the hour (from 0-59) for maintenance to be performed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minute(java.lang.Number minute) {
            this.minute = minute;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LustreMaintenanceTimeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LustreMaintenanceTimeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LustreMaintenanceTimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LustreMaintenanceTimeProps {
        private final software.amazon.awscdk.services.fsx.Weekday day;
        private final java.lang.Number hour;
        private final java.lang.Number minute;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.day = software.amazon.jsii.Kernel.get(this, "day", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.Weekday.class));
            this.hour = software.amazon.jsii.Kernel.get(this, "hour", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minute = software.amazon.jsii.Kernel.get(this, "minute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.day = java.util.Objects.requireNonNull(builder.day, "day is required");
            this.hour = java.util.Objects.requireNonNull(builder.hour, "hour is required");
            this.minute = java.util.Objects.requireNonNull(builder.minute, "minute is required");
        }

        @Override
        public final software.amazon.awscdk.services.fsx.Weekday getDay() {
            return this.day;
        }

        @Override
        public final java.lang.Number getHour() {
            return this.hour;
        }

        @Override
        public final java.lang.Number getMinute() {
            return this.minute;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("day", om.valueToTree(this.getDay()));
            data.set("hour", om.valueToTree(this.getHour()));
            data.set("minute", om.valueToTree(this.getMinute()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.LustreMaintenanceTimeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LustreMaintenanceTimeProps.Jsii$Proxy that = (LustreMaintenanceTimeProps.Jsii$Proxy) o;

            if (!day.equals(that.day)) return false;
            if (!hour.equals(that.hour)) return false;
            return this.minute.equals(that.minute);
        }

        @Override
        public final int hashCode() {
            int result = this.day.hashCode();
            result = 31 * result + (this.hour.hashCode());
            result = 31 * result + (this.minute.hashCode());
            return result;
        }
    }
}
