package software.amazon.awscdk.services.globalaccelerator;

/**
 * Properties for RawEndpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.globalaccelerator.*;
 * RawEndpointProps rawEndpointProps = RawEndpointProps.builder()
 *         .endpointId("endpointId")
 *         // the properties below are optional
 *         .preserveClientIp(false)
 *         .region("region")
 *         .weight(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.578Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.RawEndpointProps")
@software.amazon.jsii.Jsii.Proxy(RawEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RawEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifier of the endpoint.
     * <p>
     * Load balancer ARN, instance ID or EIP allocation ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointId();

    /**
     * Forward the client IP address.
     * <p>
     * GlobalAccelerator will create Network Interfaces in your VPC in order
     * to preserve the client IP address.
     * <p>
     * Only applies to Application Load Balancers and EC2 instances.
     * <p>
     * Client IP address preservation is supported only in specific AWS Regions.
     * See the GlobalAccelerator Developer Guide for a list.
     * <p>
     * Default: true if possible and available
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreserveClientIp() {
        return null;
    }

    /**
     * The region where this endpoint is located.
     * <p>
     * Default: - Unknown what region this endpoint is located
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Endpoint weight across all endpoints in the group.
     * <p>
     * Must be a value between 0 and 255.
     * <p>
     * Default: 128
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RawEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RawEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RawEndpointProps> {
        java.lang.String endpointId;
        java.lang.Boolean preserveClientIp;
        java.lang.String region;
        java.lang.Number weight;

        /**
         * Sets the value of {@link RawEndpointProps#getEndpointId}
         * @param endpointId Identifier of the endpoint. This parameter is required.
         *                   Load balancer ARN, instance ID or EIP allocation ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointId(java.lang.String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        /**
         * Sets the value of {@link RawEndpointProps#getPreserveClientIp}
         * @param preserveClientIp Forward the client IP address.
         *                         GlobalAccelerator will create Network Interfaces in your VPC in order
         *                         to preserve the client IP address.
         *                         <p>
         *                         Only applies to Application Load Balancers and EC2 instances.
         *                         <p>
         *                         Client IP address preservation is supported only in specific AWS Regions.
         *                         See the GlobalAccelerator Developer Guide for a list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveClientIp(java.lang.Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
            return this;
        }

        /**
         * Sets the value of {@link RawEndpointProps#getRegion}
         * @param region The region where this endpoint is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link RawEndpointProps#getWeight}
         * @param weight Endpoint weight across all endpoints in the group.
         *               Must be a value between 0 and 255.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(java.lang.Number weight) {
            this.weight = weight;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RawEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RawEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RawEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RawEndpointProps {
        private final java.lang.String endpointId;
        private final java.lang.Boolean preserveClientIp;
        private final java.lang.String region;
        private final java.lang.Number weight;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpointId = software.amazon.jsii.Kernel.get(this, "endpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preserveClientIp = software.amazon.jsii.Kernel.get(this, "preserveClientIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpointId = java.util.Objects.requireNonNull(builder.endpointId, "endpointId is required");
            this.preserveClientIp = builder.preserveClientIp;
            this.region = builder.region;
            this.weight = builder.weight;
        }

        @Override
        public final java.lang.String getEndpointId() {
            return this.endpointId;
        }

        @Override
        public final java.lang.Boolean getPreserveClientIp() {
            return this.preserveClientIp;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.Number getWeight() {
            return this.weight;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpointId", om.valueToTree(this.getEndpointId()));
            if (this.getPreserveClientIp() != null) {
                data.set("preserveClientIp", om.valueToTree(this.getPreserveClientIp()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getWeight() != null) {
                data.set("weight", om.valueToTree(this.getWeight()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_globalaccelerator.RawEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RawEndpointProps.Jsii$Proxy that = (RawEndpointProps.Jsii$Proxy) o;

            if (!endpointId.equals(that.endpointId)) return false;
            if (this.preserveClientIp != null ? !this.preserveClientIp.equals(that.preserveClientIp) : that.preserveClientIp != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
        }

        @Override
        public final int hashCode() {
            int result = this.endpointId.hashCode();
            result = 31 * result + (this.preserveClientIp != null ? this.preserveClientIp.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
            return result;
        }
    }
}
