package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a `CfnLoggerDefinition`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object tags;
 * CfnLoggerDefinitionProps cfnLoggerDefinitionProps = CfnLoggerDefinitionProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .initialVersion(LoggerDefinitionVersionProperty.builder()
 *                 .loggers(List.of(LoggerProperty.builder()
 *                         .component("component")
 *                         .id("id")
 *                         .level("level")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .space(123)
 *                         .build()))
 *                 .build())
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.689Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnLoggerDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoggerDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoggerDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the logger definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The logger definition version to include when the logger definition is created.
     * <p>
     * A logger definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html"><code>logger</code></a> property types.
     * <p>
     * <blockquote>
     * <p>
     * To associate a logger definition version after the logger definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html"><code>AWS::Greengrass::LoggerDefinitionVersion</code></a> resource and specify the ID of this logger definition.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInitialVersion() {
        return null;
    }

    /**
     * Application-specific metadata to attach to the logger definition.
     * <p>
     * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/tagging.html">Tagging Your AWS IoT Greengrass Resources</a> in the <em>Developer Guide</em> .
     * <p>
     * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
     * <p>
     * <blockquote><pre>
     * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
     * }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLoggerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoggerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoggerDefinitionProps> {
        java.lang.String name;
        java.lang.Object initialVersion;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnLoggerDefinitionProps#getName}
         * @param name The name of the logger definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggerDefinitionProps#getInitialVersion}
         * @param initialVersion The logger definition version to include when the logger definition is created.
         *                       A logger definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html"><code>logger</code></a> property types.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       To associate a logger definition version after the logger definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html"><code>AWS::Greengrass::LoggerDefinitionVersion</code></a> resource and specify the ID of this logger definition.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(software.amazon.awscdk.services.greengrass.CfnLoggerDefinition.LoggerDefinitionVersionProperty initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggerDefinitionProps#getInitialVersion}
         * @param initialVersion The logger definition version to include when the logger definition is created.
         *                       A logger definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html"><code>logger</code></a> property types.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       To associate a logger definition version after the logger definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html"><code>AWS::Greengrass::LoggerDefinitionVersion</code></a> resource and specify the ID of this logger definition.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(software.amazon.awscdk.IResolvable initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggerDefinitionProps#getTags}
         * @param tags Application-specific metadata to attach to the logger definition.
         *             You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/tagging.html">Tagging Your AWS IoT Greengrass Resources</a> in the <em>Developer Guide</em> .
         *             <p>
         *             This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         *             <p>
         *             <blockquote><pre>
         *             "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         *             }
         *             </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoggerDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoggerDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoggerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoggerDefinitionProps {
        private final java.lang.String name;
        private final java.lang.Object initialVersion;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.initialVersion = software.amazon.jsii.Kernel.get(this, "initialVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.initialVersion = builder.initialVersion;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getInitialVersion() {
            return this.initialVersion;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getInitialVersion() != null) {
                data.set("initialVersion", om.valueToTree(this.getInitialVersion()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnLoggerDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoggerDefinitionProps.Jsii$Proxy that = (CfnLoggerDefinitionProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.initialVersion != null ? !this.initialVersion.equals(that.initialVersion) : that.initialVersion != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.initialVersion != null ? this.initialVersion.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
