package software.amazon.awscdk.services.guardduty;

/**
 * A CloudFormation `AWS::GuardDuty::Filter`.
 * <p>
 * The <code>AWS::GuardDuty::Filter</code> resource specifies a new filter defined by the provided <code>findingCriteria</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * Object criterion;
 * CfnFilter cfnFilter = CfnFilter.Builder.create(this, "MyCfnFilter")
 *         .action("action")
 *         .description("description")
 *         .detectorId("detectorId")
 *         .findingCriteria(FindingCriteriaProperty.builder()
 *                 .criterion(criterion)
 *                 .itemType(ConditionProperty.builder()
 *                         .eq(List.of("eq"))
 *                         .equalTo(List.of("equalTo"))
 *                         .greaterThan(123)
 *                         .greaterThanOrEqual(123)
 *                         .gt(123)
 *                         .gte(123)
 *                         .lessThan(123)
 *                         .lessThanOrEqual(123)
 *                         .lt(123)
 *                         .lte(123)
 *                         .neq(List.of("neq"))
 *                         .notEquals(List.of("notEquals"))
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .rank(123)
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.737Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.CfnFilter")
public class CfnFilter extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.guardduty.CfnFilter.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::GuardDuty::Filter`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.guardduty.CfnFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::GuardDuty::Filter.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies the action that is to be applied to the findings that match the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAction() {
        return software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the action that is to be applied to the findings that match the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "action", java.util.Objects.requireNonNull(value, "action is required"));
    }

    /**
     * The description of the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDetectorId() {
        return software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDetectorId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "detectorId", java.util.Objects.requireNonNull(value, "detectorId is required"));
    }

    /**
     * Represents the criteria to be used in the filter for querying findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFindingCriteria() {
        return software.amazon.jsii.Kernel.get(this, "findingCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents the criteria to be used in the filter for querying findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFindingCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.guardduty.CfnFilter.FindingCriteriaProperty value) {
        software.amazon.jsii.Kernel.set(this, "findingCriteria", java.util.Objects.requireNonNull(value, "findingCriteria is required"));
    }

    /**
     * Represents the criteria to be used in the filter for querying findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFindingCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "findingCriteria", java.util.Objects.requireNonNull(value, "findingCriteria is required"));
    }

    /**
     * The name of the filter.
     * <p>
     * Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the filter.
     * <p>
     * Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::GuardDuty::Filter.Rank`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getRank() {
        return software.amazon.jsii.Kernel.get(this, "rank", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::GuardDuty::Filter.Rank`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRank(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "rank", java.util.Objects.requireNonNull(value, "rank is required"));
    }
    /**
     * Specifies the condition to apply to a single field when filtering through  findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * ConditionProperty conditionProperty = ConditionProperty.builder()
     *         .eq(List.of("eq"))
     *         .equalTo(List.of("equalTo"))
     *         .greaterThan(123)
     *         .greaterThanOrEqual(123)
     *         .gt(123)
     *         .gte(123)
     *         .lessThan(123)
     *         .lessThanOrEqual(123)
     *         .lt(123)
     *         .lte(123)
     *         .neq(List.of("neq"))
     *         .notEquals(List.of("notEquals"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.CfnFilter.ConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents the equal condition to apply to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEq() {
            return null;
        }

        /**
         * Represents an *equal* ** condition to be applied to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEqualTo() {
            return null;
        }

        /**
         * Represents a *greater than* condition to be applied to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGreaterThan() {
            return null;
        }

        /**
         * Represents a *greater than or equal* condition to be applied to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGreaterThanOrEqual() {
            return null;
        }

        /**
         * Represents a *greater than* condition to be applied to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGt() {
            return null;
        }

        /**
         * Represents the greater than or equal condition to apply to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGte() {
            return null;
        }

        /**
         * Represents a *less than* condition to be applied to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLessThan() {
            return null;
        }

        /**
         * Represents a *less than or equal* condition to be applied to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLessThanOrEqual() {
            return null;
        }

        /**
         * Represents the less than condition to apply to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLt() {
            return null;
        }

        /**
         * Represents the less than or equal condition to apply to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLte() {
            return null;
        }

        /**
         * Represents the not equal condition to apply to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNeq() {
            return null;
        }

        /**
         * Represents a *not equal* ** condition to be applied to a single field when querying for findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEquals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionProperty> {
            java.util.List<java.lang.String> eq;
            java.util.List<java.lang.String> equalTo;
            java.lang.Number greaterThan;
            java.lang.Number greaterThanOrEqual;
            java.lang.Number gt;
            java.lang.Number gte;
            java.lang.Number lessThan;
            java.lang.Number lessThanOrEqual;
            java.lang.Number lt;
            java.lang.Number lte;
            java.util.List<java.lang.String> neq;
            java.util.List<java.lang.String> notEquals;

            /**
             * Sets the value of {@link ConditionProperty#getEq}
             * @param eq Represents the equal condition to apply to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eq(java.util.List<java.lang.String> eq) {
                this.eq = eq;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getEqualTo}
             * @param equalTo Represents an *equal* ** condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalTo(java.util.List<java.lang.String> equalTo) {
                this.equalTo = equalTo;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getGreaterThan}
             * @param greaterThan Represents a *greater than* condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greaterThan(java.lang.Number greaterThan) {
                this.greaterThan = greaterThan;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getGreaterThanOrEqual}
             * @param greaterThanOrEqual Represents a *greater than or equal* condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greaterThanOrEqual(java.lang.Number greaterThanOrEqual) {
                this.greaterThanOrEqual = greaterThanOrEqual;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getGt}
             * @param gt Represents a *greater than* condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gt(java.lang.Number gt) {
                this.gt = gt;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getGte}
             * @param gte Represents the greater than or equal condition to apply to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gte(java.lang.Number gte) {
                this.gte = gte;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getLessThan}
             * @param lessThan Represents a *less than* condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lessThan(java.lang.Number lessThan) {
                this.lessThan = lessThan;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getLessThanOrEqual}
             * @param lessThanOrEqual Represents a *less than or equal* condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lessThanOrEqual(java.lang.Number lessThanOrEqual) {
                this.lessThanOrEqual = lessThanOrEqual;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getLt}
             * @param lt Represents the less than condition to apply to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lt(java.lang.Number lt) {
                this.lt = lt;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getLte}
             * @param lte Represents the less than or equal condition to apply to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lte(java.lang.Number lte) {
                this.lte = lte;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getNeq}
             * @param neq Represents the not equal condition to apply to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neq(java.util.List<java.lang.String> neq) {
                this.neq = neq;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getNotEquals}
             * @param notEquals Represents a *not equal* ** condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEquals(java.util.List<java.lang.String> notEquals) {
                this.notEquals = notEquals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionProperty {
            private final java.util.List<java.lang.String> eq;
            private final java.util.List<java.lang.String> equalTo;
            private final java.lang.Number greaterThan;
            private final java.lang.Number greaterThanOrEqual;
            private final java.lang.Number gt;
            private final java.lang.Number gte;
            private final java.lang.Number lessThan;
            private final java.lang.Number lessThanOrEqual;
            private final java.lang.Number lt;
            private final java.lang.Number lte;
            private final java.util.List<java.lang.String> neq;
            private final java.util.List<java.lang.String> notEquals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eq = software.amazon.jsii.Kernel.get(this, "eq", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.equalTo = software.amazon.jsii.Kernel.get(this, "equalTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.greaterThan = software.amazon.jsii.Kernel.get(this, "greaterThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.greaterThanOrEqual = software.amazon.jsii.Kernel.get(this, "greaterThanOrEqual", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gt = software.amazon.jsii.Kernel.get(this, "gt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gte = software.amazon.jsii.Kernel.get(this, "gte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lessThan = software.amazon.jsii.Kernel.get(this, "lessThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lessThanOrEqual = software.amazon.jsii.Kernel.get(this, "lessThanOrEqual", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lt = software.amazon.jsii.Kernel.get(this, "lt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lte = software.amazon.jsii.Kernel.get(this, "lte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.neq = software.amazon.jsii.Kernel.get(this, "neq", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEquals = software.amazon.jsii.Kernel.get(this, "notEquals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eq = builder.eq;
                this.equalTo = builder.equalTo;
                this.greaterThan = builder.greaterThan;
                this.greaterThanOrEqual = builder.greaterThanOrEqual;
                this.gt = builder.gt;
                this.gte = builder.gte;
                this.lessThan = builder.lessThan;
                this.lessThanOrEqual = builder.lessThanOrEqual;
                this.lt = builder.lt;
                this.lte = builder.lte;
                this.neq = builder.neq;
                this.notEquals = builder.notEquals;
            }

            @Override
            public final java.util.List<java.lang.String> getEq() {
                return this.eq;
            }

            @Override
            public final java.util.List<java.lang.String> getEqualTo() {
                return this.equalTo;
            }

            @Override
            public final java.lang.Number getGreaterThan() {
                return this.greaterThan;
            }

            @Override
            public final java.lang.Number getGreaterThanOrEqual() {
                return this.greaterThanOrEqual;
            }

            @Override
            public final java.lang.Number getGt() {
                return this.gt;
            }

            @Override
            public final java.lang.Number getGte() {
                return this.gte;
            }

            @Override
            public final java.lang.Number getLessThan() {
                return this.lessThan;
            }

            @Override
            public final java.lang.Number getLessThanOrEqual() {
                return this.lessThanOrEqual;
            }

            @Override
            public final java.lang.Number getLt() {
                return this.lt;
            }

            @Override
            public final java.lang.Number getLte() {
                return this.lte;
            }

            @Override
            public final java.util.List<java.lang.String> getNeq() {
                return this.neq;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEquals() {
                return this.notEquals;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEq() != null) {
                    data.set("eq", om.valueToTree(this.getEq()));
                }
                if (this.getEqualTo() != null) {
                    data.set("equalTo", om.valueToTree(this.getEqualTo()));
                }
                if (this.getGreaterThan() != null) {
                    data.set("greaterThan", om.valueToTree(this.getGreaterThan()));
                }
                if (this.getGreaterThanOrEqual() != null) {
                    data.set("greaterThanOrEqual", om.valueToTree(this.getGreaterThanOrEqual()));
                }
                if (this.getGt() != null) {
                    data.set("gt", om.valueToTree(this.getGt()));
                }
                if (this.getGte() != null) {
                    data.set("gte", om.valueToTree(this.getGte()));
                }
                if (this.getLessThan() != null) {
                    data.set("lessThan", om.valueToTree(this.getLessThan()));
                }
                if (this.getLessThanOrEqual() != null) {
                    data.set("lessThanOrEqual", om.valueToTree(this.getLessThanOrEqual()));
                }
                if (this.getLt() != null) {
                    data.set("lt", om.valueToTree(this.getLt()));
                }
                if (this.getLte() != null) {
                    data.set("lte", om.valueToTree(this.getLte()));
                }
                if (this.getNeq() != null) {
                    data.set("neq", om.valueToTree(this.getNeq()));
                }
                if (this.getNotEquals() != null) {
                    data.set("notEquals", om.valueToTree(this.getNotEquals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.CfnFilter.ConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionProperty.Jsii$Proxy that = (ConditionProperty.Jsii$Proxy) o;

                if (this.eq != null ? !this.eq.equals(that.eq) : that.eq != null) return false;
                if (this.equalTo != null ? !this.equalTo.equals(that.equalTo) : that.equalTo != null) return false;
                if (this.greaterThan != null ? !this.greaterThan.equals(that.greaterThan) : that.greaterThan != null) return false;
                if (this.greaterThanOrEqual != null ? !this.greaterThanOrEqual.equals(that.greaterThanOrEqual) : that.greaterThanOrEqual != null) return false;
                if (this.gt != null ? !this.gt.equals(that.gt) : that.gt != null) return false;
                if (this.gte != null ? !this.gte.equals(that.gte) : that.gte != null) return false;
                if (this.lessThan != null ? !this.lessThan.equals(that.lessThan) : that.lessThan != null) return false;
                if (this.lessThanOrEqual != null ? !this.lessThanOrEqual.equals(that.lessThanOrEqual) : that.lessThanOrEqual != null) return false;
                if (this.lt != null ? !this.lt.equals(that.lt) : that.lt != null) return false;
                if (this.lte != null ? !this.lte.equals(that.lte) : that.lte != null) return false;
                if (this.neq != null ? !this.neq.equals(that.neq) : that.neq != null) return false;
                return this.notEquals != null ? this.notEquals.equals(that.notEquals) : that.notEquals == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eq != null ? this.eq.hashCode() : 0;
                result = 31 * result + (this.equalTo != null ? this.equalTo.hashCode() : 0);
                result = 31 * result + (this.greaterThan != null ? this.greaterThan.hashCode() : 0);
                result = 31 * result + (this.greaterThanOrEqual != null ? this.greaterThanOrEqual.hashCode() : 0);
                result = 31 * result + (this.gt != null ? this.gt.hashCode() : 0);
                result = 31 * result + (this.gte != null ? this.gte.hashCode() : 0);
                result = 31 * result + (this.lessThan != null ? this.lessThan.hashCode() : 0);
                result = 31 * result + (this.lessThanOrEqual != null ? this.lessThanOrEqual.hashCode() : 0);
                result = 31 * result + (this.lt != null ? this.lt.hashCode() : 0);
                result = 31 * result + (this.lte != null ? this.lte.hashCode() : 0);
                result = 31 * result + (this.neq != null ? this.neq.hashCode() : 0);
                result = 31 * result + (this.notEquals != null ? this.notEquals.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a map of finding properties that match specified conditions and values when querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * Object criterion;
     * FindingCriteriaProperty findingCriteriaProperty = FindingCriteriaProperty.builder()
     *         .criterion(criterion)
     *         .itemType(ConditionProperty.builder()
     *                 .eq(List.of("eq"))
     *                 .equalTo(List.of("equalTo"))
     *                 .greaterThan(123)
     *                 .greaterThanOrEqual(123)
     *                 .gt(123)
     *                 .gte(123)
     *                 .lessThan(123)
     *                 .lessThanOrEqual(123)
     *                 .lt(123)
     *                 .lte(123)
     *                 .neq(List.of("neq"))
     *                 .notEquals(List.of("notEquals"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.CfnFilter.FindingCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(FindingCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FindingCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents a map of finding properties that match specified conditions and values when querying findings.
         * <p>
         * For a mapping of JSON criterion to their console equivalent see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria">Finding criteria</a> . The following are the available criterion:
         * <p>
         * <ul>
         * <li>accountId</li>
         * <li>region</li>
         * <li>confidence</li>
         * <li>id</li>
         * <li>resource.accessKeyDetails.accessKeyId</li>
         * <li>resource.accessKeyDetails.principalId</li>
         * <li>resource.accessKeyDetails.userName</li>
         * <li>resource.accessKeyDetails.userType</li>
         * <li>resource.instanceDetails.iamInstanceProfile.id</li>
         * <li>resource.instanceDetails.imageId</li>
         * <li>resource.instanceDetails.instanceId</li>
         * <li>resource.instanceDetails.outpostArn</li>
         * <li>resource.instanceDetails.networkInterfaces.ipv6Addresses</li>
         * <li>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</li>
         * <li>resource.instanceDetails.networkInterfaces.publicDnsName</li>
         * <li>resource.instanceDetails.networkInterfaces.publicIp</li>
         * <li>resource.instanceDetails.networkInterfaces.securityGroups.groupId</li>
         * <li>resource.instanceDetails.networkInterfaces.securityGroups.groupName</li>
         * <li>resource.instanceDetails.networkInterfaces.subnetId</li>
         * <li>resource.instanceDetails.networkInterfaces.vpcId</li>
         * <li>resource.instanceDetails.tags.key</li>
         * <li>resource.instanceDetails.tags.value</li>
         * <li>resource.resourceType</li>
         * <li>service.action.actionType</li>
         * <li>service.action.awsApiCallAction.api</li>
         * <li>service.action.awsApiCallAction.callerType</li>
         * <li>service.action.awsApiCallAction.errorCode</li>
         * <li>service.action.awsApiCallAction.remoteIpDetails.city.cityName</li>
         * <li>service.action.awsApiCallAction.remoteIpDetails.country.countryName</li>
         * <li>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</li>
         * <li>service.action.awsApiCallAction.remoteIpDetails.organization.asn</li>
         * <li>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</li>
         * <li>service.action.awsApiCallAction.serviceName</li>
         * <li>service.action.dnsRequestAction.domain</li>
         * <li>service.action.networkConnectionAction.blocked</li>
         * <li>service.action.networkConnectionAction.connectionDirection</li>
         * <li>service.action.networkConnectionAction.localPortDetails.port</li>
         * <li>service.action.networkConnectionAction.protocol</li>
         * <li>service.action.networkConnectionAction.localIpDetails.ipAddressV4</li>
         * <li>service.action.networkConnectionAction.remoteIpDetails.city.cityName</li>
         * <li>service.action.networkConnectionAction.remoteIpDetails.country.countryName</li>
         * <li>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</li>
         * <li>service.action.networkConnectionAction.remoteIpDetails.organization.asn</li>
         * <li>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</li>
         * <li>service.action.networkConnectionAction.remotePortDetails.port</li>
         * <li>service.additionalInfo.threatListName</li>
         * <li>service.archived</li>
         * </ul>
         * <p>
         * When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived findings are listed. When this attribute is not set, all existing findings are listed.
         * <p>
         * <ul>
         * <li>service.resourceRole</li>
         * <li>severity</li>
         * <li>type</li>
         * <li>updatedAt</li>
         * </ul>
         * <p>
         * Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCriterion() {
            return null;
        }

        /**
         * Specifies the condition to be applied to a single field when filtering through findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getItemType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FindingCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FindingCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FindingCriteriaProperty> {
            java.lang.Object criterion;
            java.lang.Object itemType;

            /**
             * Sets the value of {@link FindingCriteriaProperty#getCriterion}
             * @param criterion Represents a map of finding properties that match specified conditions and values when querying findings.
             *                  For a mapping of JSON criterion to their console equivalent see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria">Finding criteria</a> . The following are the available criterion:
             *                  <p>
             *                  <ul>
             *                  <li>accountId</li>
             *                  <li>region</li>
             *                  <li>confidence</li>
             *                  <li>id</li>
             *                  <li>resource.accessKeyDetails.accessKeyId</li>
             *                  <li>resource.accessKeyDetails.principalId</li>
             *                  <li>resource.accessKeyDetails.userName</li>
             *                  <li>resource.accessKeyDetails.userType</li>
             *                  <li>resource.instanceDetails.iamInstanceProfile.id</li>
             *                  <li>resource.instanceDetails.imageId</li>
             *                  <li>resource.instanceDetails.instanceId</li>
             *                  <li>resource.instanceDetails.outpostArn</li>
             *                  <li>resource.instanceDetails.networkInterfaces.ipv6Addresses</li>
             *                  <li>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</li>
             *                  <li>resource.instanceDetails.networkInterfaces.publicDnsName</li>
             *                  <li>resource.instanceDetails.networkInterfaces.publicIp</li>
             *                  <li>resource.instanceDetails.networkInterfaces.securityGroups.groupId</li>
             *                  <li>resource.instanceDetails.networkInterfaces.securityGroups.groupName</li>
             *                  <li>resource.instanceDetails.networkInterfaces.subnetId</li>
             *                  <li>resource.instanceDetails.networkInterfaces.vpcId</li>
             *                  <li>resource.instanceDetails.tags.key</li>
             *                  <li>resource.instanceDetails.tags.value</li>
             *                  <li>resource.resourceType</li>
             *                  <li>service.action.actionType</li>
             *                  <li>service.action.awsApiCallAction.api</li>
             *                  <li>service.action.awsApiCallAction.callerType</li>
             *                  <li>service.action.awsApiCallAction.errorCode</li>
             *                  <li>service.action.awsApiCallAction.remoteIpDetails.city.cityName</li>
             *                  <li>service.action.awsApiCallAction.remoteIpDetails.country.countryName</li>
             *                  <li>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</li>
             *                  <li>service.action.awsApiCallAction.remoteIpDetails.organization.asn</li>
             *                  <li>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</li>
             *                  <li>service.action.awsApiCallAction.serviceName</li>
             *                  <li>service.action.dnsRequestAction.domain</li>
             *                  <li>service.action.networkConnectionAction.blocked</li>
             *                  <li>service.action.networkConnectionAction.connectionDirection</li>
             *                  <li>service.action.networkConnectionAction.localPortDetails.port</li>
             *                  <li>service.action.networkConnectionAction.protocol</li>
             *                  <li>service.action.networkConnectionAction.localIpDetails.ipAddressV4</li>
             *                  <li>service.action.networkConnectionAction.remoteIpDetails.city.cityName</li>
             *                  <li>service.action.networkConnectionAction.remoteIpDetails.country.countryName</li>
             *                  <li>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</li>
             *                  <li>service.action.networkConnectionAction.remoteIpDetails.organization.asn</li>
             *                  <li>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</li>
             *                  <li>service.action.networkConnectionAction.remotePortDetails.port</li>
             *                  <li>service.additionalInfo.threatListName</li>
             *                  <li>service.archived</li>
             *                  </ul>
             *                  <p>
             *                  When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived findings are listed. When this attribute is not set, all existing findings are listed.
             *                  <p>
             *                  <ul>
             *                  <li>service.resourceRole</li>
             *                  <li>severity</li>
             *                  <li>type</li>
             *                  <li>updatedAt</li>
             *                  </ul>
             *                  <p>
             *                  Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criterion(java.lang.Object criterion) {
                this.criterion = criterion;
                return this;
            }

            /**
             * Sets the value of {@link FindingCriteriaProperty#getItemType}
             * @param itemType Specifies the condition to be applied to a single field when filtering through findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder itemType(software.amazon.awscdk.services.guardduty.CfnFilter.ConditionProperty itemType) {
                this.itemType = itemType;
                return this;
            }

            /**
             * Sets the value of {@link FindingCriteriaProperty#getItemType}
             * @param itemType Specifies the condition to be applied to a single field when filtering through findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder itemType(software.amazon.awscdk.IResolvable itemType) {
                this.itemType = itemType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FindingCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FindingCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FindingCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FindingCriteriaProperty {
            private final java.lang.Object criterion;
            private final java.lang.Object itemType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.criterion = software.amazon.jsii.Kernel.get(this, "criterion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.itemType = software.amazon.jsii.Kernel.get(this, "itemType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.criterion = builder.criterion;
                this.itemType = builder.itemType;
            }

            @Override
            public final java.lang.Object getCriterion() {
                return this.criterion;
            }

            @Override
            public final java.lang.Object getItemType() {
                return this.itemType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCriterion() != null) {
                    data.set("criterion", om.valueToTree(this.getCriterion()));
                }
                if (this.getItemType() != null) {
                    data.set("itemType", om.valueToTree(this.getItemType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.CfnFilter.FindingCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FindingCriteriaProperty.Jsii$Proxy that = (FindingCriteriaProperty.Jsii$Proxy) o;

                if (this.criterion != null ? !this.criterion.equals(that.criterion) : that.criterion != null) return false;
                return this.itemType != null ? this.itemType.equals(that.itemType) : that.itemType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.criterion != null ? this.criterion.hashCode() : 0;
                result = 31 * result + (this.itemType != null ? this.itemType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.guardduty.CfnFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.guardduty.CfnFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.guardduty.CfnFilterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.guardduty.CfnFilterProps.Builder();
        }

        /**
         * Specifies the action that is to be applied to the findings that match the filter.
         * <p>
         * @return {@code this}
         * @param action Specifies the action that is to be applied to the findings that match the filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * The description of the filter.
         * <p>
         * @return {@code this}
         * @param description The description of the filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
         * <p>
         * @return {@code this}
         * @param detectorId The ID of the detector belonging to the GuardDuty account that you want to create a filter for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(final java.lang.String detectorId) {
            this.props.detectorId(detectorId);
            return this;
        }

        /**
         * Represents the criteria to be used in the filter for querying findings.
         * <p>
         * @return {@code this}
         * @param findingCriteria Represents the criteria to be used in the filter for querying findings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder findingCriteria(final software.amazon.awscdk.services.guardduty.CfnFilter.FindingCriteriaProperty findingCriteria) {
            this.props.findingCriteria(findingCriteria);
            return this;
        }
        /**
         * Represents the criteria to be used in the filter for querying findings.
         * <p>
         * @return {@code this}
         * @param findingCriteria Represents the criteria to be used in the filter for querying findings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder findingCriteria(final software.amazon.awscdk.IResolvable findingCriteria) {
            this.props.findingCriteria(findingCriteria);
            return this;
        }

        /**
         * The name of the filter.
         * <p>
         * Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
         * <p>
         * @return {@code this}
         * @param name The name of the filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::GuardDuty::Filter.Rank`.
         * <p>
         * @return {@code this}
         * @param rank `AWS::GuardDuty::Filter.Rank`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rank(final java.lang.Number rank) {
            this.props.rank(rank);
            return this;
        }

        /**
         * `AWS::GuardDuty::Filter.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::GuardDuty::Filter.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.guardduty.CfnFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.guardduty.CfnFilter build() {
            return new software.amazon.awscdk.services.guardduty.CfnFilter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
