package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a `CfnCACertificate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnCACertificateProps cfnCACertificateProps = CfnCACertificateProps.builder()
 *         .caCertificatePem("caCertificatePem")
 *         .status("status")
 *         // the properties below are optional
 *         .autoRegistrationStatus("autoRegistrationStatus")
 *         .certificateMode("certificateMode")
 *         .registrationConfig(RegistrationConfigProperty.builder()
 *                 .roleArn("roleArn")
 *                 .templateBody("templateBody")
 *                 .templateName("templateName")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .verificationCertificatePem("verificationCertificatePem")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnCACertificateProps")
@software.amazon.jsii.Jsii.Proxy(CfnCACertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCACertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::IoT::CACertificate.CACertificatePem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCaCertificatePem();

    /**
     * `AWS::IoT::CACertificate.Status`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatus();

    /**
     * `AWS::IoT::CACertificate.AutoRegistrationStatus`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoRegistrationStatus() {
        return null;
    }

    /**
     * `AWS::IoT::CACertificate.CertificateMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateMode() {
        return null;
    }

    /**
     * `AWS::IoT::CACertificate.RegistrationConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRegistrationConfig() {
        return null;
    }

    /**
     * `AWS::IoT::CACertificate.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::IoT::CACertificate.VerificationCertificatePem`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVerificationCertificatePem() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCACertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCACertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCACertificateProps> {
        java.lang.String caCertificatePem;
        java.lang.String status;
        java.lang.String autoRegistrationStatus;
        java.lang.String certificateMode;
        java.lang.Object registrationConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String verificationCertificatePem;

        /**
         * Sets the value of {@link CfnCACertificateProps#getCaCertificatePem}
         * @param caCertificatePem `AWS::IoT::CACertificate.CACertificatePem`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificatePem(java.lang.String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
            return this;
        }

        /**
         * Sets the value of {@link CfnCACertificateProps#getStatus}
         * @param status `AWS::IoT::CACertificate.Status`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnCACertificateProps#getAutoRegistrationStatus}
         * @param autoRegistrationStatus `AWS::IoT::CACertificate.AutoRegistrationStatus`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRegistrationStatus(java.lang.String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnCACertificateProps#getCertificateMode}
         * @param certificateMode `AWS::IoT::CACertificate.CertificateMode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateMode(java.lang.String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnCACertificateProps#getRegistrationConfig}
         * @param registrationConfig `AWS::IoT::CACertificate.RegistrationConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registrationConfig(software.amazon.awscdk.services.iot.CfnCACertificate.RegistrationConfigProperty registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCACertificateProps#getRegistrationConfig}
         * @param registrationConfig `AWS::IoT::CACertificate.RegistrationConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registrationConfig(software.amazon.awscdk.IResolvable registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCACertificateProps#getTags}
         * @param tags `AWS::IoT::CACertificate.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCACertificateProps#getVerificationCertificatePem}
         * @param verificationCertificatePem `AWS::IoT::CACertificate.VerificationCertificatePem`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationCertificatePem(java.lang.String verificationCertificatePem) {
            this.verificationCertificatePem = verificationCertificatePem;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCACertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCACertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCACertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCACertificateProps {
        private final java.lang.String caCertificatePem;
        private final java.lang.String status;
        private final java.lang.String autoRegistrationStatus;
        private final java.lang.String certificateMode;
        private final java.lang.Object registrationConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String verificationCertificatePem;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.caCertificatePem = software.amazon.jsii.Kernel.get(this, "caCertificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoRegistrationStatus = software.amazon.jsii.Kernel.get(this, "autoRegistrationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateMode = software.amazon.jsii.Kernel.get(this, "certificateMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.registrationConfig = software.amazon.jsii.Kernel.get(this, "registrationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.verificationCertificatePem = software.amazon.jsii.Kernel.get(this, "verificationCertificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.caCertificatePem = java.util.Objects.requireNonNull(builder.caCertificatePem, "caCertificatePem is required");
            this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            this.autoRegistrationStatus = builder.autoRegistrationStatus;
            this.certificateMode = builder.certificateMode;
            this.registrationConfig = builder.registrationConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.verificationCertificatePem = builder.verificationCertificatePem;
        }

        @Override
        public final java.lang.String getCaCertificatePem() {
            return this.caCertificatePem;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.String getAutoRegistrationStatus() {
            return this.autoRegistrationStatus;
        }

        @Override
        public final java.lang.String getCertificateMode() {
            return this.certificateMode;
        }

        @Override
        public final java.lang.Object getRegistrationConfig() {
            return this.registrationConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVerificationCertificatePem() {
            return this.verificationCertificatePem;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("caCertificatePem", om.valueToTree(this.getCaCertificatePem()));
            data.set("status", om.valueToTree(this.getStatus()));
            if (this.getAutoRegistrationStatus() != null) {
                data.set("autoRegistrationStatus", om.valueToTree(this.getAutoRegistrationStatus()));
            }
            if (this.getCertificateMode() != null) {
                data.set("certificateMode", om.valueToTree(this.getCertificateMode()));
            }
            if (this.getRegistrationConfig() != null) {
                data.set("registrationConfig", om.valueToTree(this.getRegistrationConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVerificationCertificatePem() != null) {
                data.set("verificationCertificatePem", om.valueToTree(this.getVerificationCertificatePem()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnCACertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCACertificateProps.Jsii$Proxy that = (CfnCACertificateProps.Jsii$Proxy) o;

            if (!caCertificatePem.equals(that.caCertificatePem)) return false;
            if (!status.equals(that.status)) return false;
            if (this.autoRegistrationStatus != null ? !this.autoRegistrationStatus.equals(that.autoRegistrationStatus) : that.autoRegistrationStatus != null) return false;
            if (this.certificateMode != null ? !this.certificateMode.equals(that.certificateMode) : that.certificateMode != null) return false;
            if (this.registrationConfig != null ? !this.registrationConfig.equals(that.registrationConfig) : that.registrationConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.verificationCertificatePem != null ? this.verificationCertificatePem.equals(that.verificationCertificatePem) : that.verificationCertificatePem == null;
        }

        @Override
        public final int hashCode() {
            int result = this.caCertificatePem.hashCode();
            result = 31 * result + (this.status.hashCode());
            result = 31 * result + (this.autoRegistrationStatus != null ? this.autoRegistrationStatus.hashCode() : 0);
            result = 31 * result + (this.certificateMode != null ? this.certificateMode.hashCode() : 0);
            result = 31 * result + (this.registrationConfig != null ? this.registrationConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.verificationCertificatePem != null ? this.verificationCertificatePem.hashCode() : 0);
            return result;
        }
    }
}
