package software.amazon.awscdk.services.iotanalytics;

/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 * <p>
 * The AWS::IoTAnalytics::Pipeline resource consumes messages from one or more channels and allows you to process the messages before storing them in a data store. You must specify both a <code>channel</code> and a <code>datastore</code> activity and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/welcome.html#aws-iot-analytics-how">How to Use AWS IoT Analytics</a> in the <em>AWS IoT Analytics User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * CfnPipeline cfnPipeline = CfnPipeline.Builder.create(this, "MyCfnPipeline")
 *         .pipelineActivities(List.of(ActivityProperty.builder()
 *                 .addAttributes(AddAttributesProperty.builder()
 *                         .attributes(Map.of(
 *                                 "attributesKey", "attributes"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .channel(ChannelProperty.builder()
 *                         .channelName("channelName")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .datastore(DatastoreProperty.builder()
 *                         .datastoreName("datastoreName")
 *                         .name("name")
 *                         .build())
 *                 .deviceRegistryEnrich(DeviceRegistryEnrichProperty.builder()
 *                         .attribute("attribute")
 *                         .name("name")
 *                         .roleArn("roleArn")
 *                         .thingName("thingName")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .deviceShadowEnrich(DeviceShadowEnrichProperty.builder()
 *                         .attribute("attribute")
 *                         .name("name")
 *                         .roleArn("roleArn")
 *                         .thingName("thingName")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .filter(FilterProperty.builder()
 *                         .filter("filter")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .lambda(LambdaProperty.builder()
 *                         .batchSize(123)
 *                         .lambdaName("lambdaName")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .math(MathProperty.builder()
 *                         .attribute("attribute")
 *                         .math("math")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .removeAttributes(RemoveAttributesProperty.builder()
 *                         .attributes(List.of("attributes"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .selectAttributes(SelectAttributesProperty.builder()
 *                         .attributes(List.of("attributes"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .pipelineName("pipelineName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.994Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline")
public class CfnPipeline extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotanalytics.CfnPipeline.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTAnalytics::Pipeline`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotanalytics.CfnPipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Metadata which can be used to manage the pipeline.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of "PipelineActivity" objects.
     * <p>
     * Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
     * <p>
     * The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
     * <p>
     * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPipelineActivities() {
        return software.amazon.jsii.Kernel.get(this, "pipelineActivities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of "PipelineActivity" objects.
     * <p>
     * Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
     * <p>
     * The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
     * <p>
     * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineActivities(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pipelineActivities", java.util.Objects.requireNonNull(value, "pipelineActivities is required"));
    }

    /**
     * A list of "PipelineActivity" objects.
     * <p>
     * Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
     * <p>
     * The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
     * <p>
     * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineActivities(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotanalytics.CfnPipeline.ActivityProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.iotanalytics.CfnPipeline.ActivityProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "pipelineActivities", java.util.Objects.requireNonNull(value, "pipelineActivities is required"));
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPipelineName() {
        return software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pipelineName", value);
    }
    /**
     * An activity that performs a transformation on a message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ActivityProperty activityProperty = ActivityProperty.builder()
     *         .addAttributes(AddAttributesProperty.builder()
     *                 .attributes(Map.of(
     *                         "attributesKey", "attributes"))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .channel(ChannelProperty.builder()
     *                 .channelName("channelName")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .datastore(DatastoreProperty.builder()
     *                 .datastoreName("datastoreName")
     *                 .name("name")
     *                 .build())
     *         .deviceRegistryEnrich(DeviceRegistryEnrichProperty.builder()
     *                 .attribute("attribute")
     *                 .name("name")
     *                 .roleArn("roleArn")
     *                 .thingName("thingName")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .deviceShadowEnrich(DeviceShadowEnrichProperty.builder()
     *                 .attribute("attribute")
     *                 .name("name")
     *                 .roleArn("roleArn")
     *                 .thingName("thingName")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .filter(FilterProperty.builder()
     *                 .filter("filter")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .lambda(LambdaProperty.builder()
     *                 .batchSize(123)
     *                 .lambdaName("lambdaName")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .math(MathProperty.builder()
     *                 .attribute("attribute")
     *                 .math("math")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .removeAttributes(RemoveAttributesProperty.builder()
     *                 .attributes(List.of("attributes"))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .selectAttributes(SelectAttributesProperty.builder()
     *                 .attributes(List.of("attributes"))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .next("next")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.ActivityProperty")
    @software.amazon.jsii.Jsii.Proxy(ActivityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActivityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Adds other attributes based on existing attributes in the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddAttributes() {
            return null;
        }

        /**
         * Determines the source of the messages to be processed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChannel() {
            return null;
        }

        /**
         * Specifies where to store the processed message data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatastore() {
            return null;
        }

        /**
         * Adds data from the AWS IoT device registry to your message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceRegistryEnrich() {
            return null;
        }

        /**
         * Adds information from the AWS IoT Device Shadows service to a message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceShadowEnrich() {
            return null;
        }

        /**
         * Filters a message based on its attributes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * Runs a Lambda function to modify the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambda() {
            return null;
        }

        /**
         * Computes an arithmetic expression using the message's attributes and adds it to the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMath() {
            return null;
        }

        /**
         * Removes attributes from a message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveAttributes() {
            return null;
        }

        /**
         * Creates a new message using only the specified attributes from the original message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActivityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActivityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActivityProperty> {
            java.lang.Object addAttributes;
            java.lang.Object channel;
            java.lang.Object datastore;
            java.lang.Object deviceRegistryEnrich;
            java.lang.Object deviceShadowEnrich;
            java.lang.Object filter;
            java.lang.Object lambda;
            java.lang.Object math;
            java.lang.Object removeAttributes;
            java.lang.Object selectAttributes;

            /**
             * Sets the value of {@link ActivityProperty#getAddAttributes}
             * @param addAttributes Adds other attributes based on existing attributes in the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addAttributes(software.amazon.awscdk.services.iotanalytics.CfnPipeline.AddAttributesProperty addAttributes) {
                this.addAttributes = addAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getAddAttributes}
             * @param addAttributes Adds other attributes based on existing attributes in the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addAttributes(software.amazon.awscdk.IResolvable addAttributes) {
                this.addAttributes = addAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getChannel}
             * @param channel Determines the source of the messages to be processed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channel(software.amazon.awscdk.services.iotanalytics.CfnPipeline.ChannelProperty channel) {
                this.channel = channel;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getChannel}
             * @param channel Determines the source of the messages to be processed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channel(software.amazon.awscdk.IResolvable channel) {
                this.channel = channel;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getDatastore}
             * @param datastore Specifies where to store the processed message data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datastore(software.amazon.awscdk.services.iotanalytics.CfnPipeline.DatastoreProperty datastore) {
                this.datastore = datastore;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getDatastore}
             * @param datastore Specifies where to store the processed message data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datastore(software.amazon.awscdk.IResolvable datastore) {
                this.datastore = datastore;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getDeviceRegistryEnrich}
             * @param deviceRegistryEnrich Adds data from the AWS IoT device registry to your message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceRegistryEnrich(software.amazon.awscdk.services.iotanalytics.CfnPipeline.DeviceRegistryEnrichProperty deviceRegistryEnrich) {
                this.deviceRegistryEnrich = deviceRegistryEnrich;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getDeviceRegistryEnrich}
             * @param deviceRegistryEnrich Adds data from the AWS IoT device registry to your message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceRegistryEnrich(software.amazon.awscdk.IResolvable deviceRegistryEnrich) {
                this.deviceRegistryEnrich = deviceRegistryEnrich;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getDeviceShadowEnrich}
             * @param deviceShadowEnrich Adds information from the AWS IoT Device Shadows service to a message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceShadowEnrich(software.amazon.awscdk.services.iotanalytics.CfnPipeline.DeviceShadowEnrichProperty deviceShadowEnrich) {
                this.deviceShadowEnrich = deviceShadowEnrich;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getDeviceShadowEnrich}
             * @param deviceShadowEnrich Adds information from the AWS IoT Device Shadows service to a message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceShadowEnrich(software.amazon.awscdk.IResolvable deviceShadowEnrich) {
                this.deviceShadowEnrich = deviceShadowEnrich;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getFilter}
             * @param filter Filters a message based on its attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.iotanalytics.CfnPipeline.FilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getFilter}
             * @param filter Filters a message based on its attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getLambda}
             * @param lambda Runs a Lambda function to modify the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.services.iotanalytics.CfnPipeline.LambdaProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getLambda}
             * @param lambda Runs a Lambda function to modify the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getMath}
             * @param math Computes an arithmetic expression using the message's attributes and adds it to the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder math(software.amazon.awscdk.services.iotanalytics.CfnPipeline.MathProperty math) {
                this.math = math;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getMath}
             * @param math Computes an arithmetic expression using the message's attributes and adds it to the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder math(software.amazon.awscdk.IResolvable math) {
                this.math = math;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getRemoveAttributes}
             * @param removeAttributes Removes attributes from a message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAttributes(software.amazon.awscdk.services.iotanalytics.CfnPipeline.RemoveAttributesProperty removeAttributes) {
                this.removeAttributes = removeAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getRemoveAttributes}
             * @param removeAttributes Removes attributes from a message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAttributes(software.amazon.awscdk.IResolvable removeAttributes) {
                this.removeAttributes = removeAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getSelectAttributes}
             * @param selectAttributes Creates a new message using only the specified attributes from the original message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectAttributes(software.amazon.awscdk.services.iotanalytics.CfnPipeline.SelectAttributesProperty selectAttributes) {
                this.selectAttributes = selectAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ActivityProperty#getSelectAttributes}
             * @param selectAttributes Creates a new message using only the specified attributes from the original message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectAttributes(software.amazon.awscdk.IResolvable selectAttributes) {
                this.selectAttributes = selectAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActivityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActivityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActivityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActivityProperty {
            private final java.lang.Object addAttributes;
            private final java.lang.Object channel;
            private final java.lang.Object datastore;
            private final java.lang.Object deviceRegistryEnrich;
            private final java.lang.Object deviceShadowEnrich;
            private final java.lang.Object filter;
            private final java.lang.Object lambda;
            private final java.lang.Object math;
            private final java.lang.Object removeAttributes;
            private final java.lang.Object selectAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addAttributes = software.amazon.jsii.Kernel.get(this, "addAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.channel = software.amazon.jsii.Kernel.get(this, "channel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datastore = software.amazon.jsii.Kernel.get(this, "datastore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deviceRegistryEnrich = software.amazon.jsii.Kernel.get(this, "deviceRegistryEnrich", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deviceShadowEnrich = software.amazon.jsii.Kernel.get(this, "deviceShadowEnrich", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.math = software.amazon.jsii.Kernel.get(this, "math", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeAttributes = software.amazon.jsii.Kernel.get(this, "removeAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selectAttributes = software.amazon.jsii.Kernel.get(this, "selectAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addAttributes = builder.addAttributes;
                this.channel = builder.channel;
                this.datastore = builder.datastore;
                this.deviceRegistryEnrich = builder.deviceRegistryEnrich;
                this.deviceShadowEnrich = builder.deviceShadowEnrich;
                this.filter = builder.filter;
                this.lambda = builder.lambda;
                this.math = builder.math;
                this.removeAttributes = builder.removeAttributes;
                this.selectAttributes = builder.selectAttributes;
            }

            @Override
            public final java.lang.Object getAddAttributes() {
                return this.addAttributes;
            }

            @Override
            public final java.lang.Object getChannel() {
                return this.channel;
            }

            @Override
            public final java.lang.Object getDatastore() {
                return this.datastore;
            }

            @Override
            public final java.lang.Object getDeviceRegistryEnrich() {
                return this.deviceRegistryEnrich;
            }

            @Override
            public final java.lang.Object getDeviceShadowEnrich() {
                return this.deviceShadowEnrich;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public final java.lang.Object getLambda() {
                return this.lambda;
            }

            @Override
            public final java.lang.Object getMath() {
                return this.math;
            }

            @Override
            public final java.lang.Object getRemoveAttributes() {
                return this.removeAttributes;
            }

            @Override
            public final java.lang.Object getSelectAttributes() {
                return this.selectAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddAttributes() != null) {
                    data.set("addAttributes", om.valueToTree(this.getAddAttributes()));
                }
                if (this.getChannel() != null) {
                    data.set("channel", om.valueToTree(this.getChannel()));
                }
                if (this.getDatastore() != null) {
                    data.set("datastore", om.valueToTree(this.getDatastore()));
                }
                if (this.getDeviceRegistryEnrich() != null) {
                    data.set("deviceRegistryEnrich", om.valueToTree(this.getDeviceRegistryEnrich()));
                }
                if (this.getDeviceShadowEnrich() != null) {
                    data.set("deviceShadowEnrich", om.valueToTree(this.getDeviceShadowEnrich()));
                }
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }
                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }
                if (this.getMath() != null) {
                    data.set("math", om.valueToTree(this.getMath()));
                }
                if (this.getRemoveAttributes() != null) {
                    data.set("removeAttributes", om.valueToTree(this.getRemoveAttributes()));
                }
                if (this.getSelectAttributes() != null) {
                    data.set("selectAttributes", om.valueToTree(this.getSelectAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.ActivityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActivityProperty.Jsii$Proxy that = (ActivityProperty.Jsii$Proxy) o;

                if (this.addAttributes != null ? !this.addAttributes.equals(that.addAttributes) : that.addAttributes != null) return false;
                if (this.channel != null ? !this.channel.equals(that.channel) : that.channel != null) return false;
                if (this.datastore != null ? !this.datastore.equals(that.datastore) : that.datastore != null) return false;
                if (this.deviceRegistryEnrich != null ? !this.deviceRegistryEnrich.equals(that.deviceRegistryEnrich) : that.deviceRegistryEnrich != null) return false;
                if (this.deviceShadowEnrich != null ? !this.deviceShadowEnrich.equals(that.deviceShadowEnrich) : that.deviceShadowEnrich != null) return false;
                if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) return false;
                if (this.lambda != null ? !this.lambda.equals(that.lambda) : that.lambda != null) return false;
                if (this.math != null ? !this.math.equals(that.math) : that.math != null) return false;
                if (this.removeAttributes != null ? !this.removeAttributes.equals(that.removeAttributes) : that.removeAttributes != null) return false;
                return this.selectAttributes != null ? this.selectAttributes.equals(that.selectAttributes) : that.selectAttributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addAttributes != null ? this.addAttributes.hashCode() : 0;
                result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
                result = 31 * result + (this.datastore != null ? this.datastore.hashCode() : 0);
                result = 31 * result + (this.deviceRegistryEnrich != null ? this.deviceRegistryEnrich.hashCode() : 0);
                result = 31 * result + (this.deviceShadowEnrich != null ? this.deviceShadowEnrich.hashCode() : 0);
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                result = 31 * result + (this.lambda != null ? this.lambda.hashCode() : 0);
                result = 31 * result + (this.math != null ? this.math.hashCode() : 0);
                result = 31 * result + (this.removeAttributes != null ? this.removeAttributes.hashCode() : 0);
                result = 31 * result + (this.selectAttributes != null ? this.selectAttributes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An activity that adds other attributes based on existing attributes in the message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * AddAttributesProperty addAttributesProperty = AddAttributesProperty.builder()
     *         .attributes(Map.of(
     *                 "attributesKey", "attributes"))
     *         .name("name")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.AddAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(AddAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of 1-50 "AttributeNameMapping" objects that map an existing attribute to a new attribute.
         * <p>
         * <blockquote>
         * <p>
         * The existing attributes remain in the message, so if you want to remove the originals, use "RemoveAttributeActivity".
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAttributes();

        /**
         * The name of the 'addAttributes' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AddAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddAttributesProperty> {
            java.lang.Object attributes;
            java.lang.String name;
            java.lang.String next;

            /**
             * Sets the value of {@link AddAttributesProperty#getAttributes}
             * @param attributes A list of 1-50 "AttributeNameMapping" objects that map an existing attribute to a new attribute. This parameter is required.
             *                   <blockquote>
             *                   <p>
             *                   The existing attributes remain in the message, so if you want to remove the originals, use "RemoveAttributeActivity".
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link AddAttributesProperty#getAttributes}
             * @param attributes A list of 1-50 "AttributeNameMapping" objects that map an existing attribute to a new attribute. This parameter is required.
             *                   <blockquote>
             *                   <p>
             *                   The existing attributes remain in the message, so if you want to remove the originals, use "RemoveAttributeActivity".
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link AddAttributesProperty#getName}
             * @param name The name of the 'addAttributes' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AddAttributesProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddAttributesProperty {
            private final java.lang.Object attributes;
            private final java.lang.String name;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = java.util.Objects.requireNonNull(builder.attributes, "attributes is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.next = builder.next;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributes", om.valueToTree(this.getAttributes()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.AddAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddAttributesProperty.Jsii$Proxy that = (AddAttributesProperty.Jsii$Proxy) o;

                if (!attributes.equals(that.attributes)) return false;
                if (!name.equals(that.name)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines the source of the messages to be processed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * ChannelProperty channelProperty = ChannelProperty.builder()
     *         .channelName("channelName")
     *         .name("name")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.ChannelProperty")
    @software.amazon.jsii.Jsii.Proxy(ChannelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChannelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the channel from which the messages are processed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChannelName();

        /**
         * The name of the 'channel' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChannelProperty> {
            java.lang.String channelName;
            java.lang.String name;
            java.lang.String next;

            /**
             * Sets the value of {@link ChannelProperty#getChannelName}
             * @param channelName The name of the channel from which the messages are processed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelName(java.lang.String channelName) {
                this.channelName = channelName;
                return this;
            }

            /**
             * Sets the value of {@link ChannelProperty#getName}
             * @param name The name of the 'channel' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ChannelProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChannelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChannelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelProperty {
            private final java.lang.String channelName;
            private final java.lang.String name;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelName = java.util.Objects.requireNonNull(builder.channelName, "channelName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.next = builder.next;
            }

            @Override
            public final java.lang.String getChannelName() {
                return this.channelName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("channelName", om.valueToTree(this.getChannelName()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.ChannelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChannelProperty.Jsii$Proxy that = (ChannelProperty.Jsii$Proxy) o;

                if (!channelName.equals(that.channelName)) return false;
                if (!name.equals(that.name)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channelName.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The datastore activity that specifies where to store the processed data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DatastoreProperty datastoreProperty = DatastoreProperty.builder()
     *         .datastoreName("datastoreName")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.DatastoreProperty")
    @software.amazon.jsii.Jsii.Proxy(DatastoreProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatastoreProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the data store where processed messages are stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatastoreName();

        /**
         * The name of the datastore activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link DatastoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatastoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatastoreProperty> {
            java.lang.String datastoreName;
            java.lang.String name;

            /**
             * Sets the value of {@link DatastoreProperty#getDatastoreName}
             * @param datastoreName The name of the data store where processed messages are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datastoreName(java.lang.String datastoreName) {
                this.datastoreName = datastoreName;
                return this;
            }

            /**
             * Sets the value of {@link DatastoreProperty#getName}
             * @param name The name of the datastore activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatastoreProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatastoreProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatastoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatastoreProperty {
            private final java.lang.String datastoreName;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datastoreName = software.amazon.jsii.Kernel.get(this, "datastoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datastoreName = java.util.Objects.requireNonNull(builder.datastoreName, "datastoreName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getDatastoreName() {
                return this.datastoreName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("datastoreName", om.valueToTree(this.getDatastoreName()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.DatastoreProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatastoreProperty.Jsii$Proxy that = (DatastoreProperty.Jsii$Proxy) o;

                if (!datastoreName.equals(that.datastoreName)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.datastoreName.hashCode();
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * An activity that adds data from the AWS IoT device registry to your message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DeviceRegistryEnrichProperty deviceRegistryEnrichProperty = DeviceRegistryEnrichProperty.builder()
     *         .attribute("attribute")
     *         .name("name")
     *         .roleArn("roleArn")
     *         .thingName("thingName")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.DeviceRegistryEnrichProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceRegistryEnrichProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceRegistryEnrichProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute that is added to the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * The name of the 'deviceRegistryEnrich' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The ARN of the role that allows access to the device's registry information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the IoT device whose registry information is added to the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getThingName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceRegistryEnrichProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceRegistryEnrichProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceRegistryEnrichProperty> {
            java.lang.String attribute;
            java.lang.String name;
            java.lang.String roleArn;
            java.lang.String thingName;
            java.lang.String next;

            /**
             * Sets the value of {@link DeviceRegistryEnrichProperty#getAttribute}
             * @param attribute The name of the attribute that is added to the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link DeviceRegistryEnrichProperty#getName}
             * @param name The name of the 'deviceRegistryEnrich' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DeviceRegistryEnrichProperty#getRoleArn}
             * @param roleArn The ARN of the role that allows access to the device's registry information. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DeviceRegistryEnrichProperty#getThingName}
             * @param thingName The name of the IoT device whose registry information is added to the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingName(java.lang.String thingName) {
                this.thingName = thingName;
                return this;
            }

            /**
             * Sets the value of {@link DeviceRegistryEnrichProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceRegistryEnrichProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceRegistryEnrichProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceRegistryEnrichProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceRegistryEnrichProperty {
            private final java.lang.String attribute;
            private final java.lang.String name;
            private final java.lang.String roleArn;
            private final java.lang.String thingName;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thingName = software.amazon.jsii.Kernel.get(this, "thingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.thingName = java.util.Objects.requireNonNull(builder.thingName, "thingName is required");
                this.next = builder.next;
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getThingName() {
                return this.thingName;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("thingName", om.valueToTree(this.getThingName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.DeviceRegistryEnrichProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceRegistryEnrichProperty.Jsii$Proxy that = (DeviceRegistryEnrichProperty.Jsii$Proxy) o;

                if (!attribute.equals(that.attribute)) return false;
                if (!name.equals(that.name)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!thingName.equals(that.thingName)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.thingName.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An activity that adds information from the AWS IoT Device Shadows service to a message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * DeviceShadowEnrichProperty deviceShadowEnrichProperty = DeviceShadowEnrichProperty.builder()
     *         .attribute("attribute")
     *         .name("name")
     *         .roleArn("roleArn")
     *         .thingName("thingName")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.DeviceShadowEnrichProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceShadowEnrichProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceShadowEnrichProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute that is added to the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * The name of the 'deviceShadowEnrich' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The ARN of the role that allows access to the device's shadow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the IoT device whose shadow information is added to the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getThingName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceShadowEnrichProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceShadowEnrichProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceShadowEnrichProperty> {
            java.lang.String attribute;
            java.lang.String name;
            java.lang.String roleArn;
            java.lang.String thingName;
            java.lang.String next;

            /**
             * Sets the value of {@link DeviceShadowEnrichProperty#getAttribute}
             * @param attribute The name of the attribute that is added to the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link DeviceShadowEnrichProperty#getName}
             * @param name The name of the 'deviceShadowEnrich' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DeviceShadowEnrichProperty#getRoleArn}
             * @param roleArn The ARN of the role that allows access to the device's shadow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DeviceShadowEnrichProperty#getThingName}
             * @param thingName The name of the IoT device whose shadow information is added to the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingName(java.lang.String thingName) {
                this.thingName = thingName;
                return this;
            }

            /**
             * Sets the value of {@link DeviceShadowEnrichProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceShadowEnrichProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceShadowEnrichProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceShadowEnrichProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceShadowEnrichProperty {
            private final java.lang.String attribute;
            private final java.lang.String name;
            private final java.lang.String roleArn;
            private final java.lang.String thingName;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thingName = software.amazon.jsii.Kernel.get(this, "thingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.thingName = java.util.Objects.requireNonNull(builder.thingName, "thingName is required");
                this.next = builder.next;
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getThingName() {
                return this.thingName;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("thingName", om.valueToTree(this.getThingName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.DeviceShadowEnrichProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceShadowEnrichProperty.Jsii$Proxy that = (DeviceShadowEnrichProperty.Jsii$Proxy) o;

                if (!attribute.equals(that.attribute)) return false;
                if (!name.equals(that.name)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!thingName.equals(that.thingName)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.thingName.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An activity that filters a message based on its attributes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * FilterProperty filterProperty = FilterProperty.builder()
     *         .filter("filter")
     *         .name("name")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.FilterProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that looks like an SQL WHERE clause that must return a Boolean value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilter();

        /**
         * The name of the 'filter' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterProperty> {
            java.lang.String filter;
            java.lang.String name;
            java.lang.String next;

            /**
             * Sets the value of {@link FilterProperty#getFilter}
             * @param filter An expression that looks like an SQL WHERE clause that must return a Boolean value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(java.lang.String filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getName}
             * @param name The name of the 'filter' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterProperty {
            private final java.lang.String filter;
            private final java.lang.String name;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.next = builder.next;
            }

            @Override
            public final java.lang.String getFilter() {
                return this.filter;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filter", om.valueToTree(this.getFilter()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.FilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterProperty.Jsii$Proxy that = (FilterProperty.Jsii$Proxy) o;

                if (!filter.equals(that.filter)) return false;
                if (!name.equals(that.name)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filter.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An activity that runs a Lambda function to modify the message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * LambdaProperty lambdaProperty = LambdaProperty.builder()
     *         .batchSize(123)
     *         .lambdaName("lambdaName")
     *         .name("name")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.LambdaProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of messages passed to the Lambda function for processing.
         * <p>
         * The AWS Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBatchSize();

        /**
         * The name of the Lambda function that is run on the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaName();

        /**
         * The name of the 'lambda' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaProperty> {
            java.lang.Number batchSize;
            java.lang.String lambdaName;
            java.lang.String name;
            java.lang.String next;

            /**
             * Sets the value of {@link LambdaProperty#getBatchSize}
             * @param batchSize The number of messages passed to the Lambda function for processing. This parameter is required.
             *                  The AWS Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link LambdaProperty#getLambdaName}
             * @param lambdaName The name of the Lambda function that is run on the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaName(java.lang.String lambdaName) {
                this.lambdaName = lambdaName;
                return this;
            }

            /**
             * Sets the value of {@link LambdaProperty#getName}
             * @param name The name of the 'lambda' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LambdaProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaProperty {
            private final java.lang.Number batchSize;
            private final java.lang.String lambdaName;
            private final java.lang.String name;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lambdaName = software.amazon.jsii.Kernel.get(this, "lambdaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.batchSize = java.util.Objects.requireNonNull(builder.batchSize, "batchSize is required");
                this.lambdaName = java.util.Objects.requireNonNull(builder.lambdaName, "lambdaName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.next = builder.next;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.String getLambdaName() {
                return this.lambdaName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("batchSize", om.valueToTree(this.getBatchSize()));
                data.set("lambdaName", om.valueToTree(this.getLambdaName()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.LambdaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaProperty.Jsii$Proxy that = (LambdaProperty.Jsii$Proxy) o;

                if (!batchSize.equals(that.batchSize)) return false;
                if (!lambdaName.equals(that.lambdaName)) return false;
                if (!name.equals(that.name)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.batchSize.hashCode();
                result = 31 * result + (this.lambdaName.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An activity that computes an arithmetic expression using the message's attributes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * MathProperty mathProperty = MathProperty.builder()
     *         .attribute("attribute")
     *         .math("math")
     *         .name("name")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.MathProperty")
    @software.amazon.jsii.Jsii.Proxy(MathProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MathProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute that contains the result of the math operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * An expression that uses one or more existing attributes and must return an integer value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMath();

        /**
         * The name of the 'math' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MathProperty> {
            java.lang.String attribute;
            java.lang.String math;
            java.lang.String name;
            java.lang.String next;

            /**
             * Sets the value of {@link MathProperty#getAttribute}
             * @param attribute The name of the attribute that contains the result of the math operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link MathProperty#getMath}
             * @param math An expression that uses one or more existing attributes and must return an integer value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder math(java.lang.String math) {
                this.math = math;
                return this;
            }

            /**
             * Sets the value of {@link MathProperty#getName}
             * @param name The name of the 'math' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MathProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MathProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MathProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MathProperty {
            private final java.lang.String attribute;
            private final java.lang.String math;
            private final java.lang.String name;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.math = software.amazon.jsii.Kernel.get(this, "math", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
                this.math = java.util.Objects.requireNonNull(builder.math, "math is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.next = builder.next;
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            public final java.lang.String getMath() {
                return this.math;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));
                data.set("math", om.valueToTree(this.getMath()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.MathProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MathProperty.Jsii$Proxy that = (MathProperty.Jsii$Proxy) o;

                if (!attribute.equals(that.attribute)) return false;
                if (!math.equals(that.math)) return false;
                if (!name.equals(that.name)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                result = 31 * result + (this.math.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An activity that removes attributes from a message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * RemoveAttributesProperty removeAttributesProperty = RemoveAttributesProperty.builder()
     *         .attributes(List.of("attributes"))
     *         .name("name")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.RemoveAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(RemoveAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RemoveAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of 1-50 attributes to remove from the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttributes();

        /**
         * The name of the 'removeAttributes' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RemoveAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RemoveAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RemoveAttributesProperty> {
            java.util.List<java.lang.String> attributes;
            java.lang.String name;
            java.lang.String next;

            /**
             * Sets the value of {@link RemoveAttributesProperty#getAttributes}
             * @param attributes A list of 1-50 attributes to remove from the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.List<java.lang.String> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link RemoveAttributesProperty#getName}
             * @param name The name of the 'removeAttributes' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RemoveAttributesProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RemoveAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RemoveAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RemoveAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RemoveAttributesProperty {
            private final java.util.List<java.lang.String> attributes;
            private final java.lang.String name;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = java.util.Objects.requireNonNull(builder.attributes, "attributes is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.next = builder.next;
            }

            @Override
            public final java.util.List<java.lang.String> getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributes", om.valueToTree(this.getAttributes()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.RemoveAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RemoveAttributesProperty.Jsii$Proxy that = (RemoveAttributesProperty.Jsii$Proxy) o;

                if (!attributes.equals(that.attributes)) return false;
                if (!name.equals(that.name)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Creates a new message using only the specified attributes from the original message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotanalytics.*;
     * SelectAttributesProperty selectAttributesProperty = SelectAttributesProperty.builder()
     *         .attributes(List.of("attributes"))
     *         .name("name")
     *         // the properties below are optional
     *         .next("next")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipeline.SelectAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(SelectAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelectAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of the attributes to select from the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttributes();

        /**
         * The name of the 'selectAttributes' activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next activity in the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNext() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelectAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelectAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelectAttributesProperty> {
            java.util.List<java.lang.String> attributes;
            java.lang.String name;
            java.lang.String next;

            /**
             * Sets the value of {@link SelectAttributesProperty#getAttributes}
             * @param attributes A list of the attributes to select from the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.List<java.lang.String> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link SelectAttributesProperty#getName}
             * @param name The name of the 'selectAttributes' activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SelectAttributesProperty#getNext}
             * @param next The next activity in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder next(java.lang.String next) {
                this.next = next;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelectAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelectAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelectAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelectAttributesProperty {
            private final java.util.List<java.lang.String> attributes;
            private final java.lang.String name;
            private final java.lang.String next;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = java.util.Objects.requireNonNull(builder.attributes, "attributes is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.next = builder.next;
            }

            @Override
            public final java.util.List<java.lang.String> getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNext() {
                return this.next;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributes", om.valueToTree(this.getAttributes()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNext() != null) {
                    data.set("next", om.valueToTree(this.getNext()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipeline.SelectAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelectAttributesProperty.Jsii$Proxy that = (SelectAttributesProperty.Jsii$Proxy) o;

                if (!attributes.equals(that.attributes)) return false;
                if (!name.equals(that.name)) return false;
                return this.next != null ? this.next.equals(that.next) : that.next == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotanalytics.CfnPipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotanalytics.CfnPipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotanalytics.CfnPipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotanalytics.CfnPipelineProps.Builder();
        }

        /**
         * A list of "PipelineActivity" objects.
         * <p>
         * Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
         * <p>
         * The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
         * <p>
         * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * <p>
         * @return {@code this}
         * @param pipelineActivities A list of "PipelineActivity" objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineActivities(final software.amazon.awscdk.IResolvable pipelineActivities) {
            this.props.pipelineActivities(pipelineActivities);
            return this;
        }
        /**
         * A list of "PipelineActivity" objects.
         * <p>
         * Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
         * <p>
         * The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
         * <p>
         * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * <p>
         * @return {@code this}
         * @param pipelineActivities A list of "PipelineActivity" objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineActivities(final java.util.List<? extends java.lang.Object> pipelineActivities) {
            this.props.pipelineActivities(pipelineActivities);
            return this;
        }

        /**
         * The name of the pipeline.
         * <p>
         * @return {@code this}
         * @param pipelineName The name of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(final java.lang.String pipelineName) {
            this.props.pipelineName(pipelineName);
            return this;
        }

        /**
         * Metadata which can be used to manage the pipeline.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags Metadata which can be used to manage the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotanalytics.CfnPipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotanalytics.CfnPipeline build() {
            return new software.amazon.awscdk.services.iotanalytics.CfnPipeline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
