package software.amazon.awscdk.services.iotanalytics;

/**
 * Properties for defining a `CfnPipeline`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * CfnPipelineProps cfnPipelineProps = CfnPipelineProps.builder()
 *         .pipelineActivities(List.of(ActivityProperty.builder()
 *                 .addAttributes(AddAttributesProperty.builder()
 *                         .attributes(Map.of(
 *                                 "attributesKey", "attributes"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .channel(ChannelProperty.builder()
 *                         .channelName("channelName")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .datastore(DatastoreProperty.builder()
 *                         .datastoreName("datastoreName")
 *                         .name("name")
 *                         .build())
 *                 .deviceRegistryEnrich(DeviceRegistryEnrichProperty.builder()
 *                         .attribute("attribute")
 *                         .name("name")
 *                         .roleArn("roleArn")
 *                         .thingName("thingName")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .deviceShadowEnrich(DeviceShadowEnrichProperty.builder()
 *                         .attribute("attribute")
 *                         .name("name")
 *                         .roleArn("roleArn")
 *                         .thingName("thingName")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .filter(FilterProperty.builder()
 *                         .filter("filter")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .lambda(LambdaProperty.builder()
 *                         .batchSize(123)
 *                         .lambdaName("lambdaName")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .math(MathProperty.builder()
 *                         .attribute("attribute")
 *                         .math("math")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .removeAttributes(RemoveAttributesProperty.builder()
 *                         .attributes(List.of("attributes"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .selectAttributes(SelectAttributesProperty.builder()
 *                         .attributes(List.of("attributes"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .next("next")
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .pipelineName("pipelineName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:55.999Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnPipelineProps")
@software.amazon.jsii.Jsii.Proxy(CfnPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of "PipelineActivity" objects.
     * <p>
     * Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
     * <p>
     * The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
     * <p>
     * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPipelineActivities();

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineName() {
        return null;
    }

    /**
     * Metadata which can be used to manage the pipeline.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPipelineProps> {
        java.lang.Object pipelineActivities;
        java.lang.String pipelineName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineActivities}
         * @param pipelineActivities A list of "PipelineActivity" objects. This parameter is required.
         *                           Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
         *                           <p>
         *                           The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
         *                           <p>
         *                           <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineActivities(software.amazon.awscdk.IResolvable pipelineActivities) {
            this.pipelineActivities = pipelineActivities;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineActivities}
         * @param pipelineActivities A list of "PipelineActivity" objects. This parameter is required.
         *                           Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
         *                           <p>
         *                           The list can be 2-25 <em>PipelineActivity</em> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:
         *                           <p>
         *                           <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineActivities(java.util.List<? extends java.lang.Object> pipelineActivities) {
            this.pipelineActivities = pipelineActivities;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineName}
         * @param pipelineName The name of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getTags}
         * @param tags Metadata which can be used to manage the pipeline.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPipelineProps {
        private final java.lang.Object pipelineActivities;
        private final java.lang.String pipelineName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.pipelineActivities = software.amazon.jsii.Kernel.get(this, "pipelineActivities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.pipelineActivities = java.util.Objects.requireNonNull(builder.pipelineActivities, "pipelineActivities is required");
            this.pipelineName = builder.pipelineName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getPipelineActivities() {
            return this.pipelineActivities;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("pipelineActivities", om.valueToTree(this.getPipelineActivities()));
            if (this.getPipelineName() != null) {
                data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPipelineProps.Jsii$Proxy that = (CfnPipelineProps.Jsii$Proxy) o;

            if (!pipelineActivities.equals(that.pipelineActivities)) return false;
            if (this.pipelineName != null ? !this.pipelineName.equals(that.pipelineName) : that.pipelineName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.pipelineActivities.hashCode();
            result = 31 * result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
