package software.amazon.awscdk.services.kinesisfirehose;

/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 * <p>
 * The <code>AWS::KinesisFirehose::DeliveryStream</code> resource specifies an Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivery stream that delivers real-time streaming data to an Amazon Simple Storage Service (Amazon S3), Amazon Redshift, or Amazon Elasticsearch Service (Amazon ES) destination. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-create.html">Creating an Amazon Kinesis Data Firehose Delivery Stream</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * CfnDeliveryStream cfnDeliveryStream = CfnDeliveryStream.Builder.create(this, "MyCfnDeliveryStream")
 *         .amazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfigurationProperty.builder()
 *                 .indexName("indexName")
 *                 .roleArn("roleArn")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .bufferingHints(AmazonopensearchserviceBufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .clusterEndpoint("clusterEndpoint")
 *                 .domainArn("domainArn")
 *                 .indexRotationPeriod("indexRotationPeriod")
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(AmazonopensearchserviceRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .typeName("typeName")
 *                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build())
 *                 .build())
 *         .deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInputProperty.builder()
 *                 .keyType("keyType")
 *                 // the properties below are optional
 *                 .keyArn("keyArn")
 *                 .build())
 *         .deliveryStreamName("deliveryStreamName")
 *         .deliveryStreamType("deliveryStreamType")
 *         .elasticsearchDestinationConfiguration(ElasticsearchDestinationConfigurationProperty.builder()
 *                 .indexName("indexName")
 *                 .roleArn("roleArn")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .bufferingHints(ElasticsearchBufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .clusterEndpoint("clusterEndpoint")
 *                 .domainArn("domainArn")
 *                 .indexRotationPeriod("indexRotationPeriod")
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(ElasticsearchRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .typeName("typeName")
 *                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build())
 *                 .build())
 *         .extendedS3DestinationConfiguration(ExtendedS3DestinationConfigurationProperty.builder()
 *                 .bucketArn("bucketArn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .bufferingHints(BufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .compressionFormat("compressionFormat")
 *                 .dataFormatConversionConfiguration(DataFormatConversionConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .inputFormatConfiguration(InputFormatConfigurationProperty.builder()
 *                                 .deserializer(DeserializerProperty.builder()
 *                                         .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
 *                                                 .timestampFormats(List.of("timestampFormats"))
 *                                                 .build())
 *                                         .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
 *                                                 .caseInsensitive(false)
 *                                                 .columnToJsonKeyMappings(Map.of(
 *                                                         "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
 *                                                 .convertDotsInJsonKeysToUnderscores(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .outputFormatConfiguration(OutputFormatConfigurationProperty.builder()
 *                                 .serializer(SerializerProperty.builder()
 *                                         .orcSerDe(OrcSerDeProperty.builder()
 *                                                 .blockSizeBytes(123)
 *                                                 .bloomFilterColumns(List.of("bloomFilterColumns"))
 *                                                 .bloomFilterFalsePositiveProbability(123)
 *                                                 .compression("compression")
 *                                                 .dictionaryKeyThreshold(123)
 *                                                 .enablePadding(false)
 *                                                 .formatVersion("formatVersion")
 *                                                 .paddingTolerance(123)
 *                                                 .rowIndexStride(123)
 *                                                 .stripeSizeBytes(123)
 *                                                 .build())
 *                                         .parquetSerDe(ParquetSerDeProperty.builder()
 *                                                 .blockSizeBytes(123)
 *                                                 .compression("compression")
 *                                                 .enableDictionaryCompression(false)
 *                                                 .maxPaddingBytes(123)
 *                                                 .pageSizeBytes(123)
 *                                                 .writerVersion("writerVersion")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .schemaConfiguration(SchemaConfigurationProperty.builder()
 *                                 .catalogId("catalogId")
 *                                 .databaseName("databaseName")
 *                                 .region("region")
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 .versionId("versionId")
 *                                 .build())
 *                         .build())
 *                 .dynamicPartitioningConfiguration(DynamicPartitioningConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .retryOptions(RetryOptionsProperty.builder()
 *                                 .durationInSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                 .awskmsKeyArn("awskmsKeyArn")
 *                                 .build())
 *                         .noEncryptionConfig("noEncryptionConfig")
 *                         .build())
 *                 .errorOutputPrefix("errorOutputPrefix")
 *                 .prefix("prefix")
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .httpEndpointDestinationConfiguration(HttpEndpointDestinationConfigurationProperty.builder()
 *                 .endpointConfiguration(HttpEndpointConfigurationProperty.builder()
 *                         .url("url")
 *                         // the properties below are optional
 *                         .accessKey("accessKey")
 *                         .name("name")
 *                         .build())
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .bufferingHints(BufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .requestConfiguration(HttpEndpointRequestConfigurationProperty.builder()
 *                         .commonAttributes(List.of(HttpEndpointCommonAttributeProperty.builder()
 *                                 .attributeName("attributeName")
 *                                 .attributeValue("attributeValue")
 *                                 .build()))
 *                         .contentEncoding("contentEncoding")
 *                         .build())
 *                 .retryOptions(RetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .roleArn("roleArn")
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .kinesisStreamSourceConfiguration(KinesisStreamSourceConfigurationProperty.builder()
 *                 .kinesisStreamArn("kinesisStreamArn")
 *                 .roleArn("roleArn")
 *                 .build())
 *         .redshiftDestinationConfiguration(RedshiftDestinationConfigurationProperty.builder()
 *                 .clusterJdbcurl("clusterJdbcurl")
 *                 .copyCommand(CopyCommandProperty.builder()
 *                         .dataTableName("dataTableName")
 *                         // the properties below are optional
 *                         .copyOptions("copyOptions")
 *                         .dataTableColumns("dataTableColumns")
 *                         .build())
 *                 .password("password")
 *                 .roleArn("roleArn")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 .username("username")
 *                 // the properties below are optional
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(RedshiftRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
 *                 .bucketArn("bucketArn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .bufferingHints(BufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .compressionFormat("compressionFormat")
 *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                 .awskmsKeyArn("awskmsKeyArn")
 *                                 .build())
 *                         .noEncryptionConfig("noEncryptionConfig")
 *                         .build())
 *                 .errorOutputPrefix("errorOutputPrefix")
 *                 .prefix("prefix")
 *                 .build())
 *         .splunkDestinationConfiguration(SplunkDestinationConfigurationProperty.builder()
 *                 .hecEndpoint("hecEndpoint")
 *                 .hecEndpointType("hecEndpointType")
 *                 .hecToken("hecToken")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .hecAcknowledgmentTimeoutInSeconds(123)
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(SplunkRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:56.323Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream")
public class CfnDeliveryStream extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDeliveryStream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeliveryStream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::KinesisFirehose::DeliveryStream`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeliveryStream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::KinesisFirehose::DeliveryStream`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeliveryStream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the delivery stream, such as `arn:aws:firehose:us-east-2:123456789012:deliverystream/delivery-stream-name` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A set of tags to assign to the delivery stream.
     * <p>
     * A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
     * <p>
     * You can specify up to 50 tags when creating a delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The destination in Amazon OpenSearch Service.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAmazonopensearchserviceDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "amazonopensearchserviceDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The destination in Amazon OpenSearch Service.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonopensearchserviceDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "amazonopensearchserviceDestinationConfiguration", value);
    }

    /**
     * The destination in Amazon OpenSearch Service.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonopensearchserviceDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "amazonopensearchserviceDestinationConfiguration", value);
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryStreamEncryptionConfigurationInput() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStreamEncryptionConfigurationInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamEncryptionConfigurationInput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamEncryptionConfigurationInput", value);
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamEncryptionConfigurationInput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamEncryptionConfigurationInput", value);
    }

    /**
     * The name of the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamName() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamName", value);
    }

    /**
     * The delivery stream type. This can be one of the following values:.
     * <p>
     * <ul>
     * <li><code>DirectPut</code> : Provider applications access the delivery stream directly.</li>
     * <li><code>KinesisStreamAsSource</code> : The delivery stream uses a Kinesis data stream as a source.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamType() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStreamType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The delivery stream type. This can be one of the following values:.
     * <p>
     * <ul>
     * <li><code>DirectPut</code> : Provider applications access the delivery stream directly.</li>
     * <li><code>KinesisStreamAsSource</code> : The delivery stream uses a Kinesis data stream as a source.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamType", value);
    }

    /**
     * An Amazon ES destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An Amazon ES destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchDestinationConfiguration", value);
    }

    /**
     * An Amazon ES destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchDestinationConfiguration", value);
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExtendedS3DestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "extendedS3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendedS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "extendedS3DestinationConfiguration", value);
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendedS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "extendedS3DestinationConfiguration", value);
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHttpEndpointDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "httpEndpointDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpEndpointDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "httpEndpointDestinationConfiguration", value);
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpEndpointDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "httpEndpointDestinationConfiguration", value);
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "kinesisStreamSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamSourceConfiguration", value);
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamSourceConfiguration", value);
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "redshiftDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "redshiftDestinationConfiguration", value);
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redshiftDestinationConfiguration", value);
    }

    /**
     * The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3DestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "s3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3DestinationConfiguration", value);
    }

    /**
     * The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3DestinationConfiguration", value);
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSplunkDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "splunkDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSplunkDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "splunkDestinationConfiguration", value);
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSplunkDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "splunkDestinationConfiguration", value);
    }
    /**
     * Describes the buffering to perform before delivering data to the Amazon OpenSearch Service destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonopensearchserviceBufferingHintsProperty amazonopensearchserviceBufferingHintsProperty = AmazonopensearchserviceBufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceBufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonopensearchserviceBufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonopensearchserviceBufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
         * <p>
         * The default value is 300 (5 minutes).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
         * <p>
         * The default value is 5. We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonopensearchserviceBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonopensearchserviceBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonopensearchserviceBufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link AmazonopensearchserviceBufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
             *                          The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceBufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
             *                  The default value is 5. We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonopensearchserviceBufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonopensearchserviceBufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonopensearchserviceBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonopensearchserviceBufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceBufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonopensearchserviceBufferingHintsProperty.Jsii$Proxy that = (AmazonopensearchserviceBufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration of a destination in Amazon OpenSearch Service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonopensearchserviceDestinationConfigurationProperty amazonopensearchserviceDestinationConfigurationProperty = AmazonopensearchserviceDestinationConfigurationProperty.builder()
     *         .indexName("indexName")
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .bufferingHints(AmazonopensearchserviceBufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .clusterEndpoint("clusterEndpoint")
     *         .domainArn("domainArn")
     *         .indexRotationPeriod("indexRotationPeriod")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(AmazonopensearchserviceRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .typeName("typeName")
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonopensearchserviceDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonopensearchserviceDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon OpenSearch Service index name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The buffering options.
         * <p>
         * If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The endpoint to use when communicating with the cluster.
         * <p>
         * Specify either this ClusterEndpoint or the DomainARN field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpoint() {
            return null;
        }

        /**
         * The ARN of the Amazon OpenSearch Service domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainArn() {
            return null;
        }

        /**
         * The Amazon OpenSearch Service index rotation period.
         * <p>
         * Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIndexRotationPeriod() {
            return null;
        }

        /**
         * Describes a data processing configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
         * <p>
         * The default value is 300 (5 minutes).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Defines how documents should be delivered to Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * The Amazon OpenSearch Service type name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
            return null;
        }

        /**
         * The details of the VPC of the Amazon OpenSearch Service destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonopensearchserviceDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonopensearchserviceDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonopensearchserviceDestinationConfigurationProperty> {
            java.lang.String indexName;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String clusterEndpoint;
            java.lang.String domainArn;
            java.lang.String indexRotationPeriod;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;
            java.lang.String typeName;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getIndexName}
             * @param indexName The Amazon OpenSearch Service index name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options.
             *                       If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceBufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options.
             *                       If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getClusterEndpoint}
             * @param clusterEndpoint The endpoint to use when communicating with the cluster.
             *                        Specify either this ClusterEndpoint or the DomainARN field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterEndpoint(java.lang.String clusterEndpoint) {
                this.clusterEndpoint = clusterEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getDomainArn}
             * @param domainArn The ARN of the Amazon OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainArn(java.lang.String domainArn) {
                this.domainArn = domainArn;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getIndexRotationPeriod}
             * @param indexRotationPeriod The Amazon OpenSearch Service index rotation period.
             *                            Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexRotationPeriod(java.lang.String indexRotationPeriod) {
                this.indexRotationPeriod = indexRotationPeriod;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes a data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes a data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
             *                     The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
             *                     The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Defines how documents should be delivered to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getTypeName}
             * @param typeName The Amazon OpenSearch Service type name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeName(java.lang.String typeName) {
                this.typeName = typeName;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon OpenSearch Service destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon OpenSearch Service destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonopensearchserviceDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonopensearchserviceDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonopensearchserviceDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonopensearchserviceDestinationConfigurationProperty {
            private final java.lang.String indexName;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String clusterEndpoint;
            private final java.lang.String domainArn;
            private final java.lang.String indexRotationPeriod;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;
            private final java.lang.String typeName;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clusterEndpoint = software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainArn = software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexRotationPeriod = software.amazon.jsii.Kernel.get(this, "indexRotationPeriod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.clusterEndpoint = builder.clusterEndpoint;
                this.domainArn = builder.domainArn;
                this.indexRotationPeriod = builder.indexRotationPeriod;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
                this.typeName = builder.typeName;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getClusterEndpoint() {
                return this.clusterEndpoint;
            }

            @Override
            public final java.lang.String getDomainArn() {
                return this.domainArn;
            }

            @Override
            public final java.lang.String getIndexRotationPeriod() {
                return this.indexRotationPeriod;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.String getTypeName() {
                return this.typeName;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getClusterEndpoint() != null) {
                    data.set("clusterEndpoint", om.valueToTree(this.getClusterEndpoint()));
                }
                if (this.getDomainArn() != null) {
                    data.set("domainArn", om.valueToTree(this.getDomainArn()));
                }
                if (this.getIndexRotationPeriod() != null) {
                    data.set("indexRotationPeriod", om.valueToTree(this.getIndexRotationPeriod()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getTypeName() != null) {
                    data.set("typeName", om.valueToTree(this.getTypeName()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonopensearchserviceDestinationConfigurationProperty.Jsii$Proxy that = (AmazonopensearchserviceDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.clusterEndpoint != null ? !this.clusterEndpoint.equals(that.clusterEndpoint) : that.clusterEndpoint != null) return false;
                if (this.domainArn != null ? !this.domainArn.equals(that.domainArn) : that.domainArn != null) return false;
                if (this.indexRotationPeriod != null ? !this.indexRotationPeriod.equals(that.indexRotationPeriod) : that.indexRotationPeriod != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.clusterEndpoint != null ? this.clusterEndpoint.hashCode() : 0);
                result = 31 * result + (this.domainArn != null ? this.domainArn.hashCode() : 0);
                result = 31 * result + (this.indexRotationPeriod != null ? this.indexRotationPeriod.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonopensearchserviceRetryOptionsProperty amazonopensearchserviceRetryOptionsProperty = AmazonopensearchserviceRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonopensearchserviceRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonopensearchserviceRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * After an initial failure to deliver to Amazon OpenSearch Service, the total amount of time during which Kinesis Data Firehose retries delivery (including the first attempt).
         * <p>
         * After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonopensearchserviceRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonopensearchserviceRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonopensearchserviceRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link AmazonopensearchserviceRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds After an initial failure to deliver to Amazon OpenSearch Service, the total amount of time during which Kinesis Data Firehose retries delivery (including the first attempt).
             *                          After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonopensearchserviceRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonopensearchserviceRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonopensearchserviceRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonopensearchserviceRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonopensearchserviceRetryOptionsProperty.Jsii$Proxy that = (AmazonopensearchserviceRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `BufferingHints` property type specifies how Amazon Kinesis Data Firehose (Kinesis Data Firehose) buffers incoming data before delivering it to the destination.
     * <p>
     * The first buffer condition that is satisfied triggers Kinesis Data Firehose to deliver the data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * BufferingHintsProperty bufferingHintsProperty = BufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(BufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link BufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
             *                          For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link BufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
             *                  For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BufferingHintsProperty.Jsii$Proxy that = (BufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `CloudWatchLoggingOptions` property type specifies Amazon CloudWatch Logs (CloudWatch Logs) logging options that Amazon Kinesis Data Firehose (Kinesis Data Firehose) uses for the delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * CloudWatchLoggingOptionsProperty cloudWatchLoggingOptionsProperty = CloudWatchLoggingOptionsProperty.builder()
     *         .enabled(false)
     *         .logGroupName("logGroupName")
     *         .logStreamName("logStreamName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLoggingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLoggingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether CloudWatch Logs logging is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The name of the CloudWatch Logs log group that contains the log stream that Kinesis Data Firehose will use.
         * <p>
         * Conditional. If you enable logging, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
            return null;
        }

        /**
         * The name of the CloudWatch Logs log stream that Kinesis Data Firehose uses to send logs about data delivery.
         * <p>
         * Conditional. If you enable logging, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLoggingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLoggingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLoggingOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String logGroupName;
            java.lang.String logStreamName;

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Logs logging is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Logs logging is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getLogGroupName}
             * @param logGroupName The name of the CloudWatch Logs log group that contains the log stream that Kinesis Data Firehose will use.
             *                     Conditional. If you enable logging, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getLogStreamName}
             * @param logStreamName The name of the CloudWatch Logs log stream that Kinesis Data Firehose uses to send logs about data delivery.
             *                      Conditional. If you enable logging, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logStreamName(java.lang.String logStreamName) {
                this.logStreamName = logStreamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLoggingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLoggingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLoggingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLoggingOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String logGroupName;
            private final java.lang.String logStreamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logStreamName = software.amazon.jsii.Kernel.get(this, "logStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.logGroupName = builder.logGroupName;
                this.logStreamName = builder.logStreamName;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            public final java.lang.String getLogStreamName() {
                return this.logStreamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getLogGroupName() != null) {
                    data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                }
                if (this.getLogStreamName() != null) {
                    data.set("logStreamName", om.valueToTree(this.getLogStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLoggingOptionsProperty.Jsii$Proxy that = (CloudWatchLoggingOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
                return this.logStreamName != null ? this.logStreamName.equals(that.logStreamName) : that.logStreamName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
                result = 31 * result + (this.logStreamName != null ? this.logStreamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `CopyCommand` property type configures the Amazon Redshift `COPY` command that Amazon Kinesis Data Firehose (Kinesis Data Firehose) uses to load data into an Amazon Redshift cluster from an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * CopyCommandProperty copyCommandProperty = CopyCommandProperty.builder()
     *         .dataTableName("dataTableName")
     *         // the properties below are optional
     *         .copyOptions("copyOptions")
     *         .dataTableColumns("dataTableColumns")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CopyCommandProperty")
    @software.amazon.jsii.Jsii.Proxy(CopyCommandProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CopyCommandProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the target table.
         * <p>
         * The table must already exist in the database.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataTableName();

        /**
         * Parameters to use with the Amazon Redshift `COPY` command.
         * <p>
         * For examples, see the <code>CopyOptions</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html">CopyCommand</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCopyOptions() {
            return null;
        }

        /**
         * A comma-separated list of column names.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataTableColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CopyCommandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CopyCommandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CopyCommandProperty> {
            java.lang.String dataTableName;
            java.lang.String copyOptions;
            java.lang.String dataTableColumns;

            /**
             * Sets the value of {@link CopyCommandProperty#getDataTableName}
             * @param dataTableName The name of the target table. This parameter is required.
             *                      The table must already exist in the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTableName(java.lang.String dataTableName) {
                this.dataTableName = dataTableName;
                return this;
            }

            /**
             * Sets the value of {@link CopyCommandProperty#getCopyOptions}
             * @param copyOptions Parameters to use with the Amazon Redshift `COPY` command.
             *                    For examples, see the <code>CopyOptions</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html">CopyCommand</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyOptions(java.lang.String copyOptions) {
                this.copyOptions = copyOptions;
                return this;
            }

            /**
             * Sets the value of {@link CopyCommandProperty#getDataTableColumns}
             * @param dataTableColumns A comma-separated list of column names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTableColumns(java.lang.String dataTableColumns) {
                this.dataTableColumns = dataTableColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CopyCommandProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CopyCommandProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CopyCommandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyCommandProperty {
            private final java.lang.String dataTableName;
            private final java.lang.String copyOptions;
            private final java.lang.String dataTableColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataTableName = software.amazon.jsii.Kernel.get(this, "dataTableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyOptions = software.amazon.jsii.Kernel.get(this, "copyOptions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataTableColumns = software.amazon.jsii.Kernel.get(this, "dataTableColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataTableName = java.util.Objects.requireNonNull(builder.dataTableName, "dataTableName is required");
                this.copyOptions = builder.copyOptions;
                this.dataTableColumns = builder.dataTableColumns;
            }

            @Override
            public final java.lang.String getDataTableName() {
                return this.dataTableName;
            }

            @Override
            public final java.lang.String getCopyOptions() {
                return this.copyOptions;
            }

            @Override
            public final java.lang.String getDataTableColumns() {
                return this.dataTableColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataTableName", om.valueToTree(this.getDataTableName()));
                if (this.getCopyOptions() != null) {
                    data.set("copyOptions", om.valueToTree(this.getCopyOptions()));
                }
                if (this.getDataTableColumns() != null) {
                    data.set("dataTableColumns", om.valueToTree(this.getDataTableColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CopyCommandProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CopyCommandProperty.Jsii$Proxy that = (CopyCommandProperty.Jsii$Proxy) o;

                if (!dataTableName.equals(that.dataTableName)) return false;
                if (this.copyOptions != null ? !this.copyOptions.equals(that.copyOptions) : that.copyOptions != null) return false;
                return this.dataTableColumns != null ? this.dataTableColumns.equals(that.dataTableColumns) : that.dataTableColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataTableName.hashCode();
                result = 31 * result + (this.copyOptions != null ? this.copyOptions.hashCode() : 0);
                result = 31 * result + (this.dataTableColumns != null ? this.dataTableColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies that you want Kinesis Data Firehose to convert data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
     * <p>
     * Kinesis Data Firehose uses the serializer and deserializer that you specify, in addition to the column information from the AWS Glue table, to deserialize your input data from JSON and then serialize it to the Parquet or ORC format. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html">Kinesis Data Firehose Record Format Conversion</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DataFormatConversionConfigurationProperty dataFormatConversionConfigurationProperty = DataFormatConversionConfigurationProperty.builder()
     *         .enabled(false)
     *         .inputFormatConfiguration(InputFormatConfigurationProperty.builder()
     *                 .deserializer(DeserializerProperty.builder()
     *                         .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                                 .timestampFormats(List.of("timestampFormats"))
     *                                 .build())
     *                         .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                                 .caseInsensitive(false)
     *                                 .columnToJsonKeyMappings(Map.of(
     *                                         "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                                 .convertDotsInJsonKeysToUnderscores(false)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .outputFormatConfiguration(OutputFormatConfigurationProperty.builder()
     *                 .serializer(SerializerProperty.builder()
     *                         .orcSerDe(OrcSerDeProperty.builder()
     *                                 .blockSizeBytes(123)
     *                                 .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                                 .bloomFilterFalsePositiveProbability(123)
     *                                 .compression("compression")
     *                                 .dictionaryKeyThreshold(123)
     *                                 .enablePadding(false)
     *                                 .formatVersion("formatVersion")
     *                                 .paddingTolerance(123)
     *                                 .rowIndexStride(123)
     *                                 .stripeSizeBytes(123)
     *                                 .build())
     *                         .parquetSerDe(ParquetSerDeProperty.builder()
     *                                 .blockSizeBytes(123)
     *                                 .compression("compression")
     *                                 .enableDictionaryCompression(false)
     *                                 .maxPaddingBytes(123)
     *                                 .pageSizeBytes(123)
     *                                 .writerVersion("writerVersion")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .schemaConfiguration(SchemaConfigurationProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 .region("region")
     *                 .roleArn("roleArn")
     *                 .tableName("tableName")
     *                 .versionId("versionId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DataFormatConversionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataFormatConversionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataFormatConversionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defaults to `true` .
         * <p>
         * Set it to <code>false</code> if you want to disable format conversion while preserving the configuration details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON.
         * <p>
         * This parameter is required if <code>Enabled</code> is set to true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputFormatConfiguration() {
            return null;
        }

        /**
         * Specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format.
         * <p>
         * This parameter is required if <code>Enabled</code> is set to true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputFormatConfiguration() {
            return null;
        }

        /**
         * Specifies the AWS Glue Data Catalog table that contains the column information.
         * <p>
         * This parameter is required if <code>Enabled</code> is set to true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataFormatConversionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataFormatConversionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataFormatConversionConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object inputFormatConfiguration;
            java.lang.Object outputFormatConfiguration;
            java.lang.Object schemaConfiguration;

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getEnabled}
             * @param enabled Defaults to `true` .
             *                Set it to <code>false</code> if you want to disable format conversion while preserving the configuration details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getEnabled}
             * @param enabled Defaults to `true` .
             *                Set it to <code>false</code> if you want to disable format conversion while preserving the configuration details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getInputFormatConfiguration}
             * @param inputFormatConfiguration Specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON.
             *                                 This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormatConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty inputFormatConfiguration) {
                this.inputFormatConfiguration = inputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getInputFormatConfiguration}
             * @param inputFormatConfiguration Specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON.
             *                                 This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormatConfiguration(software.amazon.awscdk.IResolvable inputFormatConfiguration) {
                this.inputFormatConfiguration = inputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getOutputFormatConfiguration}
             * @param outputFormatConfiguration Specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format.
             *                                  This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormatConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty outputFormatConfiguration) {
                this.outputFormatConfiguration = outputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getOutputFormatConfiguration}
             * @param outputFormatConfiguration Specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format.
             *                                  This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormatConfiguration(software.amazon.awscdk.IResolvable outputFormatConfiguration) {
                this.outputFormatConfiguration = outputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getSchemaConfiguration}
             * @param schemaConfiguration Specifies the AWS Glue Data Catalog table that contains the column information.
             *                            This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty schemaConfiguration) {
                this.schemaConfiguration = schemaConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getSchemaConfiguration}
             * @param schemaConfiguration Specifies the AWS Glue Data Catalog table that contains the column information.
             *                            This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaConfiguration(software.amazon.awscdk.IResolvable schemaConfiguration) {
                this.schemaConfiguration = schemaConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataFormatConversionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataFormatConversionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataFormatConversionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataFormatConversionConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object inputFormatConfiguration;
            private final java.lang.Object outputFormatConfiguration;
            private final java.lang.Object schemaConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputFormatConfiguration = software.amazon.jsii.Kernel.get(this, "inputFormatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputFormatConfiguration = software.amazon.jsii.Kernel.get(this, "outputFormatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schemaConfiguration = software.amazon.jsii.Kernel.get(this, "schemaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.inputFormatConfiguration = builder.inputFormatConfiguration;
                this.outputFormatConfiguration = builder.outputFormatConfiguration;
                this.schemaConfiguration = builder.schemaConfiguration;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getInputFormatConfiguration() {
                return this.inputFormatConfiguration;
            }

            @Override
            public final java.lang.Object getOutputFormatConfiguration() {
                return this.outputFormatConfiguration;
            }

            @Override
            public final java.lang.Object getSchemaConfiguration() {
                return this.schemaConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getInputFormatConfiguration() != null) {
                    data.set("inputFormatConfiguration", om.valueToTree(this.getInputFormatConfiguration()));
                }
                if (this.getOutputFormatConfiguration() != null) {
                    data.set("outputFormatConfiguration", om.valueToTree(this.getOutputFormatConfiguration()));
                }
                if (this.getSchemaConfiguration() != null) {
                    data.set("schemaConfiguration", om.valueToTree(this.getSchemaConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DataFormatConversionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataFormatConversionConfigurationProperty.Jsii$Proxy that = (DataFormatConversionConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.inputFormatConfiguration != null ? !this.inputFormatConfiguration.equals(that.inputFormatConfiguration) : that.inputFormatConfiguration != null) return false;
                if (this.outputFormatConfiguration != null ? !this.outputFormatConfiguration.equals(that.outputFormatConfiguration) : that.outputFormatConfiguration != null) return false;
                return this.schemaConfiguration != null ? this.schemaConfiguration.equals(that.schemaConfiguration) : that.schemaConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.inputFormatConfiguration != null ? this.inputFormatConfiguration.hashCode() : 0);
                result = 31 * result + (this.outputFormatConfiguration != null ? this.outputFormatConfiguration.hashCode() : 0);
                result = 31 * result + (this.schemaConfiguration != null ? this.schemaConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DeliveryStreamEncryptionConfigurationInputProperty deliveryStreamEncryptionConfigurationInputProperty = DeliveryStreamEncryptionConfigurationInputProperty.builder()
     *         .keyType("keyType")
     *         // the properties below are optional
     *         .keyArn("keyArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(DeliveryStreamEncryptionConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeliveryStreamEncryptionConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the type of customer master key (CMK) to use for encryption.
         * <p>
         * The default setting is <code>AWS_OWNED_CMK</code> . For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys (CMKs)</a> .
         * <p>
         * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams.
         * <p>
         * <blockquote>
         * <p>
         * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer guide.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyType();

        /**
         * If you set `KeyType` to `CUSTOMER_MANAGED_CMK` , you must specify the Amazon Resource Name (ARN) of the CMK.
         * <p>
         * If you set <code>KeyType</code> to <code>AWS _OWNED_CMK</code> , Kinesis Data Firehose uses a service-account CMK.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeliveryStreamEncryptionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeliveryStreamEncryptionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeliveryStreamEncryptionConfigurationInputProperty> {
            java.lang.String keyType;
            java.lang.String keyArn;

            /**
             * Sets the value of {@link DeliveryStreamEncryptionConfigurationInputProperty#getKeyType}
             * @param keyType Indicates the type of customer master key (CMK) to use for encryption. This parameter is required.
             *                The default setting is <code>AWS_OWNED_CMK</code> . For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys (CMKs)</a> .
             *                <p>
             *                You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams.
             *                <p>
             *                <blockquote>
             *                <p>
             *                To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer guide.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Sets the value of {@link DeliveryStreamEncryptionConfigurationInputProperty#getKeyArn}
             * @param keyArn If you set `KeyType` to `CUSTOMER_MANAGED_CMK` , you must specify the Amazon Resource Name (ARN) of the CMK.
             *               If you set <code>KeyType</code> to <code>AWS _OWNED_CMK</code> , Kinesis Data Firehose uses a service-account CMK.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyArn(java.lang.String keyArn) {
                this.keyArn = keyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeliveryStreamEncryptionConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeliveryStreamEncryptionConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeliveryStreamEncryptionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryStreamEncryptionConfigurationInputProperty {
            private final java.lang.String keyType;
            private final java.lang.String keyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyArn = software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyType = java.util.Objects.requireNonNull(builder.keyType, "keyType is required");
                this.keyArn = builder.keyArn;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            public final java.lang.String getKeyArn() {
                return this.keyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyType", om.valueToTree(this.getKeyType()));
                if (this.getKeyArn() != null) {
                    data.set("keyArn", om.valueToTree(this.getKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeliveryStreamEncryptionConfigurationInputProperty.Jsii$Proxy that = (DeliveryStreamEncryptionConfigurationInputProperty.Jsii$Proxy) o;

                if (!keyType.equals(that.keyType)) return false;
                return this.keyArn != null ? this.keyArn.equals(that.keyArn) : that.keyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyType.hashCode();
                result = 31 * result + (this.keyArn != null ? this.keyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The deserializer you want Kinesis Data Firehose to use for converting the input data from JSON.
     * <p>
     * Kinesis Data Firehose then serializes the data to its final format using the <code>Serializer</code> . Kinesis Data Firehose supports two types of deserializers: the <a href="https://docs.aws.amazon.com/https://cwiki.apache.org/confluence/display/Hive/LanguageManual+DDL#LanguageManualDDL-JSON">Apache Hive JSON SerDe</a> and the <a href="https://docs.aws.amazon.com/https://github.com/rcongiu/Hive-JSON-Serde">OpenX JSON SerDe</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DeserializerProperty deserializerProperty = DeserializerProperty.builder()
     *         .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                 .timestampFormats(List.of("timestampFormats"))
     *                 .build())
     *         .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                 .caseInsensitive(false)
     *                 .columnToJsonKeyMappings(Map.of(
     *                         "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                 .convertDotsInJsonKeysToUnderscores(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeserializerProperty")
    @software.amazon.jsii.Jsii.Proxy(DeserializerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeserializerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The native Hive / HCatalog JsonSerDe.
         * <p>
         * Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHiveJsonSerDe() {
            return null;
        }

        /**
         * The OpenX SerDe.
         * <p>
         * Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenXJsonSerDe() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeserializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeserializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeserializerProperty> {
            java.lang.Object hiveJsonSerDe;
            java.lang.Object openXJsonSerDe;

            /**
             * Sets the value of {@link DeserializerProperty#getHiveJsonSerDe}
             * @param hiveJsonSerDe The native Hive / HCatalog JsonSerDe.
             *                      Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hiveJsonSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HiveJsonSerDeProperty hiveJsonSerDe) {
                this.hiveJsonSerDe = hiveJsonSerDe;
                return this;
            }

            /**
             * Sets the value of {@link DeserializerProperty#getHiveJsonSerDe}
             * @param hiveJsonSerDe The native Hive / HCatalog JsonSerDe.
             *                      Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hiveJsonSerDe(software.amazon.awscdk.IResolvable hiveJsonSerDe) {
                this.hiveJsonSerDe = hiveJsonSerDe;
                return this;
            }

            /**
             * Sets the value of {@link DeserializerProperty#getOpenXJsonSerDe}
             * @param openXJsonSerDe The OpenX SerDe.
             *                       Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openXJsonSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OpenXJsonSerDeProperty openXJsonSerDe) {
                this.openXJsonSerDe = openXJsonSerDe;
                return this;
            }

            /**
             * Sets the value of {@link DeserializerProperty#getOpenXJsonSerDe}
             * @param openXJsonSerDe The OpenX SerDe.
             *                       Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openXJsonSerDe(software.amazon.awscdk.IResolvable openXJsonSerDe) {
                this.openXJsonSerDe = openXJsonSerDe;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeserializerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeserializerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeserializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeserializerProperty {
            private final java.lang.Object hiveJsonSerDe;
            private final java.lang.Object openXJsonSerDe;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hiveJsonSerDe = software.amazon.jsii.Kernel.get(this, "hiveJsonSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openXJsonSerDe = software.amazon.jsii.Kernel.get(this, "openXJsonSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hiveJsonSerDe = builder.hiveJsonSerDe;
                this.openXJsonSerDe = builder.openXJsonSerDe;
            }

            @Override
            public final java.lang.Object getHiveJsonSerDe() {
                return this.hiveJsonSerDe;
            }

            @Override
            public final java.lang.Object getOpenXJsonSerDe() {
                return this.openXJsonSerDe;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHiveJsonSerDe() != null) {
                    data.set("hiveJsonSerDe", om.valueToTree(this.getHiveJsonSerDe()));
                }
                if (this.getOpenXJsonSerDe() != null) {
                    data.set("openXJsonSerDe", om.valueToTree(this.getOpenXJsonSerDe()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeserializerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeserializerProperty.Jsii$Proxy that = (DeserializerProperty.Jsii$Proxy) o;

                if (this.hiveJsonSerDe != null ? !this.hiveJsonSerDe.equals(that.hiveJsonSerDe) : that.hiveJsonSerDe != null) return false;
                return this.openXJsonSerDe != null ? this.openXJsonSerDe.equals(that.openXJsonSerDe) : that.openXJsonSerDe == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hiveJsonSerDe != null ? this.hiveJsonSerDe.hashCode() : 0;
                result = 31 * result + (this.openXJsonSerDe != null ? this.openXJsonSerDe.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `DynamicPartitioningConfiguration` property type specifies the configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DynamicPartitioningConfigurationProperty dynamicPartitioningConfigurationProperty = DynamicPartitioningConfigurationProperty.builder()
     *         .enabled(false)
     *         .retryOptions(RetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamicPartitioningConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamicPartitioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamicPartitioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamicPartitioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamicPartitioningConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object retryOptions;

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getEnabled}
             * @param enabled Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getEnabled}
             * @param enabled Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getRetryOptions}
             * @param retryOptions Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getRetryOptions}
             * @param retryOptions Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamicPartitioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamicPartitioningConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamicPartitioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamicPartitioningConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object retryOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.retryOptions = builder.retryOptions;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamicPartitioningConfigurationProperty.Jsii$Proxy that = (DynamicPartitioningConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.retryOptions != null ? this.retryOptions.equals(that.retryOptions) : that.retryOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ElasticsearchBufferingHints` property type specifies how Amazon Kinesis Data Firehose (Kinesis Data Firehose) buffers incoming data while delivering it to the destination.
     * <p>
     * The first buffer condition that is satisfied triggers Kinesis Data Firehose to deliver the data.
     * <p>
     * ElasticsearchBufferingHints is the property type for the <code>BufferingHints</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html">Amazon Kinesis Data Firehose DeliveryStream ElasticsearchDestinationConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ElasticsearchBufferingHintsProperty elasticsearchBufferingHintsProperty = ElasticsearchBufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchBufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchBufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchBufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link ElasticsearchBufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
             *                          For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchBufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
             *                  For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchBufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchBufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchBufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchBufferingHintsProperty.Jsii$Proxy that = (ElasticsearchBufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ElasticsearchDestinationConfiguration` property type specifies an Amazon Elasticsearch Service (Amazon ES) domain that Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ElasticsearchDestinationConfigurationProperty elasticsearchDestinationConfigurationProperty = ElasticsearchDestinationConfigurationProperty.builder()
     *         .indexName("indexName")
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .bufferingHints(ElasticsearchBufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .clusterEndpoint("clusterEndpoint")
     *         .domainArn("domainArn")
     *         .indexRotationPeriod("indexRotationPeriod")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(ElasticsearchRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .typeName("typeName")
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Elasticsearch index to which Kinesis Data Firehose adds data for indexing.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html">Controlling Access with Amazon Kinesis Data Firehose</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The S3 bucket where Kinesis Data Firehose backs up incoming data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * The Amazon CloudWatch Logs logging options for the delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The endpoint to use when communicating with the cluster.
         * <p>
         * Specify either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpoint() {
            return null;
        }

        /**
         * The ARN of the Amazon ES domain.
         * <p>
         * The IAM role must have permissions for <code>DescribeElasticsearchDomain</code> , <code>DescribeElasticsearchDomains</code> , and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <em>RoleARN</em> .
         * <p>
         * Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainArn() {
            return null;
        }

        /**
         * The frequency of Elasticsearch index rotation.
         * <p>
         * If you enable index rotation, Kinesis Data Firehose appends a portion of the UTC arrival timestamp to the specified index name, and rotates the appended timestamp accordingly. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the Amazon ES Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIndexRotationPeriod() {
            return null;
        }

        /**
         * The data processing configuration for the Kinesis Data Firehose delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * The condition under which Kinesis Data Firehose delivers data to Amazon Simple Storage Service (Amazon S3).
         * <p>
         * You can send Amazon S3 all documents (all data) or only the documents that Kinesis Data Firehose could not deliver to the Amazon ES destination. For more information and valid values, see the <code>S3BackupMode</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchDestinationConfiguration.html">ElasticsearchDestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * The Elasticsearch type name that Amazon ES adds to documents when indexing data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
            return null;
        }

        /**
         * The details of the VPC of the Amazon ES destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchDestinationConfigurationProperty> {
            java.lang.String indexName;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String clusterEndpoint;
            java.lang.String domainArn;
            java.lang.String indexRotationPeriod;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;
            java.lang.String typeName;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getIndexName}
             * @param indexName The name of the Elasticsearch index to which Kinesis Data Firehose adds data for indexing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents. This parameter is required.
             *                For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html">Controlling Access with Amazon Kinesis Data Firehose</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose backs up incoming data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose backs up incoming data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch Logs logging options for the delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch Logs logging options for the delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getClusterEndpoint}
             * @param clusterEndpoint The endpoint to use when communicating with the cluster.
             *                        Specify either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterEndpoint(java.lang.String clusterEndpoint) {
                this.clusterEndpoint = clusterEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getDomainArn}
             * @param domainArn The ARN of the Amazon ES domain.
             *                  The IAM role must have permissions for <code>DescribeElasticsearchDomain</code> , <code>DescribeElasticsearchDomains</code> , and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <em>RoleARN</em> .
             *                  <p>
             *                  Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainArn(java.lang.String domainArn) {
                this.domainArn = domainArn;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getIndexRotationPeriod}
             * @param indexRotationPeriod The frequency of Elasticsearch index rotation.
             *                            If you enable index rotation, Kinesis Data Firehose appends a portion of the UTC arrival timestamp to the specified index name, and rotates the appended timestamp accordingly. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the Amazon ES Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexRotationPeriod(java.lang.String indexRotationPeriod) {
                this.indexRotationPeriod = indexRotationPeriod;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode The condition under which Kinesis Data Firehose delivers data to Amazon Simple Storage Service (Amazon S3).
             *                     You can send Amazon S3 all documents (all data) or only the documents that Kinesis Data Firehose could not deliver to the Amazon ES destination. For more information and valid values, see the <code>S3BackupMode</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchDestinationConfiguration.html">ElasticsearchDestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getTypeName}
             * @param typeName The Elasticsearch type name that Amazon ES adds to documents when indexing data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeName(java.lang.String typeName) {
                this.typeName = typeName;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon ES destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon ES destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchDestinationConfigurationProperty {
            private final java.lang.String indexName;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String clusterEndpoint;
            private final java.lang.String domainArn;
            private final java.lang.String indexRotationPeriod;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;
            private final java.lang.String typeName;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clusterEndpoint = software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainArn = software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexRotationPeriod = software.amazon.jsii.Kernel.get(this, "indexRotationPeriod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.clusterEndpoint = builder.clusterEndpoint;
                this.domainArn = builder.domainArn;
                this.indexRotationPeriod = builder.indexRotationPeriod;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
                this.typeName = builder.typeName;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getClusterEndpoint() {
                return this.clusterEndpoint;
            }

            @Override
            public final java.lang.String getDomainArn() {
                return this.domainArn;
            }

            @Override
            public final java.lang.String getIndexRotationPeriod() {
                return this.indexRotationPeriod;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.String getTypeName() {
                return this.typeName;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getClusterEndpoint() != null) {
                    data.set("clusterEndpoint", om.valueToTree(this.getClusterEndpoint()));
                }
                if (this.getDomainArn() != null) {
                    data.set("domainArn", om.valueToTree(this.getDomainArn()));
                }
                if (this.getIndexRotationPeriod() != null) {
                    data.set("indexRotationPeriod", om.valueToTree(this.getIndexRotationPeriod()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getTypeName() != null) {
                    data.set("typeName", om.valueToTree(this.getTypeName()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchDestinationConfigurationProperty.Jsii$Proxy that = (ElasticsearchDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.clusterEndpoint != null ? !this.clusterEndpoint.equals(that.clusterEndpoint) : that.clusterEndpoint != null) return false;
                if (this.domainArn != null ? !this.domainArn.equals(that.domainArn) : that.domainArn != null) return false;
                if (this.indexRotationPeriod != null ? !this.indexRotationPeriod.equals(that.indexRotationPeriod) : that.indexRotationPeriod != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.clusterEndpoint != null ? this.clusterEndpoint.hashCode() : 0);
                result = 31 * result + (this.domainArn != null ? this.domainArn.hashCode() : 0);
                result = 31 * result + (this.indexRotationPeriod != null ? this.indexRotationPeriod.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ElasticsearchRetryOptions` property type configures the retry behavior for when Amazon Kinesis Data Firehose (Kinesis Data Firehose) can't deliver data to Amazon Elasticsearch Service (Amazon ES).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ElasticsearchRetryOptionsProperty elasticsearchRetryOptionsProperty = ElasticsearchRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Data Firehose re-attempts delivery (including the first attempt).
         * <p>
         * If Kinesis Data Firehose can't deliver the data within the specified time, it writes the data to the backup S3 bucket. For valid values, see the <code>DurationInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchRetryOptions.html">ElasticsearchRetryOptions</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link ElasticsearchRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Data Firehose re-attempts delivery (including the first attempt).
             *                          If Kinesis Data Firehose can't deliver the data within the specified time, it writes the data to the backup S3 bucket. For valid values, see the <code>DurationInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchRetryOptions.html">ElasticsearchRetryOptions</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchRetryOptionsProperty.Jsii$Proxy that = (ElasticsearchRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `EncryptionConfiguration` property type specifies the encryption settings that Amazon Kinesis Data Firehose (Kinesis Data Firehose) uses when delivering data to Amazon Simple Storage Service (Amazon S3).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                 .awskmsKeyArn("awskmsKeyArn")
     *                 .build())
     *         .noEncryptionConfig("noEncryptionConfig")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKmsEncryptionConfig() {
            return null;
        }

        /**
         * Disables encryption.
         * <p>
         * For valid values, see the <code>NoEncryptionConfig</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_EncryptionConfiguration.html">EncryptionConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNoEncryptionConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.Object kmsEncryptionConfig;
            java.lang.String noEncryptionConfig;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KMSEncryptionConfigProperty kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.IResolvable kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getNoEncryptionConfig}
             * @param noEncryptionConfig Disables encryption.
             *                           For valid values, see the <code>NoEncryptionConfig</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_EncryptionConfiguration.html">EncryptionConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noEncryptionConfig(java.lang.String noEncryptionConfig) {
                this.noEncryptionConfig = noEncryptionConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.Object kmsEncryptionConfig;
            private final java.lang.String noEncryptionConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsEncryptionConfig = software.amazon.jsii.Kernel.get(this, "kmsEncryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noEncryptionConfig = software.amazon.jsii.Kernel.get(this, "noEncryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
                this.noEncryptionConfig = builder.noEncryptionConfig;
            }

            @Override
            public final java.lang.Object getKmsEncryptionConfig() {
                return this.kmsEncryptionConfig;
            }

            @Override
            public final java.lang.String getNoEncryptionConfig() {
                return this.noEncryptionConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsEncryptionConfig() != null) {
                    data.set("kmsEncryptionConfig", om.valueToTree(this.getKmsEncryptionConfig()));
                }
                if (this.getNoEncryptionConfig() != null) {
                    data.set("noEncryptionConfig", om.valueToTree(this.getNoEncryptionConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                if (this.kmsEncryptionConfig != null ? !this.kmsEncryptionConfig.equals(that.kmsEncryptionConfig) : that.kmsEncryptionConfig != null) return false;
                return this.noEncryptionConfig != null ? this.noEncryptionConfig.equals(that.noEncryptionConfig) : that.noEncryptionConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsEncryptionConfig != null ? this.kmsEncryptionConfig.hashCode() : 0;
                result = 31 * result + (this.noEncryptionConfig != null ? this.noEncryptionConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ExtendedS3DestinationConfiguration` property type configures an Amazon S3 destination for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfigurationProperty = ExtendedS3DestinationConfigurationProperty.builder()
     *         .bucketArn("bucketArn")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .bufferingHints(BufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .compressionFormat("compressionFormat")
     *         .dataFormatConversionConfiguration(DataFormatConversionConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .inputFormatConfiguration(InputFormatConfigurationProperty.builder()
     *                         .deserializer(DeserializerProperty.builder()
     *                                 .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                                         .timestampFormats(List.of("timestampFormats"))
     *                                         .build())
     *                                 .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                                         .caseInsensitive(false)
     *                                         .columnToJsonKeyMappings(Map.of(
     *                                                 "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                                         .convertDotsInJsonKeysToUnderscores(false)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .outputFormatConfiguration(OutputFormatConfigurationProperty.builder()
     *                         .serializer(SerializerProperty.builder()
     *                                 .orcSerDe(OrcSerDeProperty.builder()
     *                                         .blockSizeBytes(123)
     *                                         .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                                         .bloomFilterFalsePositiveProbability(123)
     *                                         .compression("compression")
     *                                         .dictionaryKeyThreshold(123)
     *                                         .enablePadding(false)
     *                                         .formatVersion("formatVersion")
     *                                         .paddingTolerance(123)
     *                                         .rowIndexStride(123)
     *                                         .stripeSizeBytes(123)
     *                                         .build())
     *                                 .parquetSerDe(ParquetSerDeProperty.builder()
     *                                         .blockSizeBytes(123)
     *                                         .compression("compression")
     *                                         .enableDictionaryCompression(false)
     *                                         .maxPaddingBytes(123)
     *                                         .pageSizeBytes(123)
     *                                         .writerVersion("writerVersion")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .schemaConfiguration(SchemaConfigurationProperty.builder()
     *                         .catalogId("catalogId")
     *                         .databaseName("databaseName")
     *                         .region("region")
     *                         .roleArn("roleArn")
     *                         .tableName("tableName")
     *                         .versionId("versionId")
     *                         .build())
     *                 .build())
     *         .dynamicPartitioningConfiguration(DynamicPartitioningConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .retryOptions(RetryOptionsProperty.builder()
     *                         .durationInSeconds(123)
     *                         .build())
     *                 .build())
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                         .awskmsKeyArn("awskmsKeyArn")
     *                         .build())
     *                 .noEncryptionConfig("noEncryptionConfig")
     *                 .build())
     *         .errorOutputPrefix("errorOutputPrefix")
     *         .prefix("prefix")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExtendedS3DestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtendedS3DestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket.
         * <p>
         * For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The Amazon Resource Name (ARN) of the AWS credentials.
         * <p>
         * For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The buffering option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * The Amazon CloudWatch logging options for your delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The compression format.
         * <p>
         * If no value is specified, the default is <code>UNCOMPRESSED</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionFormat() {
            return null;
        }

        /**
         * The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataFormatConversionConfiguration() {
            return null;
        }

        /**
         * The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamicPartitioningConfiguration() {
            return null;
        }

        /**
         * The encryption configuration for the Kinesis Data Firehose delivery stream.
         * <p>
         * The default value is <code>NoEncryption</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorOutputPrefix() {
            return null;
        }

        /**
         * The `YYYY/MM/DD/HH` time format prefix is automatically used for delivered Amazon S3 files.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The data processing configuration for the Kinesis Data Firehose delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The configuration for backup in Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3BackupConfiguration() {
            return null;
        }

        /**
         * The Amazon S3 backup mode.
         * <p>
         * After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExtendedS3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtendedS3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtendedS3DestinationConfigurationProperty> {
            java.lang.String bucketArn;
            java.lang.String roleArn;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String compressionFormat;
            java.lang.Object dataFormatConversionConfiguration;
            java.lang.Object dynamicPartitioningConfiguration;
            java.lang.Object encryptionConfiguration;
            java.lang.String errorOutputPrefix;
            java.lang.String prefix;
            java.lang.Object processingConfiguration;
            java.lang.Object s3BackupConfiguration;
            java.lang.String s3BackupMode;

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the Amazon S3 bucket. This parameter is required.
             *                  For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the AWS credentials. This parameter is required.
             *                For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getCompressionFormat}
             * @param compressionFormat The compression format.
             *                          If no value is specified, the default is <code>UNCOMPRESSED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionFormat(java.lang.String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDataFormatConversionConfiguration}
             * @param dataFormatConversionConfiguration The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataFormatConversionConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DataFormatConversionConfigurationProperty dataFormatConversionConfiguration) {
                this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDataFormatConversionConfiguration}
             * @param dataFormatConversionConfiguration The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataFormatConversionConfiguration(software.amazon.awscdk.IResolvable dataFormatConversionConfiguration) {
                this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDynamicPartitioningConfiguration}
             * @param dynamicPartitioningConfiguration The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicPartitioningConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty dynamicPartitioningConfiguration) {
                this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDynamicPartitioningConfiguration}
             * @param dynamicPartitioningConfiguration The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicPartitioningConfiguration(software.amazon.awscdk.IResolvable dynamicPartitioningConfiguration) {
                this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the Kinesis Data Firehose delivery stream.
             *                                The default value is <code>NoEncryption</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the Kinesis Data Firehose delivery stream.
             *                                The default value is <code>NoEncryption</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getErrorOutputPrefix}
             * @param errorOutputPrefix A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
             *                          This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorOutputPrefix(java.lang.String errorOutputPrefix) {
                this.errorOutputPrefix = errorOutputPrefix;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getPrefix}
             * @param prefix The `YYYY/MM/DD/HH` time format prefix is automatically used for delivered Amazon S3 files.
             *               For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.IResolvable s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode The Amazon S3 backup mode.
             *                     After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtendedS3DestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtendedS3DestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtendedS3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtendedS3DestinationConfigurationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String roleArn;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String compressionFormat;
            private final java.lang.Object dataFormatConversionConfiguration;
            private final java.lang.Object dynamicPartitioningConfiguration;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String errorOutputPrefix;
            private final java.lang.String prefix;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object s3BackupConfiguration;
            private final java.lang.String s3BackupMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressionFormat = software.amazon.jsii.Kernel.get(this, "compressionFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataFormatConversionConfiguration = software.amazon.jsii.Kernel.get(this, "dataFormatConversionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamicPartitioningConfiguration = software.amazon.jsii.Kernel.get(this, "dynamicPartitioningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.errorOutputPrefix = software.amazon.jsii.Kernel.get(this, "errorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupConfiguration = software.amazon.jsii.Kernel.get(this, "s3BackupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.compressionFormat = builder.compressionFormat;
                this.dataFormatConversionConfiguration = builder.dataFormatConversionConfiguration;
                this.dynamicPartitioningConfiguration = builder.dynamicPartitioningConfiguration;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.errorOutputPrefix = builder.errorOutputPrefix;
                this.prefix = builder.prefix;
                this.processingConfiguration = builder.processingConfiguration;
                this.s3BackupConfiguration = builder.s3BackupConfiguration;
                this.s3BackupMode = builder.s3BackupMode;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getCompressionFormat() {
                return this.compressionFormat;
            }

            @Override
            public final java.lang.Object getDataFormatConversionConfiguration() {
                return this.dataFormatConversionConfiguration;
            }

            @Override
            public final java.lang.Object getDynamicPartitioningConfiguration() {
                return this.dynamicPartitioningConfiguration;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getErrorOutputPrefix() {
                return this.errorOutputPrefix;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getS3BackupConfiguration() {
                return this.s3BackupConfiguration;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getCompressionFormat() != null) {
                    data.set("compressionFormat", om.valueToTree(this.getCompressionFormat()));
                }
                if (this.getDataFormatConversionConfiguration() != null) {
                    data.set("dataFormatConversionConfiguration", om.valueToTree(this.getDataFormatConversionConfiguration()));
                }
                if (this.getDynamicPartitioningConfiguration() != null) {
                    data.set("dynamicPartitioningConfiguration", om.valueToTree(this.getDynamicPartitioningConfiguration()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getErrorOutputPrefix() != null) {
                    data.set("errorOutputPrefix", om.valueToTree(this.getErrorOutputPrefix()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getS3BackupConfiguration() != null) {
                    data.set("s3BackupConfiguration", om.valueToTree(this.getS3BackupConfiguration()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtendedS3DestinationConfigurationProperty.Jsii$Proxy that = (ExtendedS3DestinationConfigurationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.compressionFormat != null ? !this.compressionFormat.equals(that.compressionFormat) : that.compressionFormat != null) return false;
                if (this.dataFormatConversionConfiguration != null ? !this.dataFormatConversionConfiguration.equals(that.dataFormatConversionConfiguration) : that.dataFormatConversionConfiguration != null) return false;
                if (this.dynamicPartitioningConfiguration != null ? !this.dynamicPartitioningConfiguration.equals(that.dynamicPartitioningConfiguration) : that.dynamicPartitioningConfiguration != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.errorOutputPrefix != null ? !this.errorOutputPrefix.equals(that.errorOutputPrefix) : that.errorOutputPrefix != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.s3BackupConfiguration != null ? !this.s3BackupConfiguration.equals(that.s3BackupConfiguration) : that.s3BackupConfiguration != null) return false;
                return this.s3BackupMode != null ? this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.compressionFormat != null ? this.compressionFormat.hashCode() : 0);
                result = 31 * result + (this.dataFormatConversionConfiguration != null ? this.dataFormatConversionConfiguration.hashCode() : 0);
                result = 31 * result + (this.dynamicPartitioningConfiguration != null ? this.dynamicPartitioningConfiguration.hashCode() : 0);
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.errorOutputPrefix != null ? this.errorOutputPrefix.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3BackupConfiguration != null ? this.s3BackupConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The native Hive / HCatalog JsonSerDe.
     * <p>
     * Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HiveJsonSerDeProperty hiveJsonSerDeProperty = HiveJsonSerDeProperty.builder()
     *         .timestampFormats(List.of("timestampFormats"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HiveJsonSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(HiveJsonSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HiveJsonSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in your input data JSON.
         * <p>
         * To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://docs.aws.amazon.com/https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a> . You can also use the special value <code>millis</code> to parse timestamps in epoch milliseconds. If you don't specify a format, Kinesis Data Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTimestampFormats() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HiveJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HiveJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HiveJsonSerDeProperty> {
            java.util.List<java.lang.String> timestampFormats;

            /**
             * Sets the value of {@link HiveJsonSerDeProperty#getTimestampFormats}
             * @param timestampFormats Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in your input data JSON.
             *                         To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://docs.aws.amazon.com/https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a> . You can also use the special value <code>millis</code> to parse timestamps in epoch milliseconds. If you don't specify a format, Kinesis Data Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampFormats(java.util.List<java.lang.String> timestampFormats) {
                this.timestampFormats = timestampFormats;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HiveJsonSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HiveJsonSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HiveJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HiveJsonSerDeProperty {
            private final java.util.List<java.lang.String> timestampFormats;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timestampFormats = software.amazon.jsii.Kernel.get(this, "timestampFormats", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timestampFormats = builder.timestampFormats;
            }

            @Override
            public final java.util.List<java.lang.String> getTimestampFormats() {
                return this.timestampFormats;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTimestampFormats() != null) {
                    data.set("timestampFormats", om.valueToTree(this.getTimestampFormats()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HiveJsonSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HiveJsonSerDeProperty.Jsii$Proxy that = (HiveJsonSerDeProperty.Jsii$Proxy) o;

                return this.timestampFormats != null ? this.timestampFormats.equals(that.timestampFormats) : that.timestampFormats == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timestampFormats != null ? this.timestampFormats.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the metadata that's delivered to the specified HTTP endpoint destination.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointCommonAttributeProperty httpEndpointCommonAttributeProperty = HttpEndpointCommonAttributeProperty.builder()
     *         .attributeName("attributeName")
     *         .attributeValue("attributeValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointCommonAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointCommonAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointCommonAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the HTTP endpoint common attribute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * The value of the HTTP endpoint common attribute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeValue();

        /**
         * @return a {@link Builder} of {@link HttpEndpointCommonAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointCommonAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointCommonAttributeProperty> {
            java.lang.String attributeName;
            java.lang.String attributeValue;

            /**
             * Sets the value of {@link HttpEndpointCommonAttributeProperty#getAttributeName}
             * @param attributeName The name of the HTTP endpoint common attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointCommonAttributeProperty#getAttributeValue}
             * @param attributeValue The value of the HTTP endpoint common attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeValue(java.lang.String attributeValue) {
                this.attributeValue = attributeValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointCommonAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointCommonAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointCommonAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointCommonAttributeProperty {
            private final java.lang.String attributeName;
            private final java.lang.String attributeValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributeValue = software.amazon.jsii.Kernel.get(this, "attributeValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.attributeValue = java.util.Objects.requireNonNull(builder.attributeValue, "attributeValue is required");
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.lang.String getAttributeValue() {
                return this.attributeValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                data.set("attributeValue", om.valueToTree(this.getAttributeValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointCommonAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointCommonAttributeProperty.Jsii$Proxy that = (HttpEndpointCommonAttributeProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.attributeValue.equals(that.attributeValue);
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.attributeValue.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the configuration of the HTTP endpoint to which Kinesis Firehose delivers data.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointConfigurationProperty httpEndpointConfigurationProperty = HttpEndpointConfigurationProperty.builder()
     *         .url("url")
     *         // the properties below are optional
     *         .accessKey("accessKey")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the HTTP endpoint selected as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessKey() {
            return null;
        }

        /**
         * The name of the HTTP endpoint selected as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpEndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointConfigurationProperty> {
            java.lang.String url;
            java.lang.String accessKey;
            java.lang.String name;

            /**
             * Sets the value of {@link HttpEndpointConfigurationProperty#getUrl}
             * @param url The URL of the HTTP endpoint selected as the destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointConfigurationProperty#getAccessKey}
             * @param accessKey The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessKey(java.lang.String accessKey) {
                this.accessKey = accessKey;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointConfigurationProperty#getName}
             * @param name The name of the HTTP endpoint selected as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointConfigurationProperty {
            private final java.lang.String url;
            private final java.lang.String accessKey;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessKey = software.amazon.jsii.Kernel.get(this, "accessKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
                this.accessKey = builder.accessKey;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.String getAccessKey() {
                return this.accessKey;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("url", om.valueToTree(this.getUrl()));
                if (this.getAccessKey() != null) {
                    data.set("accessKey", om.valueToTree(this.getAccessKey()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointConfigurationProperty.Jsii$Proxy that = (HttpEndpointConfigurationProperty.Jsii$Proxy) o;

                if (!url.equals(that.url)) return false;
                if (this.accessKey != null ? !this.accessKey.equals(that.accessKey) : that.accessKey != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.url.hashCode();
                result = 31 * result + (this.accessKey != null ? this.accessKey.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration of the HTTP endpoint destination.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointDestinationConfigurationProperty httpEndpointDestinationConfigurationProperty = HttpEndpointDestinationConfigurationProperty.builder()
     *         .endpointConfiguration(HttpEndpointConfigurationProperty.builder()
     *                 .url("url")
     *                 // the properties below are optional
     *                 .accessKey("accessKey")
     *                 .name("name")
     *                 .build())
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .bufferingHints(BufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .requestConfiguration(HttpEndpointRequestConfigurationProperty.builder()
     *                 .commonAttributes(List.of(HttpEndpointCommonAttributeProperty.builder()
     *                         .attributeName("attributeName")
     *                         .attributeValue("attributeValue")
     *                         .build()))
     *                 .contentEncoding("contentEncoding")
     *                 .build())
     *         .retryOptions(RetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .roleArn("roleArn")
     *         .s3BackupMode("s3BackupMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the HTTP endpoint selected as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEndpointConfiguration();

        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The buffering options that can be used before data is delivered to the specified destination.
         * <p>
         * Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * Describes the data processing configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The configuration of the request sent to the HTTP endpoint specified as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestConfiguration() {
            return null;
        }

        /**
         * Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers to the HTTP endpoint destination.
         * <p>
         * You can back up all documents (AllData) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (FailedDataOnly).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpEndpointDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointDestinationConfigurationProperty> {
            java.lang.Object endpointConfiguration;
            java.lang.Object s3Configuration;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.Object processingConfiguration;
            java.lang.Object requestConfiguration;
            java.lang.Object retryOptions;
            java.lang.String roleArn;
            java.lang.String s3BackupMode;

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getEndpointConfiguration}
             * @param endpointConfiguration The configuration of the HTTP endpoint selected as the destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointConfigurationProperty endpointConfiguration) {
                this.endpointConfiguration = endpointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getEndpointConfiguration}
             * @param endpointConfiguration The configuration of the HTTP endpoint selected as the destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointConfiguration(software.amazon.awscdk.IResolvable endpointConfiguration) {
                this.endpointConfiguration = endpointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options that can be used before data is delivered to the specified destination.
             *                       Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options that can be used before data is delivered to the specified destination.
             *                       Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes the data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes the data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRequestConfiguration}
             * @param requestConfiguration The configuration of the request sent to the HTTP endpoint specified as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointRequestConfigurationProperty requestConfiguration) {
                this.requestConfiguration = requestConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRequestConfiguration}
             * @param requestConfiguration The configuration of the request sent to the HTTP endpoint specified as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestConfiguration(software.amazon.awscdk.IResolvable requestConfiguration) {
                this.requestConfiguration = requestConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRoleArn}
             * @param roleArn Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers to the HTTP endpoint destination.
             *                     You can back up all documents (AllData) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (FailedDataOnly).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointDestinationConfigurationProperty {
            private final java.lang.Object endpointConfiguration;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object requestConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String roleArn;
            private final java.lang.String s3BackupMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointConfiguration = software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requestConfiguration = software.amazon.jsii.Kernel.get(this, "requestConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointConfiguration = java.util.Objects.requireNonNull(builder.endpointConfiguration, "endpointConfiguration is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.processingConfiguration = builder.processingConfiguration;
                this.requestConfiguration = builder.requestConfiguration;
                this.retryOptions = builder.retryOptions;
                this.roleArn = builder.roleArn;
                this.s3BackupMode = builder.s3BackupMode;
            }

            @Override
            public final java.lang.Object getEndpointConfiguration() {
                return this.endpointConfiguration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRequestConfiguration() {
                return this.requestConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRequestConfiguration() != null) {
                    data.set("requestConfiguration", om.valueToTree(this.getRequestConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointDestinationConfigurationProperty.Jsii$Proxy that = (HttpEndpointDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!endpointConfiguration.equals(that.endpointConfiguration)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.requestConfiguration != null ? !this.requestConfiguration.equals(that.requestConfiguration) : that.requestConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.s3BackupMode != null ? this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointConfiguration.hashCode();
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.requestConfiguration != null ? this.requestConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the HTTP endpoint request.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointRequestConfigurationProperty httpEndpointRequestConfigurationProperty = HttpEndpointRequestConfigurationProperty.builder()
     *         .commonAttributes(List.of(HttpEndpointCommonAttributeProperty.builder()
     *                 .attributeName("attributeName")
     *                 .attributeValue("attributeValue")
     *                 .build()))
     *         .contentEncoding("contentEncoding")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointRequestConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointRequestConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointRequestConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the metadata sent to the HTTP endpoint destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCommonAttributes() {
            return null;
        }

        /**
         * Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination.
         * <p>
         * For more information, see Content-Encoding in MDN Web Docs, the official Mozilla documentation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentEncoding() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpEndpointRequestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointRequestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointRequestConfigurationProperty> {
            java.lang.Object commonAttributes;
            java.lang.String contentEncoding;

            /**
             * Sets the value of {@link HttpEndpointRequestConfigurationProperty#getCommonAttributes}
             * @param commonAttributes Describes the metadata sent to the HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commonAttributes(software.amazon.awscdk.IResolvable commonAttributes) {
                this.commonAttributes = commonAttributes;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointRequestConfigurationProperty#getCommonAttributes}
             * @param commonAttributes Describes the metadata sent to the HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commonAttributes(java.util.List<? extends java.lang.Object> commonAttributes) {
                this.commonAttributes = commonAttributes;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointRequestConfigurationProperty#getContentEncoding}
             * @param contentEncoding Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination.
             *                        For more information, see Content-Encoding in MDN Web Docs, the official Mozilla documentation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentEncoding(java.lang.String contentEncoding) {
                this.contentEncoding = contentEncoding;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointRequestConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointRequestConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointRequestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointRequestConfigurationProperty {
            private final java.lang.Object commonAttributes;
            private final java.lang.String contentEncoding;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.commonAttributes = software.amazon.jsii.Kernel.get(this, "commonAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contentEncoding = software.amazon.jsii.Kernel.get(this, "contentEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commonAttributes = builder.commonAttributes;
                this.contentEncoding = builder.contentEncoding;
            }

            @Override
            public final java.lang.Object getCommonAttributes() {
                return this.commonAttributes;
            }

            @Override
            public final java.lang.String getContentEncoding() {
                return this.contentEncoding;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommonAttributes() != null) {
                    data.set("commonAttributes", om.valueToTree(this.getCommonAttributes()));
                }
                if (this.getContentEncoding() != null) {
                    data.set("contentEncoding", om.valueToTree(this.getContentEncoding()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointRequestConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointRequestConfigurationProperty.Jsii$Proxy that = (HttpEndpointRequestConfigurationProperty.Jsii$Proxy) o;

                if (this.commonAttributes != null ? !this.commonAttributes.equals(that.commonAttributes) : that.commonAttributes != null) return false;
                return this.contentEncoding != null ? this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding == null;
            }

            @Override
            public final int hashCode() {
                int result = this.commonAttributes != null ? this.commonAttributes.hashCode() : 0;
                result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the deserializer you want to use to convert the format of the input data.
     * <p>
     * This parameter is required if <code>Enabled</code> is set to true.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * InputFormatConfigurationProperty inputFormatConfigurationProperty = InputFormatConfigurationProperty.builder()
     *         .deserializer(DeserializerProperty.builder()
     *                 .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                         .timestampFormats(List.of("timestampFormats"))
     *                         .build())
     *                 .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                         .caseInsensitive(false)
     *                         .columnToJsonKeyMappings(Map.of(
     *                                 "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                         .convertDotsInJsonKeysToUnderscores(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InputFormatConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputFormatConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which deserializer to use.
         * <p>
         * You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeserializer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputFormatConfigurationProperty> {
            java.lang.Object deserializer;

            /**
             * Sets the value of {@link InputFormatConfigurationProperty#getDeserializer}
             * @param deserializer Specifies which deserializer to use.
             *                     You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deserializer(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeserializerProperty deserializer) {
                this.deserializer = deserializer;
                return this;
            }

            /**
             * Sets the value of {@link InputFormatConfigurationProperty#getDeserializer}
             * @param deserializer Specifies which deserializer to use.
             *                     You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deserializer(software.amazon.awscdk.IResolvable deserializer) {
                this.deserializer = deserializer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputFormatConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputFormatConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputFormatConfigurationProperty {
            private final java.lang.Object deserializer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deserializer = software.amazon.jsii.Kernel.get(this, "deserializer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deserializer = builder.deserializer;
            }

            @Override
            public final java.lang.Object getDeserializer() {
                return this.deserializer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeserializer() != null) {
                    data.set("deserializer", om.valueToTree(this.getDeserializer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputFormatConfigurationProperty.Jsii$Proxy that = (InputFormatConfigurationProperty.Jsii$Proxy) o;

                return this.deserializer != null ? this.deserializer.equals(that.deserializer) : that.deserializer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deserializer != null ? this.deserializer.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `KMSEncryptionConfig` property type specifies the AWS Key Management Service ( AWS KMS) encryption key that Amazon Simple Storage Service (Amazon S3) uses to encrypt data delivered by the Amazon Kinesis Data Firehose (Kinesis Data Firehose) stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * KMSEncryptionConfigProperty kMSEncryptionConfigProperty = KMSEncryptionConfigProperty.builder()
     *         .awskmsKeyArn("awskmsKeyArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KMSEncryptionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KMSEncryptionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KMSEncryptionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS encryption key that Amazon S3 uses to encrypt data delivered by the Kinesis Data Firehose stream.
         * <p>
         * The key must belong to the same region as the destination S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwskmsKeyArn();

        /**
         * @return a {@link Builder} of {@link KMSEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KMSEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KMSEncryptionConfigProperty> {
            java.lang.String awskmsKeyArn;

            /**
             * Sets the value of {@link KMSEncryptionConfigProperty#getAwskmsKeyArn}
             * @param awskmsKeyArn The Amazon Resource Name (ARN) of the AWS KMS encryption key that Amazon S3 uses to encrypt data delivered by the Kinesis Data Firehose stream. This parameter is required.
             *                     The key must belong to the same region as the destination S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awskmsKeyArn(java.lang.String awskmsKeyArn) {
                this.awskmsKeyArn = awskmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KMSEncryptionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KMSEncryptionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KMSEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KMSEncryptionConfigProperty {
            private final java.lang.String awskmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awskmsKeyArn = software.amazon.jsii.Kernel.get(this, "awskmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awskmsKeyArn = java.util.Objects.requireNonNull(builder.awskmsKeyArn, "awskmsKeyArn is required");
            }

            @Override
            public final java.lang.String getAwskmsKeyArn() {
                return this.awskmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awskmsKeyArn", om.valueToTree(this.getAwskmsKeyArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KMSEncryptionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KMSEncryptionConfigProperty.Jsii$Proxy that = (KMSEncryptionConfigProperty.Jsii$Proxy) o;

                return this.awskmsKeyArn.equals(that.awskmsKeyArn);
            }

            @Override
            public final int hashCode() {
                int result = this.awskmsKeyArn.hashCode();
                return result;
            }
        }
    }
    /**
     * The `KinesisStreamSourceConfiguration` property type specifies the stream and role Amazon Resource Names (ARNs) for a Kinesis stream used as the source for a delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * KinesisStreamSourceConfigurationProperty kinesisStreamSourceConfigurationProperty = KinesisStreamSourceConfigurationProperty.builder()
     *         .kinesisStreamArn("kinesisStreamArn")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the source Kinesis data stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKinesisStreamArn();

        /**
         * The ARN of the role that provides access to the source Kinesis data stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamSourceConfigurationProperty> {
            java.lang.String kinesisStreamArn;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link KinesisStreamSourceConfigurationProperty#getKinesisStreamArn}
             * @param kinesisStreamArn The ARN of the source Kinesis data stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamArn(java.lang.String kinesisStreamArn) {
                this.kinesisStreamArn = kinesisStreamArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisStreamSourceConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the role that provides access to the source Kinesis data stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamSourceConfigurationProperty {
            private final java.lang.String kinesisStreamArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kinesisStreamArn = software.amazon.jsii.Kernel.get(this, "kinesisStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kinesisStreamArn = java.util.Objects.requireNonNull(builder.kinesisStreamArn, "kinesisStreamArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getKinesisStreamArn() {
                return this.kinesisStreamArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kinesisStreamArn", om.valueToTree(this.getKinesisStreamArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamSourceConfigurationProperty.Jsii$Proxy that = (KinesisStreamSourceConfigurationProperty.Jsii$Proxy) o;

                if (!kinesisStreamArn.equals(that.kinesisStreamArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.kinesisStreamArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * The OpenX SerDe.
     * <p>
     * Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * OpenXJsonSerDeProperty openXJsonSerDeProperty = OpenXJsonSerDeProperty.builder()
     *         .caseInsensitive(false)
     *         .columnToJsonKeyMappings(Map.of(
     *                 "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *         .convertDotsInJsonKeysToUnderscores(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OpenXJsonSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenXJsonSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenXJsonSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When set to `true` , which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaseInsensitive() {
            return null;
        }

        /**
         * Maps column names to JSON keys that aren't identical to the column names.
         * <p>
         * This is useful when the JSON contains keys that are Hive keywords. For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code> , set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnToJsonKeyMappings() {
            return null;
        }

        /**
         * When set to `true` , specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores.
         * <p>
         * This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
         * <p>
         * The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConvertDotsInJsonKeysToUnderscores() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenXJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenXJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenXJsonSerDeProperty> {
            java.lang.Object caseInsensitive;
            java.lang.Object columnToJsonKeyMappings;
            java.lang.Object convertDotsInJsonKeysToUnderscores;

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getCaseInsensitive}
             * @param caseInsensitive When set to `true` , which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseInsensitive(java.lang.Boolean caseInsensitive) {
                this.caseInsensitive = caseInsensitive;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getCaseInsensitive}
             * @param caseInsensitive When set to `true` , which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseInsensitive(software.amazon.awscdk.IResolvable caseInsensitive) {
                this.caseInsensitive = caseInsensitive;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getColumnToJsonKeyMappings}
             * @param columnToJsonKeyMappings Maps column names to JSON keys that aren't identical to the column names.
             *                                This is useful when the JSON contains keys that are Hive keywords. For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code> , set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnToJsonKeyMappings(software.amazon.awscdk.IResolvable columnToJsonKeyMappings) {
                this.columnToJsonKeyMappings = columnToJsonKeyMappings;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getColumnToJsonKeyMappings}
             * @param columnToJsonKeyMappings Maps column names to JSON keys that aren't identical to the column names.
             *                                This is useful when the JSON contains keys that are Hive keywords. For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code> , set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnToJsonKeyMappings(java.util.Map<java.lang.String, java.lang.String> columnToJsonKeyMappings) {
                this.columnToJsonKeyMappings = columnToJsonKeyMappings;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getConvertDotsInJsonKeysToUnderscores}
             * @param convertDotsInJsonKeysToUnderscores When set to `true` , specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores.
             *                                           This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
             *                                           <p>
             *                                           The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder convertDotsInJsonKeysToUnderscores(java.lang.Boolean convertDotsInJsonKeysToUnderscores) {
                this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getConvertDotsInJsonKeysToUnderscores}
             * @param convertDotsInJsonKeysToUnderscores When set to `true` , specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores.
             *                                           This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
             *                                           <p>
             *                                           The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder convertDotsInJsonKeysToUnderscores(software.amazon.awscdk.IResolvable convertDotsInJsonKeysToUnderscores) {
                this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenXJsonSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenXJsonSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenXJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenXJsonSerDeProperty {
            private final java.lang.Object caseInsensitive;
            private final java.lang.Object columnToJsonKeyMappings;
            private final java.lang.Object convertDotsInJsonKeysToUnderscores;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.caseInsensitive = software.amazon.jsii.Kernel.get(this, "caseInsensitive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnToJsonKeyMappings = software.amazon.jsii.Kernel.get(this, "columnToJsonKeyMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.convertDotsInJsonKeysToUnderscores = software.amazon.jsii.Kernel.get(this, "convertDotsInJsonKeysToUnderscores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.caseInsensitive = builder.caseInsensitive;
                this.columnToJsonKeyMappings = builder.columnToJsonKeyMappings;
                this.convertDotsInJsonKeysToUnderscores = builder.convertDotsInJsonKeysToUnderscores;
            }

            @Override
            public final java.lang.Object getCaseInsensitive() {
                return this.caseInsensitive;
            }

            @Override
            public final java.lang.Object getColumnToJsonKeyMappings() {
                return this.columnToJsonKeyMappings;
            }

            @Override
            public final java.lang.Object getConvertDotsInJsonKeysToUnderscores() {
                return this.convertDotsInJsonKeysToUnderscores;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaseInsensitive() != null) {
                    data.set("caseInsensitive", om.valueToTree(this.getCaseInsensitive()));
                }
                if (this.getColumnToJsonKeyMappings() != null) {
                    data.set("columnToJsonKeyMappings", om.valueToTree(this.getColumnToJsonKeyMappings()));
                }
                if (this.getConvertDotsInJsonKeysToUnderscores() != null) {
                    data.set("convertDotsInJsonKeysToUnderscores", om.valueToTree(this.getConvertDotsInJsonKeysToUnderscores()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OpenXJsonSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenXJsonSerDeProperty.Jsii$Proxy that = (OpenXJsonSerDeProperty.Jsii$Proxy) o;

                if (this.caseInsensitive != null ? !this.caseInsensitive.equals(that.caseInsensitive) : that.caseInsensitive != null) return false;
                if (this.columnToJsonKeyMappings != null ? !this.columnToJsonKeyMappings.equals(that.columnToJsonKeyMappings) : that.columnToJsonKeyMappings != null) return false;
                return this.convertDotsInJsonKeysToUnderscores != null ? this.convertDotsInJsonKeysToUnderscores.equals(that.convertDotsInJsonKeysToUnderscores) : that.convertDotsInJsonKeysToUnderscores == null;
            }

            @Override
            public final int hashCode() {
                int result = this.caseInsensitive != null ? this.caseInsensitive.hashCode() : 0;
                result = 31 * result + (this.columnToJsonKeyMappings != null ? this.columnToJsonKeyMappings.hashCode() : 0);
                result = 31 * result + (this.convertDotsInJsonKeysToUnderscores != null ? this.convertDotsInJsonKeysToUnderscores.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A serializer to use for converting data to the ORC format before storing it in Amazon S3.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * OrcSerDeProperty orcSerDeProperty = OrcSerDeProperty.builder()
     *         .blockSizeBytes(123)
     *         .bloomFilterColumns(List.of("bloomFilterColumns"))
     *         .bloomFilterFalsePositiveProbability(123)
     *         .compression("compression")
     *         .dictionaryKeyThreshold(123)
     *         .enablePadding(false)
     *         .formatVersion("formatVersion")
     *         .paddingTolerance(123)
     *         .rowIndexStride(123)
     *         .stripeSizeBytes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OrcSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(OrcSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrcSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Hadoop Distributed File System (HDFS) block size.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockSizeBytes() {
            return null;
        }

        /**
         * The column names for which you want Kinesis Data Firehose to create bloom filters.
         * <p>
         * The default is <code>null</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBloomFilterColumns() {
            return null;
        }

        /**
         * The Bloom filter false positive probability (FPP).
         * <p>
         * The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBloomFilterFalsePositiveProbability() {
            return null;
        }

        /**
         * The compression code to use over data blocks.
         * <p>
         * The default is <code>SNAPPY</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
            return null;
        }

        /**
         * Represents the fraction of the total number of non-null rows.
         * <p>
         * To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDictionaryKeyThreshold() {
            return null;
        }

        /**
         * Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePadding() {
            return null;
        }

        /**
         * The version of the file to write.
         * <p>
         * The possible values are <code>V0_11</code> and <code>V0_12</code> . The default is <code>V0_12</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormatVersion() {
            return null;
        }

        /**
         * A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size.
         * <p>
         * The default value is 0.05, which means 5 percent of stripe size.
         * <p>
         * For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
         * <p>
         * Kinesis Data Firehose ignores this parameter when <code>EnablePadding</code> is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPaddingTolerance() {
            return null;
        }

        /**
         * The number of rows between index entries.
         * <p>
         * The default is 10,000 and the minimum is 1,000.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRowIndexStride() {
            return null;
        }

        /**
         * The number of bytes in each stripe.
         * <p>
         * The default is 64 MiB and the minimum is 8 MiB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStripeSizeBytes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrcSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrcSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrcSerDeProperty> {
            java.lang.Number blockSizeBytes;
            java.util.List<java.lang.String> bloomFilterColumns;
            java.lang.Number bloomFilterFalsePositiveProbability;
            java.lang.String compression;
            java.lang.Number dictionaryKeyThreshold;
            java.lang.Object enablePadding;
            java.lang.String formatVersion;
            java.lang.Number paddingTolerance;
            java.lang.Number rowIndexStride;
            java.lang.Number stripeSizeBytes;

            /**
             * Sets the value of {@link OrcSerDeProperty#getBlockSizeBytes}
             * @param blockSizeBytes The Hadoop Distributed File System (HDFS) block size.
             *                       This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockSizeBytes(java.lang.Number blockSizeBytes) {
                this.blockSizeBytes = blockSizeBytes;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getBloomFilterColumns}
             * @param bloomFilterColumns The column names for which you want Kinesis Data Firehose to create bloom filters.
             *                           The default is <code>null</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bloomFilterColumns(java.util.List<java.lang.String> bloomFilterColumns) {
                this.bloomFilterColumns = bloomFilterColumns;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getBloomFilterFalsePositiveProbability}
             * @param bloomFilterFalsePositiveProbability The Bloom filter false positive probability (FPP).
             *                                            The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bloomFilterFalsePositiveProbability(java.lang.Number bloomFilterFalsePositiveProbability) {
                this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getCompression}
             * @param compression The compression code to use over data blocks.
             *                    The default is <code>SNAPPY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compression(java.lang.String compression) {
                this.compression = compression;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getDictionaryKeyThreshold}
             * @param dictionaryKeyThreshold Represents the fraction of the total number of non-null rows.
             *                               To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dictionaryKeyThreshold(java.lang.Number dictionaryKeyThreshold) {
                this.dictionaryKeyThreshold = dictionaryKeyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getEnablePadding}
             * @param enablePadding Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries.
             *                      This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePadding(java.lang.Boolean enablePadding) {
                this.enablePadding = enablePadding;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getEnablePadding}
             * @param enablePadding Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries.
             *                      This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePadding(software.amazon.awscdk.IResolvable enablePadding) {
                this.enablePadding = enablePadding;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getFormatVersion}
             * @param formatVersion The version of the file to write.
             *                      The possible values are <code>V0_11</code> and <code>V0_12</code> . The default is <code>V0_12</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatVersion(java.lang.String formatVersion) {
                this.formatVersion = formatVersion;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getPaddingTolerance}
             * @param paddingTolerance A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size.
             *                         The default value is 0.05, which means 5 percent of stripe size.
             *                         <p>
             *                         For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
             *                         <p>
             *                         Kinesis Data Firehose ignores this parameter when <code>EnablePadding</code> is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paddingTolerance(java.lang.Number paddingTolerance) {
                this.paddingTolerance = paddingTolerance;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getRowIndexStride}
             * @param rowIndexStride The number of rows between index entries.
             *                       The default is 10,000 and the minimum is 1,000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rowIndexStride(java.lang.Number rowIndexStride) {
                this.rowIndexStride = rowIndexStride;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getStripeSizeBytes}
             * @param stripeSizeBytes The number of bytes in each stripe.
             *                        The default is 64 MiB and the minimum is 8 MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stripeSizeBytes(java.lang.Number stripeSizeBytes) {
                this.stripeSizeBytes = stripeSizeBytes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrcSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrcSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrcSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrcSerDeProperty {
            private final java.lang.Number blockSizeBytes;
            private final java.util.List<java.lang.String> bloomFilterColumns;
            private final java.lang.Number bloomFilterFalsePositiveProbability;
            private final java.lang.String compression;
            private final java.lang.Number dictionaryKeyThreshold;
            private final java.lang.Object enablePadding;
            private final java.lang.String formatVersion;
            private final java.lang.Number paddingTolerance;
            private final java.lang.Number rowIndexStride;
            private final java.lang.Number stripeSizeBytes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockSizeBytes = software.amazon.jsii.Kernel.get(this, "blockSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bloomFilterColumns = software.amazon.jsii.Kernel.get(this, "bloomFilterColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bloomFilterFalsePositiveProbability = software.amazon.jsii.Kernel.get(this, "bloomFilterFalsePositiveProbability", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dictionaryKeyThreshold = software.amazon.jsii.Kernel.get(this, "dictionaryKeyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enablePadding = software.amazon.jsii.Kernel.get(this, "enablePadding", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.formatVersion = software.amazon.jsii.Kernel.get(this, "formatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.paddingTolerance = software.amazon.jsii.Kernel.get(this, "paddingTolerance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rowIndexStride = software.amazon.jsii.Kernel.get(this, "rowIndexStride", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stripeSizeBytes = software.amazon.jsii.Kernel.get(this, "stripeSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockSizeBytes = builder.blockSizeBytes;
                this.bloomFilterColumns = builder.bloomFilterColumns;
                this.bloomFilterFalsePositiveProbability = builder.bloomFilterFalsePositiveProbability;
                this.compression = builder.compression;
                this.dictionaryKeyThreshold = builder.dictionaryKeyThreshold;
                this.enablePadding = builder.enablePadding;
                this.formatVersion = builder.formatVersion;
                this.paddingTolerance = builder.paddingTolerance;
                this.rowIndexStride = builder.rowIndexStride;
                this.stripeSizeBytes = builder.stripeSizeBytes;
            }

            @Override
            public final java.lang.Number getBlockSizeBytes() {
                return this.blockSizeBytes;
            }

            @Override
            public final java.util.List<java.lang.String> getBloomFilterColumns() {
                return this.bloomFilterColumns;
            }

            @Override
            public final java.lang.Number getBloomFilterFalsePositiveProbability() {
                return this.bloomFilterFalsePositiveProbability;
            }

            @Override
            public final java.lang.String getCompression() {
                return this.compression;
            }

            @Override
            public final java.lang.Number getDictionaryKeyThreshold() {
                return this.dictionaryKeyThreshold;
            }

            @Override
            public final java.lang.Object getEnablePadding() {
                return this.enablePadding;
            }

            @Override
            public final java.lang.String getFormatVersion() {
                return this.formatVersion;
            }

            @Override
            public final java.lang.Number getPaddingTolerance() {
                return this.paddingTolerance;
            }

            @Override
            public final java.lang.Number getRowIndexStride() {
                return this.rowIndexStride;
            }

            @Override
            public final java.lang.Number getStripeSizeBytes() {
                return this.stripeSizeBytes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockSizeBytes() != null) {
                    data.set("blockSizeBytes", om.valueToTree(this.getBlockSizeBytes()));
                }
                if (this.getBloomFilterColumns() != null) {
                    data.set("bloomFilterColumns", om.valueToTree(this.getBloomFilterColumns()));
                }
                if (this.getBloomFilterFalsePositiveProbability() != null) {
                    data.set("bloomFilterFalsePositiveProbability", om.valueToTree(this.getBloomFilterFalsePositiveProbability()));
                }
                if (this.getCompression() != null) {
                    data.set("compression", om.valueToTree(this.getCompression()));
                }
                if (this.getDictionaryKeyThreshold() != null) {
                    data.set("dictionaryKeyThreshold", om.valueToTree(this.getDictionaryKeyThreshold()));
                }
                if (this.getEnablePadding() != null) {
                    data.set("enablePadding", om.valueToTree(this.getEnablePadding()));
                }
                if (this.getFormatVersion() != null) {
                    data.set("formatVersion", om.valueToTree(this.getFormatVersion()));
                }
                if (this.getPaddingTolerance() != null) {
                    data.set("paddingTolerance", om.valueToTree(this.getPaddingTolerance()));
                }
                if (this.getRowIndexStride() != null) {
                    data.set("rowIndexStride", om.valueToTree(this.getRowIndexStride()));
                }
                if (this.getStripeSizeBytes() != null) {
                    data.set("stripeSizeBytes", om.valueToTree(this.getStripeSizeBytes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OrcSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrcSerDeProperty.Jsii$Proxy that = (OrcSerDeProperty.Jsii$Proxy) o;

                if (this.blockSizeBytes != null ? !this.blockSizeBytes.equals(that.blockSizeBytes) : that.blockSizeBytes != null) return false;
                if (this.bloomFilterColumns != null ? !this.bloomFilterColumns.equals(that.bloomFilterColumns) : that.bloomFilterColumns != null) return false;
                if (this.bloomFilterFalsePositiveProbability != null ? !this.bloomFilterFalsePositiveProbability.equals(that.bloomFilterFalsePositiveProbability) : that.bloomFilterFalsePositiveProbability != null) return false;
                if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
                if (this.dictionaryKeyThreshold != null ? !this.dictionaryKeyThreshold.equals(that.dictionaryKeyThreshold) : that.dictionaryKeyThreshold != null) return false;
                if (this.enablePadding != null ? !this.enablePadding.equals(that.enablePadding) : that.enablePadding != null) return false;
                if (this.formatVersion != null ? !this.formatVersion.equals(that.formatVersion) : that.formatVersion != null) return false;
                if (this.paddingTolerance != null ? !this.paddingTolerance.equals(that.paddingTolerance) : that.paddingTolerance != null) return false;
                if (this.rowIndexStride != null ? !this.rowIndexStride.equals(that.rowIndexStride) : that.rowIndexStride != null) return false;
                return this.stripeSizeBytes != null ? this.stripeSizeBytes.equals(that.stripeSizeBytes) : that.stripeSizeBytes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockSizeBytes != null ? this.blockSizeBytes.hashCode() : 0;
                result = 31 * result + (this.bloomFilterColumns != null ? this.bloomFilterColumns.hashCode() : 0);
                result = 31 * result + (this.bloomFilterFalsePositiveProbability != null ? this.bloomFilterFalsePositiveProbability.hashCode() : 0);
                result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
                result = 31 * result + (this.dictionaryKeyThreshold != null ? this.dictionaryKeyThreshold.hashCode() : 0);
                result = 31 * result + (this.enablePadding != null ? this.enablePadding.hashCode() : 0);
                result = 31 * result + (this.formatVersion != null ? this.formatVersion.hashCode() : 0);
                result = 31 * result + (this.paddingTolerance != null ? this.paddingTolerance.hashCode() : 0);
                result = 31 * result + (this.rowIndexStride != null ? this.rowIndexStride.hashCode() : 0);
                result = 31 * result + (this.stripeSizeBytes != null ? this.stripeSizeBytes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data before it writes it to Amazon S3.
     * <p>
     * This parameter is required if <code>Enabled</code> is set to true.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * OutputFormatConfigurationProperty outputFormatConfigurationProperty = OutputFormatConfigurationProperty.builder()
     *         .serializer(SerializerProperty.builder()
     *                 .orcSerDe(OrcSerDeProperty.builder()
     *                         .blockSizeBytes(123)
     *                         .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                         .bloomFilterFalsePositiveProbability(123)
     *                         .compression("compression")
     *                         .dictionaryKeyThreshold(123)
     *                         .enablePadding(false)
     *                         .formatVersion("formatVersion")
     *                         .paddingTolerance(123)
     *                         .rowIndexStride(123)
     *                         .stripeSizeBytes(123)
     *                         .build())
     *                 .parquetSerDe(ParquetSerDeProperty.builder()
     *                         .blockSizeBytes(123)
     *                         .compression("compression")
     *                         .enableDictionaryCompression(false)
     *                         .maxPaddingBytes(123)
     *                         .pageSizeBytes(123)
     *                         .writerVersion("writerVersion")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputFormatConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputFormatConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which serializer to use.
         * <p>
         * You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSerializer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputFormatConfigurationProperty> {
            java.lang.Object serializer;

            /**
             * Sets the value of {@link OutputFormatConfigurationProperty#getSerializer}
             * @param serializer Specifies which serializer to use.
             *                   You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serializer(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SerializerProperty serializer) {
                this.serializer = serializer;
                return this;
            }

            /**
             * Sets the value of {@link OutputFormatConfigurationProperty#getSerializer}
             * @param serializer Specifies which serializer to use.
             *                   You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serializer(software.amazon.awscdk.IResolvable serializer) {
                this.serializer = serializer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputFormatConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputFormatConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputFormatConfigurationProperty {
            private final java.lang.Object serializer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serializer = software.amazon.jsii.Kernel.get(this, "serializer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serializer = builder.serializer;
            }

            @Override
            public final java.lang.Object getSerializer() {
                return this.serializer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSerializer() != null) {
                    data.set("serializer", om.valueToTree(this.getSerializer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputFormatConfigurationProperty.Jsii$Proxy that = (OutputFormatConfigurationProperty.Jsii$Proxy) o;

                return this.serializer != null ? this.serializer.equals(that.serializer) : that.serializer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serializer != null ? this.serializer.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/documentation/latest/">Apache Parquet</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ParquetSerDeProperty parquetSerDeProperty = ParquetSerDeProperty.builder()
     *         .blockSizeBytes(123)
     *         .compression("compression")
     *         .enableDictionaryCompression(false)
     *         .maxPaddingBytes(123)
     *         .pageSizeBytes(123)
     *         .writerVersion("writerVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ParquetSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(ParquetSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParquetSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Hadoop Distributed File System (HDFS) block size.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockSizeBytes() {
            return null;
        }

        /**
         * The compression code to use over data blocks.
         * <p>
         * The possible values are <code>UNCOMPRESSED</code> , <code>SNAPPY</code> , and <code>GZIP</code> , with the default being <code>SNAPPY</code> . Use <code>SNAPPY</code> for higher decompression speed. Use <code>GZIP</code> if the compression ratio is more important than speed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
            return null;
        }

        /**
         * Indicates whether to enable dictionary compression.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDictionaryCompression() {
            return null;
        }

        /**
         * The maximum amount of padding to apply.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 0.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPaddingBytes() {
            return null;
        }

        /**
         * The Parquet page size.
         * <p>
         * Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPageSizeBytes() {
            return null;
        }

        /**
         * Indicates the version of row format to output.
         * <p>
         * The possible values are <code>V1</code> and <code>V2</code> . The default is <code>V1</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriterVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParquetSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParquetSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParquetSerDeProperty> {
            java.lang.Number blockSizeBytes;
            java.lang.String compression;
            java.lang.Object enableDictionaryCompression;
            java.lang.Number maxPaddingBytes;
            java.lang.Number pageSizeBytes;
            java.lang.String writerVersion;

            /**
             * Sets the value of {@link ParquetSerDeProperty#getBlockSizeBytes}
             * @param blockSizeBytes The Hadoop Distributed File System (HDFS) block size.
             *                       This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockSizeBytes(java.lang.Number blockSizeBytes) {
                this.blockSizeBytes = blockSizeBytes;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getCompression}
             * @param compression The compression code to use over data blocks.
             *                    The possible values are <code>UNCOMPRESSED</code> , <code>SNAPPY</code> , and <code>GZIP</code> , with the default being <code>SNAPPY</code> . Use <code>SNAPPY</code> for higher decompression speed. Use <code>GZIP</code> if the compression ratio is more important than speed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compression(java.lang.String compression) {
                this.compression = compression;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getEnableDictionaryCompression}
             * @param enableDictionaryCompression Indicates whether to enable dictionary compression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDictionaryCompression(java.lang.Boolean enableDictionaryCompression) {
                this.enableDictionaryCompression = enableDictionaryCompression;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getEnableDictionaryCompression}
             * @param enableDictionaryCompression Indicates whether to enable dictionary compression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDictionaryCompression(software.amazon.awscdk.IResolvable enableDictionaryCompression) {
                this.enableDictionaryCompression = enableDictionaryCompression;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getMaxPaddingBytes}
             * @param maxPaddingBytes The maximum amount of padding to apply.
             *                        This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPaddingBytes(java.lang.Number maxPaddingBytes) {
                this.maxPaddingBytes = maxPaddingBytes;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getPageSizeBytes}
             * @param pageSizeBytes The Parquet page size.
             *                      Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageSizeBytes(java.lang.Number pageSizeBytes) {
                this.pageSizeBytes = pageSizeBytes;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getWriterVersion}
             * @param writerVersion Indicates the version of row format to output.
             *                      The possible values are <code>V1</code> and <code>V2</code> . The default is <code>V1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writerVersion(java.lang.String writerVersion) {
                this.writerVersion = writerVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParquetSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParquetSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParquetSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParquetSerDeProperty {
            private final java.lang.Number blockSizeBytes;
            private final java.lang.String compression;
            private final java.lang.Object enableDictionaryCompression;
            private final java.lang.Number maxPaddingBytes;
            private final java.lang.Number pageSizeBytes;
            private final java.lang.String writerVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockSizeBytes = software.amazon.jsii.Kernel.get(this, "blockSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableDictionaryCompression = software.amazon.jsii.Kernel.get(this, "enableDictionaryCompression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxPaddingBytes = software.amazon.jsii.Kernel.get(this, "maxPaddingBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pageSizeBytes = software.amazon.jsii.Kernel.get(this, "pageSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.writerVersion = software.amazon.jsii.Kernel.get(this, "writerVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockSizeBytes = builder.blockSizeBytes;
                this.compression = builder.compression;
                this.enableDictionaryCompression = builder.enableDictionaryCompression;
                this.maxPaddingBytes = builder.maxPaddingBytes;
                this.pageSizeBytes = builder.pageSizeBytes;
                this.writerVersion = builder.writerVersion;
            }

            @Override
            public final java.lang.Number getBlockSizeBytes() {
                return this.blockSizeBytes;
            }

            @Override
            public final java.lang.String getCompression() {
                return this.compression;
            }

            @Override
            public final java.lang.Object getEnableDictionaryCompression() {
                return this.enableDictionaryCompression;
            }

            @Override
            public final java.lang.Number getMaxPaddingBytes() {
                return this.maxPaddingBytes;
            }

            @Override
            public final java.lang.Number getPageSizeBytes() {
                return this.pageSizeBytes;
            }

            @Override
            public final java.lang.String getWriterVersion() {
                return this.writerVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockSizeBytes() != null) {
                    data.set("blockSizeBytes", om.valueToTree(this.getBlockSizeBytes()));
                }
                if (this.getCompression() != null) {
                    data.set("compression", om.valueToTree(this.getCompression()));
                }
                if (this.getEnableDictionaryCompression() != null) {
                    data.set("enableDictionaryCompression", om.valueToTree(this.getEnableDictionaryCompression()));
                }
                if (this.getMaxPaddingBytes() != null) {
                    data.set("maxPaddingBytes", om.valueToTree(this.getMaxPaddingBytes()));
                }
                if (this.getPageSizeBytes() != null) {
                    data.set("pageSizeBytes", om.valueToTree(this.getPageSizeBytes()));
                }
                if (this.getWriterVersion() != null) {
                    data.set("writerVersion", om.valueToTree(this.getWriterVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ParquetSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParquetSerDeProperty.Jsii$Proxy that = (ParquetSerDeProperty.Jsii$Proxy) o;

                if (this.blockSizeBytes != null ? !this.blockSizeBytes.equals(that.blockSizeBytes) : that.blockSizeBytes != null) return false;
                if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
                if (this.enableDictionaryCompression != null ? !this.enableDictionaryCompression.equals(that.enableDictionaryCompression) : that.enableDictionaryCompression != null) return false;
                if (this.maxPaddingBytes != null ? !this.maxPaddingBytes.equals(that.maxPaddingBytes) : that.maxPaddingBytes != null) return false;
                if (this.pageSizeBytes != null ? !this.pageSizeBytes.equals(that.pageSizeBytes) : that.pageSizeBytes != null) return false;
                return this.writerVersion != null ? this.writerVersion.equals(that.writerVersion) : that.writerVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockSizeBytes != null ? this.blockSizeBytes.hashCode() : 0;
                result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
                result = 31 * result + (this.enableDictionaryCompression != null ? this.enableDictionaryCompression.hashCode() : 0);
                result = 31 * result + (this.maxPaddingBytes != null ? this.maxPaddingBytes.hashCode() : 0);
                result = 31 * result + (this.pageSizeBytes != null ? this.pageSizeBytes.hashCode() : 0);
                result = 31 * result + (this.writerVersion != null ? this.writerVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ProcessingConfiguration` property configures data processing for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ProcessingConfigurationProperty processingConfigurationProperty = ProcessingConfigurationProperty.builder()
     *         .enabled(false)
     *         .processors(List.of(ProcessorProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .parameters(List.of(ProcessorParameterProperty.builder()
     *                         .parameterName("parameterName")
     *                         .parameterValue("parameterValue")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether data processing is enabled (true) or disabled (false).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The data processors.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessors() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessingConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object processors;

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getEnabled}
             * @param enabled Indicates whether data processing is enabled (true) or disabled (false).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getEnabled}
             * @param enabled Indicates whether data processing is enabled (true) or disabled (false).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getProcessors}
             * @param processors The data processors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processors(software.amazon.awscdk.IResolvable processors) {
                this.processors = processors;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getProcessors}
             * @param processors The data processors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processors(java.util.List<? extends java.lang.Object> processors) {
                this.processors = processors;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessingConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object processors;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processors = software.amazon.jsii.Kernel.get(this, "processors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.processors = builder.processors;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getProcessors() {
                return this.processors;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getProcessors() != null) {
                    data.set("processors", om.valueToTree(this.getProcessors()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessingConfigurationProperty.Jsii$Proxy that = (ProcessingConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.processors != null ? this.processors.equals(that.processors) : that.processors == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.processors != null ? this.processors.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ProcessorParameter` property specifies a processor parameter in a data processor for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ProcessorParameterProperty processorParameterProperty = ProcessorParameterProperty.builder()
     *         .parameterName("parameterName")
     *         .parameterValue("parameterValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessorParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessorParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the parameter.
         * <p>
         * Currently the following default values are supported: 3 for <code>NumberOfRetries</code> , 60 for the <code>BufferIntervalInSeconds</code> , and 3 for the <code>BufferSizeInMBs</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

        /**
         * The parameter value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterValue();

        /**
         * @return a {@link Builder} of {@link ProcessorParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessorParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessorParameterProperty> {
            java.lang.String parameterName;
            java.lang.String parameterValue;

            /**
             * Sets the value of {@link ProcessorParameterProperty#getParameterName}
             * @param parameterName The name of the parameter. This parameter is required.
             *                      Currently the following default values are supported: 3 for <code>NumberOfRetries</code> , 60 for the <code>BufferIntervalInSeconds</code> , and 3 for the <code>BufferSizeInMBs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorParameterProperty#getParameterValue}
             * @param parameterValue The parameter value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterValue(java.lang.String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessorParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessorParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessorParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorParameterProperty {
            private final java.lang.String parameterName;
            private final java.lang.String parameterValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterValue = software.amazon.jsii.Kernel.get(this, "parameterValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
                this.parameterValue = java.util.Objects.requireNonNull(builder.parameterValue, "parameterValue is required");
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            public final java.lang.String getParameterValue() {
                return this.parameterValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameterName", om.valueToTree(this.getParameterName()));
                data.set("parameterValue", om.valueToTree(this.getParameterValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessorParameterProperty.Jsii$Proxy that = (ProcessorParameterProperty.Jsii$Proxy) o;

                if (!parameterName.equals(that.parameterName)) return false;
                return this.parameterValue.equals(that.parameterValue);
            }

            @Override
            public final int hashCode() {
                int result = this.parameterName.hashCode();
                result = 31 * result + (this.parameterValue.hashCode());
                return result;
            }
        }
    }
    /**
     * The `Processor` property specifies a data processor for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ProcessorProperty processorProperty = ProcessorProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .parameters(List.of(ProcessorParameterProperty.builder()
     *                 .parameterName("parameterName")
     *                 .parameterValue("parameterValue")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of processor.
         * <p>
         * Valid values: <code>Lambda</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The processor parameters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessorProperty> {
            java.lang.String type;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link ProcessorProperty#getType}
             * @param type The type of processor. This parameter is required.
             *             Valid values: <code>Lambda</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParameters}
             * @param parameters The processor parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParameters}
             * @param parameters The processor parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorProperty {
            private final java.lang.String type;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessorProperty.Jsii$Proxy that = (ProcessorProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `RedshiftDestinationConfiguration` property type specifies an Amazon Redshift cluster to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * RedshiftDestinationConfigurationProperty redshiftDestinationConfigurationProperty = RedshiftDestinationConfigurationProperty.builder()
     *         .clusterJdbcurl("clusterJdbcurl")
     *         .copyCommand(CopyCommandProperty.builder()
     *                 .dataTableName("dataTableName")
     *                 // the properties below are optional
     *                 .copyOptions("copyOptions")
     *                 .dataTableColumns("dataTableColumns")
     *                 .build())
     *         .password("password")
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         .username("username")
     *         // the properties below are optional
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(RedshiftRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connection string that Kinesis Data Firehose uses to connect to the Amazon Redshift cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterJdbcurl();

        /**
         * Configures the Amazon Redshift `COPY` command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCopyCommand();

        /**
         * The password for the Amazon Redshift user that you specified in the `Username` property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The ARN of the AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs">Grant Kinesis Data Firehose Access to an Amazon Redshift Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The S3 bucket where Kinesis Data Firehose first delivers data.
         * <p>
         * After the data is in the bucket, Kinesis Data Firehose uses the <code>COPY</code> command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify <code>SNAPPY</code> or <code>ZIP</code> because the Amazon Redshift <code>COPY</code> command doesn't support them.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The Amazon Redshift user that has permission to access the Amazon Redshift cluster.
         * <p>
         * This user must have <code>INSERT</code> privileges for copying data from the Amazon S3 bucket to the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * The CloudWatch logging options for your delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The data processing configuration for the Kinesis Data Firehose delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift.
         * <p>
         * Default value is 3600 (60 minutes).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * The configuration for backup in Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3BackupConfiguration() {
            return null;
        }

        /**
         * The Amazon S3 backup mode.
         * <p>
         * After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftDestinationConfigurationProperty> {
            java.lang.String clusterJdbcurl;
            java.lang.Object copyCommand;
            java.lang.String password;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.String username;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.Object s3BackupConfiguration;
            java.lang.String s3BackupMode;

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getClusterJdbcurl}
             * @param clusterJdbcurl The connection string that Kinesis Data Firehose uses to connect to the Amazon Redshift cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterJdbcurl(java.lang.String clusterJdbcurl) {
                this.clusterJdbcurl = clusterJdbcurl;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCopyCommand}
             * @param copyCommand Configures the Amazon Redshift `COPY` command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyCommand(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CopyCommandProperty copyCommand) {
                this.copyCommand = copyCommand;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCopyCommand}
             * @param copyCommand Configures the Amazon Redshift `COPY` command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyCommand(software.amazon.awscdk.IResolvable copyCommand) {
                this.copyCommand = copyCommand;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getPassword}
             * @param password The password for the Amazon Redshift user that you specified in the `Username` property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). This parameter is required.
             *                For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs">Grant Kinesis Data Firehose Access to an Amazon Redshift Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose first delivers data. This parameter is required.
             *                        After the data is in the bucket, Kinesis Data Firehose uses the <code>COPY</code> command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify <code>SNAPPY</code> or <code>ZIP</code> because the Amazon Redshift <code>COPY</code> command doesn't support them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose first delivers data. This parameter is required.
             *                        After the data is in the bucket, Kinesis Data Firehose uses the <code>COPY</code> command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify <code>SNAPPY</code> or <code>ZIP</code> because the Amazon Redshift <code>COPY</code> command doesn't support them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getUsername}
             * @param username The Amazon Redshift user that has permission to access the Amazon Redshift cluster. This parameter is required.
             *                 This user must have <code>INSERT</code> privileges for copying data from the Amazon S3 bucket to the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift.
             *                     Default value is 3600 (60 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift.
             *                     Default value is 3600 (60 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.IResolvable s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode The Amazon S3 backup mode.
             *                     After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftDestinationConfigurationProperty {
            private final java.lang.String clusterJdbcurl;
            private final java.lang.Object copyCommand;
            private final java.lang.String password;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.String username;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.Object s3BackupConfiguration;
            private final java.lang.String s3BackupMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterJdbcurl = software.amazon.jsii.Kernel.get(this, "clusterJdbcurl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyCommand = software.amazon.jsii.Kernel.get(this, "copyCommand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupConfiguration = software.amazon.jsii.Kernel.get(this, "s3BackupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterJdbcurl = java.util.Objects.requireNonNull(builder.clusterJdbcurl, "clusterJdbcurl is required");
                this.copyCommand = java.util.Objects.requireNonNull(builder.copyCommand, "copyCommand is required");
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupConfiguration = builder.s3BackupConfiguration;
                this.s3BackupMode = builder.s3BackupMode;
            }

            @Override
            public final java.lang.String getClusterJdbcurl() {
                return this.clusterJdbcurl;
            }

            @Override
            public final java.lang.Object getCopyCommand() {
                return this.copyCommand;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.Object getS3BackupConfiguration() {
                return this.s3BackupConfiguration;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterJdbcurl", om.valueToTree(this.getClusterJdbcurl()));
                data.set("copyCommand", om.valueToTree(this.getCopyCommand()));
                data.set("password", om.valueToTree(this.getPassword()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                data.set("username", om.valueToTree(this.getUsername()));
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupConfiguration() != null) {
                    data.set("s3BackupConfiguration", om.valueToTree(this.getS3BackupConfiguration()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftDestinationConfigurationProperty.Jsii$Proxy that = (RedshiftDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!clusterJdbcurl.equals(that.clusterJdbcurl)) return false;
                if (!copyCommand.equals(that.copyCommand)) return false;
                if (!password.equals(that.password)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (!username.equals(that.username)) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupConfiguration != null ? !this.s3BackupConfiguration.equals(that.s3BackupConfiguration) : that.s3BackupConfiguration != null) return false;
                return this.s3BackupMode != null ? this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterJdbcurl.hashCode();
                result = 31 * result + (this.copyCommand.hashCode());
                result = 31 * result + (this.password.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.username.hashCode());
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupConfiguration != null ? this.s3BackupConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * RedshiftRetryOptionsProperty redshiftRetryOptionsProperty = RedshiftRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the initial request and including the first attempt.
         * <p>
         * The default value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer than the current value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link RedshiftRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the initial request and including the first attempt.
             *                          The default value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer than the current value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftRetryOptionsProperty.Jsii$Proxy that = (RedshiftRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * RetryOptionsProperty retryOptionsProperty = RetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total amount of time that Kinesis Data Firehose spends on retries.
         * <p>
         * This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from the specified destination after each attempt.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link RetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds The total amount of time that Kinesis Data Firehose spends on retries.
             *                          This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from the specified destination after each attempt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryOptionsProperty.Jsii$Proxy that = (RetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * S3DestinationConfigurationProperty s3DestinationConfigurationProperty = S3DestinationConfigurationProperty.builder()
     *         .bucketArn("bucketArn")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .bufferingHints(BufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .compressionFormat("compressionFormat")
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                         .awskmsKeyArn("awskmsKeyArn")
     *                         .build())
     *                 .noEncryptionConfig("noEncryptionConfig")
     *                 .build())
     *         .errorOutputPrefix("errorOutputPrefix")
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket to send data to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The ARN of an AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * The CloudWatch logging options for your delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
         * <p>
         * For valid values, see the <code>CompressionFormat</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_S3DestinationConfiguration.html">S3DestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionFormat() {
            return null;
        }

        /**
         * Configures Amazon Simple Storage Service (Amazon S3) server-side encryption.
         * <p>
         * Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorOutputPrefix() {
            return null;
        }

        /**
         * A prefix that Kinesis Data Firehose adds to the files that it delivers to the Amazon S3 bucket.
         * <p>
         * The prefix helps you identify the files that Kinesis Data Firehose delivered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationConfigurationProperty> {
            java.lang.String bucketArn;
            java.lang.String roleArn;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String compressionFormat;
            java.lang.Object encryptionConfiguration;
            java.lang.String errorOutputPrefix;
            java.lang.String prefix;

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the Amazon S3 bucket to send data to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of an AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). This parameter is required.
             *                For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getCompressionFormat}
             * @param compressionFormat The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
             *                          For valid values, see the <code>CompressionFormat</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_S3DestinationConfiguration.html">S3DestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionFormat(java.lang.String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Configures Amazon Simple Storage Service (Amazon S3) server-side encryption.
             *                                Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Configures Amazon Simple Storage Service (Amazon S3) server-side encryption.
             *                                Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getErrorOutputPrefix}
             * @param errorOutputPrefix A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
             *                          This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorOutputPrefix(java.lang.String errorOutputPrefix) {
                this.errorOutputPrefix = errorOutputPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getPrefix}
             * @param prefix A prefix that Kinesis Data Firehose adds to the files that it delivers to the Amazon S3 bucket.
             *               The prefix helps you identify the files that Kinesis Data Firehose delivered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationConfigurationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String roleArn;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String compressionFormat;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String errorOutputPrefix;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressionFormat = software.amazon.jsii.Kernel.get(this, "compressionFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.errorOutputPrefix = software.amazon.jsii.Kernel.get(this, "errorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.compressionFormat = builder.compressionFormat;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.errorOutputPrefix = builder.errorOutputPrefix;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getCompressionFormat() {
                return this.compressionFormat;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getErrorOutputPrefix() {
                return this.errorOutputPrefix;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getCompressionFormat() != null) {
                    data.set("compressionFormat", om.valueToTree(this.getCompressionFormat()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getErrorOutputPrefix() != null) {
                    data.set("errorOutputPrefix", om.valueToTree(this.getErrorOutputPrefix()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationConfigurationProperty.Jsii$Proxy that = (S3DestinationConfigurationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.compressionFormat != null ? !this.compressionFormat.equals(that.compressionFormat) : that.compressionFormat != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.errorOutputPrefix != null ? !this.errorOutputPrefix.equals(that.errorOutputPrefix) : that.errorOutputPrefix != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.compressionFormat != null ? this.compressionFormat.hashCode() : 0);
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.errorOutputPrefix != null ? this.errorOutputPrefix.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the schema to which you want Kinesis Data Firehose to configure your data before it writes it to Amazon S3.
     * <p>
     * This parameter is required if <code>Enabled</code> is set to true.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SchemaConfigurationProperty schemaConfigurationProperty = SchemaConfigurationProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         .region("region")
     *         .roleArn("roleArn")
     *         .tableName("tableName")
     *         .versionId("versionId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the AWS Glue Data Catalog.
         * <p>
         * If you don't supply this, the AWS account ID is used by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * Specifies the name of the AWS Glue database that contains the schema for the output data.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its value must be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * If you don't specify an AWS Region, the default is the current Region.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * The role that Kinesis Data Firehose can use to access AWS Glue.
         * <p>
         * This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its value must be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Specifies the AWS Glue table that contains the column information that constitutes your data schema.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its value must be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
            return null;
        }

        /**
         * Specifies the table version for the output data schema.
         * <p>
         * If you don't specify this version ID, or if you set it to <code>LATEST</code> , Kinesis Data Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersionId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaConfigurationProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String region;
            java.lang.String roleArn;
            java.lang.String tableName;
            java.lang.String versionId;

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getCatalogId}
             * @param catalogId The ID of the AWS Glue Data Catalog.
             *                  If you don't supply this, the AWS account ID is used by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getDatabaseName}
             * @param databaseName Specifies the name of the AWS Glue database that contains the schema for the output data.
             *                     <blockquote>
             *                     <p>
             *                     If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its value must be specified.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getRegion}
             * @param region If you don't specify an AWS Region, the default is the current Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getRoleArn}
             * @param roleArn The role that Kinesis Data Firehose can use to access AWS Glue.
             *                This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
             *                <p>
             *                <blockquote>
             *                <p>
             *                If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its value must be specified.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getTableName}
             * @param tableName Specifies the AWS Glue table that contains the column information that constitutes your data schema.
             *                  <blockquote>
             *                  <p>
             *                  If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its value must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getVersionId}
             * @param versionId Specifies the table version for the output data schema.
             *                  If you don't specify this version ID, or if you set it to <code>LATEST</code> , Kinesis Data Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionId(java.lang.String versionId) {
                this.versionId = versionId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaConfigurationProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String region;
            private final java.lang.String roleArn;
            private final java.lang.String tableName;
            private final java.lang.String versionId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.versionId = software.amazon.jsii.Kernel.get(this, "versionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = builder.catalogId;
                this.databaseName = builder.databaseName;
                this.region = builder.region;
                this.roleArn = builder.roleArn;
                this.tableName = builder.tableName;
                this.versionId = builder.versionId;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getVersionId() {
                return this.versionId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getTableName() != null) {
                    data.set("tableName", om.valueToTree(this.getTableName()));
                }
                if (this.getVersionId() != null) {
                    data.set("versionId", om.valueToTree(this.getVersionId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaConfigurationProperty.Jsii$Proxy that = (SchemaConfigurationProperty.Jsii$Proxy) o;

                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
                return this.versionId != null ? this.versionId.equals(that.versionId) : that.versionId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId != null ? this.catalogId.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
                result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The serializer that you want Kinesis Data Firehose to use to convert data to the target format before writing it to Amazon S3.
     * <p>
     * Kinesis Data Firehose supports two types of serializers: the <a href="https://docs.aws.amazon.com/https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html">ORC SerDe</a> and the <a href="https://docs.aws.amazon.com/https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html">Parquet SerDe</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SerializerProperty serializerProperty = SerializerProperty.builder()
     *         .orcSerDe(OrcSerDeProperty.builder()
     *                 .blockSizeBytes(123)
     *                 .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                 .bloomFilterFalsePositiveProbability(123)
     *                 .compression("compression")
     *                 .dictionaryKeyThreshold(123)
     *                 .enablePadding(false)
     *                 .formatVersion("formatVersion")
     *                 .paddingTolerance(123)
     *                 .rowIndexStride(123)
     *                 .stripeSizeBytes(123)
     *                 .build())
     *         .parquetSerDe(ParquetSerDeProperty.builder()
     *                 .blockSizeBytes(123)
     *                 .compression("compression")
     *                 .enableDictionaryCompression(false)
     *                 .maxPaddingBytes(123)
     *                 .pageSizeBytes(123)
     *                 .writerVersion("writerVersion")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SerializerProperty")
    @software.amazon.jsii.Jsii.Proxy(SerializerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SerializerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A serializer to use for converting data to the ORC format before storing it in Amazon S3.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrcSerDe() {
            return null;
        }

        /**
         * A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/documentation/latest/">Apache Parquet</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParquetSerDe() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SerializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SerializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SerializerProperty> {
            java.lang.Object orcSerDe;
            java.lang.Object parquetSerDe;

            /**
             * Sets the value of {@link SerializerProperty#getOrcSerDe}
             * @param orcSerDe A serializer to use for converting data to the ORC format before storing it in Amazon S3.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orcSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OrcSerDeProperty orcSerDe) {
                this.orcSerDe = orcSerDe;
                return this;
            }

            /**
             * Sets the value of {@link SerializerProperty#getOrcSerDe}
             * @param orcSerDe A serializer to use for converting data to the ORC format before storing it in Amazon S3.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orcSerDe(software.amazon.awscdk.IResolvable orcSerDe) {
                this.orcSerDe = orcSerDe;
                return this;
            }

            /**
             * Sets the value of {@link SerializerProperty#getParquetSerDe}
             * @param parquetSerDe A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
             *                     For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/documentation/latest/">Apache Parquet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ParquetSerDeProperty parquetSerDe) {
                this.parquetSerDe = parquetSerDe;
                return this;
            }

            /**
             * Sets the value of {@link SerializerProperty#getParquetSerDe}
             * @param parquetSerDe A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
             *                     For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/documentation/latest/">Apache Parquet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetSerDe(software.amazon.awscdk.IResolvable parquetSerDe) {
                this.parquetSerDe = parquetSerDe;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SerializerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SerializerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SerializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SerializerProperty {
            private final java.lang.Object orcSerDe;
            private final java.lang.Object parquetSerDe;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.orcSerDe = software.amazon.jsii.Kernel.get(this, "orcSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parquetSerDe = software.amazon.jsii.Kernel.get(this, "parquetSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.orcSerDe = builder.orcSerDe;
                this.parquetSerDe = builder.parquetSerDe;
            }

            @Override
            public final java.lang.Object getOrcSerDe() {
                return this.orcSerDe;
            }

            @Override
            public final java.lang.Object getParquetSerDe() {
                return this.parquetSerDe;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOrcSerDe() != null) {
                    data.set("orcSerDe", om.valueToTree(this.getOrcSerDe()));
                }
                if (this.getParquetSerDe() != null) {
                    data.set("parquetSerDe", om.valueToTree(this.getParquetSerDe()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SerializerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SerializerProperty.Jsii$Proxy that = (SerializerProperty.Jsii$Proxy) o;

                if (this.orcSerDe != null ? !this.orcSerDe.equals(that.orcSerDe) : that.orcSerDe != null) return false;
                return this.parquetSerDe != null ? this.parquetSerDe.equals(that.parquetSerDe) : that.parquetSerDe == null;
            }

            @Override
            public final int hashCode() {
                int result = this.orcSerDe != null ? this.orcSerDe.hashCode() : 0;
                result = 31 * result + (this.parquetSerDe != null ? this.parquetSerDe.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `SplunkDestinationConfiguration` property type specifies the configuration of a destination in Splunk for a Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SplunkDestinationConfigurationProperty splunkDestinationConfigurationProperty = SplunkDestinationConfigurationProperty.builder()
     *         .hecEndpoint("hecEndpoint")
     *         .hecEndpointType("hecEndpointType")
     *         .hecToken("hecToken")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .hecAcknowledgmentTimeoutInSeconds(123)
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(SplunkRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SplunkDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SplunkDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHecEndpoint();

        /**
         * This type can be either `Raw` or `Event` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHecEndpointType();

        /**
         * This is a GUID that you obtain from your Splunk cluster when you create a new HEC endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHecToken();

        /**
         * The configuration for the backup Amazon S3 location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The Amazon CloudWatch logging options for your delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from Splunk after it sends it data.
         * <p>
         * At the end of the timeout period, Kinesis Data Firehose either tries to send the data again or considers it an error, based on your retry settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHecAcknowledgmentTimeoutInSeconds() {
            return null;
        }

        /**
         * The data processing configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk, or if it doesn't receive an acknowledgment of receipt from Splunk.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Defines how documents should be delivered to Amazon S3.
         * <p>
         * When set to <code>FailedEventsOnly</code> , Kinesis Data Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code> , Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents to Amazon S3. The default value is <code>FailedEventsOnly</code> .
         * <p>
         * You can update this backup mode from <code>FailedEventsOnly</code> to <code>AllEvents</code> . You can't update it from <code>AllEvents</code> to <code>FailedEventsOnly</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SplunkDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SplunkDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SplunkDestinationConfigurationProperty> {
            java.lang.String hecEndpoint;
            java.lang.String hecEndpointType;
            java.lang.String hecToken;
            java.lang.Object s3Configuration;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.Number hecAcknowledgmentTimeoutInSeconds;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getHecEndpoint}
             * @param hecEndpoint The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hecEndpoint(java.lang.String hecEndpoint) {
                this.hecEndpoint = hecEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getHecEndpointType}
             * @param hecEndpointType This type can be either `Raw` or `Event` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hecEndpointType(java.lang.String hecEndpointType) {
                this.hecEndpointType = hecEndpointType;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getHecToken}
             * @param hecToken This is a GUID that you obtain from your Splunk cluster when you create a new HEC endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hecToken(java.lang.String hecToken) {
                this.hecToken = hecToken;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration for the backup Amazon S3 location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration for the backup Amazon S3 location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getHecAcknowledgmentTimeoutInSeconds}
             * @param hecAcknowledgmentTimeoutInSeconds The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from Splunk after it sends it data.
             *                                          At the end of the timeout period, Kinesis Data Firehose either tries to send the data again or considers it an error, based on your retry settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hecAcknowledgmentTimeoutInSeconds(java.lang.Number hecAcknowledgmentTimeoutInSeconds) {
                this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk, or if it doesn't receive an acknowledgment of receipt from Splunk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SplunkRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk, or if it doesn't receive an acknowledgment of receipt from Splunk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link SplunkDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Defines how documents should be delivered to Amazon S3.
             *                     When set to <code>FailedEventsOnly</code> , Kinesis Data Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code> , Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents to Amazon S3. The default value is <code>FailedEventsOnly</code> .
             *                     <p>
             *                     You can update this backup mode from <code>FailedEventsOnly</code> to <code>AllEvents</code> . You can't update it from <code>AllEvents</code> to <code>FailedEventsOnly</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SplunkDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SplunkDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SplunkDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SplunkDestinationConfigurationProperty {
            private final java.lang.String hecEndpoint;
            private final java.lang.String hecEndpointType;
            private final java.lang.String hecToken;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.Number hecAcknowledgmentTimeoutInSeconds;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hecEndpoint = software.amazon.jsii.Kernel.get(this, "hecEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hecEndpointType = software.amazon.jsii.Kernel.get(this, "hecEndpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hecToken = software.amazon.jsii.Kernel.get(this, "hecToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hecAcknowledgmentTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "hecAcknowledgmentTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hecEndpoint = java.util.Objects.requireNonNull(builder.hecEndpoint, "hecEndpoint is required");
                this.hecEndpointType = java.util.Objects.requireNonNull(builder.hecEndpointType, "hecEndpointType is required");
                this.hecToken = java.util.Objects.requireNonNull(builder.hecToken, "hecToken is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.hecAcknowledgmentTimeoutInSeconds = builder.hecAcknowledgmentTimeoutInSeconds;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
            }

            @Override
            public final java.lang.String getHecEndpoint() {
                return this.hecEndpoint;
            }

            @Override
            public final java.lang.String getHecEndpointType() {
                return this.hecEndpointType;
            }

            @Override
            public final java.lang.String getHecToken() {
                return this.hecToken;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.Number getHecAcknowledgmentTimeoutInSeconds() {
                return this.hecAcknowledgmentTimeoutInSeconds;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hecEndpoint", om.valueToTree(this.getHecEndpoint()));
                data.set("hecEndpointType", om.valueToTree(this.getHecEndpointType()));
                data.set("hecToken", om.valueToTree(this.getHecToken()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getHecAcknowledgmentTimeoutInSeconds() != null) {
                    data.set("hecAcknowledgmentTimeoutInSeconds", om.valueToTree(this.getHecAcknowledgmentTimeoutInSeconds()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SplunkDestinationConfigurationProperty.Jsii$Proxy that = (SplunkDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!hecEndpoint.equals(that.hecEndpoint)) return false;
                if (!hecEndpointType.equals(that.hecEndpointType)) return false;
                if (!hecToken.equals(that.hecToken)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.hecAcknowledgmentTimeoutInSeconds != null ? !this.hecAcknowledgmentTimeoutInSeconds.equals(that.hecAcknowledgmentTimeoutInSeconds) : that.hecAcknowledgmentTimeoutInSeconds != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                return this.s3BackupMode != null ? this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hecEndpoint.hashCode();
                result = 31 * result + (this.hecEndpointType.hashCode());
                result = 31 * result + (this.hecToken.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.hecAcknowledgmentTimeoutInSeconds != null ? this.hecAcknowledgmentTimeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `SplunkRetryOptions` property type specifies retry behavior in case Kinesis Data Firehose is unable to deliver documents to Splunk or if it doesn't receive an acknowledgment from Splunk.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SplunkRetryOptionsProperty splunkRetryOptionsProperty = SplunkRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SplunkRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SplunkRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total amount of time that Kinesis Data Firehose spends on retries.
         * <p>
         * This duration starts after the initial attempt to send data to Splunk fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each attempt.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SplunkRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SplunkRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SplunkRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link SplunkRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds The total amount of time that Kinesis Data Firehose spends on retries.
             *                          This duration starts after the initial attempt to send data to Splunk fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each attempt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SplunkRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SplunkRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SplunkRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SplunkRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SplunkRetryOptionsProperty.Jsii$Proxy that = (SplunkRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the VPC of the Amazon ES destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * VpcConfigurationProperty vpcConfigurationProperty = VpcConfigurationProperty.builder()
     *         .roleArn("roleArn")
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role that you want the delivery stream to use to create endpoints in the destination VPC.
         * <p>
         * You can use your existing Kinesis Data Firehose delivery role or you can specify a new role. In either case, make sure that the role trusts the Kinesis Data Firehose service principal and that it grants the following permissions:
         * <p>
         * <ul>
         * <li><code>ec2:DescribeVpcs</code></li>
         * <li><code>ec2:DescribeVpcAttribute</code></li>
         * <li><code>ec2:DescribeSubnets</code></li>
         * <li><code>ec2:DescribeSecurityGroups</code></li>
         * <li><code>ec2:DescribeNetworkInterfaces</code></li>
         * <li><code>ec2:CreateNetworkInterface</code></li>
         * <li><code>ec2:CreateNetworkInterfacePermission</code></li>
         * <li><code>ec2:DeleteNetworkInterface</code></li>
         * </ul>
         * <p>
         * If you revoke these permissions after you create the delivery stream, Kinesis Data Firehose can't scale out by creating more ENIs when necessary. You might therefore see a degradation in performance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The IDs of the security groups that you want Kinesis Data Firehose to use when it creates ENIs in the VPC of the Amazon ES destination.
         * <p>
         * You can use the same security group that the Amazon ES domain uses or different ones. If you specify different security groups here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the security groups specified here. If you use the same security group for both your delivery stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES destination.
         * <p>
         * Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.
         * <p>
         * The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified here.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            java.lang.String roleArn;
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VpcConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that you want the delivery stream to use to create endpoints in the destination VPC. This parameter is required.
             *                You can use your existing Kinesis Data Firehose delivery role or you can specify a new role. In either case, make sure that the role trusts the Kinesis Data Firehose service principal and that it grants the following permissions:
             *                <p>
             *                <ul>
             *                <li><code>ec2:DescribeVpcs</code></li>
             *                <li><code>ec2:DescribeVpcAttribute</code></li>
             *                <li><code>ec2:DescribeSubnets</code></li>
             *                <li><code>ec2:DescribeSecurityGroups</code></li>
             *                <li><code>ec2:DescribeNetworkInterfaces</code></li>
             *                <li><code>ec2:CreateNetworkInterface</code></li>
             *                <li><code>ec2:CreateNetworkInterfacePermission</code></li>
             *                <li><code>ec2:DeleteNetworkInterface</code></li>
             *                </ul>
             *                <p>
             *                If you revoke these permissions after you create the delivery stream, Kinesis Data Firehose can't scale out by creating more ENIs when necessary. You might therefore see a degradation in performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds The IDs of the security groups that you want Kinesis Data Firehose to use when it creates ENIs in the VPC of the Amazon ES destination. This parameter is required.
             *                         You can use the same security group that the Amazon ES domain uses or different ones. If you specify different security groups here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the security groups specified here. If you use the same security group for both your delivery stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSubnetIds}
             * @param subnetIds The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES destination. This parameter is required.
             *                  Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.
             *                  <p>
             *                  The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigurationProperty {
            private final java.lang.String roleArn;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigurationProperty.Jsii$Proxy that = (VpcConfigurationProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.securityGroupIds.hashCode());
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStreamProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The destination in Amazon OpenSearch Service.
         * <p>
         * You can specify only one destination.
         * <p>
         * @return {@code this}
         * @param amazonopensearchserviceDestinationConfiguration The destination in Amazon OpenSearch Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonopensearchserviceDestinationConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty amazonopensearchserviceDestinationConfiguration) {
            this.props().amazonopensearchserviceDestinationConfiguration(amazonopensearchserviceDestinationConfiguration);
            return this;
        }
        /**
         * The destination in Amazon OpenSearch Service.
         * <p>
         * You can specify only one destination.
         * <p>
         * @return {@code this}
         * @param amazonopensearchserviceDestinationConfiguration The destination in Amazon OpenSearch Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonopensearchserviceDestinationConfiguration(final software.amazon.awscdk.IResolvable amazonopensearchserviceDestinationConfiguration) {
            this.props().amazonopensearchserviceDestinationConfiguration(amazonopensearchserviceDestinationConfiguration);
            return this;
        }

        /**
         * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
         * <p>
         * @return {@code this}
         * @param deliveryStreamEncryptionConfigurationInput Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamEncryptionConfigurationInput(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty deliveryStreamEncryptionConfigurationInput) {
            this.props().deliveryStreamEncryptionConfigurationInput(deliveryStreamEncryptionConfigurationInput);
            return this;
        }
        /**
         * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
         * <p>
         * @return {@code this}
         * @param deliveryStreamEncryptionConfigurationInput Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamEncryptionConfigurationInput(final software.amazon.awscdk.IResolvable deliveryStreamEncryptionConfigurationInput) {
            this.props().deliveryStreamEncryptionConfigurationInput(deliveryStreamEncryptionConfigurationInput);
            return this;
        }

        /**
         * The name of the delivery stream.
         * <p>
         * @return {@code this}
         * @param deliveryStreamName The name of the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamName(final java.lang.String deliveryStreamName) {
            this.props().deliveryStreamName(deliveryStreamName);
            return this;
        }

        /**
         * The delivery stream type. This can be one of the following values:.
         * <p>
         * <ul>
         * <li><code>DirectPut</code> : Provider applications access the delivery stream directly.</li>
         * <li><code>KinesisStreamAsSource</code> : The delivery stream uses a Kinesis data stream as a source.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param deliveryStreamType The delivery stream type. This can be one of the following values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamType(final java.lang.String deliveryStreamType) {
            this.props().deliveryStreamType(deliveryStreamType);
            return this;
        }

        /**
         * An Amazon ES destination for the delivery stream.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param elasticsearchDestinationConfiguration An Amazon ES destination for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchDestinationConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty elasticsearchDestinationConfiguration) {
            this.props().elasticsearchDestinationConfiguration(elasticsearchDestinationConfiguration);
            return this;
        }
        /**
         * An Amazon ES destination for the delivery stream.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param elasticsearchDestinationConfiguration An Amazon ES destination for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchDestinationConfiguration(final software.amazon.awscdk.IResolvable elasticsearchDestinationConfiguration) {
            this.props().elasticsearchDestinationConfiguration(elasticsearchDestinationConfiguration);
            return this;
        }

        /**
         * An Amazon S3 destination for the delivery stream.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param extendedS3DestinationConfiguration An Amazon S3 destination for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedS3DestinationConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfiguration) {
            this.props().extendedS3DestinationConfiguration(extendedS3DestinationConfiguration);
            return this;
        }
        /**
         * An Amazon S3 destination for the delivery stream.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param extendedS3DestinationConfiguration An Amazon S3 destination for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedS3DestinationConfiguration(final software.amazon.awscdk.IResolvable extendedS3DestinationConfiguration) {
            this.props().extendedS3DestinationConfiguration(extendedS3DestinationConfiguration);
            return this;
        }

        /**
         * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
         * <p>
         * You can specify only one destination.
         * <p>
         * @return {@code this}
         * @param httpEndpointDestinationConfiguration Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpointDestinationConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty httpEndpointDestinationConfiguration) {
            this.props().httpEndpointDestinationConfiguration(httpEndpointDestinationConfiguration);
            return this;
        }
        /**
         * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
         * <p>
         * You can specify only one destination.
         * <p>
         * @return {@code this}
         * @param httpEndpointDestinationConfiguration Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpointDestinationConfiguration(final software.amazon.awscdk.IResolvable httpEndpointDestinationConfiguration) {
            this.props().httpEndpointDestinationConfiguration(httpEndpointDestinationConfiguration);
            return this;
        }

        /**
         * When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
         * <p>
         * @return {@code this}
         * @param kinesisStreamSourceConfiguration When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSourceConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty kinesisStreamSourceConfiguration) {
            this.props().kinesisStreamSourceConfiguration(kinesisStreamSourceConfiguration);
            return this;
        }
        /**
         * When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
         * <p>
         * @return {@code this}
         * @param kinesisStreamSourceConfiguration When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSourceConfiguration(final software.amazon.awscdk.IResolvable kinesisStreamSourceConfiguration) {
            this.props().kinesisStreamSourceConfiguration(kinesisStreamSourceConfiguration);
            return this;
        }

        /**
         * An Amazon Redshift destination for the delivery stream.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param redshiftDestinationConfiguration An Amazon Redshift destination for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftDestinationConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty redshiftDestinationConfiguration) {
            this.props().redshiftDestinationConfiguration(redshiftDestinationConfiguration);
            return this;
        }
        /**
         * An Amazon Redshift destination for the delivery stream.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param redshiftDestinationConfiguration An Amazon Redshift destination for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftDestinationConfiguration(final software.amazon.awscdk.IResolvable redshiftDestinationConfiguration) {
            this.props().redshiftDestinationConfiguration(redshiftDestinationConfiguration);
            return this;
        }

        /**
         * The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param s3DestinationConfiguration The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DestinationConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3DestinationConfiguration) {
            this.props().s3DestinationConfiguration(s3DestinationConfiguration);
            return this;
        }
        /**
         * The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
         * <p>
         * Conditional. You must specify only one destination configuration.
         * <p>
         * If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * <p>
         * @return {@code this}
         * @param s3DestinationConfiguration The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DestinationConfiguration(final software.amazon.awscdk.IResolvable s3DestinationConfiguration) {
            this.props().s3DestinationConfiguration(s3DestinationConfiguration);
            return this;
        }

        /**
         * The configuration of a destination in Splunk for the delivery stream.
         * <p>
         * @return {@code this}
         * @param splunkDestinationConfiguration The configuration of a destination in Splunk for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splunkDestinationConfiguration(final software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty splunkDestinationConfiguration) {
            this.props().splunkDestinationConfiguration(splunkDestinationConfiguration);
            return this;
        }
        /**
         * The configuration of a destination in Splunk for the delivery stream.
         * <p>
         * @return {@code this}
         * @param splunkDestinationConfiguration The configuration of a destination in Splunk for the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splunkDestinationConfiguration(final software.amazon.awscdk.IResolvable splunkDestinationConfiguration) {
            this.props().splunkDestinationConfiguration(splunkDestinationConfiguration);
            return this;
        }

        /**
         * A set of tags to assign to the delivery stream.
         * <p>
         * A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
         * <p>
         * You can specify up to 50 tags when creating a delivery stream.
         * <p>
         * @return {@code this}
         * @param tags A set of tags to assign to the delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream build() {
            return new software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStreamProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStreamProps.Builder();
            }
            return this.props;
        }
    }
}
