package software.amazon.awscdk.services.kms;

/**
 * A principal to allow access to a key if it's being used through another AWS service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * IPrincipal principal;
 * ViaServicePrincipal viaServicePrincipal = new ViaServicePrincipal("serviceName", principal);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:56.390Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.ViaServicePrincipal")
public class ViaServicePrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected ViaServicePrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ViaServicePrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param serviceName This parameter is required.
     * @param basePrincipal
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ViaServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String serviceName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IPrincipal basePrincipal) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(serviceName, "serviceName is required"), basePrincipal });
    }

    /**
     * @param serviceName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ViaServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String serviceName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(serviceName, "serviceName is required") });
    }

    /**
     * Return whether or not this principal is equal to the given principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.Nullable java.lang.String dedupeString() {
        return software.amazon.jsii.Kernel.call(this, "dedupeString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }
}
