package software.amazon.awscdk.services.lambda;

/**
 * Non runtime options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.codeguruprofiler.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.sqs.*;
 * Architecture architecture;
 * CodeSigningConfig codeSigningConfig;
 * IDestination destination;
 * IEventSource eventSource;
 * FileSystem fileSystem;
 * Key key;
 * LambdaInsightsVersion lambdaInsightsVersion;
 * LayerVersion layerVersion;
 * PolicyStatement policyStatement;
 * ProfilingGroup profilingGroup;
 * Queue queue;
 * Role role;
 * SecurityGroup securityGroup;
 * Size size;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Topic topic;
 * Vpc vpc;
 * FunctionOptions functionOptions = FunctionOptions.builder()
 *         .allowAllOutbound(false)
 *         .allowPublicSubnet(false)
 *         .architecture(architecture)
 *         .codeSigningConfig(codeSigningConfig)
 *         .currentVersionOptions(VersionOptions.builder()
 *                 .codeSha256("codeSha256")
 *                 .description("description")
 *                 .maxEventAge(Duration.minutes(30))
 *                 .onFailure(destination)
 *                 .onSuccess(destination)
 *                 .provisionedConcurrentExecutions(123)
 *                 .removalPolicy(RemovalPolicy.DESTROY)
 *                 .retryAttempts(123)
 *                 .build())
 *         .deadLetterQueue(queue)
 *         .deadLetterQueueEnabled(false)
 *         .deadLetterTopic(topic)
 *         .description("description")
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .environmentEncryption(key)
 *         .ephemeralStorageSize(size)
 *         .events(List.of(eventSource))
 *         .filesystem(fileSystem)
 *         .functionName("functionName")
 *         .initialPolicy(List.of(policyStatement))
 *         .insightsVersion(lambdaInsightsVersion)
 *         .layers(List.of(layerVersion))
 *         .logRetention(RetentionDays.ONE_DAY)
 *         .logRetentionRetryOptions(LogRetentionRetryOptions.builder()
 *                 .base(Duration.minutes(30))
 *                 .maxRetries(123)
 *                 .build())
 *         .logRetentionRole(role)
 *         .maxEventAge(Duration.minutes(30))
 *         .memorySize(123)
 *         .onFailure(destination)
 *         .onSuccess(destination)
 *         .profiling(false)
 *         .profilingGroup(profilingGroup)
 *         .reservedConcurrentExecutions(123)
 *         .retryAttempts(123)
 *         .role(role)
 *         .securityGroups(List.of(securityGroup))
 *         .timeout(Duration.minutes(30))
 *         .tracing(Tracing.ACTIVE)
 *         .vpc(vpc)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:56.491Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.FunctionOptions")
@software.amazon.jsii.Jsii.Proxy(FunctionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.EventInvokeConfigOptions {

    /**
     * Whether to allow the Lambda to send all network traffic.
     * <p>
     * If set to false, you must individually add traffic rules to allow the
     * Lambda to connect to network targets.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * Lambda Functions in a public subnet can NOT access the internet.
     * <p>
     * Use this property to acknowledge this limitation and still place the function in a public subnet.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841">https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowPublicSubnet() {
        return null;
    }

    /**
     * The system architectures compatible with this lambda function.
     * <p>
     * Default: Architecture.X86_64
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Architecture getArchitecture() {
        return null;
    }

    /**
     * Code signing config associated with this function.
     * <p>
     * Default: - Not Sign the Code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ICodeSigningConfig getCodeSigningConfig() {
        return null;
    }

    /**
     * Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
     * <p>
     * Default: - default options as described in `VersionOptions`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.VersionOptions getCurrentVersionOptions() {
        return null;
    }

    /**
     * The SQS queue to use if DLQ is enabled.
     * <p>
     * If SNS topic is desired, specify <code>deadLetterTopic</code> property instead.
     * <p>
     * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * Enabled DLQ.
     * <p>
     * If <code>deadLetterQueue</code> is undefined,
     * an SQS queue with default options will be defined for your Function.
     * <p>
     * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeadLetterQueueEnabled() {
        return null;
    }

    /**
     * The SNS topic to use as a DLQ.
     * <p>
     * Note that if <code>deadLetterQueueEnabled</code> is set to <code>true</code>, an SQS queue will be created
     * rather than an SNS topic. Using an SNS topic as a DLQ requires this property to be set explicitly.
     * <p>
     * Default: - no SNS topic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getDeadLetterTopic() {
        return null;
    }

    /**
     * A description of the function.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Key-value pairs that Lambda caches and makes available for your Lambda functions.
     * <p>
     * Use environment variables to apply configuration changes, such
     * as test and production environment configurations, without changing your
     * Lambda function source code.
     * <p>
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The AWS KMS key that's used to encrypt your function's environment variables.
     * <p>
     * Default: - AWS Lambda creates and uses an AWS managed customer master key (CMK).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEnvironmentEncryption() {
        return null;
    }

    /**
     * The size of the function’s /tmp directory in MiB.
     * <p>
     * Default: 512 MiB
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getEphemeralStorageSize() {
        return null;
    }

    /**
     * Event sources for this function.
     * <p>
     * You can also add event sources using <code>addEventSource</code>.
     * <p>
     * Default: - No event sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
        return null;
    }

    /**
     * The filesystem configuration for the lambda function.
     * <p>
     * Default: - will not mount any filesystem
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FileSystem getFilesystem() {
        return null;
    }

    /**
     * A name for the function.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that
     * ID for the function's name. For more information, see Name Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return null;
    }

    /**
     * Initial policy statements to add to the created Lambda Role.
     * <p>
     * You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
     * <p>
     * Default: - No policy statements are added to the created Lambda role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
        return null;
    }

    /**
     * Specify the version of CloudWatch Lambda insights to use for monitoring.
     * <p>
     * Default: - No Lambda Insights
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-docker.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-docker.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.LambdaInsightsVersion getInsightsVersion() {
        return null;
    }

    /**
     * A list of layers to add to the function's execution environment.
     * <p>
     * You can configure your Lambda function to pull in
     * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
     * that can be used by multiple functions.
     * <p>
     * Default: - No layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * <p>
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>INFINITE</code>.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * When log retention is specified, a custom resource attempts to create the CloudWatch log group.
     * <p>
     * These options control the retry policy when interacting with CloudWatch APIs.
     * <p>
     * Default: - Default AWS SDK retry options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.LogRetentionRetryOptions getLogRetentionRetryOptions() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * <p>
     * Default: - A new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
        return null;
    }

    /**
     * The amount of memory, in MB, that is allocated to your Lambda function.
     * <p>
     * Lambda uses this value to proportionally allocate the amount of CPU
     * power. For more information, see Resource Model in the AWS Lambda
     * Developer Guide.
     * <p>
     * Default: 128
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
        return null;
    }

    /**
     * Enable profiling.
     * <p>
     * Default: - No profiling.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html">https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getProfiling() {
        return null;
    }

    /**
     * Profiling Group.
     * <p>
     * Default: - A new profiling group will be created if `profiling` is set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html">https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup getProfilingGroup() {
        return null;
    }

    /**
     * The maximum of concurrent executions you want to reserve for the function.
     * <p>
     * Default: - No specific limit - account limit.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReservedConcurrentExecutions() {
        return null;
    }

    /**
     * Lambda execution role.
     * <p>
     * This is the role that will be assumed by the function upon execution.
     * It controls the permissions that the function will have. The Role must
     * be assumable by the 'lambda.amazonaws.com' service principal.
     * <p>
     * The default Role automatically has permissions granted for Lambda execution. If you
     * provide a Role, you must add the relevant AWS managed policies yourself.
     * <p>
     * The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
     * "service-role/AWSLambdaVPCAccessExecutionRole".
     * <p>
     * Default: - A unique role will be generated for this lambda function.
     * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The list of security groups to associate with the Lambda's network interfaces.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - If the function is placed within a VPC and a security group is
     * not specified, either by this or securityGroup prop, a dedicated security
     * group will be created for this function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     * <p>
     * Because the execution time affects cost, set this value
     * based on the function's expected execution time.
     * <p>
     * Default: Duration.seconds(3)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * Enable AWS X-Ray Tracing for Lambda Function.
     * <p>
     * Default: Tracing.Disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Tracing getTracing() {
        return null;
    }

    /**
     * VPC network to place Lambda network interfaces.
     * <p>
     * Specify this if the Lambda function needs to access resources in a VPC.
     * This is required when <code>vpcSubnets</code> is specified.
     * <p>
     * Default: - Function is not placed within a VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Where to place the network interfaces within the VPC.
     * <p>
     * This requires <code>vpc</code> to be specified in order for interfaces to actually be
     * placed in the subnets. If <code>vpc</code> is not specify, this will raise an error.
     * <p>
     * Note: Internet access for Lambda Functions requires a NAT Gateway, so picking
     * public subnets is not allowed (unless <code>allowPublicSubnet</code> is set to <code>true</code>).
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionOptions> {
        java.lang.Boolean allowAllOutbound;
        java.lang.Boolean allowPublicSubnet;
        software.amazon.awscdk.services.lambda.Architecture architecture;
        software.amazon.awscdk.services.lambda.ICodeSigningConfig codeSigningConfig;
        software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        java.lang.Boolean deadLetterQueueEnabled;
        software.amazon.awscdk.services.sns.ITopic deadLetterTopic;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.services.kms.IKey environmentEncryption;
        software.amazon.awscdk.Size ephemeralStorageSize;
        java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        software.amazon.awscdk.services.lambda.FileSystem filesystem;
        java.lang.String functionName;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        software.amazon.awscdk.services.lambda.LambdaInsightsVersion insightsVersion;
        java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        software.amazon.awscdk.services.logs.RetentionDays logRetention;
        software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions;
        software.amazon.awscdk.services.iam.IRole logRetentionRole;
        java.lang.Number memorySize;
        java.lang.Boolean profiling;
        software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup profilingGroup;
        java.lang.Number reservedConcurrentExecutions;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.lambda.Tracing tracing;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        software.amazon.awscdk.Duration maxEventAge;
        software.amazon.awscdk.services.lambda.IDestination onFailure;
        software.amazon.awscdk.services.lambda.IDestination onSuccess;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link FunctionOptions#getAllowAllOutbound}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic.
         *                         If set to false, you must individually add traffic rules to allow the
         *                         Lambda to connect to network targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getAllowPublicSubnet}
         * @param allowPublicSubnet Lambda Functions in a public subnet can NOT access the internet.
         *                          Use this property to acknowledge this limitation and still place the function in a public subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowPublicSubnet(java.lang.Boolean allowPublicSubnet) {
            this.allowPublicSubnet = allowPublicSubnet;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getArchitecture}
         * @param architecture The system architectures compatible with this lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(software.amazon.awscdk.services.lambda.Architecture architecture) {
            this.architecture = architecture;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getCodeSigningConfig}
         * @param codeSigningConfig Code signing config associated with this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningConfig(software.amazon.awscdk.services.lambda.ICodeSigningConfig codeSigningConfig) {
            this.codeSigningConfig = codeSigningConfig;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getCurrentVersionOptions}
         * @param currentVersionOptions Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionOptions(software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions) {
            this.currentVersionOptions = currentVersionOptions;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled.
         *                        If SNS topic is desired, specify <code>deadLetterTopic</code> property instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getDeadLetterQueueEnabled}
         * @param deadLetterQueueEnabled Enabled DLQ.
         *                               If <code>deadLetterQueue</code> is undefined,
         *                               an SQS queue with default options will be defined for your Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(java.lang.Boolean deadLetterQueueEnabled) {
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getDeadLetterTopic}
         * @param deadLetterTopic The SNS topic to use as a DLQ.
         *                        Note that if <code>deadLetterQueueEnabled</code> is set to <code>true</code>, an SQS queue will be created
         *                        rather than an SNS topic. Using an SNS topic as a DLQ requires this property to be set explicitly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterTopic(software.amazon.awscdk.services.sns.ITopic deadLetterTopic) {
            this.deadLetterTopic = deadLetterTopic;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getDescription}
         * @param description A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getEnvironment}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions.
         *                    Use environment variables to apply configuration changes, such
         *                    as test and production environment configurations, without changing your
         *                    Lambda function source code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getEnvironmentEncryption}
         * @param environmentEncryption The AWS KMS key that's used to encrypt your function's environment variables.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentEncryption(software.amazon.awscdk.services.kms.IKey environmentEncryption) {
            this.environmentEncryption = environmentEncryption;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getEphemeralStorageSize}
         * @param ephemeralStorageSize The size of the function’s /tmp directory in MiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageSize(software.amazon.awscdk.Size ephemeralStorageSize) {
            this.ephemeralStorageSize = ephemeralStorageSize;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getEvents}
         * @param events Event sources for this function.
         *               You can also add event sources using <code>addEventSource</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder events(java.util.List<? extends software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.events = (java.util.List<software.amazon.awscdk.services.lambda.IEventSource>)events;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getFilesystem}
         * @param filesystem The filesystem configuration for the lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filesystem(software.amazon.awscdk.services.lambda.FileSystem filesystem) {
            this.filesystem = filesystem;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getFunctionName}
         * @param functionName A name for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getInitialPolicy}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role.
         *                      You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder initialPolicy(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.initialPolicy = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)initialPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getInsightsVersion}
         * @param insightsVersion Specify the version of CloudWatch Lambda insights to use for monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightsVersion(software.amazon.awscdk.services.lambda.LambdaInsightsVersion insightsVersion) {
            this.insightsVersion = insightsVersion;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLayers}
         * @param layers A list of layers to add to the function's execution environment.
         *               You can configure your Lambda function to pull in
         *               additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         *               that can be used by multiple functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder layers(java.util.List<? extends software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.layers = (java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion>)layers;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLogRetention}
         * @param logRetention The number of days log events are kept in CloudWatch Logs.
         *                     When updating
         *                     this property, unsetting it doesn't remove the log retention policy. To
         *                     remove the retention policy, set the value to <code>INFINITE</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLogRetentionRetryOptions}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         *                                 These options control the retry policy when interacting with CloudWatch APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.logRetentionRetryOptions = logRetentionRetryOptions;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLogRetentionRole}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.logRetentionRole = logRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getMemorySize}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function.
         *                   Lambda uses this value to proportionally allocate the amount of CPU
         *                   power. For more information, see Resource Model in the AWS Lambda
         *                   Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(java.lang.Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getProfiling}
         * @param profiling Enable profiling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profiling(java.lang.Boolean profiling) {
            this.profiling = profiling;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getProfilingGroup}
         * @param profilingGroup Profiling Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilingGroup(software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup profilingGroup) {
            this.profilingGroup = profilingGroup;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getReservedConcurrentExecutions}
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(java.lang.Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getRole}
         * @param role Lambda execution role.
         *             This is the role that will be assumed by the function upon execution.
         *             It controls the permissions that the function will have. The Role must
         *             be assumable by the 'lambda.amazonaws.com' service principal.
         *             <p>
         *             The default Role automatically has permissions granted for Lambda execution. If you
         *             provide a Role, you must add the relevant AWS managed policies yourself.
         *             <p>
         *             The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
         *             "service-role/AWSLambdaVPCAccessExecutionRole".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getSecurityGroups}
         * @param securityGroups The list of security groups to associate with the Lambda's network interfaces.
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getTimeout}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function.
         *                Because the execution time affects cost, set this value
         *                based on the function's expected execution time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getTracing}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.tracing = tracing;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getVpc}
         * @param vpc VPC network to place Lambda network interfaces.
         *            Specify this if the Lambda function needs to access resources in a VPC.
         *            This is required when <code>vpcSubnets</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getVpcSubnets}
         * @param vpcSubnets Where to place the network interfaces within the VPC.
         *                   This requires <code>vpc</code> to be specified in order for interfaces to actually be
         *                   placed in the subnets. If <code>vpc</code> is not specify, this will raise an error.
         *                   <p>
         *                   Note: Internet access for Lambda Functions requires a NAT Gateway, so picking
         *                   public subnets is not allowed (unless <code>allowPublicSubnet</code> is set to <code>true</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum: 60 seconds
         *                    Maximum: 6 hours
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getOnFailure}
         * @param onFailure The destination for failed invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getOnSuccess}
         * @param onSuccess The destination for successful invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum: 0
         *                      Maximum: 2
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionOptions {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean allowPublicSubnet;
        private final software.amazon.awscdk.services.lambda.Architecture architecture;
        private final software.amazon.awscdk.services.lambda.ICodeSigningConfig codeSigningConfig;
        private final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.lang.Boolean deadLetterQueueEnabled;
        private final software.amazon.awscdk.services.sns.ITopic deadLetterTopic;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.kms.IKey environmentEncryption;
        private final software.amazon.awscdk.Size ephemeralStorageSize;
        private final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        private final software.amazon.awscdk.services.lambda.FileSystem filesystem;
        private final java.lang.String functionName;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        private final software.amazon.awscdk.services.lambda.LambdaInsightsVersion insightsVersion;
        private final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions;
        private final software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private final java.lang.Number memorySize;
        private final java.lang.Boolean profiling;
        private final software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup profilingGroup;
        private final java.lang.Number reservedConcurrentExecutions;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.lambda.Tracing tracing;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final software.amazon.awscdk.services.lambda.IDestination onFailure;
        private final software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowPublicSubnet = software.amazon.jsii.Kernel.get(this, "allowPublicSubnet", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.architecture = software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class));
            this.codeSigningConfig = software.amazon.jsii.Kernel.get(this, "codeSigningConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ICodeSigningConfig.class));
            this.currentVersionOptions = software.amazon.jsii.Kernel.get(this, "currentVersionOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.VersionOptions.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.deadLetterQueueEnabled = software.amazon.jsii.Kernel.get(this, "deadLetterQueueEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deadLetterTopic = software.amazon.jsii.Kernel.get(this, "deadLetterTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environmentEncryption = software.amazon.jsii.Kernel.get(this, "environmentEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.ephemeralStorageSize = software.amazon.jsii.Kernel.get(this, "ephemeralStorageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSource.class)));
            this.filesystem = software.amazon.jsii.Kernel.get(this, "filesystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FileSystem.class));
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.initialPolicy = software.amazon.jsii.Kernel.get(this, "initialPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.insightsVersion = software.amazon.jsii.Kernel.get(this, "insightsVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class));
            this.layers = software.amazon.jsii.Kernel.get(this, "layers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class)));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.logRetentionRetryOptions = software.amazon.jsii.Kernel.get(this, "logRetentionRetryOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LogRetentionRetryOptions.class));
            this.logRetentionRole = software.amazon.jsii.Kernel.get(this, "logRetentionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.memorySize = software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.profiling = software.amazon.jsii.Kernel.get(this, "profiling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.profilingGroup = software.amazon.jsii.Kernel.get(this, "profilingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup.class));
            this.reservedConcurrentExecutions = software.amazon.jsii.Kernel.get(this, "reservedConcurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.tracing = software.amazon.jsii.Kernel.get(this, "tracing", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Tracing.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IDestination.class));
            this.onSuccess = software.amazon.jsii.Kernel.get(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IDestination.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = builder.allowAllOutbound;
            this.allowPublicSubnet = builder.allowPublicSubnet;
            this.architecture = builder.architecture;
            this.codeSigningConfig = builder.codeSigningConfig;
            this.currentVersionOptions = builder.currentVersionOptions;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.deadLetterQueueEnabled = builder.deadLetterQueueEnabled;
            this.deadLetterTopic = builder.deadLetterTopic;
            this.description = builder.description;
            this.environment = builder.environment;
            this.environmentEncryption = builder.environmentEncryption;
            this.ephemeralStorageSize = builder.ephemeralStorageSize;
            this.events = (java.util.List<software.amazon.awscdk.services.lambda.IEventSource>)builder.events;
            this.filesystem = builder.filesystem;
            this.functionName = builder.functionName;
            this.initialPolicy = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.initialPolicy;
            this.insightsVersion = builder.insightsVersion;
            this.layers = (java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion>)builder.layers;
            this.logRetention = builder.logRetention;
            this.logRetentionRetryOptions = builder.logRetentionRetryOptions;
            this.logRetentionRole = builder.logRetentionRole;
            this.memorySize = builder.memorySize;
            this.profiling = builder.profiling;
            this.profilingGroup = builder.profilingGroup;
            this.reservedConcurrentExecutions = builder.reservedConcurrentExecutions;
            this.role = builder.role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.timeout = builder.timeout;
            this.tracing = builder.tracing;
            this.vpc = builder.vpc;
            this.vpcSubnets = builder.vpcSubnets;
            this.maxEventAge = builder.maxEventAge;
            this.onFailure = builder.onFailure;
            this.onSuccess = builder.onSuccess;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.Boolean getAllowPublicSubnet() {
            return this.allowPublicSubnet;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Architecture getArchitecture() {
            return this.architecture;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ICodeSigningConfig getCodeSigningConfig() {
            return this.codeSigningConfig;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.VersionOptions getCurrentVersionOptions() {
            return this.currentVersionOptions;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final java.lang.Boolean getDeadLetterQueueEnabled() {
            return this.deadLetterQueueEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getDeadLetterTopic() {
            return this.deadLetterTopic;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEnvironmentEncryption() {
            return this.environmentEncryption;
        }

        @Override
        public final software.amazon.awscdk.Size getEphemeralStorageSize() {
            return this.ephemeralStorageSize;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
            return this.events;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FileSystem getFilesystem() {
            return this.filesystem;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
            return this.initialPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.LambdaInsightsVersion getInsightsVersion() {
            return this.insightsVersion;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
            return this.layers;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions getLogRetentionRetryOptions() {
            return this.logRetentionRetryOptions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
            return this.logRetentionRole;
        }

        @Override
        public final java.lang.Number getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final java.lang.Boolean getProfiling() {
            return this.profiling;
        }

        @Override
        public final software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup getProfilingGroup() {
            return this.profilingGroup;
        }

        @Override
        public final java.lang.Number getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Tracing getTracing() {
            return this.tracing;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAllowPublicSubnet() != null) {
                data.set("allowPublicSubnet", om.valueToTree(this.getAllowPublicSubnet()));
            }
            if (this.getArchitecture() != null) {
                data.set("architecture", om.valueToTree(this.getArchitecture()));
            }
            if (this.getCodeSigningConfig() != null) {
                data.set("codeSigningConfig", om.valueToTree(this.getCodeSigningConfig()));
            }
            if (this.getCurrentVersionOptions() != null) {
                data.set("currentVersionOptions", om.valueToTree(this.getCurrentVersionOptions()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getDeadLetterQueueEnabled() != null) {
                data.set("deadLetterQueueEnabled", om.valueToTree(this.getDeadLetterQueueEnabled()));
            }
            if (this.getDeadLetterTopic() != null) {
                data.set("deadLetterTopic", om.valueToTree(this.getDeadLetterTopic()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEnvironmentEncryption() != null) {
                data.set("environmentEncryption", om.valueToTree(this.getEnvironmentEncryption()));
            }
            if (this.getEphemeralStorageSize() != null) {
                data.set("ephemeralStorageSize", om.valueToTree(this.getEphemeralStorageSize()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getFilesystem() != null) {
                data.set("filesystem", om.valueToTree(this.getFilesystem()));
            }
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getInitialPolicy() != null) {
                data.set("initialPolicy", om.valueToTree(this.getInitialPolicy()));
            }
            if (this.getInsightsVersion() != null) {
                data.set("insightsVersion", om.valueToTree(this.getInsightsVersion()));
            }
            if (this.getLayers() != null) {
                data.set("layers", om.valueToTree(this.getLayers()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getLogRetentionRetryOptions() != null) {
                data.set("logRetentionRetryOptions", om.valueToTree(this.getLogRetentionRetryOptions()));
            }
            if (this.getLogRetentionRole() != null) {
                data.set("logRetentionRole", om.valueToTree(this.getLogRetentionRole()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getProfiling() != null) {
                data.set("profiling", om.valueToTree(this.getProfiling()));
            }
            if (this.getProfilingGroup() != null) {
                data.set("profilingGroup", om.valueToTree(this.getProfilingGroup()));
            }
            if (this.getReservedConcurrentExecutions() != null) {
                data.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTracing() != null) {
                data.set("tracing", om.valueToTree(this.getTracing()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.FunctionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionOptions.Jsii$Proxy that = (FunctionOptions.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.allowPublicSubnet != null ? !this.allowPublicSubnet.equals(that.allowPublicSubnet) : that.allowPublicSubnet != null) return false;
            if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) return false;
            if (this.codeSigningConfig != null ? !this.codeSigningConfig.equals(that.codeSigningConfig) : that.codeSigningConfig != null) return false;
            if (this.currentVersionOptions != null ? !this.currentVersionOptions.equals(that.currentVersionOptions) : that.currentVersionOptions != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.deadLetterQueueEnabled != null ? !this.deadLetterQueueEnabled.equals(that.deadLetterQueueEnabled) : that.deadLetterQueueEnabled != null) return false;
            if (this.deadLetterTopic != null ? !this.deadLetterTopic.equals(that.deadLetterTopic) : that.deadLetterTopic != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.environmentEncryption != null ? !this.environmentEncryption.equals(that.environmentEncryption) : that.environmentEncryption != null) return false;
            if (this.ephemeralStorageSize != null ? !this.ephemeralStorageSize.equals(that.ephemeralStorageSize) : that.ephemeralStorageSize != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.filesystem != null ? !this.filesystem.equals(that.filesystem) : that.filesystem != null) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.initialPolicy != null ? !this.initialPolicy.equals(that.initialPolicy) : that.initialPolicy != null) return false;
            if (this.insightsVersion != null ? !this.insightsVersion.equals(that.insightsVersion) : that.insightsVersion != null) return false;
            if (this.layers != null ? !this.layers.equals(that.layers) : that.layers != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.logRetentionRetryOptions != null ? !this.logRetentionRetryOptions.equals(that.logRetentionRetryOptions) : that.logRetentionRetryOptions != null) return false;
            if (this.logRetentionRole != null ? !this.logRetentionRole.equals(that.logRetentionRole) : that.logRetentionRole != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.profiling != null ? !this.profiling.equals(that.profiling) : that.profiling != null) return false;
            if (this.profilingGroup != null ? !this.profilingGroup.equals(that.profilingGroup) : that.profilingGroup != null) return false;
            if (this.reservedConcurrentExecutions != null ? !this.reservedConcurrentExecutions.equals(that.reservedConcurrentExecutions) : that.reservedConcurrentExecutions != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.tracing != null ? !this.tracing.equals(that.tracing) : that.tracing != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.allowPublicSubnet != null ? this.allowPublicSubnet.hashCode() : 0);
            result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
            result = 31 * result + (this.codeSigningConfig != null ? this.codeSigningConfig.hashCode() : 0);
            result = 31 * result + (this.currentVersionOptions != null ? this.currentVersionOptions.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueueEnabled != null ? this.deadLetterQueueEnabled.hashCode() : 0);
            result = 31 * result + (this.deadLetterTopic != null ? this.deadLetterTopic.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.environmentEncryption != null ? this.environmentEncryption.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorageSize != null ? this.ephemeralStorageSize.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.filesystem != null ? this.filesystem.hashCode() : 0);
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.initialPolicy != null ? this.initialPolicy.hashCode() : 0);
            result = 31 * result + (this.insightsVersion != null ? this.insightsVersion.hashCode() : 0);
            result = 31 * result + (this.layers != null ? this.layers.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.logRetentionRetryOptions != null ? this.logRetentionRetryOptions.hashCode() : 0);
            result = 31 * result + (this.logRetentionRole != null ? this.logRetentionRole.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.profiling != null ? this.profiling.hashCode() : 0);
            result = 31 * result + (this.profilingGroup != null ? this.profilingGroup.hashCode() : 0);
            result = 31 * result + (this.reservedConcurrentExecutions != null ? this.reservedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tracing != null ? this.tracing.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
