package software.amazon.awscdk.services.lambda;

/**
 * The type of authentication protocol or the VPC components for your event source's SourceAccessConfiguration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * SourceAccessConfigurationType sourceAccessConfigurationType = SourceAccessConfigurationType.BASIC_AUTH;
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_SourceAccessConfiguration.html#SSS-Type-SourceAccessConfiguration-Type">https://docs.aws.amazon.com/lambda/latest/dg/API_SourceAccessConfiguration.html#SSS-Type-SourceAccessConfiguration-Type</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:56.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.SourceAccessConfigurationType")
public class SourceAccessConfigurationType extends software.amazon.jsii.JsiiObject {

    protected SourceAccessConfigurationType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SourceAccessConfigurationType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        BASIC_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "BASIC_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class));
        CLIENT_CERTIFICATE_TLS_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "CLIENT_CERTIFICATE_TLS_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class));
        SASL_SCRAM_256_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "SASL_SCRAM_256_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class));
        SASL_SCRAM_512_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "SASL_SCRAM_512_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class));
        SERVER_ROOT_CA_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "SERVER_ROOT_CA_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class));
        VPC_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "VPC_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class));
        VPC_SUBNET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "VPC_SUBNET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class));
    }

    /**
     * A custom source access configuration property.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.SourceAccessConfigurationType of(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.SourceAccessConfigurationType.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (MQ) The Secrets Manager secret that stores your broker credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.SourceAccessConfigurationType BASIC_AUTH;

    /**
     * The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.SourceAccessConfigurationType CLIENT_CERTIFICATE_TLS_AUTH;

    /**
     * The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your Self-Managed Apache Kafka brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.SourceAccessConfigurationType SASL_SCRAM_256_AUTH;

    /**
     * The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your Self-Managed Apache Kafka brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.SourceAccessConfigurationType SASL_SCRAM_512_AUTH;

    /**
     * The Secrets Manager ARN of your secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.SourceAccessConfigurationType SERVER_ROOT_CA_CERTIFICATE;

    /**
     * The VPC security group used to manage access to your Self-Managed Apache Kafka brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.SourceAccessConfigurationType VPC_SECURITY_GROUP;

    /**
     * The subnets associated with your VPC.
     * <p>
     * Lambda connects to these subnets to fetch data from your Self-Managed Apache Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.SourceAccessConfigurationType VPC_SUBNET;

    /**
     * The key to use in `SourceAccessConfigurationProperty.Type` property in CloudFormation.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html#cfn-lambda-eventsourcemapping-sourceaccessconfiguration-type">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html#cfn-lambda-eventsourcemapping-sourceaccessconfiguration-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
