package software.amazon.awscdk.services.location;

/**
 * A CloudFormation `AWS::Location::RouteCalculator`.
 * <p>
 * The <code>AWS::Location::RouteCalculator</code> resource specifies a route calculator resource in your AWS account.
 * <p>
 * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnRouteCalculator cfnRouteCalculator = CfnRouteCalculator.Builder.create(this, "MyCfnRouteCalculator")
 *         .calculatorName("calculatorName")
 *         .dataSource("dataSource")
 *         // the properties below are optional
 *         .description("description")
 *         .pricingPlan("pricingPlan")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:56.716Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnRouteCalculator")
public class CfnRouteCalculator extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRouteCalculator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRouteCalculator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.location.CfnRouteCalculator.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Location::RouteCalculator`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRouteCalculator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.location.CfnRouteCalculatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for the route calculator resource.
     * <p>
     * Use the ARN when you specify a resource across all AWS .
     * <p>
     * <ul>
     * <li>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Synonym for `Arn` .
     * <p>
     * The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS .
     * <p>
     * <ul>
     * <li>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCalculatorArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCalculatorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the route calculator resource was created in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the route calculator resource was last updated in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the route calculator resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique route calculator resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleRouteCalculator</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCalculatorName() {
        return software.amazon.jsii.Kernel.get(this, "calculatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the route calculator resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique route calculator resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleRouteCalculator</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCalculatorName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "calculatorName", java.util.Objects.requireNonNull(value, "calculatorName is required"));
    }

    /**
     * Specifies the data provider of traffic and road network data.
     * <p>
     * <blockquote>
     * <p>
     * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.
     * <p>
     * </blockquote>
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>Esri</code></li>
     * <li><code>Here</code></li>
     * </ul>
     * <p>
     * For more information about data providers, see the <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers page</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataSource() {
        return software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the data provider of traffic and road network data.
     * <p>
     * <blockquote>
     * <p>
     * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.
     * <p>
     * </blockquote>
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>Esri</code></li>
     * <li><code>Here</code></li>
     * </ul>
     * <p>
     * For more information about data providers, see the <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers page</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSource(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataSource", java.util.Objects.requireNonNull(value, "dataSource is required"));
    }

    /**
     * The optional description for the route calculator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The optional description for the route calculator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage` .
     * <p>
     * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPricingPlan() {
        return software.amazon.jsii.Kernel.get(this, "pricingPlan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage` .
     * <p>
     * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPricingPlan(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pricingPlan", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.location.CfnRouteCalculator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.location.CfnRouteCalculator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.location.CfnRouteCalculatorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.location.CfnRouteCalculatorProps.Builder();
        }

        /**
         * The name of the route calculator resource.
         * <p>
         * Requirements:
         * <p>
         * <ul>
         * <li>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</li>
         * <li>Must be a unique route calculator resource name.</li>
         * <li>No spaces allowed. For example, <code>ExampleRouteCalculator</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param calculatorName The name of the route calculator resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder calculatorName(final java.lang.String calculatorName) {
            this.props.calculatorName(calculatorName);
            return this;
        }

        /**
         * Specifies the data provider of traffic and road network data.
         * <p>
         * <blockquote>
         * <p>
         * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.
         * <p>
         * </blockquote>
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><code>Esri</code></li>
         * <li><code>Here</code></li>
         * </ul>
         * <p>
         * For more information about data providers, see the <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers page</a> .
         * <p>
         * @return {@code this}
         * @param dataSource Specifies the data provider of traffic and road network data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(final java.lang.String dataSource) {
            this.props.dataSource(dataSource);
            return this;
        }

        /**
         * The optional description for the route calculator resource.
         * <p>
         * @return {@code this}
         * @param description The optional description for the route calculator resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * No longer used. If included, the only allowed value is `RequestBasedUsage` .
         * <p>
         * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
         * <p>
         * @return {@code this}
         * @param pricingPlan No longer used. If included, the only allowed value is `RequestBasedUsage` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricingPlan(final java.lang.String pricingPlan) {
            this.props.pricingPlan(pricingPlan);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.location.CfnRouteCalculator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.location.CfnRouteCalculator build() {
            return new software.amazon.awscdk.services.location.CfnRouteCalculator(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
