package software.amazon.awscdk.services.nimblestudio;

/**
 * A CloudFormation `AWS::NimbleStudio::LaunchProfile`.
 * <p>
 * The <code>AWS::NimbleStudio::LaunchProfile</code> resource represents access permissions for a set of studio components, including types of workstations, render farms, and shared file systems. Launch profiles are shared with studio users to give them access to the set of studio components.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.nimblestudio.*;
 * CfnLaunchProfile cfnLaunchProfile = CfnLaunchProfile.Builder.create(this, "MyCfnLaunchProfile")
 *         .ec2SubnetIds(List.of("ec2SubnetIds"))
 *         .launchProfileProtocolVersions(List.of("launchProfileProtocolVersions"))
 *         .name("name")
 *         .streamConfiguration(StreamConfigurationProperty.builder()
 *                 .clipboardMode("clipboardMode")
 *                 .ec2InstanceTypes(List.of("ec2InstanceTypes"))
 *                 .streamingImageIds(List.of("streamingImageIds"))
 *                 // the properties below are optional
 *                 .maxSessionLengthInMinutes(123)
 *                 .maxStoppedSessionLengthInMinutes(123)
 *                 .sessionStorage(StreamConfigurationSessionStorageProperty.builder()
 *                         .mode(List.of("mode"))
 *                         // the properties below are optional
 *                         .root(StreamingSessionStorageRootProperty.builder()
 *                                 .linux("linux")
 *                                 .windows("windows")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .studioComponentIds(List.of("studioComponentIds"))
 *         .studioId("studioId")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.083Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile")
public class CfnLaunchProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLaunchProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::NimbleStudio::LaunchProfile`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLaunchProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier for the launch profile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLaunchProfileId() {
        return software.amazon.jsii.Kernel.get(this, "attrLaunchProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Unique identifiers for a collection of EC2 subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEc2SubnetIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "ec2SubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Unique identifiers for a collection of EC2 subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2SubnetIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "ec2SubnetIds", java.util.Objects.requireNonNull(value, "ec2SubnetIds is required"));
    }

    /**
     * The version number of the protocol that is used by the launch profile.
     * <p>
     * The only valid version is "2021-03-31".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLaunchProfileProtocolVersions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "launchProfileProtocolVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The version number of the protocol that is used by the launch profile.
     * <p>
     * The only valid version is "2021-03-31".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchProfileProtocolVersions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "launchProfileProtocolVersions", java.util.Objects.requireNonNull(value, "launchProfileProtocolVersions is required"));
    }

    /**
     * A friendly name for the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly name for the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A configuration for a streaming session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStreamConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "streamConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A configuration for a streaming session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamConfiguration", java.util.Objects.requireNonNull(value, "streamConfiguration is required"));
    }

    /**
     * A configuration for a streaming session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamConfiguration", java.util.Objects.requireNonNull(value, "streamConfiguration is required"));
    }

    /**
     * Unique identifiers for a collection of studio components that can be used with this launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStudioComponentIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "studioComponentIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Unique identifiers for a collection of studio components that can be used with this launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStudioComponentIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "studioComponentIds", java.util.Objects.requireNonNull(value, "studioComponentIds is required"));
    }

    /**
     * The unique identifier for a studio resource.
     * <p>
     * In Nimble Studio , all other resources are contained in a studio resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStudioId() {
        return software.amazon.jsii.Kernel.get(this, "studioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for a studio resource.
     * <p>
     * In Nimble Studio , all other resources are contained in a studio resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStudioId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "studioId", java.util.Objects.requireNonNull(value, "studioId is required"));
    }

    /**
     * A human-readable description of the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A human-readable description of the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * A configuration for a streaming session.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * StreamConfigurationProperty streamConfigurationProperty = StreamConfigurationProperty.builder()
     *         .clipboardMode("clipboardMode")
     *         .ec2InstanceTypes(List.of("ec2InstanceTypes"))
     *         .streamingImageIds(List.of("streamingImageIds"))
     *         // the properties below are optional
     *         .maxSessionLengthInMinutes(123)
     *         .maxStoppedSessionLengthInMinutes(123)
     *         .sessionStorage(StreamConfigurationSessionStorageProperty.builder()
     *                 .mode(List.of("mode"))
     *                 // the properties below are optional
     *                 .root(StreamingSessionStorageRootProperty.builder()
     *                         .linux("linux")
     *                         .windows("windows")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enable or disable the use of the system clipboard to copy and paste between the streaming session and streaming client.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClipboardMode();

        /**
         * The EC2 instance types that users can select from when launching a streaming session with this launch profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEc2InstanceTypes();

        /**
         * The streaming images that users can select from when launching a streaming session with this launch profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStreamingImageIds();

        /**
         * The length of time, in minutes, that a streaming session can be active before it is stopped or terminated.
         * <p>
         * After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSessionLengthInMinutes() {
            return null;
        }

        /**
         * Integer that determines if you can start and stop your sessions and how long a session can stay in the STOPPED state.
         * <p>
         * The default value is 0. The maximum value is 5760.
         * <p>
         * If the value is missing or set to 0, your sessions can’t be stopped. If you then call <code>StopStreamingSession</code> , the session fails. If the time that a session stays in the READY state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be terminated (instead of stopped).
         * <p>
         * If the value is set to a positive number, the session can be stopped. You can call <code>StopStreamingSession</code> to stop sessions in the READY state. If the time that a session stays in the READY state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be stopped (instead of terminated).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxStoppedSessionLengthInMinutes() {
            return null;
        }

        /**
         * (Optional) The upload storage for a streaming session.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSessionStorage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamConfigurationProperty> {
            java.lang.String clipboardMode;
            java.util.List<java.lang.String> ec2InstanceTypes;
            java.util.List<java.lang.String> streamingImageIds;
            java.lang.Number maxSessionLengthInMinutes;
            java.lang.Number maxStoppedSessionLengthInMinutes;
            java.lang.Object sessionStorage;

            /**
             * Sets the value of {@link StreamConfigurationProperty#getClipboardMode}
             * @param clipboardMode Enable or disable the use of the system clipboard to copy and paste between the streaming session and streaming client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clipboardMode(java.lang.String clipboardMode) {
                this.clipboardMode = clipboardMode;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getEc2InstanceTypes}
             * @param ec2InstanceTypes The EC2 instance types that users can select from when launching a streaming session with this launch profile. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceTypes(java.util.List<java.lang.String> ec2InstanceTypes) {
                this.ec2InstanceTypes = ec2InstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getStreamingImageIds}
             * @param streamingImageIds The streaming images that users can select from when launching a streaming session with this launch profile. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamingImageIds(java.util.List<java.lang.String> streamingImageIds) {
                this.streamingImageIds = streamingImageIds;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getMaxSessionLengthInMinutes}
             * @param maxSessionLengthInMinutes The length of time, in minutes, that a streaming session can be active before it is stopped or terminated.
             *                                  After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSessionLengthInMinutes(java.lang.Number maxSessionLengthInMinutes) {
                this.maxSessionLengthInMinutes = maxSessionLengthInMinutes;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getMaxStoppedSessionLengthInMinutes}
             * @param maxStoppedSessionLengthInMinutes Integer that determines if you can start and stop your sessions and how long a session can stay in the STOPPED state.
             *                                         The default value is 0. The maximum value is 5760.
             *                                         <p>
             *                                         If the value is missing or set to 0, your sessions can’t be stopped. If you then call <code>StopStreamingSession</code> , the session fails. If the time that a session stays in the READY state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be terminated (instead of stopped).
             *                                         <p>
             *                                         If the value is set to a positive number, the session can be stopped. You can call <code>StopStreamingSession</code> to stop sessions in the READY state. If the time that a session stays in the READY state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be stopped (instead of terminated).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxStoppedSessionLengthInMinutes(java.lang.Number maxStoppedSessionLengthInMinutes) {
                this.maxStoppedSessionLengthInMinutes = maxStoppedSessionLengthInMinutes;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getSessionStorage}
             * @param sessionStorage (Optional) The upload storage for a streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStorage(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationSessionStorageProperty sessionStorage) {
                this.sessionStorage = sessionStorage;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getSessionStorage}
             * @param sessionStorage (Optional) The upload storage for a streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStorage(software.amazon.awscdk.IResolvable sessionStorage) {
                this.sessionStorage = sessionStorage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamConfigurationProperty {
            private final java.lang.String clipboardMode;
            private final java.util.List<java.lang.String> ec2InstanceTypes;
            private final java.util.List<java.lang.String> streamingImageIds;
            private final java.lang.Number maxSessionLengthInMinutes;
            private final java.lang.Number maxStoppedSessionLengthInMinutes;
            private final java.lang.Object sessionStorage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clipboardMode = software.amazon.jsii.Kernel.get(this, "clipboardMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2InstanceTypes = software.amazon.jsii.Kernel.get(this, "ec2InstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.streamingImageIds = software.amazon.jsii.Kernel.get(this, "streamingImageIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxSessionLengthInMinutes = software.amazon.jsii.Kernel.get(this, "maxSessionLengthInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxStoppedSessionLengthInMinutes = software.amazon.jsii.Kernel.get(this, "maxStoppedSessionLengthInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sessionStorage = software.amazon.jsii.Kernel.get(this, "sessionStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clipboardMode = java.util.Objects.requireNonNull(builder.clipboardMode, "clipboardMode is required");
                this.ec2InstanceTypes = java.util.Objects.requireNonNull(builder.ec2InstanceTypes, "ec2InstanceTypes is required");
                this.streamingImageIds = java.util.Objects.requireNonNull(builder.streamingImageIds, "streamingImageIds is required");
                this.maxSessionLengthInMinutes = builder.maxSessionLengthInMinutes;
                this.maxStoppedSessionLengthInMinutes = builder.maxStoppedSessionLengthInMinutes;
                this.sessionStorage = builder.sessionStorage;
            }

            @Override
            public final java.lang.String getClipboardMode() {
                return this.clipboardMode;
            }

            @Override
            public final java.util.List<java.lang.String> getEc2InstanceTypes() {
                return this.ec2InstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getStreamingImageIds() {
                return this.streamingImageIds;
            }

            @Override
            public final java.lang.Number getMaxSessionLengthInMinutes() {
                return this.maxSessionLengthInMinutes;
            }

            @Override
            public final java.lang.Number getMaxStoppedSessionLengthInMinutes() {
                return this.maxStoppedSessionLengthInMinutes;
            }

            @Override
            public final java.lang.Object getSessionStorage() {
                return this.sessionStorage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clipboardMode", om.valueToTree(this.getClipboardMode()));
                data.set("ec2InstanceTypes", om.valueToTree(this.getEc2InstanceTypes()));
                data.set("streamingImageIds", om.valueToTree(this.getStreamingImageIds()));
                if (this.getMaxSessionLengthInMinutes() != null) {
                    data.set("maxSessionLengthInMinutes", om.valueToTree(this.getMaxSessionLengthInMinutes()));
                }
                if (this.getMaxStoppedSessionLengthInMinutes() != null) {
                    data.set("maxStoppedSessionLengthInMinutes", om.valueToTree(this.getMaxStoppedSessionLengthInMinutes()));
                }
                if (this.getSessionStorage() != null) {
                    data.set("sessionStorage", om.valueToTree(this.getSessionStorage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamConfigurationProperty.Jsii$Proxy that = (StreamConfigurationProperty.Jsii$Proxy) o;

                if (!clipboardMode.equals(that.clipboardMode)) return false;
                if (!ec2InstanceTypes.equals(that.ec2InstanceTypes)) return false;
                if (!streamingImageIds.equals(that.streamingImageIds)) return false;
                if (this.maxSessionLengthInMinutes != null ? !this.maxSessionLengthInMinutes.equals(that.maxSessionLengthInMinutes) : that.maxSessionLengthInMinutes != null) return false;
                if (this.maxStoppedSessionLengthInMinutes != null ? !this.maxStoppedSessionLengthInMinutes.equals(that.maxStoppedSessionLengthInMinutes) : that.maxStoppedSessionLengthInMinutes != null) return false;
                return this.sessionStorage != null ? this.sessionStorage.equals(that.sessionStorage) : that.sessionStorage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clipboardMode.hashCode();
                result = 31 * result + (this.ec2InstanceTypes.hashCode());
                result = 31 * result + (this.streamingImageIds.hashCode());
                result = 31 * result + (this.maxSessionLengthInMinutes != null ? this.maxSessionLengthInMinutes.hashCode() : 0);
                result = 31 * result + (this.maxStoppedSessionLengthInMinutes != null ? this.maxStoppedSessionLengthInMinutes.hashCode() : 0);
                result = 31 * result + (this.sessionStorage != null ? this.sessionStorage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for a streaming session’s upload storage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * StreamConfigurationSessionStorageProperty streamConfigurationSessionStorageProperty = StreamConfigurationSessionStorageProperty.builder()
     *         .mode(List.of("mode"))
     *         // the properties below are optional
     *         .root(StreamingSessionStorageRootProperty.builder()
     *                 .linux("linux")
     *                 .windows("windows")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationSessionStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamConfigurationSessionStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamConfigurationSessionStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allows artists to upload files to their workstations.
         * <p>
         * The only valid option is <code>UPLOAD</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMode();

        /**
         * The configuration for the upload storage root of the streaming session.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoot() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamConfigurationSessionStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamConfigurationSessionStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamConfigurationSessionStorageProperty> {
            java.util.List<java.lang.String> mode;
            java.lang.Object root;

            /**
             * Sets the value of {@link StreamConfigurationSessionStorageProperty#getMode}
             * @param mode Allows artists to upload files to their workstations. This parameter is required.
             *             The only valid option is <code>UPLOAD</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.util.List<java.lang.String> mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationSessionStorageProperty#getRoot}
             * @param root The configuration for the upload storage root of the streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder root(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamingSessionStorageRootProperty root) {
                this.root = root;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationSessionStorageProperty#getRoot}
             * @param root The configuration for the upload storage root of the streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder root(software.amazon.awscdk.IResolvable root) {
                this.root = root;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamConfigurationSessionStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamConfigurationSessionStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamConfigurationSessionStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamConfigurationSessionStorageProperty {
            private final java.util.List<java.lang.String> mode;
            private final java.lang.Object root;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.root = software.amazon.jsii.Kernel.get(this, "root", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.root = builder.root;
            }

            @Override
            public final java.util.List<java.lang.String> getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Object getRoot() {
                return this.root;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                if (this.getRoot() != null) {
                    data.set("root", om.valueToTree(this.getRoot()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationSessionStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamConfigurationSessionStorageProperty.Jsii$Proxy that = (StreamConfigurationSessionStorageProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                return this.root != null ? this.root.equals(that.root) : that.root == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.root != null ? this.root.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The upload storage root location (folder) on streaming workstations where files are uploaded.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * StreamingSessionStorageRootProperty streamingSessionStorageRootProperty = StreamingSessionStorageRootProperty.builder()
     *         .linux("linux")
     *         .windows("windows")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamingSessionStorageRootProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamingSessionStorageRootProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamingSessionStorageRootProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The folder path in Linux workstations where files are uploaded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLinux() {
            return null;
        }

        /**
         * The folder path in Windows workstations where files are uploaded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWindows() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamingSessionStorageRootProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamingSessionStorageRootProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamingSessionStorageRootProperty> {
            java.lang.String linux;
            java.lang.String windows;

            /**
             * Sets the value of {@link StreamingSessionStorageRootProperty#getLinux}
             * @param linux The folder path in Linux workstations where files are uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linux(java.lang.String linux) {
                this.linux = linux;
                return this;
            }

            /**
             * Sets the value of {@link StreamingSessionStorageRootProperty#getWindows}
             * @param windows The folder path in Windows workstations where files are uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windows(java.lang.String windows) {
                this.windows = windows;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamingSessionStorageRootProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamingSessionStorageRootProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamingSessionStorageRootProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamingSessionStorageRootProperty {
            private final java.lang.String linux;
            private final java.lang.String windows;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.linux = software.amazon.jsii.Kernel.get(this, "linux", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.windows = software.amazon.jsii.Kernel.get(this, "windows", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.linux = builder.linux;
                this.windows = builder.windows;
            }

            @Override
            public final java.lang.String getLinux() {
                return this.linux;
            }

            @Override
            public final java.lang.String getWindows() {
                return this.windows;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLinux() != null) {
                    data.set("linux", om.valueToTree(this.getLinux()));
                }
                if (this.getWindows() != null) {
                    data.set("windows", om.valueToTree(this.getWindows()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamingSessionStorageRootProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamingSessionStorageRootProperty.Jsii$Proxy that = (StreamingSessionStorageRootProperty.Jsii$Proxy) o;

                if (this.linux != null ? !this.linux.equals(that.linux) : that.linux != null) return false;
                return this.windows != null ? this.windows.equals(that.windows) : that.windows == null;
            }

            @Override
            public final int hashCode() {
                int result = this.linux != null ? this.linux.hashCode() : 0;
                result = 31 * result + (this.windows != null ? this.windows.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps.Builder();
        }

        /**
         * Unique identifiers for a collection of EC2 subnets.
         * <p>
         * @return {@code this}
         * @param ec2SubnetIds Unique identifiers for a collection of EC2 subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SubnetIds(final java.util.List<java.lang.String> ec2SubnetIds) {
            this.props.ec2SubnetIds(ec2SubnetIds);
            return this;
        }

        /**
         * The version number of the protocol that is used by the launch profile.
         * <p>
         * The only valid version is "2021-03-31".
         * <p>
         * @return {@code this}
         * @param launchProfileProtocolVersions The version number of the protocol that is used by the launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchProfileProtocolVersions(final java.util.List<java.lang.String> launchProfileProtocolVersions) {
            this.props.launchProfileProtocolVersions(launchProfileProtocolVersions);
            return this;
        }

        /**
         * A friendly name for the launch profile.
         * <p>
         * @return {@code this}
         * @param name A friendly name for the launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A configuration for a streaming session.
         * <p>
         * @return {@code this}
         * @param streamConfiguration A configuration for a streaming session. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfiguration(final software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty streamConfiguration) {
            this.props.streamConfiguration(streamConfiguration);
            return this;
        }
        /**
         * A configuration for a streaming session.
         * <p>
         * @return {@code this}
         * @param streamConfiguration A configuration for a streaming session. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfiguration(final software.amazon.awscdk.IResolvable streamConfiguration) {
            this.props.streamConfiguration(streamConfiguration);
            return this;
        }

        /**
         * Unique identifiers for a collection of studio components that can be used with this launch profile.
         * <p>
         * @return {@code this}
         * @param studioComponentIds Unique identifiers for a collection of studio components that can be used with this launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioComponentIds(final java.util.List<java.lang.String> studioComponentIds) {
            this.props.studioComponentIds(studioComponentIds);
            return this;
        }

        /**
         * The unique identifier for a studio resource.
         * <p>
         * In Nimble Studio , all other resources are contained in a studio resource.
         * <p>
         * @return {@code this}
         * @param studioId The unique identifier for a studio resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioId(final java.lang.String studioId) {
            this.props.studioId(studioId);
            return this;
        }

        /**
         * A human-readable description of the launch profile.
         * <p>
         * @return {@code this}
         * @param description A human-readable description of the launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile build() {
            return new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
