package software.amazon.awscdk.services.opsworks;

/**
 * Properties for defining a `CfnApp`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * CfnAppProps cfnAppProps = CfnAppProps.builder()
 *         .name("name")
 *         .stackId("stackId")
 *         .type("type")
 *         // the properties below are optional
 *         .appSource(SourceProperty.builder()
 *                 .password("password")
 *                 .revision("revision")
 *                 .sshKey("sshKey")
 *                 .type("type")
 *                 .url("url")
 *                 .username("username")
 *                 .build())
 *         .attributes(Map.of(
 *                 "attributesKey", "attributes"))
 *         .dataSources(List.of(DataSourceProperty.builder()
 *                 .arn("arn")
 *                 .databaseName("databaseName")
 *                 .type("type")
 *                 .build()))
 *         .description("description")
 *         .domains(List.of("domains"))
 *         .enableSsl(false)
 *         .environment(List.of(EnvironmentVariableProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 // the properties below are optional
 *                 .secure(false)
 *                 .build()))
 *         .shortname("shortname")
 *         .sslConfiguration(SslConfigurationProperty.builder()
 *                 .certificate("certificate")
 *                 .chain("chain")
 *                 .privateKey("privateKey")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.127Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnAppProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The app name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The stack ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackId();

    /**
     * The app type.
     * <p>
     * Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify <code>other</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * A `Source` object that specifies the app repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAppSource() {
        return null;
    }

    /**
     * One or more user-defined key/value pairs to be added to the stack attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return null;
    }

    /**
     * The app's data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSources() {
        return null;
    }

    /**
     * A description of the app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The app virtual host settings, with multiple domains separated by commas.
     * <p>
     * For example: <code>'www.example.com, example.com'</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomains() {
        return null;
    }

    /**
     * Whether to enable SSL for the app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableSsl() {
        return null;
    }

    /**
     * An array of `EnvironmentVariable` objects that specify environment variables to be associated with the app.
     * <p>
     * After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment">Environment Variables</a> .
     * <p>
     * There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."
     * <p>
     * <blockquote>
     * <p>
     * If you have specified one or more environment variables, you cannot modify the stack's Chef version.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return null;
    }

    /**
     * The app's short name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getShortname() {
        return null;
    }

    /**
     * An `SslConfiguration` object with the SSL configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSslConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppProps> {
        java.lang.String name;
        java.lang.String stackId;
        java.lang.String type;
        java.lang.Object appSource;
        java.lang.Object attributes;
        java.lang.Object dataSources;
        java.lang.String description;
        java.util.List<java.lang.String> domains;
        java.lang.Object enableSsl;
        java.lang.Object environment;
        java.lang.String shortname;
        java.lang.Object sslConfiguration;

        /**
         * Sets the value of {@link CfnAppProps#getName}
         * @param name The app name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getStackId}
         * @param stackId The stack ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackId(java.lang.String stackId) {
            this.stackId = stackId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getType}
         * @param type The app type. This parameter is required.
         *             Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify <code>other</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAppSource}
         * @param appSource A `Source` object that specifies the app repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSource(software.amazon.awscdk.services.opsworks.CfnApp.SourceProperty appSource) {
            this.appSource = appSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAppSource}
         * @param appSource A `Source` object that specifies the app repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSource(software.amazon.awscdk.IResolvable appSource) {
            this.appSource = appSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAttributes}
         * @param attributes One or more user-defined key/value pairs to be added to the stack attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAttributes}
         * @param attributes One or more user-defined key/value pairs to be added to the stack attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getDataSources}
         * @param dataSources The app's data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(software.amazon.awscdk.IResolvable dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getDataSources}
         * @param dataSources The app's data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(java.util.List<? extends java.lang.Object> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getDescription}
         * @param description A description of the app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getDomains}
         * @param domains The app virtual host settings, with multiple domains separated by commas.
         *                For example: <code>'www.example.com, example.com'</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domains(java.util.List<java.lang.String> domains) {
            this.domains = domains;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnableSsl}
         * @param enableSsl Whether to enable SSL for the app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSsl(java.lang.Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnableSsl}
         * @param enableSsl Whether to enable SSL for the app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSsl(software.amazon.awscdk.IResolvable enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnvironment}
         * @param environment An array of `EnvironmentVariable` objects that specify environment variables to be associated with the app.
         *                    After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment">Environment Variables</a> .
         *                    <p>
         *                    There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    If you have specified one or more environment variables, you cannot modify the stack's Chef version.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(software.amazon.awscdk.IResolvable environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnvironment}
         * @param environment An array of `EnvironmentVariable` objects that specify environment variables to be associated with the app.
         *                    After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment">Environment Variables</a> .
         *                    <p>
         *                    There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    If you have specified one or more environment variables, you cannot modify the stack's Chef version.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.List<? extends java.lang.Object> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getShortname}
         * @param shortname The app's short name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortname(java.lang.String shortname) {
            this.shortname = shortname;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getSslConfiguration}
         * @param sslConfiguration An `SslConfiguration` object with the SSL configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslConfiguration(software.amazon.awscdk.services.opsworks.CfnApp.SslConfigurationProperty sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getSslConfiguration}
         * @param sslConfiguration An `SslConfiguration` object with the SSL configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslConfiguration(software.amazon.awscdk.IResolvable sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppProps {
        private final java.lang.String name;
        private final java.lang.String stackId;
        private final java.lang.String type;
        private final java.lang.Object appSource;
        private final java.lang.Object attributes;
        private final java.lang.Object dataSources;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> domains;
        private final java.lang.Object enableSsl;
        private final java.lang.Object environment;
        private final java.lang.String shortname;
        private final java.lang.Object sslConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackId = software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appSource = software.amazon.jsii.Kernel.get(this, "appSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSources = software.amazon.jsii.Kernel.get(this, "dataSources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domains = software.amazon.jsii.Kernel.get(this, "domains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enableSsl = software.amazon.jsii.Kernel.get(this, "enableSsl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.shortname = software.amazon.jsii.Kernel.get(this, "shortname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sslConfiguration = software.amazon.jsii.Kernel.get(this, "sslConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.stackId = java.util.Objects.requireNonNull(builder.stackId, "stackId is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.appSource = builder.appSource;
            this.attributes = builder.attributes;
            this.dataSources = builder.dataSources;
            this.description = builder.description;
            this.domains = builder.domains;
            this.enableSsl = builder.enableSsl;
            this.environment = builder.environment;
            this.shortname = builder.shortname;
            this.sslConfiguration = builder.sslConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getStackId() {
            return this.stackId;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAppSource() {
            return this.appSource;
        }

        @Override
        public final java.lang.Object getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.lang.Object getDataSources() {
            return this.dataSources;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getDomains() {
            return this.domains;
        }

        @Override
        public final java.lang.Object getEnableSsl() {
            return this.enableSsl;
        }

        @Override
        public final java.lang.Object getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getShortname() {
            return this.shortname;
        }

        @Override
        public final java.lang.Object getSslConfiguration() {
            return this.sslConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("stackId", om.valueToTree(this.getStackId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAppSource() != null) {
                data.set("appSource", om.valueToTree(this.getAppSource()));
            }
            if (this.getAttributes() != null) {
                data.set("attributes", om.valueToTree(this.getAttributes()));
            }
            if (this.getDataSources() != null) {
                data.set("dataSources", om.valueToTree(this.getDataSources()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDomains() != null) {
                data.set("domains", om.valueToTree(this.getDomains()));
            }
            if (this.getEnableSsl() != null) {
                data.set("enableSsl", om.valueToTree(this.getEnableSsl()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getShortname() != null) {
                data.set("shortname", om.valueToTree(this.getShortname()));
            }
            if (this.getSslConfiguration() != null) {
                data.set("sslConfiguration", om.valueToTree(this.getSslConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnAppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppProps.Jsii$Proxy that = (CfnAppProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!stackId.equals(that.stackId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.appSource != null ? !this.appSource.equals(that.appSource) : that.appSource != null) return false;
            if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
            if (this.dataSources != null ? !this.dataSources.equals(that.dataSources) : that.dataSources != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.domains != null ? !this.domains.equals(that.domains) : that.domains != null) return false;
            if (this.enableSsl != null ? !this.enableSsl.equals(that.enableSsl) : that.enableSsl != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.shortname != null ? !this.shortname.equals(that.shortname) : that.shortname != null) return false;
            return this.sslConfiguration != null ? this.sslConfiguration.equals(that.sslConfiguration) : that.sslConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.stackId.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.appSource != null ? this.appSource.hashCode() : 0);
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.dataSources != null ? this.dataSources.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.domains != null ? this.domains.hashCode() : 0);
            result = 31 * result + (this.enableSsl != null ? this.enableSsl.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.shortname != null ? this.shortname.hashCode() : 0);
            result = 31 * result + (this.sslConfiguration != null ? this.sslConfiguration.hashCode() : 0);
            return result;
        }
    }
}
