package software.amazon.awscdk.services.pinpoint;

/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 * <p>
 * Creates a message template that you can use to send in-app messages. A message template is a set of content and settings that you can define, save, and reuse in messages for any of your Amazon Pinpoint applications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object customConfig;
 * Object tags;
 * CfnInAppTemplate cfnInAppTemplate = CfnInAppTemplate.Builder.create(this, "MyCfnInAppTemplate")
 *         .templateName("templateName")
 *         // the properties below are optional
 *         .content(List.of(InAppMessageContentProperty.builder()
 *                 .backgroundColor("backgroundColor")
 *                 .bodyConfig(BodyConfigProperty.builder()
 *                         .alignment("alignment")
 *                         .body("body")
 *                         .textColor("textColor")
 *                         .build())
 *                 .headerConfig(HeaderConfigProperty.builder()
 *                         .alignment("alignment")
 *                         .header("header")
 *                         .textColor("textColor")
 *                         .build())
 *                 .imageUrl("imageUrl")
 *                 .primaryBtn(ButtonConfigProperty.builder()
 *                         .android(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                 .backgroundColor("backgroundColor")
 *                                 .borderRadius(123)
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .text("text")
 *                                 .textColor("textColor")
 *                                 .build())
 *                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .web(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .build())
 *                 .secondaryBtn(ButtonConfigProperty.builder()
 *                         .android(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                 .backgroundColor("backgroundColor")
 *                                 .borderRadius(123)
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .text("text")
 *                                 .textColor("textColor")
 *                                 .build())
 *                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .web(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .customConfig(customConfig)
 *         .layout("layout")
 *         .tags(tags)
 *         .templateDescription("templateDescription")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.233Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplate")
public class CfnInAppTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnInAppTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInAppTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Pinpoint::InAppTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInAppTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.CfnInAppTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCustomConfig() {
        return software.amazon.jsii.Kernel.get(this, "customConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "customConfig", java.util.Objects.requireNonNull(value, "customConfig is required"));
    }

    /**
     * The name of the in-app message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the in-app message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateName", java.util.Objects.requireNonNull(value, "templateName is required"));
    }

    /**
     * An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContent() {
        return software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContent(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "content", value);
    }

    /**
     * An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContent(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.InAppMessageContentProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.InAppMessageContentProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "content", value);
    }

    /**
     * A string that determines the appearance of the in-app message. You can specify one of the following:.
     * <p>
     * <ul>
     * <li><code>BOTTOM_BANNER</code> – a message that appears as a banner at the bottom of the page.</li>
     * <li><code>TOP_BANNER</code> – a message that appears as a banner at the top of the page.</li>
     * <li><code>OVERLAYS</code> – a message that covers entire screen.</li>
     * <li><code>MOBILE_FEED</code> – a message that appears in a window in front of the page.</li>
     * <li><code>MIDDLE_BANNER</code> – a message that appears as a banner in the middle of the page.</li>
     * <li><code>CAROUSEL</code> – a scrollable layout of up to five unique messages.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLayout() {
        return software.amazon.jsii.Kernel.get(this, "layout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string that determines the appearance of the in-app message. You can specify one of the following:.
     * <p>
     * <ul>
     * <li><code>BOTTOM_BANNER</code> – a message that appears as a banner at the bottom of the page.</li>
     * <li><code>TOP_BANNER</code> – a message that appears as a banner at the top of the page.</li>
     * <li><code>OVERLAYS</code> – a message that covers entire screen.</li>
     * <li><code>MOBILE_FEED</code> – a message that appears in a window in front of the page.</li>
     * <li><code>MIDDLE_BANNER</code> – a message that appears as a banner in the middle of the page.</li>
     * <li><code>CAROUSEL</code> – a scrollable layout of up to five unique messages.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLayout(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "layout", value);
    }

    /**
     * An optional description of the in-app template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateDescription() {
        return software.amazon.jsii.Kernel.get(this, "templateDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description of the in-app template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateDescription", value);
    }
    /**
     * Specifies the configuration of the main body text of the in-app message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * BodyConfigProperty bodyConfigProperty = BodyConfigProperty.builder()
     *         .alignment("alignment")
     *         .body("body")
     *         .textColor("textColor")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.BodyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BodyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BodyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text alignment of the main body text of the message.
         * <p>
         * Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * The main body text of the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The color of the body text, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextColor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BodyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BodyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BodyConfigProperty> {
            java.lang.String alignment;
            java.lang.String body;
            java.lang.String textColor;

            /**
             * Sets the value of {@link BodyConfigProperty#getAlignment}
             * @param alignment The text alignment of the main body text of the message.
             *                  Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link BodyConfigProperty#getBody}
             * @param body The main body text of the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link BodyConfigProperty#getTextColor}
             * @param textColor The color of the body text, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textColor(java.lang.String textColor) {
                this.textColor = textColor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BodyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BodyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BodyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BodyConfigProperty {
            private final java.lang.String alignment;
            private final java.lang.String body;
            private final java.lang.String textColor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textColor = software.amazon.jsii.Kernel.get(this, "textColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.body = builder.body;
                this.textColor = builder.textColor;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getTextColor() {
                return this.textColor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getTextColor() != null) {
                    data.set("textColor", om.valueToTree(this.getTextColor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.BodyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BodyConfigProperty.Jsii$Proxy that = (BodyConfigProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                return this.textColor != null ? this.textColor.equals(that.textColor) : that.textColor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the behavior of buttons that appear in an in-app message template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * ButtonConfigProperty buttonConfigProperty = ButtonConfigProperty.builder()
     *         .android(OverrideButtonConfigurationProperty.builder()
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .build())
     *         .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                 .backgroundColor("backgroundColor")
     *                 .borderRadius(123)
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .text("text")
     *                 .textColor("textColor")
     *                 .build())
     *         .ios(OverrideButtonConfigurationProperty.builder()
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .build())
     *         .web(OverrideButtonConfigurationProperty.builder()
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.ButtonConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ButtonConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ButtonConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Optional button configuration to use for in-app messages sent to Android devices.
         * <p>
         * This button configuration overrides the default button configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAndroid() {
            return null;
        }

        /**
         * Specifies the default behavior of a button that appears in an in-app message.
         * <p>
         * You can optionally add button configurations that specifically apply to iOS, Android, or web browser users.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultConfig() {
            return null;
        }

        /**
         * Optional button configuration to use for in-app messages sent to iOS devices.
         * <p>
         * This button configuration overrides the default button configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIos() {
            return null;
        }

        /**
         * Optional button configuration to use for in-app messages sent to web applications.
         * <p>
         * This button configuration overrides the default button configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWeb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ButtonConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ButtonConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ButtonConfigProperty> {
            java.lang.Object android;
            java.lang.Object defaultConfig;
            java.lang.Object ios;
            java.lang.Object web;

            /**
             * Sets the value of {@link ButtonConfigProperty#getAndroid}
             * @param android Optional button configuration to use for in-app messages sent to Android devices.
             *                This button configuration overrides the default button configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder android(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.OverrideButtonConfigurationProperty android) {
                this.android = android;
                return this;
            }

            /**
             * Sets the value of {@link ButtonConfigProperty#getAndroid}
             * @param android Optional button configuration to use for in-app messages sent to Android devices.
             *                This button configuration overrides the default button configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder android(software.amazon.awscdk.IResolvable android) {
                this.android = android;
                return this;
            }

            /**
             * Sets the value of {@link ButtonConfigProperty#getDefaultConfig}
             * @param defaultConfig Specifies the default behavior of a button that appears in an in-app message.
             *                      You can optionally add button configurations that specifically apply to iOS, Android, or web browser users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultConfig(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.DefaultButtonConfigurationProperty defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            /**
             * Sets the value of {@link ButtonConfigProperty#getDefaultConfig}
             * @param defaultConfig Specifies the default behavior of a button that appears in an in-app message.
             *                      You can optionally add button configurations that specifically apply to iOS, Android, or web browser users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultConfig(software.amazon.awscdk.IResolvable defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            /**
             * Sets the value of {@link ButtonConfigProperty#getIos}
             * @param ios Optional button configuration to use for in-app messages sent to iOS devices.
             *            This button configuration overrides the default button configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ios(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.OverrideButtonConfigurationProperty ios) {
                this.ios = ios;
                return this;
            }

            /**
             * Sets the value of {@link ButtonConfigProperty#getIos}
             * @param ios Optional button configuration to use for in-app messages sent to iOS devices.
             *            This button configuration overrides the default button configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ios(software.amazon.awscdk.IResolvable ios) {
                this.ios = ios;
                return this;
            }

            /**
             * Sets the value of {@link ButtonConfigProperty#getWeb}
             * @param web Optional button configuration to use for in-app messages sent to web applications.
             *            This button configuration overrides the default button configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder web(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.OverrideButtonConfigurationProperty web) {
                this.web = web;
                return this;
            }

            /**
             * Sets the value of {@link ButtonConfigProperty#getWeb}
             * @param web Optional button configuration to use for in-app messages sent to web applications.
             *            This button configuration overrides the default button configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder web(software.amazon.awscdk.IResolvable web) {
                this.web = web;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ButtonConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ButtonConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ButtonConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ButtonConfigProperty {
            private final java.lang.Object android;
            private final java.lang.Object defaultConfig;
            private final java.lang.Object ios;
            private final java.lang.Object web;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.android = software.amazon.jsii.Kernel.get(this, "android", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultConfig = software.amazon.jsii.Kernel.get(this, "defaultConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ios = software.amazon.jsii.Kernel.get(this, "ios", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.web = software.amazon.jsii.Kernel.get(this, "web", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.android = builder.android;
                this.defaultConfig = builder.defaultConfig;
                this.ios = builder.ios;
                this.web = builder.web;
            }

            @Override
            public final java.lang.Object getAndroid() {
                return this.android;
            }

            @Override
            public final java.lang.Object getDefaultConfig() {
                return this.defaultConfig;
            }

            @Override
            public final java.lang.Object getIos() {
                return this.ios;
            }

            @Override
            public final java.lang.Object getWeb() {
                return this.web;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAndroid() != null) {
                    data.set("android", om.valueToTree(this.getAndroid()));
                }
                if (this.getDefaultConfig() != null) {
                    data.set("defaultConfig", om.valueToTree(this.getDefaultConfig()));
                }
                if (this.getIos() != null) {
                    data.set("ios", om.valueToTree(this.getIos()));
                }
                if (this.getWeb() != null) {
                    data.set("web", om.valueToTree(this.getWeb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.ButtonConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ButtonConfigProperty.Jsii$Proxy that = (ButtonConfigProperty.Jsii$Proxy) o;

                if (this.android != null ? !this.android.equals(that.android) : that.android != null) return false;
                if (this.defaultConfig != null ? !this.defaultConfig.equals(that.defaultConfig) : that.defaultConfig != null) return false;
                if (this.ios != null ? !this.ios.equals(that.ios) : that.ios != null) return false;
                return this.web != null ? this.web.equals(that.web) : that.web == null;
            }

            @Override
            public final int hashCode() {
                int result = this.android != null ? this.android.hashCode() : 0;
                result = 31 * result + (this.defaultConfig != null ? this.defaultConfig.hashCode() : 0);
                result = 31 * result + (this.ios != null ? this.ios.hashCode() : 0);
                result = 31 * result + (this.web != null ? this.web.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default behavior of a button that appears in an in-app message.
     * <p>
     * You can optionally add button configurations that specifically apply to iOS, Android, or web browser users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * DefaultButtonConfigurationProperty defaultButtonConfigurationProperty = DefaultButtonConfigurationProperty.builder()
     *         .backgroundColor("backgroundColor")
     *         .borderRadius(123)
     *         .buttonAction("buttonAction")
     *         .link("link")
     *         .text("text")
     *         .textColor("textColor")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.DefaultButtonConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultButtonConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultButtonConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The background color of a button, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * The border radius of a button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBorderRadius() {
            return null;
        }

        /**
         * The action that occurs when a recipient chooses a button in an in-app message.
         * <p>
         * You can specify one of the following:
         * <p>
         * <ul>
         * <li><code>LINK</code> – A link to a web destination.</li>
         * <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
         * <li><code>CLOSE</code> – Dismisses the message.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getButtonAction() {
            return null;
        }

        /**
         * The destination (such as a URL) for a button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLink() {
            return null;
        }

        /**
         * The text that appears on a button in an in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * The color of the body text in a button, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextColor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultButtonConfigurationProperty> {
            java.lang.String backgroundColor;
            java.lang.Number borderRadius;
            java.lang.String buttonAction;
            java.lang.String link;
            java.lang.String text;
            java.lang.String textColor;

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getBackgroundColor}
             * @param backgroundColor The background color of a button, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getBorderRadius}
             * @param borderRadius The border radius of a button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder borderRadius(java.lang.Number borderRadius) {
                this.borderRadius = borderRadius;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getButtonAction}
             * @param buttonAction The action that occurs when a recipient chooses a button in an in-app message.
             *                     You can specify one of the following:
             *                     <p>
             *                     <ul>
             *                     <li><code>LINK</code> – A link to a web destination.</li>
             *                     <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
             *                     <li><code>CLOSE</code> – Dismisses the message.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttonAction(java.lang.String buttonAction) {
                this.buttonAction = buttonAction;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getLink}
             * @param link The destination (such as a URL) for a button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder link(java.lang.String link) {
                this.link = link;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getText}
             * @param text The text that appears on a button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getTextColor}
             * @param textColor The color of the body text in a button, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textColor(java.lang.String textColor) {
                this.textColor = textColor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultButtonConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultButtonConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultButtonConfigurationProperty {
            private final java.lang.String backgroundColor;
            private final java.lang.Number borderRadius;
            private final java.lang.String buttonAction;
            private final java.lang.String link;
            private final java.lang.String text;
            private final java.lang.String textColor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.borderRadius = software.amazon.jsii.Kernel.get(this, "borderRadius", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.buttonAction = software.amazon.jsii.Kernel.get(this, "buttonAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.link = software.amazon.jsii.Kernel.get(this, "link", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textColor = software.amazon.jsii.Kernel.get(this, "textColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backgroundColor = builder.backgroundColor;
                this.borderRadius = builder.borderRadius;
                this.buttonAction = builder.buttonAction;
                this.link = builder.link;
                this.text = builder.text;
                this.textColor = builder.textColor;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Number getBorderRadius() {
                return this.borderRadius;
            }

            @Override
            public final java.lang.String getButtonAction() {
                return this.buttonAction;
            }

            @Override
            public final java.lang.String getLink() {
                return this.link;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.String getTextColor() {
                return this.textColor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBorderRadius() != null) {
                    data.set("borderRadius", om.valueToTree(this.getBorderRadius()));
                }
                if (this.getButtonAction() != null) {
                    data.set("buttonAction", om.valueToTree(this.getButtonAction()));
                }
                if (this.getLink() != null) {
                    data.set("link", om.valueToTree(this.getLink()));
                }
                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }
                if (this.getTextColor() != null) {
                    data.set("textColor", om.valueToTree(this.getTextColor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.DefaultButtonConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultButtonConfigurationProperty.Jsii$Proxy that = (DefaultButtonConfigurationProperty.Jsii$Proxy) o;

                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.borderRadius != null ? !this.borderRadius.equals(that.borderRadius) : that.borderRadius != null) return false;
                if (this.buttonAction != null ? !this.buttonAction.equals(that.buttonAction) : that.buttonAction != null) return false;
                if (this.link != null ? !this.link.equals(that.link) : that.link != null) return false;
                if (this.text != null ? !this.text.equals(that.text) : that.text != null) return false;
                return this.textColor != null ? this.textColor.equals(that.textColor) : that.textColor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.backgroundColor != null ? this.backgroundColor.hashCode() : 0;
                result = 31 * result + (this.borderRadius != null ? this.borderRadius.hashCode() : 0);
                result = 31 * result + (this.buttonAction != null ? this.buttonAction.hashCode() : 0);
                result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
                result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
                result = 31 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration and content of the header or title text of the in-app message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * HeaderConfigProperty headerConfigProperty = HeaderConfigProperty.builder()
     *         .alignment("alignment")
     *         .header("header")
     *         .textColor("textColor")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.HeaderConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HeaderConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text alignment of the title of the message.
         * <p>
         * Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * The title text of the in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHeader() {
            return null;
        }

        /**
         * The color of the title text, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextColor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeaderConfigProperty> {
            java.lang.String alignment;
            java.lang.String header;
            java.lang.String textColor;

            /**
             * Sets the value of {@link HeaderConfigProperty#getAlignment}
             * @param alignment The text alignment of the title of the message.
             *                  Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link HeaderConfigProperty#getHeader}
             * @param header The title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.String header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link HeaderConfigProperty#getTextColor}
             * @param textColor The color of the title text, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textColor(java.lang.String textColor) {
                this.textColor = textColor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeaderConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeaderConfigProperty {
            private final java.lang.String alignment;
            private final java.lang.String header;
            private final java.lang.String textColor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textColor = software.amazon.jsii.Kernel.get(this, "textColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.header = builder.header;
                this.textColor = builder.textColor;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.String getTextColor() {
                return this.textColor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getHeader() != null) {
                    data.set("header", om.valueToTree(this.getHeader()));
                }
                if (this.getTextColor() != null) {
                    data.set("textColor", om.valueToTree(this.getTextColor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.HeaderConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeaderConfigProperty.Jsii$Proxy that = (HeaderConfigProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.header != null ? !this.header.equals(that.header) : that.header != null) return false;
                return this.textColor != null ? this.textColor.equals(that.textColor) : that.textColor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.header != null ? this.header.hashCode() : 0);
                result = 31 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of an in-app message, including its header, body, buttons, colors, and images.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * InAppMessageContentProperty inAppMessageContentProperty = InAppMessageContentProperty.builder()
     *         .backgroundColor("backgroundColor")
     *         .bodyConfig(BodyConfigProperty.builder()
     *                 .alignment("alignment")
     *                 .body("body")
     *                 .textColor("textColor")
     *                 .build())
     *         .headerConfig(HeaderConfigProperty.builder()
     *                 .alignment("alignment")
     *                 .header("header")
     *                 .textColor("textColor")
     *                 .build())
     *         .imageUrl("imageUrl")
     *         .primaryBtn(ButtonConfigProperty.builder()
     *                 .android(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                         .backgroundColor("backgroundColor")
     *                         .borderRadius(123)
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .text("text")
     *                         .textColor("textColor")
     *                         .build())
     *                 .ios(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .web(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .build())
     *         .secondaryBtn(ButtonConfigProperty.builder()
     *                 .android(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                         .backgroundColor("backgroundColor")
     *                         .borderRadius(123)
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .text("text")
     *                         .textColor("textColor")
     *                         .build())
     *                 .ios(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .web(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.InAppMessageContentProperty")
    @software.amazon.jsii.Jsii.Proxy(InAppMessageContentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InAppMessageContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The background color for an in-app message banner, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * An object that contains configuration information about the header or title text of the in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBodyConfig() {
            return null;
        }

        /**
         * An object that contains configuration information about the header or title text of the in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderConfig() {
            return null;
        }

        /**
         * The URL of the image that appears on an in-app message banner.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageUrl() {
            return null;
        }

        /**
         * An object that contains configuration information about the primary button in an in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryBtn() {
            return null;
        }

        /**
         * An object that contains configuration information about the secondary button in an in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecondaryBtn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InAppMessageContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InAppMessageContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InAppMessageContentProperty> {
            java.lang.String backgroundColor;
            java.lang.Object bodyConfig;
            java.lang.Object headerConfig;
            java.lang.String imageUrl;
            java.lang.Object primaryBtn;
            java.lang.Object secondaryBtn;

            /**
             * Sets the value of {@link InAppMessageContentProperty#getBackgroundColor}
             * @param backgroundColor The background color for an in-app message banner, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getBodyConfig}
             * @param bodyConfig An object that contains configuration information about the header or title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bodyConfig(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.BodyConfigProperty bodyConfig) {
                this.bodyConfig = bodyConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getBodyConfig}
             * @param bodyConfig An object that contains configuration information about the header or title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bodyConfig(software.amazon.awscdk.IResolvable bodyConfig) {
                this.bodyConfig = bodyConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getHeaderConfig}
             * @param headerConfig An object that contains configuration information about the header or title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerConfig(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.HeaderConfigProperty headerConfig) {
                this.headerConfig = headerConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getHeaderConfig}
             * @param headerConfig An object that contains configuration information about the header or title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerConfig(software.amazon.awscdk.IResolvable headerConfig) {
                this.headerConfig = headerConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getImageUrl}
             * @param imageUrl The URL of the image that appears on an in-app message banner.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUrl(java.lang.String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getPrimaryBtn}
             * @param primaryBtn An object that contains configuration information about the primary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryBtn(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.ButtonConfigProperty primaryBtn) {
                this.primaryBtn = primaryBtn;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getPrimaryBtn}
             * @param primaryBtn An object that contains configuration information about the primary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryBtn(software.amazon.awscdk.IResolvable primaryBtn) {
                this.primaryBtn = primaryBtn;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getSecondaryBtn}
             * @param secondaryBtn An object that contains configuration information about the secondary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryBtn(software.amazon.awscdk.services.pinpoint.CfnInAppTemplate.ButtonConfigProperty secondaryBtn) {
                this.secondaryBtn = secondaryBtn;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getSecondaryBtn}
             * @param secondaryBtn An object that contains configuration information about the secondary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryBtn(software.amazon.awscdk.IResolvable secondaryBtn) {
                this.secondaryBtn = secondaryBtn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InAppMessageContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InAppMessageContentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InAppMessageContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InAppMessageContentProperty {
            private final java.lang.String backgroundColor;
            private final java.lang.Object bodyConfig;
            private final java.lang.Object headerConfig;
            private final java.lang.String imageUrl;
            private final java.lang.Object primaryBtn;
            private final java.lang.Object secondaryBtn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bodyConfig = software.amazon.jsii.Kernel.get(this, "bodyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headerConfig = software.amazon.jsii.Kernel.get(this, "headerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageUrl = software.amazon.jsii.Kernel.get(this, "imageUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryBtn = software.amazon.jsii.Kernel.get(this, "primaryBtn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryBtn = software.amazon.jsii.Kernel.get(this, "secondaryBtn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backgroundColor = builder.backgroundColor;
                this.bodyConfig = builder.bodyConfig;
                this.headerConfig = builder.headerConfig;
                this.imageUrl = builder.imageUrl;
                this.primaryBtn = builder.primaryBtn;
                this.secondaryBtn = builder.secondaryBtn;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Object getBodyConfig() {
                return this.bodyConfig;
            }

            @Override
            public final java.lang.Object getHeaderConfig() {
                return this.headerConfig;
            }

            @Override
            public final java.lang.String getImageUrl() {
                return this.imageUrl;
            }

            @Override
            public final java.lang.Object getPrimaryBtn() {
                return this.primaryBtn;
            }

            @Override
            public final java.lang.Object getSecondaryBtn() {
                return this.secondaryBtn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBodyConfig() != null) {
                    data.set("bodyConfig", om.valueToTree(this.getBodyConfig()));
                }
                if (this.getHeaderConfig() != null) {
                    data.set("headerConfig", om.valueToTree(this.getHeaderConfig()));
                }
                if (this.getImageUrl() != null) {
                    data.set("imageUrl", om.valueToTree(this.getImageUrl()));
                }
                if (this.getPrimaryBtn() != null) {
                    data.set("primaryBtn", om.valueToTree(this.getPrimaryBtn()));
                }
                if (this.getSecondaryBtn() != null) {
                    data.set("secondaryBtn", om.valueToTree(this.getSecondaryBtn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.InAppMessageContentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InAppMessageContentProperty.Jsii$Proxy that = (InAppMessageContentProperty.Jsii$Proxy) o;

                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.bodyConfig != null ? !this.bodyConfig.equals(that.bodyConfig) : that.bodyConfig != null) return false;
                if (this.headerConfig != null ? !this.headerConfig.equals(that.headerConfig) : that.headerConfig != null) return false;
                if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) return false;
                if (this.primaryBtn != null ? !this.primaryBtn.equals(that.primaryBtn) : that.primaryBtn != null) return false;
                return this.secondaryBtn != null ? this.secondaryBtn.equals(that.secondaryBtn) : that.secondaryBtn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.backgroundColor != null ? this.backgroundColor.hashCode() : 0;
                result = 31 * result + (this.bodyConfig != null ? this.bodyConfig.hashCode() : 0);
                result = 31 * result + (this.headerConfig != null ? this.headerConfig.hashCode() : 0);
                result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
                result = 31 * result + (this.primaryBtn != null ? this.primaryBtn.hashCode() : 0);
                result = 31 * result + (this.secondaryBtn != null ? this.secondaryBtn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a button with settings that are specific to a certain device type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * OverrideButtonConfigurationProperty overrideButtonConfigurationProperty = OverrideButtonConfigurationProperty.builder()
     *         .buttonAction("buttonAction")
     *         .link("link")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.OverrideButtonConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideButtonConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideButtonConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that occurs when a recipient chooses a button in an in-app message.
         * <p>
         * You can specify one of the following:
         * <p>
         * <ul>
         * <li><code>LINK</code> – A link to a web destination.</li>
         * <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
         * <li><code>CLOSE</code> – Dismisses the message.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getButtonAction() {
            return null;
        }

        /**
         * The destination (such as a URL) for a button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLink() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideButtonConfigurationProperty> {
            java.lang.String buttonAction;
            java.lang.String link;

            /**
             * Sets the value of {@link OverrideButtonConfigurationProperty#getButtonAction}
             * @param buttonAction The action that occurs when a recipient chooses a button in an in-app message.
             *                     You can specify one of the following:
             *                     <p>
             *                     <ul>
             *                     <li><code>LINK</code> – A link to a web destination.</li>
             *                     <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
             *                     <li><code>CLOSE</code> – Dismisses the message.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttonAction(java.lang.String buttonAction) {
                this.buttonAction = buttonAction;
                return this;
            }

            /**
             * Sets the value of {@link OverrideButtonConfigurationProperty#getLink}
             * @param link The destination (such as a URL) for a button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder link(java.lang.String link) {
                this.link = link;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideButtonConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideButtonConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideButtonConfigurationProperty {
            private final java.lang.String buttonAction;
            private final java.lang.String link;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.buttonAction = software.amazon.jsii.Kernel.get(this, "buttonAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.link = software.amazon.jsii.Kernel.get(this, "link", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.buttonAction = builder.buttonAction;
                this.link = builder.link;
            }

            @Override
            public final java.lang.String getButtonAction() {
                return this.buttonAction;
            }

            @Override
            public final java.lang.String getLink() {
                return this.link;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getButtonAction() != null) {
                    data.set("buttonAction", om.valueToTree(this.getButtonAction()));
                }
                if (this.getLink() != null) {
                    data.set("link", om.valueToTree(this.getLink()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnInAppTemplate.OverrideButtonConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideButtonConfigurationProperty.Jsii$Proxy that = (OverrideButtonConfigurationProperty.Jsii$Proxy) o;

                if (this.buttonAction != null ? !this.buttonAction.equals(that.buttonAction) : that.buttonAction != null) return false;
                return this.link != null ? this.link.equals(that.link) : that.link == null;
            }

            @Override
            public final int hashCode() {
                int result = this.buttonAction != null ? this.buttonAction.hashCode() : 0;
                result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpoint.CfnInAppTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpoint.CfnInAppTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpoint.CfnInAppTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpoint.CfnInAppTemplateProps.Builder();
        }

        /**
         * The name of the in-app message template.
         * <p>
         * @return {@code this}
         * @param templateName The name of the in-app message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateName(final java.lang.String templateName) {
            this.props.templateName(templateName);
            return this;
        }

        /**
         * An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
         * <p>
         * @return {@code this}
         * @param content An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(final software.amazon.awscdk.IResolvable content) {
            this.props.content(content);
            return this;
        }
        /**
         * An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
         * <p>
         * @return {@code this}
         * @param content An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(final java.util.List<? extends java.lang.Object> content) {
            this.props.content(content);
            return this;
        }

        /**
         * Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
         * <p>
         * @return {@code this}
         * @param customConfig Custom data, in the form of key-value pairs, that is included in an in-app messaging payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customConfig(final java.lang.Object customConfig) {
            this.props.customConfig(customConfig);
            return this;
        }

        /**
         * A string that determines the appearance of the in-app message. You can specify one of the following:.
         * <p>
         * <ul>
         * <li><code>BOTTOM_BANNER</code> – a message that appears as a banner at the bottom of the page.</li>
         * <li><code>TOP_BANNER</code> – a message that appears as a banner at the top of the page.</li>
         * <li><code>OVERLAYS</code> – a message that covers entire screen.</li>
         * <li><code>MOBILE_FEED</code> – a message that appears in a window in front of the page.</li>
         * <li><code>MIDDLE_BANNER</code> – a message that appears as a banner in the middle of the page.</li>
         * <li><code>CAROUSEL</code> – a scrollable layout of up to five unique messages.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param layout A string that determines the appearance of the in-app message. You can specify one of the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layout(final java.lang.String layout) {
            this.props.layout(layout);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * An optional description of the in-app template.
         * <p>
         * @return {@code this}
         * @param templateDescription An optional description of the in-app template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateDescription(final java.lang.String templateDescription) {
            this.props.templateDescription(templateDescription);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.pinpoint.CfnInAppTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpoint.CfnInAppTemplate build() {
            return new software.amazon.awscdk.services.pinpoint.CfnInAppTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
