package software.amazon.awscdk.services.pinpoint;

/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 * <p>
 * Updates the configuration, dimension, and other settings for an existing segment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object attributes;
 * Object metrics;
 * Object tags;
 * Object userAttributes;
 * CfnSegment cfnSegment = CfnSegment.Builder.create(this, "MyCfnSegment")
 *         .applicationId("applicationId")
 *         .name("name")
 *         // the properties below are optional
 *         .dimensions(SegmentDimensionsProperty.builder()
 *                 .attributes(attributes)
 *                 .behavior(BehaviorProperty.builder()
 *                         .recency(RecencyProperty.builder()
 *                                 .duration("duration")
 *                                 .recencyType("recencyType")
 *                                 .build())
 *                         .build())
 *                 .demographic(DemographicProperty.builder()
 *                         .appVersion(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .channel(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .deviceType(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .make(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .model(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .platform(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .build())
 *                 .location(LocationProperty.builder()
 *                         .country(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .gpsPoint(GPSPointProperty.builder()
 *                                 .coordinates(CoordinatesProperty.builder()
 *                                         .latitude(123)
 *                                         .longitude(123)
 *                                         .build())
 *                                 .rangeInKilometers(123)
 *                                 .build())
 *                         .build())
 *                 .metrics(metrics)
 *                 .userAttributes(userAttributes)
 *                 .build())
 *         .segmentGroups(SegmentGroupsProperty.builder()
 *                 .groups(List.of(GroupsProperty.builder()
 *                         .dimensions(List.of(SegmentDimensionsProperty.builder()
 *                                 .attributes(attributes)
 *                                 .behavior(BehaviorProperty.builder()
 *                                         .recency(RecencyProperty.builder()
 *                                                 .duration("duration")
 *                                                 .recencyType("recencyType")
 *                                                 .build())
 *                                         .build())
 *                                 .demographic(DemographicProperty.builder()
 *                                         .appVersion(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .channel(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .deviceType(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .make(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .model(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .platform(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .build())
 *                                 .location(LocationProperty.builder()
 *                                         .country(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .gpsPoint(GPSPointProperty.builder()
 *                                                 .coordinates(CoordinatesProperty.builder()
 *                                                         .latitude(123)
 *                                                         .longitude(123)
 *                                                         .build())
 *                                                 .rangeInKilometers(123)
 *                                                 .build())
 *                                         .build())
 *                                 .metrics(metrics)
 *                                 .userAttributes(userAttributes)
 *                                 .build()))
 *                         .sourceSegments(List.of(SourceSegmentsProperty.builder()
 *                                 .id("id")
 *                                 // the properties below are optional
 *                                 .version(123)
 *                                 .build()))
 *                         .sourceType("sourceType")
 *                         .type("type")
 *                         .build()))
 *                 .include("include")
 *                 .build())
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.251Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment")
public class CfnSegment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSegment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSegment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpoint.CfnSegment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Pinpoint::Segment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSegment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.CfnSegmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSegmentId() {
        return software.amazon.jsii.Kernel.get(this, "attrSegmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application that the segment is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application that the segment is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", java.util.Objects.requireNonNull(value, "applicationId is required"));
    }

    /**
     * The name of the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The criteria that define the dimensions for the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
        return software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The criteria that define the dimensions for the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDimensions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnSegment.SegmentDimensionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dimensions", value);
    }

    /**
     * The criteria that define the dimensions for the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDimensions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dimensions", value);
    }

    /**
     * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
     * <p>
     * A segment group can consist of zero or more base segments. Your request can include only one segment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSegmentGroups() {
        return software.amazon.jsii.Kernel.get(this, "segmentGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
     * <p>
     * A segment group can consist of zero or more base segments. Your request can include only one segment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnSegment.SegmentGroupsProperty value) {
        software.amazon.jsii.Kernel.set(this, "segmentGroups", value);
    }

    /**
     * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
     * <p>
     * A segment group can consist of zero or more base segments. Your request can include only one segment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "segmentGroups", value);
    }
    /**
     * Specifies attribute-based criteria for including or excluding endpoints from a segment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * AttributeDimensionProperty attributeDimensionProperty = AttributeDimensionProperty.builder()
     *         .attributeType("attributeType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.AttributeDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of segment dimension to use. Valid values are:.
         * <p>
         * <ul>
         * <li><code>INCLUSIVE</code> – endpoints that have attributes matching the values are included in the segment.</li>
         * <li><code>EXCLUSIVE</code> – endpoints that have attributes matching the values are excluded from the segment.</li>
         * <li><code>CONTAINS</code> – endpoints that have attributes' substrings match the values are included in the segment.</li>
         * <li><code>BEFORE</code> – endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li>
         * <li><code>AFTER</code> – endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li>
         * <li><code>BETWEEN</code> – endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li>
         * <li><code>ON</code> – endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttributeType() {
            return null;
        }

        /**
         * The criteria values to use for the segment dimension.
         * <p>
         * Depending on the value of the <code>AttributeType</code> property, endpoints are included or excluded from the segment if their attribute values match the criteria values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeDimensionProperty> {
            java.lang.String attributeType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link AttributeDimensionProperty#getAttributeType}
             * @param attributeType The type of segment dimension to use. Valid values are:.
             *                      <ul>
             *                      <li><code>INCLUSIVE</code> – endpoints that have attributes matching the values are included in the segment.</li>
             *                      <li><code>EXCLUSIVE</code> – endpoints that have attributes matching the values are excluded from the segment.</li>
             *                      <li><code>CONTAINS</code> – endpoints that have attributes' substrings match the values are included in the segment.</li>
             *                      <li><code>BEFORE</code> – endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li>
             *                      <li><code>AFTER</code> – endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li>
             *                      <li><code>BETWEEN</code> – endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li>
             *                      <li><code>ON</code> – endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeType(java.lang.String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            /**
             * Sets the value of {@link AttributeDimensionProperty#getValues}
             * @param values The criteria values to use for the segment dimension.
             *               Depending on the value of the <code>AttributeType</code> property, endpoints are included or excluded from the segment if their attribute values match the criteria values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeDimensionProperty {
            private final java.lang.String attributeType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeType = software.amazon.jsii.Kernel.get(this, "attributeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeType = builder.attributeType;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getAttributeType() {
                return this.attributeType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributeType() != null) {
                    data.set("attributeType", om.valueToTree(this.getAttributeType()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.AttributeDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeDimensionProperty.Jsii$Proxy that = (AttributeDimensionProperty.Jsii$Proxy) o;

                if (this.attributeType != null ? !this.attributeType.equals(that.attributeType) : that.attributeType != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeType != null ? this.attributeType.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies behavior-based criteria for the segment, such as how recently users have used your app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * BehaviorProperty behaviorProperty = BehaviorProperty.builder()
     *         .recency(RecencyProperty.builder()
     *                 .duration("duration")
     *                 .recencyType("recencyType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.BehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(BehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies how recently segment members were active.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BehaviorProperty> {
            java.lang.Object recency;

            /**
             * Sets the value of {@link BehaviorProperty#getRecency}
             * @param recency Specifies how recently segment members were active.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recency(software.amazon.awscdk.services.pinpoint.CfnSegment.RecencyProperty recency) {
                this.recency = recency;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getRecency}
             * @param recency Specifies how recently segment members were active.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recency(software.amazon.awscdk.IResolvable recency) {
                this.recency = recency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BehaviorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BehaviorProperty {
            private final java.lang.Object recency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recency = software.amazon.jsii.Kernel.get(this, "recency", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recency = builder.recency;
            }

            @Override
            public final java.lang.Object getRecency() {
                return this.recency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecency() != null) {
                    data.set("recency", om.valueToTree(this.getRecency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.BehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BehaviorProperty.Jsii$Proxy that = (BehaviorProperty.Jsii$Proxy) o;

                return this.recency != null ? this.recency.equals(that.recency) : that.recency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recency != null ? this.recency.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the GPS coordinates of a location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * CoordinatesProperty coordinatesProperty = CoordinatesProperty.builder()
     *         .latitude(123)
     *         .longitude(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.CoordinatesProperty")
    @software.amazon.jsii.Jsii.Proxy(CoordinatesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CoordinatesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The latitude coordinate of the location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLatitude();

        /**
         * The longitude coordinate of the location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLongitude();

        /**
         * @return a {@link Builder} of {@link CoordinatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CoordinatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CoordinatesProperty> {
            java.lang.Number latitude;
            java.lang.Number longitude;

            /**
             * Sets the value of {@link CoordinatesProperty#getLatitude}
             * @param latitude The latitude coordinate of the location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder latitude(java.lang.Number latitude) {
                this.latitude = latitude;
                return this;
            }

            /**
             * Sets the value of {@link CoordinatesProperty#getLongitude}
             * @param longitude The longitude coordinate of the location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longitude(java.lang.Number longitude) {
                this.longitude = longitude;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CoordinatesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CoordinatesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CoordinatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CoordinatesProperty {
            private final java.lang.Number latitude;
            private final java.lang.Number longitude;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.latitude = software.amazon.jsii.Kernel.get(this, "latitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.longitude = software.amazon.jsii.Kernel.get(this, "longitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.latitude = java.util.Objects.requireNonNull(builder.latitude, "latitude is required");
                this.longitude = java.util.Objects.requireNonNull(builder.longitude, "longitude is required");
            }

            @Override
            public final java.lang.Number getLatitude() {
                return this.latitude;
            }

            @Override
            public final java.lang.Number getLongitude() {
                return this.longitude;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("latitude", om.valueToTree(this.getLatitude()));
                data.set("longitude", om.valueToTree(this.getLongitude()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.CoordinatesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CoordinatesProperty.Jsii$Proxy that = (CoordinatesProperty.Jsii$Proxy) o;

                if (!latitude.equals(that.latitude)) return false;
                return this.longitude.equals(that.longitude);
            }

            @Override
            public final int hashCode() {
                int result = this.latitude.hashCode();
                result = 31 * result + (this.longitude.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies demographic-based criteria, such as device platform, for the segment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * DemographicProperty demographicProperty = DemographicProperty.builder()
     *         .appVersion(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .channel(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .deviceType(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .make(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .model(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .platform(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.DemographicProperty")
    @software.amazon.jsii.Jsii.Proxy(DemographicProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DemographicProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The app version criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppVersion() {
            return null;
        }

        /**
         * The channel criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChannel() {
            return null;
        }

        /**
         * The device type criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceType() {
            return null;
        }

        /**
         * The device make criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMake() {
            return null;
        }

        /**
         * The device model criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModel() {
            return null;
        }

        /**
         * The device platform criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlatform() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DemographicProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DemographicProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DemographicProperty> {
            java.lang.Object appVersion;
            java.lang.Object channel;
            java.lang.Object deviceType;
            java.lang.Object make;
            java.lang.Object model;
            java.lang.Object platform;

            /**
             * Sets the value of {@link DemographicProperty#getAppVersion}
             * @param appVersion The app version criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appVersion(software.amazon.awscdk.services.pinpoint.CfnSegment.SetDimensionProperty appVersion) {
                this.appVersion = appVersion;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getAppVersion}
             * @param appVersion The app version criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appVersion(software.amazon.awscdk.IResolvable appVersion) {
                this.appVersion = appVersion;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getChannel}
             * @param channel The channel criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channel(software.amazon.awscdk.services.pinpoint.CfnSegment.SetDimensionProperty channel) {
                this.channel = channel;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getChannel}
             * @param channel The channel criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channel(software.amazon.awscdk.IResolvable channel) {
                this.channel = channel;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getDeviceType}
             * @param deviceType The device type criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceType(software.amazon.awscdk.services.pinpoint.CfnSegment.SetDimensionProperty deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getDeviceType}
             * @param deviceType The device type criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceType(software.amazon.awscdk.IResolvable deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getMake}
             * @param make The device make criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder make(software.amazon.awscdk.services.pinpoint.CfnSegment.SetDimensionProperty make) {
                this.make = make;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getMake}
             * @param make The device make criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder make(software.amazon.awscdk.IResolvable make) {
                this.make = make;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getModel}
             * @param model The device model criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(software.amazon.awscdk.services.pinpoint.CfnSegment.SetDimensionProperty model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getModel}
             * @param model The device model criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(software.amazon.awscdk.IResolvable model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getPlatform}
             * @param platform The device platform criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platform(software.amazon.awscdk.services.pinpoint.CfnSegment.SetDimensionProperty platform) {
                this.platform = platform;
                return this;
            }

            /**
             * Sets the value of {@link DemographicProperty#getPlatform}
             * @param platform The device platform criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platform(software.amazon.awscdk.IResolvable platform) {
                this.platform = platform;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DemographicProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DemographicProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DemographicProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DemographicProperty {
            private final java.lang.Object appVersion;
            private final java.lang.Object channel;
            private final java.lang.Object deviceType;
            private final java.lang.Object make;
            private final java.lang.Object model;
            private final java.lang.Object platform;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appVersion = software.amazon.jsii.Kernel.get(this, "appVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.channel = software.amazon.jsii.Kernel.get(this, "channel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deviceType = software.amazon.jsii.Kernel.get(this, "deviceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.make = software.amazon.jsii.Kernel.get(this, "make", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appVersion = builder.appVersion;
                this.channel = builder.channel;
                this.deviceType = builder.deviceType;
                this.make = builder.make;
                this.model = builder.model;
                this.platform = builder.platform;
            }

            @Override
            public final java.lang.Object getAppVersion() {
                return this.appVersion;
            }

            @Override
            public final java.lang.Object getChannel() {
                return this.channel;
            }

            @Override
            public final java.lang.Object getDeviceType() {
                return this.deviceType;
            }

            @Override
            public final java.lang.Object getMake() {
                return this.make;
            }

            @Override
            public final java.lang.Object getModel() {
                return this.model;
            }

            @Override
            public final java.lang.Object getPlatform() {
                return this.platform;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppVersion() != null) {
                    data.set("appVersion", om.valueToTree(this.getAppVersion()));
                }
                if (this.getChannel() != null) {
                    data.set("channel", om.valueToTree(this.getChannel()));
                }
                if (this.getDeviceType() != null) {
                    data.set("deviceType", om.valueToTree(this.getDeviceType()));
                }
                if (this.getMake() != null) {
                    data.set("make", om.valueToTree(this.getMake()));
                }
                if (this.getModel() != null) {
                    data.set("model", om.valueToTree(this.getModel()));
                }
                if (this.getPlatform() != null) {
                    data.set("platform", om.valueToTree(this.getPlatform()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.DemographicProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DemographicProperty.Jsii$Proxy that = (DemographicProperty.Jsii$Proxy) o;

                if (this.appVersion != null ? !this.appVersion.equals(that.appVersion) : that.appVersion != null) return false;
                if (this.channel != null ? !this.channel.equals(that.channel) : that.channel != null) return false;
                if (this.deviceType != null ? !this.deviceType.equals(that.deviceType) : that.deviceType != null) return false;
                if (this.make != null ? !this.make.equals(that.make) : that.make != null) return false;
                if (this.model != null ? !this.model.equals(that.model) : that.model != null) return false;
                return this.platform != null ? this.platform.equals(that.platform) : that.platform == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appVersion != null ? this.appVersion.hashCode() : 0;
                result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
                result = 31 * result + (this.deviceType != null ? this.deviceType.hashCode() : 0);
                result = 31 * result + (this.make != null ? this.make.hashCode() : 0);
                result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
                result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the GPS coordinates of the endpoint location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * GPSPointProperty gPSPointProperty = GPSPointProperty.builder()
     *         .coordinates(CoordinatesProperty.builder()
     *                 .latitude(123)
     *                 .longitude(123)
     *                 .build())
     *         .rangeInKilometers(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.GPSPointProperty")
    @software.amazon.jsii.Jsii.Proxy(GPSPointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GPSPointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The GPS coordinates to measure distance from.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCoordinates();

        /**
         * The range, in kilometers, from the GPS coordinates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRangeInKilometers();

        /**
         * @return a {@link Builder} of {@link GPSPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GPSPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GPSPointProperty> {
            java.lang.Object coordinates;
            java.lang.Number rangeInKilometers;

            /**
             * Sets the value of {@link GPSPointProperty#getCoordinates}
             * @param coordinates The GPS coordinates to measure distance from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coordinates(software.amazon.awscdk.services.pinpoint.CfnSegment.CoordinatesProperty coordinates) {
                this.coordinates = coordinates;
                return this;
            }

            /**
             * Sets the value of {@link GPSPointProperty#getCoordinates}
             * @param coordinates The GPS coordinates to measure distance from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coordinates(software.amazon.awscdk.IResolvable coordinates) {
                this.coordinates = coordinates;
                return this;
            }

            /**
             * Sets the value of {@link GPSPointProperty#getRangeInKilometers}
             * @param rangeInKilometers The range, in kilometers, from the GPS coordinates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeInKilometers(java.lang.Number rangeInKilometers) {
                this.rangeInKilometers = rangeInKilometers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GPSPointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GPSPointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GPSPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GPSPointProperty {
            private final java.lang.Object coordinates;
            private final java.lang.Number rangeInKilometers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coordinates = software.amazon.jsii.Kernel.get(this, "coordinates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rangeInKilometers = software.amazon.jsii.Kernel.get(this, "rangeInKilometers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coordinates = java.util.Objects.requireNonNull(builder.coordinates, "coordinates is required");
                this.rangeInKilometers = java.util.Objects.requireNonNull(builder.rangeInKilometers, "rangeInKilometers is required");
            }

            @Override
            public final java.lang.Object getCoordinates() {
                return this.coordinates;
            }

            @Override
            public final java.lang.Number getRangeInKilometers() {
                return this.rangeInKilometers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("coordinates", om.valueToTree(this.getCoordinates()));
                data.set("rangeInKilometers", om.valueToTree(this.getRangeInKilometers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.GPSPointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GPSPointProperty.Jsii$Proxy that = (GPSPointProperty.Jsii$Proxy) o;

                if (!coordinates.equals(that.coordinates)) return false;
                return this.rangeInKilometers.equals(that.rangeInKilometers);
            }

            @Override
            public final int hashCode() {
                int result = this.coordinates.hashCode();
                result = 31 * result + (this.rangeInKilometers.hashCode());
                return result;
            }
        }
    }
    /**
     * An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object attributes;
     * Object metrics;
     * Object userAttributes;
     * GroupsProperty groupsProperty = GroupsProperty.builder()
     *         .dimensions(List.of(SegmentDimensionsProperty.builder()
     *                 .attributes(attributes)
     *                 .behavior(BehaviorProperty.builder()
     *                         .recency(RecencyProperty.builder()
     *                                 .duration("duration")
     *                                 .recencyType("recencyType")
     *                                 .build())
     *                         .build())
     *                 .demographic(DemographicProperty.builder()
     *                         .appVersion(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .channel(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .deviceType(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .make(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .model(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .platform(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .build())
     *                 .location(LocationProperty.builder()
     *                         .country(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .gpsPoint(GPSPointProperty.builder()
     *                                 .coordinates(CoordinatesProperty.builder()
     *                                         .latitude(123)
     *                                         .longitude(123)
     *                                         .build())
     *                                 .rangeInKilometers(123)
     *                                 .build())
     *                         .build())
     *                 .metrics(metrics)
     *                 .userAttributes(userAttributes)
     *                 .build()))
     *         .sourceSegments(List.of(SourceSegmentsProperty.builder()
     *                 .id("id")
     *                 // the properties below are optional
     *                 .version(123)
     *                 .build()))
     *         .sourceType("sourceType")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.GroupsProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array that defines the dimensions to include or exclude from the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The base segment to build the segment on.
         * <p>
         * A base segment, also called a <em>source segment</em> , defines the initial population of endpoints for a segment. When you add dimensions to the segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.
         * <p>
         * You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the segment size estimate that displays on the Amazon Pinpoint console indicates the size of the imported segment without any filters applied to it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceSegments() {
            return null;
        }

        /**
         * Specifies how to handle multiple base segments for the segment.
         * <p>
         * For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceType() {
            return null;
        }

        /**
         * Specifies how to handle multiple dimensions for the segment.
         * <p>
         * For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupsProperty> {
            java.lang.Object dimensions;
            java.lang.Object sourceSegments;
            java.lang.String sourceType;
            java.lang.String type;

            /**
             * Sets the value of {@link GroupsProperty#getDimensions}
             * @param dimensions An array that defines the dimensions to include or exclude from the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link GroupsProperty#getDimensions}
             * @param dimensions An array that defines the dimensions to include or exclude from the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link GroupsProperty#getSourceSegments}
             * @param sourceSegments The base segment to build the segment on.
             *                       A base segment, also called a <em>source segment</em> , defines the initial population of endpoints for a segment. When you add dimensions to the segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.
             *                       <p>
             *                       You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the segment size estimate that displays on the Amazon Pinpoint console indicates the size of the imported segment without any filters applied to it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSegments(software.amazon.awscdk.IResolvable sourceSegments) {
                this.sourceSegments = sourceSegments;
                return this;
            }

            /**
             * Sets the value of {@link GroupsProperty#getSourceSegments}
             * @param sourceSegments The base segment to build the segment on.
             *                       A base segment, also called a <em>source segment</em> , defines the initial population of endpoints for a segment. When you add dimensions to the segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.
             *                       <p>
             *                       You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the segment size estimate that displays on the Amazon Pinpoint console indicates the size of the imported segment without any filters applied to it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSegments(java.util.List<? extends java.lang.Object> sourceSegments) {
                this.sourceSegments = sourceSegments;
                return this;
            }

            /**
             * Sets the value of {@link GroupsProperty#getSourceType}
             * @param sourceType Specifies how to handle multiple base segments for the segment.
             *                   For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceType(java.lang.String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            /**
             * Sets the value of {@link GroupsProperty#getType}
             * @param type Specifies how to handle multiple dimensions for the segment.
             *             For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupsProperty {
            private final java.lang.Object dimensions;
            private final java.lang.Object sourceSegments;
            private final java.lang.String sourceType;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceSegments = software.amazon.jsii.Kernel.get(this, "sourceSegments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceType = software.amazon.jsii.Kernel.get(this, "sourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.sourceSegments = builder.sourceSegments;
                this.sourceType = builder.sourceType;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.Object getSourceSegments() {
                return this.sourceSegments;
            }

            @Override
            public final java.lang.String getSourceType() {
                return this.sourceType;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getSourceSegments() != null) {
                    data.set("sourceSegments", om.valueToTree(this.getSourceSegments()));
                }
                if (this.getSourceType() != null) {
                    data.set("sourceType", om.valueToTree(this.getSourceType()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.GroupsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupsProperty.Jsii$Proxy that = (GroupsProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.sourceSegments != null ? !this.sourceSegments.equals(that.sourceSegments) : that.sourceSegments != null) return false;
                if (this.sourceType != null ? !this.sourceType.equals(that.sourceType) : that.sourceType != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.sourceSegments != null ? this.sourceSegments.hashCode() : 0);
                result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies location-based criteria, such as region or GPS coordinates, for the segment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * LocationProperty locationProperty = LocationProperty.builder()
     *         .country(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .gpsPoint(GPSPointProperty.builder()
     *                 .coordinates(CoordinatesProperty.builder()
     *                         .latitude(123)
     *                         .longitude(123)
     *                         .build())
     *                 .rangeInKilometers(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCountry() {
            return null;
        }

        /**
         * The GPS point dimension for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGpsPoint() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationProperty> {
            java.lang.Object country;
            java.lang.Object gpsPoint;

            /**
             * Sets the value of {@link LocationProperty#getCountry}
             * @param country The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder country(software.amazon.awscdk.services.pinpoint.CfnSegment.SetDimensionProperty country) {
                this.country = country;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getCountry}
             * @param country The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder country(software.amazon.awscdk.IResolvable country) {
                this.country = country;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getGpsPoint}
             * @param gpsPoint The GPS point dimension for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gpsPoint(software.amazon.awscdk.services.pinpoint.CfnSegment.GPSPointProperty gpsPoint) {
                this.gpsPoint = gpsPoint;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getGpsPoint}
             * @param gpsPoint The GPS point dimension for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gpsPoint(software.amazon.awscdk.IResolvable gpsPoint) {
                this.gpsPoint = gpsPoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationProperty {
            private final java.lang.Object country;
            private final java.lang.Object gpsPoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.country = software.amazon.jsii.Kernel.get(this, "country", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.gpsPoint = software.amazon.jsii.Kernel.get(this, "gpsPoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.country = builder.country;
                this.gpsPoint = builder.gpsPoint;
            }

            @Override
            public final java.lang.Object getCountry() {
                return this.country;
            }

            @Override
            public final java.lang.Object getGpsPoint() {
                return this.gpsPoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCountry() != null) {
                    data.set("country", om.valueToTree(this.getCountry()));
                }
                if (this.getGpsPoint() != null) {
                    data.set("gpsPoint", om.valueToTree(this.getGpsPoint()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationProperty.Jsii$Proxy that = (LocationProperty.Jsii$Proxy) o;

                if (this.country != null ? !this.country.equals(that.country) : that.country != null) return false;
                return this.gpsPoint != null ? this.gpsPoint.equals(that.gpsPoint) : that.gpsPoint == null;
            }

            @Override
            public final int hashCode() {
                int result = this.country != null ? this.country.hashCode() : 0;
                result = 31 * result + (this.gpsPoint != null ? this.gpsPoint.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies how recently segment members were active.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * RecencyProperty recencyProperty = RecencyProperty.builder()
     *         .duration("duration")
     *         .recencyType("recencyType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.RecencyProperty")
    @software.amazon.jsii.Jsii.Proxy(RecencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The duration to use when determining which users have been active or inactive with your app.
         * <p>
         * Possible values: <code>HR_24</code> | <code>DAY_7</code> | <code>DAY_14</code> | <code>DAY_30</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDuration();

        /**
         * The type of recency dimension to use for the segment.
         * <p>
         * Valid values are: <code>ACTIVE</code> and <code>INACTIVE</code> . If the value is <code>ACTIVE</code> , the segment includes users who have used your app within the specified duration are included in the segment. If the value is <code>INACTIVE</code> , the segment includes users who haven't used your app within the specified duration are included in the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecencyType();

        /**
         * @return a {@link Builder} of {@link RecencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecencyProperty> {
            java.lang.String duration;
            java.lang.String recencyType;

            /**
             * Sets the value of {@link RecencyProperty#getDuration}
             * @param duration The duration to use when determining which users have been active or inactive with your app. This parameter is required.
             *                 Possible values: <code>HR_24</code> | <code>DAY_7</code> | <code>DAY_14</code> | <code>DAY_30</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder duration(java.lang.String duration) {
                this.duration = duration;
                return this;
            }

            /**
             * Sets the value of {@link RecencyProperty#getRecencyType}
             * @param recencyType The type of recency dimension to use for the segment. This parameter is required.
             *                    Valid values are: <code>ACTIVE</code> and <code>INACTIVE</code> . If the value is <code>ACTIVE</code> , the segment includes users who have used your app within the specified duration are included in the segment. If the value is <code>INACTIVE</code> , the segment includes users who haven't used your app within the specified duration are included in the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recencyType(java.lang.String recencyType) {
                this.recencyType = recencyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecencyProperty {
            private final java.lang.String duration;
            private final java.lang.String recencyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.duration = software.amazon.jsii.Kernel.get(this, "duration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recencyType = software.amazon.jsii.Kernel.get(this, "recencyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.duration = java.util.Objects.requireNonNull(builder.duration, "duration is required");
                this.recencyType = java.util.Objects.requireNonNull(builder.recencyType, "recencyType is required");
            }

            @Override
            public final java.lang.String getDuration() {
                return this.duration;
            }

            @Override
            public final java.lang.String getRecencyType() {
                return this.recencyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("duration", om.valueToTree(this.getDuration()));
                data.set("recencyType", om.valueToTree(this.getRecencyType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.RecencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecencyProperty.Jsii$Proxy that = (RecencyProperty.Jsii$Proxy) o;

                if (!duration.equals(that.duration)) return false;
                return this.recencyType.equals(that.recencyType);
            }

            @Override
            public final int hashCode() {
                int result = this.duration.hashCode();
                result = 31 * result + (this.recencyType.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the dimension settings for a segment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object attributes;
     * Object metrics;
     * Object userAttributes;
     * SegmentDimensionsProperty segmentDimensionsProperty = SegmentDimensionsProperty.builder()
     *         .attributes(attributes)
     *         .behavior(BehaviorProperty.builder()
     *                 .recency(RecencyProperty.builder()
     *                         .duration("duration")
     *                         .recencyType("recencyType")
     *                         .build())
     *                 .build())
     *         .demographic(DemographicProperty.builder()
     *                 .appVersion(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .channel(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .deviceType(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .make(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .model(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .platform(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build())
     *         .location(LocationProperty.builder()
     *                 .country(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .gpsPoint(GPSPointProperty.builder()
     *                         .coordinates(CoordinatesProperty.builder()
     *                                 .latitude(123)
     *                                 .longitude(123)
     *                                 .build())
     *                         .rangeInKilometers(123)
     *                         .build())
     *                 .build())
     *         .metrics(metrics)
     *         .userAttributes(userAttributes)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.SegmentDimensionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SegmentDimensionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SegmentDimensionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more custom attributes to use as criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * The behavior-based criteria, such as how recently users have used your app, for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBehavior() {
            return null;
        }

        /**
         * The demographic-based criteria, such as device platform, for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDemographic() {
            return null;
        }

        /**
         * The location-based criteria, such as region or GPS coordinates, for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLocation() {
            return null;
        }

        /**
         * One or more custom metrics to use as criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetrics() {
            return null;
        }

        /**
         * One or more custom user attributes to use as criteria for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SegmentDimensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SegmentDimensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SegmentDimensionsProperty> {
            java.lang.Object attributes;
            java.lang.Object behavior;
            java.lang.Object demographic;
            java.lang.Object location;
            java.lang.Object metrics;
            java.lang.Object userAttributes;

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getAttributes}
             * @param attributes One or more custom attributes to use as criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.lang.Object attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getBehavior}
             * @param behavior The behavior-based criteria, such as how recently users have used your app, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behavior(software.amazon.awscdk.services.pinpoint.CfnSegment.BehaviorProperty behavior) {
                this.behavior = behavior;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getBehavior}
             * @param behavior The behavior-based criteria, such as how recently users have used your app, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behavior(software.amazon.awscdk.IResolvable behavior) {
                this.behavior = behavior;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getDemographic}
             * @param demographic The demographic-based criteria, such as device platform, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder demographic(software.amazon.awscdk.services.pinpoint.CfnSegment.DemographicProperty demographic) {
                this.demographic = demographic;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getDemographic}
             * @param demographic The demographic-based criteria, such as device platform, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder demographic(software.amazon.awscdk.IResolvable demographic) {
                this.demographic = demographic;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getLocation}
             * @param location The location-based criteria, such as region or GPS coordinates, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.services.pinpoint.CfnSegment.LocationProperty location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getLocation}
             * @param location The location-based criteria, such as region or GPS coordinates, for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.IResolvable location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getMetrics}
             * @param metrics One or more custom metrics to use as criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(java.lang.Object metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link SegmentDimensionsProperty#getUserAttributes}
             * @param userAttributes One or more custom user attributes to use as criteria for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAttributes(java.lang.Object userAttributes) {
                this.userAttributes = userAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SegmentDimensionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SegmentDimensionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SegmentDimensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SegmentDimensionsProperty {
            private final java.lang.Object attributes;
            private final java.lang.Object behavior;
            private final java.lang.Object demographic;
            private final java.lang.Object location;
            private final java.lang.Object metrics;
            private final java.lang.Object userAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.behavior = software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.demographic = software.amazon.jsii.Kernel.get(this, "demographic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userAttributes = software.amazon.jsii.Kernel.get(this, "userAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = builder.attributes;
                this.behavior = builder.behavior;
                this.demographic = builder.demographic;
                this.location = builder.location;
                this.metrics = builder.metrics;
                this.userAttributes = builder.userAttributes;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.Object getBehavior() {
                return this.behavior;
            }

            @Override
            public final java.lang.Object getDemographic() {
                return this.demographic;
            }

            @Override
            public final java.lang.Object getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Object getMetrics() {
                return this.metrics;
            }

            @Override
            public final java.lang.Object getUserAttributes() {
                return this.userAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getBehavior() != null) {
                    data.set("behavior", om.valueToTree(this.getBehavior()));
                }
                if (this.getDemographic() != null) {
                    data.set("demographic", om.valueToTree(this.getDemographic()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getMetrics() != null) {
                    data.set("metrics", om.valueToTree(this.getMetrics()));
                }
                if (this.getUserAttributes() != null) {
                    data.set("userAttributes", om.valueToTree(this.getUserAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.SegmentDimensionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SegmentDimensionsProperty.Jsii$Proxy that = (SegmentDimensionsProperty.Jsii$Proxy) o;

                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                if (this.behavior != null ? !this.behavior.equals(that.behavior) : that.behavior != null) return false;
                if (this.demographic != null ? !this.demographic.equals(that.demographic) : that.demographic != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
                return this.userAttributes != null ? this.userAttributes.equals(that.userAttributes) : that.userAttributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes != null ? this.attributes.hashCode() : 0;
                result = 31 * result + (this.behavior != null ? this.behavior.hashCode() : 0);
                result = 31 * result + (this.demographic != null ? this.demographic.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
                result = 31 * result + (this.userAttributes != null ? this.userAttributes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the set of segment criteria to evaluate when handling segment groups for the segment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object attributes;
     * Object metrics;
     * Object userAttributes;
     * SegmentGroupsProperty segmentGroupsProperty = SegmentGroupsProperty.builder()
     *         .groups(List.of(GroupsProperty.builder()
     *                 .dimensions(List.of(SegmentDimensionsProperty.builder()
     *                         .attributes(attributes)
     *                         .behavior(BehaviorProperty.builder()
     *                                 .recency(RecencyProperty.builder()
     *                                         .duration("duration")
     *                                         .recencyType("recencyType")
     *                                         .build())
     *                                 .build())
     *                         .demographic(DemographicProperty.builder()
     *                                 .appVersion(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .channel(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .deviceType(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .make(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .model(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .platform(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .build())
     *                         .location(LocationProperty.builder()
     *                                 .country(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .gpsPoint(GPSPointProperty.builder()
     *                                         .coordinates(CoordinatesProperty.builder()
     *                                                 .latitude(123)
     *                                                 .longitude(123)
     *                                                 .build())
     *                                         .rangeInKilometers(123)
     *                                         .build())
     *                                 .build())
     *                         .metrics(metrics)
     *                         .userAttributes(userAttributes)
     *                         .build()))
     *                 .sourceSegments(List.of(SourceSegmentsProperty.builder()
     *                         .id("id")
     *                         // the properties below are optional
     *                         .version(123)
     *                         .build()))
     *                 .sourceType("sourceType")
     *                 .type("type")
     *                 .build()))
     *         .include("include")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.SegmentGroupsProperty")
    @software.amazon.jsii.Jsii.Proxy(SegmentGroupsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SegmentGroupsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the set of segment criteria to evaluate when handling segment groups for the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroups() {
            return null;
        }

        /**
         * Specifies how to handle multiple segment groups for the segment.
         * <p>
         * For example, if the segment includes three segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment groups.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SegmentGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SegmentGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SegmentGroupsProperty> {
            java.lang.Object groups;
            java.lang.String include;

            /**
             * Sets the value of {@link SegmentGroupsProperty#getGroups}
             * @param groups Specifies the set of segment criteria to evaluate when handling segment groups for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(software.amazon.awscdk.IResolvable groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link SegmentGroupsProperty#getGroups}
             * @param groups Specifies the set of segment criteria to evaluate when handling segment groups for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<? extends java.lang.Object> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link SegmentGroupsProperty#getInclude}
             * @param include Specifies how to handle multiple segment groups for the segment.
             *                For example, if the segment includes three segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(java.lang.String include) {
                this.include = include;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SegmentGroupsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SegmentGroupsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SegmentGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SegmentGroupsProperty {
            private final java.lang.Object groups;
            private final java.lang.String include;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groups = builder.groups;
                this.include = builder.include;
            }

            @Override
            public final java.lang.Object getGroups() {
                return this.groups;
            }

            @Override
            public final java.lang.String getInclude() {
                return this.include;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.SegmentGroupsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SegmentGroupsProperty.Jsii$Proxy that = (SegmentGroupsProperty.Jsii$Proxy) o;

                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                return this.include != null ? this.include.equals(that.include) : that.include == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groups != null ? this.groups.hashCode() : 0;
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the dimension type and values for a segment dimension.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * SetDimensionProperty setDimensionProperty = SetDimensionProperty.builder()
     *         .dimensionType("dimensionType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.SetDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(SetDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SetDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of segment dimension to use.
         * <p>
         * Valid values are: <code>INCLUSIVE</code> , endpoints that match the criteria are included in the segment; and, <code>EXCLUSIVE</code> , endpoints that match the criteria are excluded from the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDimensionType() {
            return null;
        }

        /**
         * The criteria values to use for the segment dimension.
         * <p>
         * Depending on the value of the <code>DimensionType</code> property, endpoints are included or excluded from the segment if their values match the criteria values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SetDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SetDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SetDimensionProperty> {
            java.lang.String dimensionType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link SetDimensionProperty#getDimensionType}
             * @param dimensionType The type of segment dimension to use.
             *                      Valid values are: <code>INCLUSIVE</code> , endpoints that match the criteria are included in the segment; and, <code>EXCLUSIVE</code> , endpoints that match the criteria are excluded from the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionType(java.lang.String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            /**
             * Sets the value of {@link SetDimensionProperty#getValues}
             * @param values The criteria values to use for the segment dimension.
             *               Depending on the value of the <code>DimensionType</code> property, endpoints are included or excluded from the segment if their values match the criteria values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SetDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SetDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SetDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SetDimensionProperty {
            private final java.lang.String dimensionType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionType = software.amazon.jsii.Kernel.get(this, "dimensionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionType = builder.dimensionType;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getDimensionType() {
                return this.dimensionType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensionType() != null) {
                    data.set("dimensionType", om.valueToTree(this.getDimensionType()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.SetDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SetDimensionProperty.Jsii$Proxy that = (SetDimensionProperty.Jsii$Proxy) o;

                if (this.dimensionType != null ? !this.dimensionType.equals(that.dimensionType) : that.dimensionType != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionType != null ? this.dimensionType.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the base segment to build the segment on.
     * <p>
     * A base segment, also called a <em>source segment</em> , defines the initial population of endpoints for a segment. When you add dimensions to the segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.
     * <p>
     * You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the segment size estimate that displays on the Amazon Pinpoint console indicates the size of the imported segment without any filters applied to it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * SourceSegmentsProperty sourceSegmentsProperty = SourceSegmentsProperty.builder()
     *         .id("id")
     *         // the properties below are optional
     *         .version(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegment.SourceSegmentsProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceSegmentsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceSegmentsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier for the source segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The version number of the source segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceSegmentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceSegmentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceSegmentsProperty> {
            java.lang.String id;
            java.lang.Number version;

            /**
             * Sets the value of {@link SourceSegmentsProperty#getId}
             * @param id The unique identifier for the source segment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link SourceSegmentsProperty#getVersion}
             * @param version The version number of the source segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSegmentsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceSegmentsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceSegmentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceSegmentsProperty {
            private final java.lang.String id;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegment.SourceSegmentsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceSegmentsProperty.Jsii$Proxy that = (SourceSegmentsProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpoint.CfnSegment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpoint.CfnSegment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpoint.CfnSegmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpoint.CfnSegmentProps.Builder();
        }

        /**
         * The unique identifier for the Amazon Pinpoint application that the segment is associated with.
         * <p>
         * @return {@code this}
         * @param applicationId The unique identifier for the Amazon Pinpoint application that the segment is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(final java.lang.String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        /**
         * The name of the segment.
         * <p>
         * @return {@code this}
         * @param name The name of the segment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The criteria that define the dimensions for the segment.
         * <p>
         * @return {@code this}
         * @param dimensions The criteria that define the dimensions for the segment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(final software.amazon.awscdk.services.pinpoint.CfnSegment.SegmentDimensionsProperty dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }
        /**
         * The criteria that define the dimensions for the segment.
         * <p>
         * @return {@code this}
         * @param dimensions The criteria that define the dimensions for the segment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(final software.amazon.awscdk.IResolvable dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        /**
         * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
         * <p>
         * A segment group can consist of zero or more base segments. Your request can include only one segment group.
         * <p>
         * @return {@code this}
         * @param segmentGroups The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(final software.amazon.awscdk.services.pinpoint.CfnSegment.SegmentGroupsProperty segmentGroups) {
            this.props.segmentGroups(segmentGroups);
            return this;
        }
        /**
         * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
         * <p>
         * A segment group can consist of zero or more base segments. Your request can include only one segment group.
         * <p>
         * @return {@code this}
         * @param segmentGroups The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(final software.amazon.awscdk.IResolvable segmentGroups) {
            this.props.segmentGroups(segmentGroups);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.pinpoint.CfnSegment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpoint.CfnSegment build() {
            return new software.amazon.awscdk.services.pinpoint.CfnSegment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
