package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a `CfnSmsTemplate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object tags;
 * CfnSmsTemplateProps cfnSmsTemplateProps = CfnSmsTemplateProps.builder()
 *         .body("body")
 *         .templateName("templateName")
 *         // the properties below are optional
 *         .defaultSubstitutions("defaultSubstitutions")
 *         .tags(tags)
 *         .templateDescription("templateDescription")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.258Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSmsTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnSmsTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSmsTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The message body to use in text messages that are based on the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBody();

    /**
     * The name of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateName();

    /**
     * A JSON object that specifies the default values to use for message variables in the message template.
     * <p>
     * This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultSubstitutions() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * A custom description of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSmsTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSmsTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSmsTemplateProps> {
        java.lang.String body;
        java.lang.String templateName;
        java.lang.String defaultSubstitutions;
        java.lang.Object tags;
        java.lang.String templateDescription;

        /**
         * Sets the value of {@link CfnSmsTemplateProps#getBody}
         * @param body The message body to use in text messages that are based on the message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(java.lang.String body) {
            this.body = body;
            return this;
        }

        /**
         * Sets the value of {@link CfnSmsTemplateProps#getTemplateName}
         * @param templateName The name of the message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateName(java.lang.String templateName) {
            this.templateName = templateName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSmsTemplateProps#getDefaultSubstitutions}
         * @param defaultSubstitutions A JSON object that specifies the default values to use for message variables in the message template.
         *                             This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSubstitutions(java.lang.String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnSmsTemplateProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnSmsTemplateProps#getTemplateDescription}
         * @param templateDescription A custom description of the message template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateDescription(java.lang.String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSmsTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSmsTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSmsTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSmsTemplateProps {
        private final java.lang.String body;
        private final java.lang.String templateName;
        private final java.lang.String defaultSubstitutions;
        private final java.lang.Object tags;
        private final java.lang.String templateDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateName = software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultSubstitutions = software.amazon.jsii.Kernel.get(this, "defaultSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.templateDescription = software.amazon.jsii.Kernel.get(this, "templateDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.body = java.util.Objects.requireNonNull(builder.body, "body is required");
            this.templateName = java.util.Objects.requireNonNull(builder.templateName, "templateName is required");
            this.defaultSubstitutions = builder.defaultSubstitutions;
            this.tags = builder.tags;
            this.templateDescription = builder.templateDescription;
        }

        @Override
        public final java.lang.String getBody() {
            return this.body;
        }

        @Override
        public final java.lang.String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final java.lang.String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("body", om.valueToTree(this.getBody()));
            data.set("templateName", om.valueToTree(this.getTemplateName()));
            if (this.getDefaultSubstitutions() != null) {
                data.set("defaultSubstitutions", om.valueToTree(this.getDefaultSubstitutions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateDescription() != null) {
                data.set("templateDescription", om.valueToTree(this.getTemplateDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSmsTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSmsTemplateProps.Jsii$Proxy that = (CfnSmsTemplateProps.Jsii$Proxy) o;

            if (!body.equals(that.body)) return false;
            if (!templateName.equals(that.templateName)) return false;
            if (this.defaultSubstitutions != null ? !this.defaultSubstitutions.equals(that.defaultSubstitutions) : that.defaultSubstitutions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.templateDescription != null ? this.templateDescription.equals(that.templateDescription) : that.templateDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.body.hashCode();
            result = 31 * result + (this.templateName.hashCode());
            result = 31 * result + (this.defaultSubstitutions != null ? this.defaultSubstitutions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateDescription != null ? this.templateDescription.hashCode() : 0);
            return result;
        }
    }
}
