package software.amazon.awscdk.services.quicksight;

/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 * <p>
 * Creates an analysis in Amazon QuickSight.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnAnalysis cfnAnalysis = CfnAnalysis.Builder.create(this, "MyCfnAnalysis")
 *         .analysisId("analysisId")
 *         .awsAccountId("awsAccountId")
 *         .sourceEntity(AnalysisSourceEntityProperty.builder()
 *                 .sourceTemplate(AnalysisSourceTemplateProperty.builder()
 *                         .arn("arn")
 *                         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
 *                                 .dataSetArn("dataSetArn")
 *                                 .dataSetPlaceholder("dataSetPlaceholder")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .errors(List.of(AnalysisErrorProperty.builder()
 *                 .message("message")
 *                 .type("type")
 *                 .build()))
 *         .name("name")
 *         .parameters(ParametersProperty.builder()
 *                 .dateTimeParameters(List.of(DateTimeParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .decimalParameters(List.of(DecimalParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of(123))
 *                         .build()))
 *                 .integerParameters(List.of(IntegerParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of(123))
 *                         .build()))
 *                 .stringParameters(List.of(StringParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .build())
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .themeArn("themeArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.286Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis")
public class CfnAnalysis extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAnalysis(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAnalysis(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnAnalysis.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::QuickSight::Analysis`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAnalysis(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnAnalysisProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARNs of the datasets of the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDataSetArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDataSetArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The time that the analysis was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrSheets() {
        return software.amazon.jsii.Kernel.get(this, "attrSheets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID for the analysis that you're creating.
     * <p>
     * This ID displays in the URL of the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAnalysisId() {
        return software.amazon.jsii.Kernel.get(this, "analysisId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID for the analysis that you're creating.
     * <p>
     * This ID displays in the URL of the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalysisId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "analysisId", java.util.Objects.requireNonNull(value, "analysisId is required"));
    }

    /**
     * The ID of the AWS account where you are creating an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account where you are creating an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
    }

    /**
     * A source entity to use for the analysis that you're creating.
     * <p>
     * This metadata structure contains details that describe a source template and one or more datasets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceEntity() {
        return software.amazon.jsii.Kernel.get(this, "sourceEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A source entity to use for the analysis that you're creating.
     * <p>
     * This metadata structure contains details that describe a source template and one or more datasets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisSourceEntityProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", java.util.Objects.requireNonNull(value, "sourceEntity is required"));
    }

    /**
     * A source entity to use for the analysis that you're creating.
     * <p>
     * This metadata structure contains details that describe a source template and one or more datasets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", java.util.Objects.requireNonNull(value, "sourceEntity is required"));
    }

    /**
     * `AWS::QuickSight::Analysis.Errors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getErrors() {
        return software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::QuickSight::Analysis.Errors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "errors", value);
    }

    /**
     * `AWS::QuickSight::Analysis.Errors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisErrorProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisErrorProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "errors", value);
    }

    /**
     * A descriptive name for the analysis that you're creating.
     * <p>
     * This name displays for the analysis in the Amazon QuickSight console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A descriptive name for the analysis that you're creating.
     * <p>
     * This name displays for the analysis in the Amazon QuickSight console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The parameter names and override values that you want to use.
     * <p>
     * An analysis can have any parameter type, and some parameters might accept multiple values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameter names and override values that you want to use.
     * <p>
     * An analysis can have any parameter type, and some parameters might accept multiple values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnAnalysis.ParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The parameter names and override values that you want to use.
     * <p>
     * An analysis can have any parameter type, and some parameters might accept multiple values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     * <p>
     * You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
     * <p>
     * To specify no permissions, omit <code>Permissions</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     * <p>
     * You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
     * <p>
     * To specify no permissions, omit <code>Permissions</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     * <p>
     * You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
     * <p>
     * To specify no permissions, omit <code>Permissions</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnAnalysis.ResourcePermissionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnAnalysis.ResourcePermissionProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * The ARN for the theme to apply to the analysis that you're creating.
     * <p>
     * To see the theme in the Amazon QuickSight console, make sure that you have access to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThemeArn() {
        return software.amazon.jsii.Kernel.get(this, "themeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the theme to apply to the analysis that you're creating.
     * <p>
     * To see the theme in the Amazon QuickSight console, make sure that you have access to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThemeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "themeArn", value);
    }
    /**
     * Analysis error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnalysisErrorProperty analysisErrorProperty = AnalysisErrorProperty.builder()
     *         .message("message")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisErrorProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisErrorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisErrorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message associated with the analysis error.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * The type of the analysis error.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisErrorProperty> {
            java.lang.String message;
            java.lang.String type;

            /**
             * Sets the value of {@link AnalysisErrorProperty#getMessage}
             * @param message The message associated with the analysis error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisErrorProperty#getType}
             * @param type The type of the analysis error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisErrorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisErrorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisErrorProperty {
            private final java.lang.String message;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = builder.message;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisErrorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisErrorProperty.Jsii$Proxy that = (AnalysisErrorProperty.Jsii$Proxy) o;

                if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message != null ? this.message.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The source entity of an analysis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnalysisSourceEntityProperty analysisSourceEntityProperty = AnalysisSourceEntityProperty.builder()
     *         .sourceTemplate(AnalysisSourceTemplateProperty.builder()
     *                 .arn("arn")
     *                 .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                         .dataSetArn("dataSetArn")
     *                         .dataSetPlaceholder("dataSetPlaceholder")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceEntityProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisSourceEntityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisSourceEntityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source template for the source entity of the analysis.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisSourceEntityProperty> {
            java.lang.Object sourceTemplate;

            /**
             * Sets the value of {@link AnalysisSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate The source template for the source entity of the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisSourceTemplateProperty sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate The source template for the source entity of the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.IResolvable sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisSourceEntityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisSourceEntityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisSourceEntityProperty {
            private final java.lang.Object sourceTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceTemplate = software.amazon.jsii.Kernel.get(this, "sourceTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceTemplate = builder.sourceTemplate;
            }

            @Override
            public final java.lang.Object getSourceTemplate() {
                return this.sourceTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceTemplate() != null) {
                    data.set("sourceTemplate", om.valueToTree(this.getSourceTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceEntityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisSourceEntityProperty.Jsii$Proxy that = (AnalysisSourceEntityProperty.Jsii$Proxy) o;

                return this.sourceTemplate != null ? this.sourceTemplate.equals(that.sourceTemplate) : that.sourceTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceTemplate != null ? this.sourceTemplate.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The source template of an analysis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnalysisSourceTemplateProperty analysisSourceTemplateProperty = AnalysisSourceTemplateProperty.builder()
     *         .arn("arn")
     *         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                 .dataSetArn("dataSetArn")
     *                 .dataSetPlaceholder("dataSetPlaceholder")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisSourceTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisSourceTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the source template of an analysis.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The dataset references of the source template of an analysis.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataSetReferences();

        /**
         * @return a {@link Builder} of {@link AnalysisSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisSourceTemplateProperty> {
            java.lang.String arn;
            java.lang.Object dataSetReferences;

            /**
             * Sets the value of {@link AnalysisSourceTemplateProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the source template of an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSourceTemplateProperty#getDataSetReferences}
             * @param dataSetReferences The dataset references of the source template of an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(software.amazon.awscdk.IResolvable dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSourceTemplateProperty#getDataSetReferences}
             * @param dataSetReferences The dataset references of the source template of an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(java.util.List<? extends java.lang.Object> dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisSourceTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisSourceTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisSourceTemplateProperty {
            private final java.lang.String arn;
            private final java.lang.Object dataSetReferences;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetReferences = software.amazon.jsii.Kernel.get(this, "dataSetReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.dataSetReferences = java.util.Objects.requireNonNull(builder.dataSetReferences, "dataSetReferences is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getDataSetReferences() {
                return this.dataSetReferences;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("dataSetReferences", om.valueToTree(this.getDataSetReferences()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisSourceTemplateProperty.Jsii$Proxy that = (AnalysisSourceTemplateProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.dataSetReferences.equals(that.dataSetReferences);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.dataSetReferences.hashCode());
                return result;
            }
        }
    }
    /**
     * Dataset reference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetReferenceProperty dataSetReferenceProperty = DataSetReferenceProperty.builder()
     *         .dataSetArn("dataSetArn")
     *         .dataSetPlaceholder("dataSetPlaceholder")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.DataSetReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Dataset Amazon Resource Name (ARN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetArn();

        /**
         * Dataset placeholder.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetPlaceholder();

        /**
         * @return a {@link Builder} of {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetReferenceProperty> {
            java.lang.String dataSetArn;
            java.lang.String dataSetPlaceholder;

            /**
             * Sets the value of {@link DataSetReferenceProperty#getDataSetArn}
             * @param dataSetArn Dataset Amazon Resource Name (ARN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetArn(java.lang.String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            /**
             * Sets the value of {@link DataSetReferenceProperty#getDataSetPlaceholder}
             * @param dataSetPlaceholder Dataset placeholder. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetPlaceholder(java.lang.String dataSetPlaceholder) {
                this.dataSetPlaceholder = dataSetPlaceholder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetReferenceProperty {
            private final java.lang.String dataSetArn;
            private final java.lang.String dataSetPlaceholder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetArn = software.amazon.jsii.Kernel.get(this, "dataSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetPlaceholder = software.amazon.jsii.Kernel.get(this, "dataSetPlaceholder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetArn = java.util.Objects.requireNonNull(builder.dataSetArn, "dataSetArn is required");
                this.dataSetPlaceholder = java.util.Objects.requireNonNull(builder.dataSetPlaceholder, "dataSetPlaceholder is required");
            }

            @Override
            public final java.lang.String getDataSetArn() {
                return this.dataSetArn;
            }

            @Override
            public final java.lang.String getDataSetPlaceholder() {
                return this.dataSetPlaceholder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSetArn", om.valueToTree(this.getDataSetArn()));
                data.set("dataSetPlaceholder", om.valueToTree(this.getDataSetPlaceholder()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.DataSetReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetReferenceProperty.Jsii$Proxy that = (DataSetReferenceProperty.Jsii$Proxy) o;

                if (!dataSetArn.equals(that.dataSetArn)) return false;
                return this.dataSetPlaceholder.equals(that.dataSetPlaceholder);
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetArn.hashCode();
                result = 31 * result + (this.dataSetPlaceholder.hashCode());
                return result;
            }
        }
    }
    /**
     * A date-time parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DateTimeParameterProperty dateTimeParameterProperty = DateTimeParameterProperty.builder()
     *         .name("name")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateTimeParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateTimeParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for the date-time parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values for the date-time parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link DateTimeParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateTimeParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateTimeParameterProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link DateTimeParameterProperty#getName}
             * @param name A display name for the date-time parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeParameterProperty#getValues}
             * @param values The values for the date-time parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateTimeParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateTimeParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateTimeParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeParameterProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateTimeParameterProperty.Jsii$Proxy that = (DateTimeParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * A decimal parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DecimalParameterProperty decimalParameterProperty = DecimalParameterProperty.builder()
     *         .name("name")
     *         .values(List.of(123))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DecimalParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DecimalParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for the decimal parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values for the decimal parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link DecimalParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DecimalParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DecimalParameterProperty> {
            java.lang.String name;
            java.lang.Object values;

            /**
             * Sets the value of {@link DecimalParameterProperty#getName}
             * @param name A display name for the decimal parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DecimalParameterProperty#getValues}
             * @param values The values for the decimal parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link DecimalParameterProperty#getValues}
             * @param values The values for the decimal parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Number> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DecimalParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DecimalParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DecimalParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecimalParameterProperty {
            private final java.lang.String name;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DecimalParameterProperty.Jsii$Proxy that = (DecimalParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * An integer parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IntegerParameterProperty integerParameterProperty = IntegerParameterProperty.builder()
     *         .name("name")
     *         .values(List.of(123))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.IntegerParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegerParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegerParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the integer parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values for the integer parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link IntegerParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegerParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegerParameterProperty> {
            java.lang.String name;
            java.lang.Object values;

            /**
             * Sets the value of {@link IntegerParameterProperty#getName}
             * @param name The name of the integer parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link IntegerParameterProperty#getValues}
             * @param values The values for the integer parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link IntegerParameterProperty#getValues}
             * @param values The values for the integer parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Number> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegerParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegerParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegerParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegerParameterProperty {
            private final java.lang.String name;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.IntegerParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegerParameterProperty.Jsii$Proxy that = (IntegerParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of Amazon QuickSight parameters and the list's override values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ParametersProperty parametersProperty = ParametersProperty.builder()
     *         .dateTimeParameters(List.of(DateTimeParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .decimalParameters(List.of(DecimalParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of(123))
     *                 .build()))
     *         .integerParameters(List.of(IntegerParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of(123))
     *                 .build()))
     *         .stringParameters(List.of(StringParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters that have a data type of date-time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateTimeParameters() {
            return null;
        }

        /**
         * The parameters that have a data type of decimal.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecimalParameters() {
            return null;
        }

        /**
         * The parameters that have a data type of integer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerParameters() {
            return null;
        }

        /**
         * The parameters that have a data type of string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParametersProperty> {
            java.lang.Object dateTimeParameters;
            java.lang.Object decimalParameters;
            java.lang.Object integerParameters;
            java.lang.Object stringParameters;

            /**
             * Sets the value of {@link ParametersProperty#getDateTimeParameters}
             * @param dateTimeParameters The parameters that have a data type of date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeParameters(software.amazon.awscdk.IResolvable dateTimeParameters) {
                this.dateTimeParameters = dateTimeParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getDateTimeParameters}
             * @param dateTimeParameters The parameters that have a data type of date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeParameters(java.util.List<? extends java.lang.Object> dateTimeParameters) {
                this.dateTimeParameters = dateTimeParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getDecimalParameters}
             * @param decimalParameters The parameters that have a data type of decimal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalParameters(software.amazon.awscdk.IResolvable decimalParameters) {
                this.decimalParameters = decimalParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getDecimalParameters}
             * @param decimalParameters The parameters that have a data type of decimal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalParameters(java.util.List<? extends java.lang.Object> decimalParameters) {
                this.decimalParameters = decimalParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getIntegerParameters}
             * @param integerParameters The parameters that have a data type of integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerParameters(software.amazon.awscdk.IResolvable integerParameters) {
                this.integerParameters = integerParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getIntegerParameters}
             * @param integerParameters The parameters that have a data type of integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerParameters(java.util.List<? extends java.lang.Object> integerParameters) {
                this.integerParameters = integerParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getStringParameters}
             * @param stringParameters The parameters that have a data type of string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringParameters(software.amazon.awscdk.IResolvable stringParameters) {
                this.stringParameters = stringParameters;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getStringParameters}
             * @param stringParameters The parameters that have a data type of string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringParameters(java.util.List<? extends java.lang.Object> stringParameters) {
                this.stringParameters = stringParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParametersProperty {
            private final java.lang.Object dateTimeParameters;
            private final java.lang.Object decimalParameters;
            private final java.lang.Object integerParameters;
            private final java.lang.Object stringParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateTimeParameters = software.amazon.jsii.Kernel.get(this, "dateTimeParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.decimalParameters = software.amazon.jsii.Kernel.get(this, "decimalParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.integerParameters = software.amazon.jsii.Kernel.get(this, "integerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringParameters = software.amazon.jsii.Kernel.get(this, "stringParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateTimeParameters = builder.dateTimeParameters;
                this.decimalParameters = builder.decimalParameters;
                this.integerParameters = builder.integerParameters;
                this.stringParameters = builder.stringParameters;
            }

            @Override
            public final java.lang.Object getDateTimeParameters() {
                return this.dateTimeParameters;
            }

            @Override
            public final java.lang.Object getDecimalParameters() {
                return this.decimalParameters;
            }

            @Override
            public final java.lang.Object getIntegerParameters() {
                return this.integerParameters;
            }

            @Override
            public final java.lang.Object getStringParameters() {
                return this.stringParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateTimeParameters() != null) {
                    data.set("dateTimeParameters", om.valueToTree(this.getDateTimeParameters()));
                }
                if (this.getDecimalParameters() != null) {
                    data.set("decimalParameters", om.valueToTree(this.getDecimalParameters()));
                }
                if (this.getIntegerParameters() != null) {
                    data.set("integerParameters", om.valueToTree(this.getIntegerParameters()));
                }
                if (this.getStringParameters() != null) {
                    data.set("stringParameters", om.valueToTree(this.getStringParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParametersProperty.Jsii$Proxy that = (ParametersProperty.Jsii$Proxy) o;

                if (this.dateTimeParameters != null ? !this.dateTimeParameters.equals(that.dateTimeParameters) : that.dateTimeParameters != null) return false;
                if (this.decimalParameters != null ? !this.decimalParameters.equals(that.decimalParameters) : that.decimalParameters != null) return false;
                if (this.integerParameters != null ? !this.integerParameters.equals(that.integerParameters) : that.integerParameters != null) return false;
                return this.stringParameters != null ? this.stringParameters.equals(that.stringParameters) : that.stringParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateTimeParameters != null ? this.dateTimeParameters.hashCode() : 0;
                result = 31 * result + (this.decimalParameters != null ? this.decimalParameters.hashCode() : 0);
                result = 31 * result + (this.integerParameters != null ? this.integerParameters.hashCode() : 0);
                result = 31 * result + (this.stringParameters != null ? this.stringParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grant or revoke permissions on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grant or revoke permissions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }
    /**
     * A *sheet* , which is an object that contains a set of visuals that are viewed together on one page in Amazon QuickSight.
     * <p>
     * Every analysis and dashboard contains at least one sheet. Each sheet contains at least one visualization widget, for example a chart, pivot table, or narrative insight. Sheets can be associated with other components, such as controls, filters, and so on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SheetProperty sheetProperty = SheetProperty.builder()
     *         .name("name")
     *         .sheetId("sheetId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetProperty")
    @software.amazon.jsii.Jsii.Proxy(SheetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SheetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a sheet.
         * <p>
         * This name is displayed on the sheet's tab in the Amazon QuickSight console.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The unique identifier associated with a sheet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSheetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SheetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SheetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SheetProperty> {
            java.lang.String name;
            java.lang.String sheetId;

            /**
             * Sets the value of {@link SheetProperty#getName}
             * @param name The name of a sheet.
             *             This name is displayed on the sheet's tab in the Amazon QuickSight console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SheetProperty#getSheetId}
             * @param sheetId The unique identifier associated with a sheet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetId(java.lang.String sheetId) {
                this.sheetId = sheetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SheetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SheetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SheetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SheetProperty {
            private final java.lang.String name;
            private final java.lang.String sheetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sheetId = software.amazon.jsii.Kernel.get(this, "sheetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.sheetId = builder.sheetId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSheetId() {
                return this.sheetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSheetId() != null) {
                    data.set("sheetId", om.valueToTree(this.getSheetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SheetProperty.Jsii$Proxy that = (SheetProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.sheetId != null ? this.sheetId.equals(that.sheetId) : that.sheetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.sheetId != null ? this.sheetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A string parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * StringParameterProperty stringParameterProperty = StringParameterProperty.builder()
     *         .name("name")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.StringParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(StringParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for a string parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The values of a string parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link StringParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringParameterProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link StringParameterProperty#getName}
             * @param name A display name for a string parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StringParameterProperty#getValues}
             * @param values The values of a string parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringParameterProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.StringParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringParameterProperty.Jsii$Proxy that = (StringParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnAnalysis}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnAnalysis> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.quicksight.CfnAnalysisProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.quicksight.CfnAnalysisProps.Builder();
        }

        /**
         * The ID for the analysis that you're creating.
         * <p>
         * This ID displays in the URL of the analysis.
         * <p>
         * @return {@code this}
         * @param analysisId The ID for the analysis that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisId(final java.lang.String analysisId) {
            this.props.analysisId(analysisId);
            return this;
        }

        /**
         * The ID of the AWS account where you are creating an analysis.
         * <p>
         * @return {@code this}
         * @param awsAccountId The ID of the AWS account where you are creating an analysis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props.awsAccountId(awsAccountId);
            return this;
        }

        /**
         * A source entity to use for the analysis that you're creating.
         * <p>
         * This metadata structure contains details that describe a source template and one or more datasets.
         * <p>
         * @return {@code this}
         * @param sourceEntity A source entity to use for the analysis that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(final software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisSourceEntityProperty sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }
        /**
         * A source entity to use for the analysis that you're creating.
         * <p>
         * This metadata structure contains details that describe a source template and one or more datasets.
         * <p>
         * @return {@code this}
         * @param sourceEntity A source entity to use for the analysis that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(final software.amazon.awscdk.IResolvable sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }

        /**
         * `AWS::QuickSight::Analysis.Errors`.
         * <p>
         * @return {@code this}
         * @param errors `AWS::QuickSight::Analysis.Errors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errors(final software.amazon.awscdk.IResolvable errors) {
            this.props.errors(errors);
            return this;
        }
        /**
         * `AWS::QuickSight::Analysis.Errors`.
         * <p>
         * @return {@code this}
         * @param errors `AWS::QuickSight::Analysis.Errors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errors(final java.util.List<? extends java.lang.Object> errors) {
            this.props.errors(errors);
            return this;
        }

        /**
         * A descriptive name for the analysis that you're creating.
         * <p>
         * This name displays for the analysis in the Amazon QuickSight console.
         * <p>
         * @return {@code this}
         * @param name A descriptive name for the analysis that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The parameter names and override values that you want to use.
         * <p>
         * An analysis can have any parameter type, and some parameters might accept multiple values.
         * <p>
         * @return {@code this}
         * @param parameters The parameter names and override values that you want to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.services.quicksight.CfnAnalysis.ParametersProperty parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * The parameter names and override values that you want to use.
         * <p>
         * An analysis can have any parameter type, and some parameters might accept multiple values.
         * <p>
         * @return {@code this}
         * @param parameters The parameter names and override values that you want to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * A structure that describes the principals and the resource-level permissions on an analysis.
         * <p>
         * You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
         * <p>
         * To specify no permissions, omit <code>Permissions</code> .
         * <p>
         * @return {@code this}
         * @param permissions A structure that describes the principals and the resource-level permissions on an analysis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final software.amazon.awscdk.IResolvable permissions) {
            this.props.permissions(permissions);
            return this;
        }
        /**
         * A structure that describes the principals and the resource-level permissions on an analysis.
         * <p>
         * You can use the <code>Permissions</code> structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
         * <p>
         * To specify no permissions, omit <code>Permissions</code> .
         * <p>
         * @return {@code this}
         * @param permissions A structure that describes the principals and the resource-level permissions on an analysis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<? extends java.lang.Object> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
         * <p>
         * @return {@code this}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The ARN for the theme to apply to the analysis that you're creating.
         * <p>
         * To see the theme in the Amazon QuickSight console, make sure that you have access to it.
         * <p>
         * @return {@code this}
         * @param themeArn The ARN for the theme to apply to the analysis that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeArn(final java.lang.String themeArn) {
            this.props.themeArn(themeArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnAnalysis}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnAnalysis build() {
            return new software.amazon.awscdk.services.quicksight.CfnAnalysis(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
