package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBProxy`.
 * <p>
 * The <code>AWS::RDS::DBProxy</code> resource creates or updates a DB proxy.
 * <p>
 * For information about RDS Proxy for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html">Managing Connections with Amazon RDS Proxy</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For information about RDS Proxy for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html">Managing Connections with Amazon RDS Proxy</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * <p>
 * For information about limitations that apply to RDS Proxy for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations">Limitations for RDS Proxy</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For information about that apply to RDS Proxy for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations">Limitations for RDS Proxy</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBProxy cfnDBProxy = CfnDBProxy.Builder.create(this, "MyCfnDBProxy")
 *         .auth(List.of(AuthFormatProperty.builder()
 *                 .authScheme("authScheme")
 *                 .description("description")
 *                 .iamAuth("iamAuth")
 *                 .secretArn("secretArn")
 *                 .userName("userName")
 *                 .build()))
 *         .dbProxyName("dbProxyName")
 *         .engineFamily("engineFamily")
 *         .roleArn("roleArn")
 *         .vpcSubnetIds(List.of("vpcSubnetIds"))
 *         // the properties below are optional
 *         .debugLogging(false)
 *         .idleClientTimeout(123)
 *         .requireTls(false)
 *         .tags(List.of(TagFormatProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.417Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxy")
public class CfnDBProxy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBProxy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBProxy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBProxy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBProxy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBProxy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBProxyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) representing the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbProxyArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDbProxyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The writer endpoint for the RDS DB instance or Aurora DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The authorization mechanism that the proxy uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAuth() {
        return software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The authorization mechanism that the proxy uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuth(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "auth", java.util.Objects.requireNonNull(value, "auth is required"));
    }

    /**
     * The authorization mechanism that the proxy uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuth(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBProxy.AuthFormatProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.rds.CfnDBProxy.AuthFormatProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "auth", java.util.Objects.requireNonNull(value, "auth is required"));
    }

    /**
     * The identifier for the proxy.
     * <p>
     * This name must be unique for all proxies owned by your AWS account in the specified AWS Region . An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbProxyName() {
        return software.amazon.jsii.Kernel.get(this, "dbProxyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the proxy.
     * <p>
     * This name must be unique for all proxies owned by your AWS account in the specified AWS Region . An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbProxyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbProxyName", java.util.Objects.requireNonNull(value, "dbProxyName is required"));
    }

    /**
     * The kinds of databases that the proxy can connect to.
     * <p>
     * This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
     * <p>
     * <em>Valid values</em> : <code>MYSQL</code> | <code>POSTGRESQL</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngineFamily() {
        return software.amazon.jsii.Kernel.get(this, "engineFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The kinds of databases that the proxy can connect to.
     * <p>
     * This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
     * <p>
     * <em>Valid values</em> : <code>MYSQL</code> | <code>POSTGRESQL</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineFamily(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineFamily", java.util.Objects.requireNonNull(value, "engineFamily is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVpcSubnetIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "vpcSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSubnetIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSubnetIds", java.util.Objects.requireNonNull(value, "vpcSubnetIds is required"));
    }

    /**
     * Whether the proxy includes detailed information about SQL statements in its logs.
     * <p>
     * This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDebugLogging() {
        return software.amazon.jsii.Kernel.get(this, "debugLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the proxy includes detailed information about SQL statements in its logs.
     * <p>
     * This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDebugLogging(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "debugLogging", value);
    }

    /**
     * Whether the proxy includes detailed information about SQL statements in its logs.
     * <p>
     * This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDebugLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "debugLogging", value);
    }

    /**
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
     * <p>
     * You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIdleClientTimeout() {
        return software.amazon.jsii.Kernel.get(this, "idleClientTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
     * <p>
     * You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdleClientTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "idleClientTimeout", value);
    }

    /**
     * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
     * <p>
     * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequireTls() {
        return software.amazon.jsii.Kernel.get(this, "requireTls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
     * <p>
     * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequireTls(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "requireTls", value);
    }

    /**
     * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
     * <p>
     * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequireTls(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "requireTls", value);
    }

    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * One or more VPC security group IDs to associate with the new proxy.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more VPC security group IDs to associate with the new proxy.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroupIds", value);
    }
    /**
     * Specifies the details of authentication used by a proxy to log in as a specific database user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * AuthFormatProperty authFormatProperty = AuthFormatProperty.builder()
     *         .authScheme("authScheme")
     *         .description("description")
     *         .iamAuth("iamAuth")
     *         .secretArn("secretArn")
     *         .userName("userName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxy.AuthFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
         * <p>
         * Valid Values: <code>SECRETS</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthScheme() {
            return null;
        }

        /**
         * A user-specified description about the authentication used by a proxy to log in as a specific database user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy.
         * <p>
         * Valid Values: <code>DISABLED | REQUIRED</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIamAuth() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster.
         * <p>
         * These secrets are stored within Amazon Secrets Manager.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * The name of the database user to which the proxy connects.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthFormatProperty> {
            java.lang.String authScheme;
            java.lang.String description;
            java.lang.String iamAuth;
            java.lang.String secretArn;
            java.lang.String userName;

            /**
             * Sets the value of {@link AuthFormatProperty#getAuthScheme}
             * @param authScheme The type of authentication that the proxy uses for connections from the proxy to the underlying database.
             *                   Valid Values: <code>SECRETS</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authScheme(java.lang.String authScheme) {
                this.authScheme = authScheme;
                return this;
            }

            /**
             * Sets the value of {@link AuthFormatProperty#getDescription}
             * @param description A user-specified description about the authentication used by a proxy to log in as a specific database user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AuthFormatProperty#getIamAuth}
             * @param iamAuth Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy.
             *                Valid Values: <code>DISABLED | REQUIRED</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamAuth(java.lang.String iamAuth) {
                this.iamAuth = iamAuth;
                return this;
            }

            /**
             * Sets the value of {@link AuthFormatProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster.
             *                  These secrets are stored within Amazon Secrets Manager.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthFormatProperty#getUserName}
             * @param userName The name of the database user to which the proxy connects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userName(java.lang.String userName) {
                this.userName = userName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthFormatProperty {
            private final java.lang.String authScheme;
            private final java.lang.String description;
            private final java.lang.String iamAuth;
            private final java.lang.String secretArn;
            private final java.lang.String userName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authScheme = software.amazon.jsii.Kernel.get(this, "authScheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamAuth = software.amazon.jsii.Kernel.get(this, "iamAuth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authScheme = builder.authScheme;
                this.description = builder.description;
                this.iamAuth = builder.iamAuth;
                this.secretArn = builder.secretArn;
                this.userName = builder.userName;
            }

            @Override
            public final java.lang.String getAuthScheme() {
                return this.authScheme;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getIamAuth() {
                return this.iamAuth;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getUserName() {
                return this.userName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthScheme() != null) {
                    data.set("authScheme", om.valueToTree(this.getAuthScheme()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getIamAuth() != null) {
                    data.set("iamAuth", om.valueToTree(this.getIamAuth()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }
                if (this.getUserName() != null) {
                    data.set("userName", om.valueToTree(this.getUserName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBProxy.AuthFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthFormatProperty.Jsii$Proxy that = (AuthFormatProperty.Jsii$Proxy) o;

                if (this.authScheme != null ? !this.authScheme.equals(that.authScheme) : that.authScheme != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.iamAuth != null ? !this.iamAuth.equals(that.iamAuth) : that.iamAuth != null) return false;
                if (this.secretArn != null ? !this.secretArn.equals(that.secretArn) : that.secretArn != null) return false;
                return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authScheme != null ? this.authScheme.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.iamAuth != null ? this.iamAuth.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata assigned to a DB proxy consisting of a key-value pair.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * TagFormatProperty tagFormatProperty = TagFormatProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxy.TagFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A key is the required name of the tag.
         * <p>
         * The string value can be 1-128 Unicode characters in length and can't be prefixed with <code>aws:</code> . The string can contain only the set of Unicode letters, digits, white-space, '<em>', '.', '/', '=', '+', '-' (Java regex: "^([\p{L}\p{Z}\p{N}</em>.:/=+-]*)$").
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * A value is the optional value of the tag.
         * <p>
         * The string value can be 1-256 Unicode characters in length and can't be prefixed with <code>aws:</code> . The string can contain only the set of Unicode letters, digits, white-space, '<em>', '.', '/', '=', '+', '-' (Java regex: "^([\p{L}\p{Z}\p{N}</em>.:/=+-]*)$").
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagFormatProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TagFormatProperty#getKey}
             * @param key A key is the required name of the tag.
             *            The string value can be 1-128 Unicode characters in length and can't be prefixed with <code>aws:</code> . The string can contain only the set of Unicode letters, digits, white-space, '<em>', '.', '/', '=', '+', '-' (Java regex: "^([\p{L}\p{Z}\p{N}</em>.:/=+-]*)$").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagFormatProperty#getValue}
             * @param value A value is the optional value of the tag.
             *              The string value can be 1-256 Unicode characters in length and can't be prefixed with <code>aws:</code> . The string can contain only the set of Unicode letters, digits, white-space, '<em>', '.', '/', '=', '+', '-' (Java regex: "^([\p{L}\p{Z}\p{N}</em>.:/=+-]*)$").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFormatProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBProxy.TagFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFormatProperty.Jsii$Proxy that = (TagFormatProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBProxy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBProxy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBProxyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBProxyProps.Builder();
        }

        /**
         * The authorization mechanism that the proxy uses.
         * <p>
         * @return {@code this}
         * @param auth The authorization mechanism that the proxy uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(final software.amazon.awscdk.IResolvable auth) {
            this.props.auth(auth);
            return this;
        }
        /**
         * The authorization mechanism that the proxy uses.
         * <p>
         * @return {@code this}
         * @param auth The authorization mechanism that the proxy uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(final java.util.List<? extends java.lang.Object> auth) {
            this.props.auth(auth);
            return this;
        }

        /**
         * The identifier for the proxy.
         * <p>
         * This name must be unique for all proxies owned by your AWS account in the specified AWS Region . An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         * <p>
         * @return {@code this}
         * @param dbProxyName The identifier for the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyName(final java.lang.String dbProxyName) {
            this.props.dbProxyName(dbProxyName);
            return this;
        }

        /**
         * The kinds of databases that the proxy can connect to.
         * <p>
         * This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
         * <p>
         * <em>Valid values</em> : <code>MYSQL</code> | <code>POSTGRESQL</code>
         * <p>
         * @return {@code this}
         * @param engineFamily The kinds of databases that the proxy can connect to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineFamily(final java.lang.String engineFamily) {
            this.props.engineFamily(engineFamily);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * One or more VPC subnet IDs to associate with the new proxy.
         * <p>
         * @return {@code this}
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnetIds(final java.util.List<java.lang.String> vpcSubnetIds) {
            this.props.vpcSubnetIds(vpcSubnetIds);
            return this;
        }

        /**
         * Whether the proxy includes detailed information about SQL statements in its logs.
         * <p>
         * This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
         * <p>
         * @return {@code this}
         * @param debugLogging Whether the proxy includes detailed information about SQL statements in its logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debugLogging(final java.lang.Boolean debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }
        /**
         * Whether the proxy includes detailed information about SQL statements in its logs.
         * <p>
         * This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
         * <p>
         * @return {@code this}
         * @param debugLogging Whether the proxy includes detailed information about SQL statements in its logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debugLogging(final software.amazon.awscdk.IResolvable debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }

        /**
         * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
         * <p>
         * You can set this value higher or lower than the connection timeout limit for the associated database.
         * <p>
         * @return {@code this}
         * @param idleClientTimeout The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleClientTimeout(final java.lang.Number idleClientTimeout) {
            this.props.idleClientTimeout(idleClientTimeout);
            return this;
        }

        /**
         * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         * <p>
         * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * <p>
         * @return {@code this}
         * @param requireTls A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireTls(final java.lang.Boolean requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }
        /**
         * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         * <p>
         * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * <p>
         * @return {@code this}
         * @param requireTls A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireTls(final software.amazon.awscdk.IResolvable requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }

        /**
         * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         * <p>
         * @return {@code this}
         * @param tags An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * One or more VPC security group IDs to associate with the new proxy.
         * <p>
         * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(final java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBProxy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBProxy build() {
            return new software.amazon.awscdk.services.rds.CfnDBProxy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
