package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a `CfnDBSecurityGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBSecurityGroupProps cfnDBSecurityGroupProps = CfnDBSecurityGroupProps.builder()
 *         .dbSecurityGroupIngress(List.of(IngressProperty.builder()
 *                 .cidrip("cidrip")
 *                 .ec2SecurityGroupId("ec2SecurityGroupId")
 *                 .ec2SecurityGroupName("ec2SecurityGroupName")
 *                 .ec2SecurityGroupOwnerId("ec2SecurityGroupOwnerId")
 *                 .build()))
 *         .groupDescription("groupDescription")
 *         // the properties below are optional
 *         .ec2VpcId("ec2VpcId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.430Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBSecurityGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBSecurityGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBSecurityGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Ingress rules to be applied to the DB security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDbSecurityGroupIngress();

    /**
     * Provides the description of the DB security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupDescription();

    /**
     * The identifier of an Amazon VPC. This property indicates the VPC that this DB security group belongs to.
     * <p>
     * <blockquote>
     * <p>
     * The <code>EC2VpcId</code> property is for backward compatibility with older regions, and is no longer recommended for providing security information to an RDS DB instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2VpcId() {
        return null;
    }

    /**
     * Tags to assign to the DB security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBSecurityGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBSecurityGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBSecurityGroupProps> {
        java.lang.Object dbSecurityGroupIngress;
        java.lang.String groupDescription;
        java.lang.String ec2VpcId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDBSecurityGroupProps#getDbSecurityGroupIngress}
         * @param dbSecurityGroupIngress Ingress rules to be applied to the DB security group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroupIngress(software.amazon.awscdk.IResolvable dbSecurityGroupIngress) {
            this.dbSecurityGroupIngress = dbSecurityGroupIngress;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupProps#getDbSecurityGroupIngress}
         * @param dbSecurityGroupIngress Ingress rules to be applied to the DB security group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroupIngress(java.util.List<? extends java.lang.Object> dbSecurityGroupIngress) {
            this.dbSecurityGroupIngress = dbSecurityGroupIngress;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupProps#getGroupDescription}
         * @param groupDescription Provides the description of the DB security group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupDescription(java.lang.String groupDescription) {
            this.groupDescription = groupDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupProps#getEc2VpcId}
         * @param ec2VpcId The identifier of an Amazon VPC. This property indicates the VPC that this DB security group belongs to.
         *                 <blockquote>
         *                 <p>
         *                 The <code>EC2VpcId</code> property is for backward compatibility with older regions, and is no longer recommended for providing security information to an RDS DB instance.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2VpcId(java.lang.String ec2VpcId) {
            this.ec2VpcId = ec2VpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupProps#getTags}
         * @param tags Tags to assign to the DB security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBSecurityGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBSecurityGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBSecurityGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBSecurityGroupProps {
        private final java.lang.Object dbSecurityGroupIngress;
        private final java.lang.String groupDescription;
        private final java.lang.String ec2VpcId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbSecurityGroupIngress = software.amazon.jsii.Kernel.get(this, "dbSecurityGroupIngress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.groupDescription = software.amazon.jsii.Kernel.get(this, "groupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2VpcId = software.amazon.jsii.Kernel.get(this, "ec2VpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbSecurityGroupIngress = java.util.Objects.requireNonNull(builder.dbSecurityGroupIngress, "dbSecurityGroupIngress is required");
            this.groupDescription = java.util.Objects.requireNonNull(builder.groupDescription, "groupDescription is required");
            this.ec2VpcId = builder.ec2VpcId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDbSecurityGroupIngress() {
            return this.dbSecurityGroupIngress;
        }

        @Override
        public final java.lang.String getGroupDescription() {
            return this.groupDescription;
        }

        @Override
        public final java.lang.String getEc2VpcId() {
            return this.ec2VpcId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbSecurityGroupIngress", om.valueToTree(this.getDbSecurityGroupIngress()));
            data.set("groupDescription", om.valueToTree(this.getGroupDescription()));
            if (this.getEc2VpcId() != null) {
                data.set("ec2VpcId", om.valueToTree(this.getEc2VpcId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBSecurityGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBSecurityGroupProps.Jsii$Proxy that = (CfnDBSecurityGroupProps.Jsii$Proxy) o;

            if (!dbSecurityGroupIngress.equals(that.dbSecurityGroupIngress)) return false;
            if (!groupDescription.equals(that.groupDescription)) return false;
            if (this.ec2VpcId != null ? !this.ec2VpcId.equals(that.ec2VpcId) : that.ec2VpcId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dbSecurityGroupIngress.hashCode();
            result = 31 * result + (this.groupDescription.hashCode());
            result = 31 * result + (this.ec2VpcId != null ? this.ec2VpcId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
