package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::OptionGroup`.
 * <p>
 * The <code>AWS::RDS::OptionGroup</code> resource creates or updates an option group, to enable and configure features that are specific to a particular DB engine.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnOptionGroup cfnOptionGroup = CfnOptionGroup.Builder.create(this, "MyCfnOptionGroup")
 *         .engineName("engineName")
 *         .majorEngineVersion("majorEngineVersion")
 *         .optionGroupDescription("optionGroupDescription")
 *         // the properties below are optional
 *         .optionConfigurations(List.of(OptionConfigurationProperty.builder()
 *                 .optionName("optionName")
 *                 // the properties below are optional
 *                 .dbSecurityGroupMemberships(List.of("dbSecurityGroupMemberships"))
 *                 .optionSettings(List.of(OptionSettingProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .optionVersion("optionVersion")
 *                 .port(123)
 *                 .vpcSecurityGroupMemberships(List.of("vpcSecurityGroupMemberships"))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.435Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnOptionGroup")
public class CfnOptionGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnOptionGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOptionGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnOptionGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::OptionGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOptionGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnOptionGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOptionGroupName() {
        return software.amazon.jsii.Kernel.get(this, "attrOptionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tags to assign to the option group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies the name of the engine that this option group should be associated with.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>mariadb</code></li>
     * <li><code>mysql</code></li>
     * <li><code>oracle-ee</code></li>
     * <li><code>oracle-se2</code></li>
     * <li><code>oracle-se1</code></li>
     * <li><code>oracle-se</code></li>
     * <li><code>postgres</code></li>
     * <li><code>sqlserver-ee</code></li>
     * <li><code>sqlserver-se</code></li>
     * <li><code>sqlserver-ex</code></li>
     * <li><code>sqlserver-web</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngineName() {
        return software.amazon.jsii.Kernel.get(this, "engineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the engine that this option group should be associated with.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>mariadb</code></li>
     * <li><code>mysql</code></li>
     * <li><code>oracle-ee</code></li>
     * <li><code>oracle-se2</code></li>
     * <li><code>oracle-se1</code></li>
     * <li><code>oracle-se</code></li>
     * <li><code>postgres</code></li>
     * <li><code>sqlserver-ee</code></li>
     * <li><code>sqlserver-se</code></li>
     * <li><code>sqlserver-ex</code></li>
     * <li><code>sqlserver-web</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineName", java.util.Objects.requireNonNull(value, "engineName is required"));
    }

    /**
     * Specifies the major version of the engine that this option group should be associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMajorEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "majorEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the major version of the engine that this option group should be associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMajorEngineVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "majorEngineVersion", java.util.Objects.requireNonNull(value, "majorEngineVersion is required"));
    }

    /**
     * The description of the option group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOptionGroupDescription() {
        return software.amazon.jsii.Kernel.get(this, "optionGroupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the option group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionGroupDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "optionGroupDescription", java.util.Objects.requireNonNull(value, "optionGroupDescription is required"));
    }

    /**
     * A list of options and the settings for each option.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOptionConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "optionConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of options and the settings for each option.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "optionConfigurations", value);
    }

    /**
     * A list of options and the settings for each option.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnOptionGroup.OptionConfigurationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.rds.CfnOptionGroup.OptionConfigurationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "optionConfigurations", value);
    }
    /**
     * The `OptionConfiguration` property type specifies an individual option, and its settings, within an `AWS::RDS::OptionGroup` resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * OptionConfigurationProperty optionConfigurationProperty = OptionConfigurationProperty.builder()
     *         .optionName("optionName")
     *         // the properties below are optional
     *         .dbSecurityGroupMemberships(List.of("dbSecurityGroupMemberships"))
     *         .optionSettings(List.of(OptionSettingProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .optionVersion("optionVersion")
     *         .port(123)
     *         .vpcSecurityGroupMemberships(List.of("vpcSecurityGroupMemberships"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnOptionGroup.OptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of options to include in a group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOptionName();

        /**
         * A list of DBSecurityGroupMembership name strings used for this option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbSecurityGroupMemberships() {
            return null;
        }

        /**
         * The option settings to include in an option group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptionSettings() {
            return null;
        }

        /**
         * The version for the option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOptionVersion() {
            return null;
        }

        /**
         * The optional port for the option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * A list of VpcSecurityGroupMembership name strings used for this option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupMemberships() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OptionConfigurationProperty> {
            java.lang.String optionName;
            java.util.List<java.lang.String> dbSecurityGroupMemberships;
            java.lang.Object optionSettings;
            java.lang.String optionVersion;
            java.lang.Number port;
            java.util.List<java.lang.String> vpcSecurityGroupMemberships;

            /**
             * Sets the value of {@link OptionConfigurationProperty#getOptionName}
             * @param optionName The configuration of options to include in a group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionName(java.lang.String optionName) {
                this.optionName = optionName;
                return this;
            }

            /**
             * Sets the value of {@link OptionConfigurationProperty#getDbSecurityGroupMemberships}
             * @param dbSecurityGroupMemberships A list of DBSecurityGroupMembership name strings used for this option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbSecurityGroupMemberships(java.util.List<java.lang.String> dbSecurityGroupMemberships) {
                this.dbSecurityGroupMemberships = dbSecurityGroupMemberships;
                return this;
            }

            /**
             * Sets the value of {@link OptionConfigurationProperty#getOptionSettings}
             * @param optionSettings The option settings to include in an option group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionSettings(software.amazon.awscdk.IResolvable optionSettings) {
                this.optionSettings = optionSettings;
                return this;
            }

            /**
             * Sets the value of {@link OptionConfigurationProperty#getOptionSettings}
             * @param optionSettings The option settings to include in an option group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionSettings(java.util.List<? extends java.lang.Object> optionSettings) {
                this.optionSettings = optionSettings;
                return this;
            }

            /**
             * Sets the value of {@link OptionConfigurationProperty#getOptionVersion}
             * @param optionVersion The version for the option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionVersion(java.lang.String optionVersion) {
                this.optionVersion = optionVersion;
                return this;
            }

            /**
             * Sets the value of {@link OptionConfigurationProperty#getPort}
             * @param port The optional port for the option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link OptionConfigurationProperty#getVpcSecurityGroupMemberships}
             * @param vpcSecurityGroupMemberships A list of VpcSecurityGroupMembership name strings used for this option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSecurityGroupMemberships(java.util.List<java.lang.String> vpcSecurityGroupMemberships) {
                this.vpcSecurityGroupMemberships = vpcSecurityGroupMemberships;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionConfigurationProperty {
            private final java.lang.String optionName;
            private final java.util.List<java.lang.String> dbSecurityGroupMemberships;
            private final java.lang.Object optionSettings;
            private final java.lang.String optionVersion;
            private final java.lang.Number port;
            private final java.util.List<java.lang.String> vpcSecurityGroupMemberships;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.optionName = software.amazon.jsii.Kernel.get(this, "optionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbSecurityGroupMemberships = software.amazon.jsii.Kernel.get(this, "dbSecurityGroupMemberships", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.optionSettings = software.amazon.jsii.Kernel.get(this, "optionSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.optionVersion = software.amazon.jsii.Kernel.get(this, "optionVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.vpcSecurityGroupMemberships = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupMemberships", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.optionName = java.util.Objects.requireNonNull(builder.optionName, "optionName is required");
                this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
                this.optionSettings = builder.optionSettings;
                this.optionVersion = builder.optionVersion;
                this.port = builder.port;
                this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
            }

            @Override
            public final java.lang.String getOptionName() {
                return this.optionName;
            }

            @Override
            public final java.util.List<java.lang.String> getDbSecurityGroupMemberships() {
                return this.dbSecurityGroupMemberships;
            }

            @Override
            public final java.lang.Object getOptionSettings() {
                return this.optionSettings;
            }

            @Override
            public final java.lang.String getOptionVersion() {
                return this.optionVersion;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.util.List<java.lang.String> getVpcSecurityGroupMemberships() {
                return this.vpcSecurityGroupMemberships;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("optionName", om.valueToTree(this.getOptionName()));
                if (this.getDbSecurityGroupMemberships() != null) {
                    data.set("dbSecurityGroupMemberships", om.valueToTree(this.getDbSecurityGroupMemberships()));
                }
                if (this.getOptionSettings() != null) {
                    data.set("optionSettings", om.valueToTree(this.getOptionSettings()));
                }
                if (this.getOptionVersion() != null) {
                    data.set("optionVersion", om.valueToTree(this.getOptionVersion()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getVpcSecurityGroupMemberships() != null) {
                    data.set("vpcSecurityGroupMemberships", om.valueToTree(this.getVpcSecurityGroupMemberships()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnOptionGroup.OptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OptionConfigurationProperty.Jsii$Proxy that = (OptionConfigurationProperty.Jsii$Proxy) o;

                if (!optionName.equals(that.optionName)) return false;
                if (this.dbSecurityGroupMemberships != null ? !this.dbSecurityGroupMemberships.equals(that.dbSecurityGroupMemberships) : that.dbSecurityGroupMemberships != null) return false;
                if (this.optionSettings != null ? !this.optionSettings.equals(that.optionSettings) : that.optionSettings != null) return false;
                if (this.optionVersion != null ? !this.optionVersion.equals(that.optionVersion) : that.optionVersion != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.vpcSecurityGroupMemberships != null ? this.vpcSecurityGroupMemberships.equals(that.vpcSecurityGroupMemberships) : that.vpcSecurityGroupMemberships == null;
            }

            @Override
            public final int hashCode() {
                int result = this.optionName.hashCode();
                result = 31 * result + (this.dbSecurityGroupMemberships != null ? this.dbSecurityGroupMemberships.hashCode() : 0);
                result = 31 * result + (this.optionSettings != null ? this.optionSettings.hashCode() : 0);
                result = 31 * result + (this.optionVersion != null ? this.optionVersion.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.vpcSecurityGroupMemberships != null ? this.vpcSecurityGroupMemberships.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `OptionSetting` property type specifies the value for an option within an `OptionSetting` property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * OptionSettingProperty optionSettingProperty = OptionSettingProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnOptionGroup.OptionSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(OptionSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OptionSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the option that has settings that you can set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The current value of the option setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OptionSettingProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link OptionSettingProperty#getName}
             * @param name The name of the option that has settings that you can set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OptionSettingProperty#getValue}
             * @param value The current value of the option setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OptionSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionSettingProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnOptionGroup.OptionSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OptionSettingProperty.Jsii$Proxy that = (OptionSettingProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnOptionGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnOptionGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnOptionGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnOptionGroupProps.Builder();
        }

        /**
         * Specifies the name of the engine that this option group should be associated with.
         * <p>
         * Valid Values:
         * <p>
         * <ul>
         * <li><code>mariadb</code></li>
         * <li><code>mysql</code></li>
         * <li><code>oracle-ee</code></li>
         * <li><code>oracle-se2</code></li>
         * <li><code>oracle-se1</code></li>
         * <li><code>oracle-se</code></li>
         * <li><code>postgres</code></li>
         * <li><code>sqlserver-ee</code></li>
         * <li><code>sqlserver-se</code></li>
         * <li><code>sqlserver-ex</code></li>
         * <li><code>sqlserver-web</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param engineName Specifies the name of the engine that this option group should be associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineName(final java.lang.String engineName) {
            this.props.engineName(engineName);
            return this;
        }

        /**
         * Specifies the major version of the engine that this option group should be associated with.
         * <p>
         * @return {@code this}
         * @param majorEngineVersion Specifies the major version of the engine that this option group should be associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder majorEngineVersion(final java.lang.String majorEngineVersion) {
            this.props.majorEngineVersion(majorEngineVersion);
            return this;
        }

        /**
         * The description of the option group.
         * <p>
         * @return {@code this}
         * @param optionGroupDescription The description of the option group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroupDescription(final java.lang.String optionGroupDescription) {
            this.props.optionGroupDescription(optionGroupDescription);
            return this;
        }

        /**
         * A list of options and the settings for each option.
         * <p>
         * @return {@code this}
         * @param optionConfigurations A list of options and the settings for each option. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionConfigurations(final software.amazon.awscdk.IResolvable optionConfigurations) {
            this.props.optionConfigurations(optionConfigurations);
            return this;
        }
        /**
         * A list of options and the settings for each option.
         * <p>
         * @return {@code this}
         * @param optionConfigurations A list of options and the settings for each option. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionConfigurations(final java.util.List<? extends java.lang.Object> optionConfigurations) {
            this.props.optionConfigurations(optionConfigurations);
            return this;
        }

        /**
         * Tags to assign to the option group.
         * <p>
         * @return {@code this}
         * @param tags Tags to assign to the option group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnOptionGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnOptionGroup build() {
            return new software.amazon.awscdk.services.rds.CfnOptionGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
