package software.amazon.awscdk.services.resiliencehub;

/**
 * A CloudFormation `AWS::ResilienceHub::App`.
 * <p>
 * Creates a Resilience Hub application. A Resilience Hub application is a collection of AWS resources structured to prevent and recover AWS application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five– AWS CloudFormation stacks, and an appropriate resiliency policy.
 * <p>
 * After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resiliencehub.*;
 * CfnApp cfnApp = CfnApp.Builder.create(this, "MyCfnApp")
 *         .appTemplateBody("appTemplateBody")
 *         .name("name")
 *         .resourceMappings(List.of(ResourceMappingProperty.builder()
 *                 .mappingType("mappingType")
 *                 .physicalResourceId(PhysicalResourceIdProperty.builder()
 *                         .identifier("identifier")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .awsAccountId("awsAccountId")
 *                         .awsRegion("awsRegion")
 *                         .build())
 *                 // the properties below are optional
 *                 .logicalStackName("logicalStackName")
 *                 .resourceName("resourceName")
 *                 .terraformSourceName("terraformSourceName")
 *                 .build()))
 *         // the properties below are optional
 *         .appAssessmentSchedule("appAssessmentSchedule")
 *         .description("description")
 *         .resiliencyPolicyArn("resiliencyPolicyArn")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.569Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp")
public class CfnApp extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnApp(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApp(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.resiliencehub.CfnApp.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ResilienceHub::App`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApp(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.resiliencehub.CfnAppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAppArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAppArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags assigned to the resource.
     * <p>
     * A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A string containing a full Resilience Hub app template body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppTemplateBody() {
        return software.amazon.jsii.Kernel.get(this, "appTemplateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string containing a full Resilience Hub app template body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppTemplateBody(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appTemplateBody", java.util.Objects.requireNonNull(value, "appTemplateBody is required"));
    }

    /**
     * The name for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * An array of ResourceMapping objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResourceMappings() {
        return software.amazon.jsii.Kernel.get(this, "resourceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of ResourceMapping objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceMappings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceMappings", java.util.Objects.requireNonNull(value, "resourceMappings is required"));
    }

    /**
     * An array of ResourceMapping objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceMappings(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "resourceMappings", java.util.Objects.requireNonNull(value, "resourceMappings is required"));
    }

    /**
     * `AWS::ResilienceHub::App.AppAssessmentSchedule`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAppAssessmentSchedule() {
        return software.amazon.jsii.Kernel.get(this, "appAssessmentSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::ResilienceHub::App.AppAssessmentSchedule`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppAssessmentSchedule(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appAssessmentSchedule", value);
    }

    /**
     * The optional description for an app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The optional description for an app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResiliencyPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "resiliencyPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResiliencyPolicyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resiliencyPolicyArn", value);
    }
    /**
     * Defines a physical resource identifier.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resiliencehub.*;
     * PhysicalResourceIdProperty physicalResourceIdProperty = PhysicalResourceIdProperty.builder()
     *         .identifier("identifier")
     *         .type("type")
     *         // the properties below are optional
     *         .awsAccountId("awsAccountId")
     *         .awsRegion("awsRegion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp.PhysicalResourceIdProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalResourceIdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalResourceIdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the physical resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

        /**
         * Specifies the type of physical resource identifier.
         * <p>
         * <ul>
         * <li><strong>Arn</strong> - The resource identifier is an Amazon Resource Name (ARN) .</li>
         * <li><strong>Native</strong> - The resource identifier is a Resilience Hub-native identifier.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The AWS account that owns the physical resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
            return null;
        }

        /**
         * The AWS Region that the physical resource is located in.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalResourceIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalResourceIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalResourceIdProperty> {
            java.lang.String identifier;
            java.lang.String type;
            java.lang.String awsAccountId;
            java.lang.String awsRegion;

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getIdentifier}
             * @param identifier The identifier of the physical resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifier(java.lang.String identifier) {
                this.identifier = identifier;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getType}
             * @param type Specifies the type of physical resource identifier. This parameter is required.
             *             <ul>
             *             <li><strong>Arn</strong> - The resource identifier is an Amazon Resource Name (ARN) .</li>
             *             <li><strong>Native</strong> - The resource identifier is a Resilience Hub-native identifier.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getAwsAccountId}
             * @param awsAccountId The AWS account that owns the physical resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(java.lang.String awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getAwsRegion}
             * @param awsRegion The AWS Region that the physical resource is located in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalResourceIdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalResourceIdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalResourceIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalResourceIdProperty {
            private final java.lang.String identifier;
            private final java.lang.String type;
            private final java.lang.String awsAccountId;
            private final java.lang.String awsRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.awsAccountId = builder.awsAccountId;
                this.awsRegion = builder.awsRegion;
            }

            @Override
            public final java.lang.String getIdentifier() {
                return this.identifier;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getAwsAccountId() {
                return this.awsAccountId;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identifier", om.valueToTree(this.getIdentifier()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAwsAccountId() != null) {
                    data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnApp.PhysicalResourceIdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalResourceIdProperty.Jsii$Proxy that = (PhysicalResourceIdProperty.Jsii$Proxy) o;

                if (!identifier.equals(that.identifier)) return false;
                if (!type.equals(that.type)) return false;
                if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
                return this.awsRegion != null ? this.awsRegion.equals(that.awsRegion) : that.awsRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.identifier.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.awsAccountId != null ? this.awsAccountId.hashCode() : 0);
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a resource mapping.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resiliencehub.*;
     * ResourceMappingProperty resourceMappingProperty = ResourceMappingProperty.builder()
     *         .mappingType("mappingType")
     *         .physicalResourceId(PhysicalResourceIdProperty.builder()
     *                 .identifier("identifier")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .awsAccountId("awsAccountId")
     *                 .awsRegion("awsRegion")
     *                 .build())
     *         // the properties below are optional
     *         .logicalStackName("logicalStackName")
     *         .resourceName("resourceName")
     *         .terraformSourceName("terraformSourceName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp.ResourceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of resource mapping.
         * <p>
         * <ul>
         * <li><strong>AppRegistryApp</strong> - The resource is mapped to another application. The name of the application is contained in the <code>appRegistryAppName</code> property.</li>
         * <li><strong>CfnStack</strong> - The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the <code>logicalStackName</code> property.</li>
         * <li><strong>Resource</strong> - The resource is mapped to another resource. The name of the resource is contained in the <code>resourceName</code> property.</li>
         * <li><strong>ResourceGroup</strong> - The resource is mapped to a resource group. The name of the resource group is contained in the <code>resourceGroupName</code> property.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMappingType();

        /**
         * The identifier of this resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPhysicalResourceId();

        /**
         * The name of the CloudFormation stack this resource is mapped to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogicalStackName() {
            return null;
        }

        /**
         * The name of the resource this resource is mapped to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceName() {
            return null;
        }

        /**
         * `CfnApp.ResourceMappingProperty.TerraformSourceName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTerraformSourceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceMappingProperty> {
            java.lang.String mappingType;
            java.lang.Object physicalResourceId;
            java.lang.String logicalStackName;
            java.lang.String resourceName;
            java.lang.String terraformSourceName;

            /**
             * Sets the value of {@link ResourceMappingProperty#getMappingType}
             * @param mappingType Specifies the type of resource mapping. This parameter is required.
             *                    <ul>
             *                    <li><strong>AppRegistryApp</strong> - The resource is mapped to another application. The name of the application is contained in the <code>appRegistryAppName</code> property.</li>
             *                    <li><strong>CfnStack</strong> - The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the <code>logicalStackName</code> property.</li>
             *                    <li><strong>Resource</strong> - The resource is mapped to another resource. The name of the resource is contained in the <code>resourceName</code> property.</li>
             *                    <li><strong>ResourceGroup</strong> - The resource is mapped to a resource group. The name of the resource group is contained in the <code>resourceGroupName</code> property.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingType(java.lang.String mappingType) {
                this.mappingType = mappingType;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getPhysicalResourceId}
             * @param physicalResourceId The identifier of this resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalResourceId(software.amazon.awscdk.services.resiliencehub.CfnApp.PhysicalResourceIdProperty physicalResourceId) {
                this.physicalResourceId = physicalResourceId;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getPhysicalResourceId}
             * @param physicalResourceId The identifier of this resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalResourceId(software.amazon.awscdk.IResolvable physicalResourceId) {
                this.physicalResourceId = physicalResourceId;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getLogicalStackName}
             * @param logicalStackName The name of the CloudFormation stack this resource is mapped to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalStackName(java.lang.String logicalStackName) {
                this.logicalStackName = logicalStackName;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getResourceName}
             * @param resourceName The name of the resource this resource is mapped to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceName(java.lang.String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getTerraformSourceName}
             * @param terraformSourceName `CfnApp.ResourceMappingProperty.TerraformSourceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terraformSourceName(java.lang.String terraformSourceName) {
                this.terraformSourceName = terraformSourceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceMappingProperty {
            private final java.lang.String mappingType;
            private final java.lang.Object physicalResourceId;
            private final java.lang.String logicalStackName;
            private final java.lang.String resourceName;
            private final java.lang.String terraformSourceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mappingType = software.amazon.jsii.Kernel.get(this, "mappingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.physicalResourceId = software.amazon.jsii.Kernel.get(this, "physicalResourceId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logicalStackName = software.amazon.jsii.Kernel.get(this, "logicalStackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceName = software.amazon.jsii.Kernel.get(this, "resourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terraformSourceName = software.amazon.jsii.Kernel.get(this, "terraformSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mappingType = java.util.Objects.requireNonNull(builder.mappingType, "mappingType is required");
                this.physicalResourceId = java.util.Objects.requireNonNull(builder.physicalResourceId, "physicalResourceId is required");
                this.logicalStackName = builder.logicalStackName;
                this.resourceName = builder.resourceName;
                this.terraformSourceName = builder.terraformSourceName;
            }

            @Override
            public final java.lang.String getMappingType() {
                return this.mappingType;
            }

            @Override
            public final java.lang.Object getPhysicalResourceId() {
                return this.physicalResourceId;
            }

            @Override
            public final java.lang.String getLogicalStackName() {
                return this.logicalStackName;
            }

            @Override
            public final java.lang.String getResourceName() {
                return this.resourceName;
            }

            @Override
            public final java.lang.String getTerraformSourceName() {
                return this.terraformSourceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mappingType", om.valueToTree(this.getMappingType()));
                data.set("physicalResourceId", om.valueToTree(this.getPhysicalResourceId()));
                if (this.getLogicalStackName() != null) {
                    data.set("logicalStackName", om.valueToTree(this.getLogicalStackName()));
                }
                if (this.getResourceName() != null) {
                    data.set("resourceName", om.valueToTree(this.getResourceName()));
                }
                if (this.getTerraformSourceName() != null) {
                    data.set("terraformSourceName", om.valueToTree(this.getTerraformSourceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnApp.ResourceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceMappingProperty.Jsii$Proxy that = (ResourceMappingProperty.Jsii$Proxy) o;

                if (!mappingType.equals(that.mappingType)) return false;
                if (!physicalResourceId.equals(that.physicalResourceId)) return false;
                if (this.logicalStackName != null ? !this.logicalStackName.equals(that.logicalStackName) : that.logicalStackName != null) return false;
                if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) return false;
                return this.terraformSourceName != null ? this.terraformSourceName.equals(that.terraformSourceName) : that.terraformSourceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mappingType.hashCode();
                result = 31 * result + (this.physicalResourceId.hashCode());
                result = 31 * result + (this.logicalStackName != null ? this.logicalStackName.hashCode() : 0);
                result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
                result = 31 * result + (this.terraformSourceName != null ? this.terraformSourceName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.resiliencehub.CfnApp}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.resiliencehub.CfnApp> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.resiliencehub.CfnAppProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.resiliencehub.CfnAppProps.Builder();
        }

        /**
         * A string containing a full Resilience Hub app template body.
         * <p>
         * @return {@code this}
         * @param appTemplateBody A string containing a full Resilience Hub app template body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appTemplateBody(final java.lang.String appTemplateBody) {
            this.props.appTemplateBody(appTemplateBody);
            return this;
        }

        /**
         * The name for the application.
         * <p>
         * @return {@code this}
         * @param name The name for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An array of ResourceMapping objects.
         * <p>
         * @return {@code this}
         * @param resourceMappings An array of ResourceMapping objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(final software.amazon.awscdk.IResolvable resourceMappings) {
            this.props.resourceMappings(resourceMappings);
            return this;
        }
        /**
         * An array of ResourceMapping objects.
         * <p>
         * @return {@code this}
         * @param resourceMappings An array of ResourceMapping objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(final java.util.List<? extends java.lang.Object> resourceMappings) {
            this.props.resourceMappings(resourceMappings);
            return this;
        }

        /**
         * `AWS::ResilienceHub::App.AppAssessmentSchedule`.
         * <p>
         * @return {@code this}
         * @param appAssessmentSchedule `AWS::ResilienceHub::App.AppAssessmentSchedule`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appAssessmentSchedule(final java.lang.String appAssessmentSchedule) {
            this.props.appAssessmentSchedule(appAssessmentSchedule);
            return this;
        }

        /**
         * The optional description for an app.
         * <p>
         * @return {@code this}
         * @param description The optional description for an app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the resiliency policy.
         * <p>
         * @return {@code this}
         * @param resiliencyPolicyArn The Amazon Resource Name (ARN) of the resiliency policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resiliencyPolicyArn(final java.lang.String resiliencyPolicyArn) {
            this.props.resiliencyPolicyArn(resiliencyPolicyArn);
            return this;
        }

        /**
         * The tags assigned to the resource.
         * <p>
         * A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
         * <p>
         * @return {@code this}
         * @param tags The tags assigned to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.resiliencehub.CfnApp}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.resiliencehub.CfnApp build() {
            return new software.amazon.awscdk.services.resiliencehub.CfnApp(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
