package software.amazon.awscdk.services.rum;

/**
 * A CloudFormation `AWS::RUM::AppMonitor`.
 * <p>
 * Creates a CloudWatch RUM app monitor, which you can use to collect telemetry data from your application and send it to CloudWatch RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
 * <p>
 * After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet that I've already generated?</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rum.*;
 * CfnAppMonitor cfnAppMonitor = CfnAppMonitor.Builder.create(this, "MyCfnAppMonitor")
 *         .domain("domain")
 *         .name("name")
 *         // the properties below are optional
 *         .appMonitorConfiguration(AppMonitorConfigurationProperty.builder()
 *                 .allowCookies(false)
 *                 .enableXRay(false)
 *                 .excludedPages(List.of("excludedPages"))
 *                 .favoritePages(List.of("favoritePages"))
 *                 .guestRoleArn("guestRoleArn")
 *                 .identityPoolId("identityPoolId")
 *                 .includedPages(List.of("includedPages"))
 *                 .sessionSampleRate(123)
 *                 .telemetries(List.of("telemetries"))
 *                 .build())
 *         .cwLogEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.714Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitor")
public class CfnAppMonitor extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAppMonitor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAppMonitor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rum.CfnAppMonitor.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RUM::AppMonitor`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAppMonitor(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rum.CfnAppMonitorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Assigns one or more tags (key-value pairs) to the app monitor.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with an app monitor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The top-level internet domain name for which your application has administrative authority.
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The top-level internet domain name for which your application has administrative authority.
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", java.util.Objects.requireNonNull(value, "domain is required"));
    }

    /**
     * A name for the app monitor.
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the app monitor.
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A structure that contains much of the configuration data for the app monitor.
     * <p>
     * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
     * <p>
     * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAppMonitorConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "appMonitorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains much of the configuration data for the app monitor.
     * <p>
     * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
     * <p>
     * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppMonitorConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "appMonitorConfiguration", value);
    }

    /**
     * A structure that contains much of the configuration data for the app monitor.
     * <p>
     * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
     * <p>
     * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppMonitorConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "appMonitorConfiguration", value);
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     * <p>
     * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     * <p>
     * If you omit this parameter, the default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCwLogEnabled() {
        return software.amazon.jsii.Kernel.get(this, "cwLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     * <p>
     * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     * <p>
     * If you omit this parameter, the default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCwLogEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "cwLogEnabled", value);
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     * <p>
     * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     * <p>
     * If you omit this parameter, the default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCwLogEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cwLogEnabled", value);
    }
    /**
     * This structure contains much of the configuration data for the app monitor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rum.*;
     * AppMonitorConfigurationProperty appMonitorConfigurationProperty = AppMonitorConfigurationProperty.builder()
     *         .allowCookies(false)
     *         .enableXRay(false)
     *         .excludedPages(List.of("excludedPages"))
     *         .favoritePages(List.of("favoritePages"))
     *         .guestRoleArn("guestRoleArn")
     *         .identityPoolId("identityPoolId")
     *         .includedPages(List.of("includedPages"))
     *         .sessionSampleRate(123)
     *         .telemetries(List.of("telemetries"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitor.AppMonitorConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AppMonitorConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppMonitorConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you set this to `true` , the CloudWatch RUM web client sets two cookies, a session cookie and a user cookie.
         * <p>
         * The cookies allow the CloudWatch RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowCookies() {
            return null;
        }

        /**
         * If you set this to `true` , CloudWatch RUM sends client-side traces to X-Ray for each sampled session.
         * <p>
         * You can then see traces and segments from these user sessions in the RUM dashboard and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is AWS X-Ray ?</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableXRay() {
            return null;
        }

        /**
         * A list of URLs in your website or application to exclude from RUM data collection.
         * <p>
         * You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedPages() {
            return null;
        }

        /**
         * A list of pages in your application that are to be displayed with a "favorite" icon in the CloudWatch RUM console.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFavoritePages() {
            return null;
        }

        /**
         * The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuestRoleArn() {
            return null;
        }

        /**
         * The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolId() {
            return null;
        }

        /**
         * If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
         * <p>
         * You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedPages() {
            return null;
        }

        /**
         * Specifies the portion of user sessions to use for CloudWatch RUM data collection.
         * <p>
         * Choosing a higher portion gives you more data but also incurs more costs.
         * <p>
         * The range for this value is 0 to 1 inclusive. Setting this to 1 means that 100% of user sessions are sampled, and setting it to 0.1 means that 10% of user sessions are sampled.
         * <p>
         * If you omit this parameter, the default of 0.1 is used, and 10% of sessions will be sampled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSessionSampleRate() {
            return null;
        }

        /**
         * An array that lists the types of telemetry data that this app monitor is to collect.
         * <p>
         * <ul>
         * <li><code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</li>
         * <li><code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</li>
         * <li><code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTelemetries() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AppMonitorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppMonitorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppMonitorConfigurationProperty> {
            java.lang.Object allowCookies;
            java.lang.Object enableXRay;
            java.util.List<java.lang.String> excludedPages;
            java.util.List<java.lang.String> favoritePages;
            java.lang.String guestRoleArn;
            java.lang.String identityPoolId;
            java.util.List<java.lang.String> includedPages;
            java.lang.Number sessionSampleRate;
            java.util.List<java.lang.String> telemetries;

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getAllowCookies}
             * @param allowCookies If you set this to `true` , the CloudWatch RUM web client sets two cookies, a session cookie and a user cookie.
             *                     The cookies allow the CloudWatch RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCookies(java.lang.Boolean allowCookies) {
                this.allowCookies = allowCookies;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getAllowCookies}
             * @param allowCookies If you set this to `true` , the CloudWatch RUM web client sets two cookies, a session cookie and a user cookie.
             *                     The cookies allow the CloudWatch RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCookies(software.amazon.awscdk.IResolvable allowCookies) {
                this.allowCookies = allowCookies;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getEnableXRay}
             * @param enableXRay If you set this to `true` , CloudWatch RUM sends client-side traces to X-Ray for each sampled session.
             *                   You can then see traces and segments from these user sessions in the RUM dashboard and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is AWS X-Ray ?</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableXRay(java.lang.Boolean enableXRay) {
                this.enableXRay = enableXRay;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getEnableXRay}
             * @param enableXRay If you set this to `true` , CloudWatch RUM sends client-side traces to X-Ray for each sampled session.
             *                   You can then see traces and segments from these user sessions in the RUM dashboard and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is AWS X-Ray ?</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableXRay(software.amazon.awscdk.IResolvable enableXRay) {
                this.enableXRay = enableXRay;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getExcludedPages}
             * @param excludedPages A list of URLs in your website or application to exclude from RUM data collection.
             *                      You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedPages(java.util.List<java.lang.String> excludedPages) {
                this.excludedPages = excludedPages;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getFavoritePages}
             * @param favoritePages A list of pages in your application that are to be displayed with a "favorite" icon in the CloudWatch RUM console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder favoritePages(java.util.List<java.lang.String> favoritePages) {
                this.favoritePages = favoritePages;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getGuestRoleArn}
             * @param guestRoleArn The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guestRoleArn(java.lang.String guestRoleArn) {
                this.guestRoleArn = guestRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getIdentityPoolId}
             * @param identityPoolId The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to CloudWatch RUM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityPoolId(java.lang.String identityPoolId) {
                this.identityPoolId = identityPoolId;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getIncludedPages}
             * @param includedPages If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
             *                      You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same app monitor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedPages(java.util.List<java.lang.String> includedPages) {
                this.includedPages = includedPages;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getSessionSampleRate}
             * @param sessionSampleRate Specifies the portion of user sessions to use for CloudWatch RUM data collection.
             *                          Choosing a higher portion gives you more data but also incurs more costs.
             *                          <p>
             *                          The range for this value is 0 to 1 inclusive. Setting this to 1 means that 100% of user sessions are sampled, and setting it to 0.1 means that 10% of user sessions are sampled.
             *                          <p>
             *                          If you omit this parameter, the default of 0.1 is used, and 10% of sessions will be sampled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionSampleRate(java.lang.Number sessionSampleRate) {
                this.sessionSampleRate = sessionSampleRate;
                return this;
            }

            /**
             * Sets the value of {@link AppMonitorConfigurationProperty#getTelemetries}
             * @param telemetries An array that lists the types of telemetry data that this app monitor is to collect.
             *                    <ul>
             *                    <li><code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</li>
             *                    <li><code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</li>
             *                    <li><code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telemetries(java.util.List<java.lang.String> telemetries) {
                this.telemetries = telemetries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppMonitorConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppMonitorConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppMonitorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppMonitorConfigurationProperty {
            private final java.lang.Object allowCookies;
            private final java.lang.Object enableXRay;
            private final java.util.List<java.lang.String> excludedPages;
            private final java.util.List<java.lang.String> favoritePages;
            private final java.lang.String guestRoleArn;
            private final java.lang.String identityPoolId;
            private final java.util.List<java.lang.String> includedPages;
            private final java.lang.Number sessionSampleRate;
            private final java.util.List<java.lang.String> telemetries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowCookies = software.amazon.jsii.Kernel.get(this, "allowCookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableXRay = software.amazon.jsii.Kernel.get(this, "enableXRay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludedPages = software.amazon.jsii.Kernel.get(this, "excludedPages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.favoritePages = software.amazon.jsii.Kernel.get(this, "favoritePages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.guestRoleArn = software.amazon.jsii.Kernel.get(this, "guestRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityPoolId = software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includedPages = software.amazon.jsii.Kernel.get(this, "includedPages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sessionSampleRate = software.amazon.jsii.Kernel.get(this, "sessionSampleRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.telemetries = software.amazon.jsii.Kernel.get(this, "telemetries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowCookies = builder.allowCookies;
                this.enableXRay = builder.enableXRay;
                this.excludedPages = builder.excludedPages;
                this.favoritePages = builder.favoritePages;
                this.guestRoleArn = builder.guestRoleArn;
                this.identityPoolId = builder.identityPoolId;
                this.includedPages = builder.includedPages;
                this.sessionSampleRate = builder.sessionSampleRate;
                this.telemetries = builder.telemetries;
            }

            @Override
            public final java.lang.Object getAllowCookies() {
                return this.allowCookies;
            }

            @Override
            public final java.lang.Object getEnableXRay() {
                return this.enableXRay;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedPages() {
                return this.excludedPages;
            }

            @Override
            public final java.util.List<java.lang.String> getFavoritePages() {
                return this.favoritePages;
            }

            @Override
            public final java.lang.String getGuestRoleArn() {
                return this.guestRoleArn;
            }

            @Override
            public final java.lang.String getIdentityPoolId() {
                return this.identityPoolId;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedPages() {
                return this.includedPages;
            }

            @Override
            public final java.lang.Number getSessionSampleRate() {
                return this.sessionSampleRate;
            }

            @Override
            public final java.util.List<java.lang.String> getTelemetries() {
                return this.telemetries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowCookies() != null) {
                    data.set("allowCookies", om.valueToTree(this.getAllowCookies()));
                }
                if (this.getEnableXRay() != null) {
                    data.set("enableXRay", om.valueToTree(this.getEnableXRay()));
                }
                if (this.getExcludedPages() != null) {
                    data.set("excludedPages", om.valueToTree(this.getExcludedPages()));
                }
                if (this.getFavoritePages() != null) {
                    data.set("favoritePages", om.valueToTree(this.getFavoritePages()));
                }
                if (this.getGuestRoleArn() != null) {
                    data.set("guestRoleArn", om.valueToTree(this.getGuestRoleArn()));
                }
                if (this.getIdentityPoolId() != null) {
                    data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
                }
                if (this.getIncludedPages() != null) {
                    data.set("includedPages", om.valueToTree(this.getIncludedPages()));
                }
                if (this.getSessionSampleRate() != null) {
                    data.set("sessionSampleRate", om.valueToTree(this.getSessionSampleRate()));
                }
                if (this.getTelemetries() != null) {
                    data.set("telemetries", om.valueToTree(this.getTelemetries()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rum.CfnAppMonitor.AppMonitorConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppMonitorConfigurationProperty.Jsii$Proxy that = (AppMonitorConfigurationProperty.Jsii$Proxy) o;

                if (this.allowCookies != null ? !this.allowCookies.equals(that.allowCookies) : that.allowCookies != null) return false;
                if (this.enableXRay != null ? !this.enableXRay.equals(that.enableXRay) : that.enableXRay != null) return false;
                if (this.excludedPages != null ? !this.excludedPages.equals(that.excludedPages) : that.excludedPages != null) return false;
                if (this.favoritePages != null ? !this.favoritePages.equals(that.favoritePages) : that.favoritePages != null) return false;
                if (this.guestRoleArn != null ? !this.guestRoleArn.equals(that.guestRoleArn) : that.guestRoleArn != null) return false;
                if (this.identityPoolId != null ? !this.identityPoolId.equals(that.identityPoolId) : that.identityPoolId != null) return false;
                if (this.includedPages != null ? !this.includedPages.equals(that.includedPages) : that.includedPages != null) return false;
                if (this.sessionSampleRate != null ? !this.sessionSampleRate.equals(that.sessionSampleRate) : that.sessionSampleRate != null) return false;
                return this.telemetries != null ? this.telemetries.equals(that.telemetries) : that.telemetries == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowCookies != null ? this.allowCookies.hashCode() : 0;
                result = 31 * result + (this.enableXRay != null ? this.enableXRay.hashCode() : 0);
                result = 31 * result + (this.excludedPages != null ? this.excludedPages.hashCode() : 0);
                result = 31 * result + (this.favoritePages != null ? this.favoritePages.hashCode() : 0);
                result = 31 * result + (this.guestRoleArn != null ? this.guestRoleArn.hashCode() : 0);
                result = 31 * result + (this.identityPoolId != null ? this.identityPoolId.hashCode() : 0);
                result = 31 * result + (this.includedPages != null ? this.includedPages.hashCode() : 0);
                result = 31 * result + (this.sessionSampleRate != null ? this.sessionSampleRate.hashCode() : 0);
                result = 31 * result + (this.telemetries != null ? this.telemetries.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rum.CfnAppMonitor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rum.CfnAppMonitor> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rum.CfnAppMonitorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rum.CfnAppMonitorProps.Builder();
        }

        /**
         * The top-level internet domain name for which your application has administrative authority.
         * <p>
         * This parameter is required.
         * <p>
         * @return {@code this}
         * @param domain The top-level internet domain name for which your application has administrative authority. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props.domain(domain);
            return this;
        }

        /**
         * A name for the app monitor.
         * <p>
         * This parameter is required.
         * <p>
         * @return {@code this}
         * @param name A name for the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A structure that contains much of the configuration data for the app monitor.
         * <p>
         * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         * <p>
         * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * <p>
         * @return {@code this}
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(final software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty appMonitorConfiguration) {
            this.props.appMonitorConfiguration(appMonitorConfiguration);
            return this;
        }
        /**
         * A structure that contains much of the configuration data for the app monitor.
         * <p>
         * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         * <p>
         * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * <p>
         * @return {@code this}
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(final software.amazon.awscdk.IResolvable appMonitorConfiguration) {
            this.props.appMonitorConfiguration(appMonitorConfiguration);
            return this;
        }

        /**
         * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         * <p>
         * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         * <p>
         * If you omit this parameter, the default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(final java.lang.Boolean cwLogEnabled) {
            this.props.cwLogEnabled(cwLogEnabled);
            return this;
        }
        /**
         * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         * <p>
         * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         * <p>
         * If you omit this parameter, the default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(final software.amazon.awscdk.IResolvable cwLogEnabled) {
            this.props.cwLogEnabled(cwLogEnabled);
            return this;
        }

        /**
         * Assigns one or more tags (key-value pairs) to the app monitor.
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * <p>
         * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         * <p>
         * You can associate as many as 50 tags with an app monitor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * <p>
         * @return {@code this}
         * @param tags Assigns one or more tags (key-value pairs) to the app monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rum.CfnAppMonitor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rum.CfnAppMonitor build() {
            return new software.amazon.awscdk.services.rum.CfnAppMonitor(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
