package software.amazon.awscdk.services.s3.deployment;

/**
 * Custom user defined metadata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket websiteBucket = Bucket.Builder.create(this, "WebsiteBucket")
 *         .websiteIndexDocument("index.html")
 *         .publicReadAccess(true)
 *         .build();
 * BucketDeployment.Builder.create(this, "DeployWebsite")
 *         .sources(List.of(Source.asset("./website-dist")))
 *         .destinationBucket(websiteBucket)
 *         .destinationKeyPrefix("web/static") // optional prefix in destination bucket
 *         .metadata(UserDefinedObjectMetadata.builder().A("1").b("2").build()) // user-defined metadata
 *         // system-defined metadata
 *         .contentType("text/html")
 *         .contentLanguage("en")
 *         .storageClass(StorageClass.INTELLIGENT_TIERING)
 *         .serverSideEncryption(ServerSideEncryption.AES_256)
 *         .cacheControl(List.of(CacheControl.setPublic(), CacheControl.maxAge(Duration.hours(1))))
 *         .accessControl(BucketAccessControl.BUCKET_OWNER_FULL_CONTROL)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:57.817Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.UserDefinedObjectMetadata")
@software.amazon.jsii.Jsii.Proxy(UserDefinedObjectMetadata.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserDefinedObjectMetadata extends software.amazon.jsii.JsiiSerializable {

    /**
     * @return a {@link Builder} of {@link UserDefinedObjectMetadata}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserDefinedObjectMetadata}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserDefinedObjectMetadata> {

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserDefinedObjectMetadata}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserDefinedObjectMetadata build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserDefinedObjectMetadata}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserDefinedObjectMetadata {

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_deployment.UserDefinedObjectMetadata"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }
    }
}
