package software.amazon.awscdk.services.stepfunctions;

/**
 * Predefined error strings Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Errors errors = new Errors();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:58.342Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Errors")
public class Errors extends software.amazon.jsii.JsiiObject {

    protected Errors(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Errors(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "ALL", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        BRANCH_FAILED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "BRANCH_FAILED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        HEARTBEAT_TIMEOUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "HEARTBEAT_TIMEOUT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NO_CHOICE_MATCHED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "NO_CHOICE_MATCHED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        PARAMETER_PATH_FAILURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "PARAMETER_PATH_FAILURE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        PERMISSIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "PERMISSIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RESULT_PATH_MATCH_FAILURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "RESULT_PATH_MATCH_FAILURE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        TASKS_FAILED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "TASKS_FAILED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        TIMEOUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "TIMEOUT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Errors() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Matches any Error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ALL;

    /**
     * A branch of a Parallel state failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String BRANCH_FAILED;

    /**
     * A Task State failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String HEARTBEAT_TIMEOUT;

    /**
     * A Choice state failed to find a match for the condition field extracted from its input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NO_CHOICE_MATCHED;

    /**
     * Within a state’s “Parameters” field, the attempt to replace a field whose name ends in “.$” using a Path failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PARAMETER_PATH_FAILURE;

    /**
     * A Task State failed because it had insufficient privileges to execute the specified code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PERMISSIONS;

    /**
     * A Task State’s “ResultPath” field cannot be applied to the input the state received.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RESULT_PATH_MATCH_FAILURE;

    /**
     * A Task State failed during the execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String TASKS_FAILED;

    /**
     * A Task State either ran longer than the “TimeoutSeconds” value, or failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String TIMEOUT;
}
