package software.amazon.awscdk.triggers;

/**
 * Triggers an AWS Lambda function during deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.triggers.*;
 * import software.constructs.*;
 * Construct construct;
 * Function function_;
 * Trigger trigger = Trigger.Builder.create(this, "MyTrigger")
 *         .handler(function_)
 *         // the properties below are optional
 *         .executeAfter(List.of(construct))
 *         .executeBefore(List.of(construct))
 *         .executeOnHandlerChange(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:00:58.882Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.triggers.Trigger")
public class Trigger extends software.constructs.Construct implements software.amazon.awscdk.triggers.ITrigger {

    protected Trigger(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Trigger(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Trigger(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.triggers.TriggerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds trigger dependencies.
     * <p>
     * Execute this trigger only after these construct
     * scopes have been provisioned.
     * <p>
     * @param scopes This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void executeAfter(final @org.jetbrains.annotations.NotNull software.constructs.Construct... scopes) {
        software.amazon.jsii.Kernel.call(this, "executeAfter", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(scopes).toArray(Object[]::new));
    }

    /**
     * Adds this trigger as a dependency on other constructs.
     * <p>
     * This means that this
     * trigger will get executed <em>before</em> the given construct(s).
     * <p>
     * @param scopes This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void executeBefore(final @org.jetbrains.annotations.NotNull software.constructs.Construct... scopes) {
        software.amazon.jsii.Kernel.call(this, "executeBefore", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(scopes).toArray(Object[]::new));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.triggers.Trigger}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.triggers.Trigger> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.triggers.TriggerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.triggers.TriggerProps.Builder();
        }

        /**
         * Adds trigger dependencies. Execute this trigger only after these construct scopes have been provisioned.
         * <p>
         * You can also use <code>trigger.executeAfter()</code> to add additional dependencies.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param executeAfter Adds trigger dependencies. Execute this trigger only after these construct scopes have been provisioned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executeAfter(final java.util.List<? extends software.constructs.Construct> executeAfter) {
            this.props.executeAfter(executeAfter);
            return this;
        }

        /**
         * Adds this trigger as a dependency on other constructs.
         * <p>
         * This means that this
         * trigger will get executed <em>before</em> the given construct(s).
         * <p>
         * You can also use <code>trigger.executeBefore()</code> to add additional dependants.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param executeBefore Adds this trigger as a dependency on other constructs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executeBefore(final java.util.List<? extends software.constructs.Construct> executeBefore) {
            this.props.executeBefore(executeBefore);
            return this;
        }

        /**
         * Re-executes the trigger every time the handler changes.
         * <p>
         * This implies that the trigger is associated with the <code>currentVersion</code> of
         * the handler, which gets recreated every time the handler or its
         * configuration is updated.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param executeOnHandlerChange Re-executes the trigger every time the handler changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executeOnHandlerChange(final java.lang.Boolean executeOnHandlerChange) {
            this.props.executeOnHandlerChange(executeOnHandlerChange);
            return this;
        }

        /**
         * The AWS Lambda function of the handler to execute.
         * <p>
         * @return {@code this}
         * @param handler The AWS Lambda function of the handler to execute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final software.amazon.awscdk.services.lambda.Function handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.triggers.Trigger}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.triggers.Trigger build() {
            return new software.amazon.awscdk.triggers.Trigger(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
