/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint")
public class CfnClientVpnEndpoint
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnClientVpnEndpoint.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnClientVpnEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnClientVpnEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnClientVpnEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull CfnClientVpnEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getAuthenticationOptions() {
        return Kernel.get((Object)this, (String)"authenticationOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAuthenticationOptions(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"authenticationOptions", (Object)Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    public void setAuthenticationOptions(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof ClientAuthenticationRequestProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"authenticationOptions", Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    @NotNull
    public String getClientCidrBlock() {
        return (String)Kernel.get((Object)this, (String)"clientCidrBlock", (NativeType)NativeType.forClass(String.class));
    }

    public void setClientCidrBlock(@NotNull String value) {
        Kernel.set((Object)this, (String)"clientCidrBlock", (Object)Objects.requireNonNull(value, "clientCidrBlock is required"));
    }

    @NotNull
    public Object getConnectionLogOptions() {
        return Kernel.get((Object)this, (String)"connectionLogOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConnectionLogOptions(@NotNull ConnectionLogOptionsProperty value) {
        Kernel.set((Object)this, (String)"connectionLogOptions", (Object)Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    public void setConnectionLogOptions(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"connectionLogOptions", (Object)Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    @NotNull
    public String getServerCertificateArn() {
        return (String)Kernel.get((Object)this, (String)"serverCertificateArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setServerCertificateArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"serverCertificateArn", (Object)Objects.requireNonNull(value, "serverCertificateArn is required"));
    }

    @Nullable
    public Object getClientConnectOptions() {
        return Kernel.get((Object)this, (String)"clientConnectOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClientConnectOptions(@Nullable ClientConnectOptionsProperty value) {
        Kernel.set((Object)this, (String)"clientConnectOptions", (Object)value);
    }

    public void setClientConnectOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"clientConnectOptions", (Object)value);
    }

    @Nullable
    public Object getClientLoginBannerOptions() {
        return Kernel.get((Object)this, (String)"clientLoginBannerOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClientLoginBannerOptions(@Nullable ClientLoginBannerOptionsProperty value) {
        Kernel.set((Object)this, (String)"clientLoginBannerOptions", (Object)value);
    }

    public void setClientLoginBannerOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"clientLoginBannerOptions", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public List<String> getDnsServers() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"dnsServers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setDnsServers(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"dnsServers", value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"securityGroupIds", value);
    }

    @Nullable
    public String getSelfServicePortal() {
        return (String)Kernel.get((Object)this, (String)"selfServicePortal", (NativeType)NativeType.forClass(String.class));
    }

    public void setSelfServicePortal(@Nullable String value) {
        Kernel.set((Object)this, (String)"selfServicePortal", (Object)value);
    }

    @Nullable
    public Number getSessionTimeoutHours() {
        return (Number)Kernel.get((Object)this, (String)"sessionTimeoutHours", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSessionTimeoutHours(@Nullable Number value) {
        Kernel.set((Object)this, (String)"sessionTimeoutHours", (Object)value);
    }

    @Nullable
    public Object getSplitTunnel() {
        return Kernel.get((Object)this, (String)"splitTunnel", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSplitTunnel(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"splitTunnel", (Object)value);
    }

    public void setSplitTunnel(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"splitTunnel", (Object)value);
    }

    @Nullable
    public Object getTagSpecifications() {
        return Kernel.get((Object)this, (String)"tagSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTagSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"tagSpecifications", (Object)value);
    }

    public void setTagSpecifications(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof TagSpecificationProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.TagSpecificationProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"tagSpecifications", value);
    }

    @Nullable
    public String getTransportProtocol() {
        return (String)Kernel.get((Object)this, (String)"transportProtocol", (NativeType)NativeType.forClass(String.class));
    }

    public void setTransportProtocol(@Nullable String value) {
        Kernel.set((Object)this, (String)"transportProtocol", (Object)value);
    }

    @Nullable
    public String getVpcId() {
        return (String)Kernel.get((Object)this, (String)"vpcId", (NativeType)NativeType.forClass(String.class));
    }

    public void setVpcId(@Nullable String value) {
        Kernel.set((Object)this, (String)"vpcId", (Object)value);
    }

    @Nullable
    public Number getVpnPort() {
        return (Number)Kernel.get((Object)this, (String)"vpnPort", (NativeType)NativeType.forClass(Number.class));
    }

    public void setVpnPort(@Nullable Number value) {
        Kernel.set((Object)this, (String)"vpnPort", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnClientVpnEndpoint> {
        private final Construct scope;
        private final String id;
        private final CfnClientVpnEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClientVpnEndpointProps.Builder();
        }

        public Builder authenticationOptions(IResolvable authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }

        public Builder authenticationOptions(List<? extends Object> authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }

        public Builder clientCidrBlock(String clientCidrBlock) {
            this.props.clientCidrBlock(clientCidrBlock);
            return this;
        }

        public Builder connectionLogOptions(ConnectionLogOptionsProperty connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }

        public Builder connectionLogOptions(IResolvable connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }

        public Builder serverCertificateArn(String serverCertificateArn) {
            this.props.serverCertificateArn(serverCertificateArn);
            return this;
        }

        public Builder clientConnectOptions(ClientConnectOptionsProperty clientConnectOptions) {
            this.props.clientConnectOptions(clientConnectOptions);
            return this;
        }

        public Builder clientConnectOptions(IResolvable clientConnectOptions) {
            this.props.clientConnectOptions(clientConnectOptions);
            return this;
        }

        public Builder clientLoginBannerOptions(ClientLoginBannerOptionsProperty clientLoginBannerOptions) {
            this.props.clientLoginBannerOptions(clientLoginBannerOptions);
            return this;
        }

        public Builder clientLoginBannerOptions(IResolvable clientLoginBannerOptions) {
            this.props.clientLoginBannerOptions(clientLoginBannerOptions);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder selfServicePortal(String selfServicePortal) {
            this.props.selfServicePortal(selfServicePortal);
            return this;
        }

        public Builder sessionTimeoutHours(Number sessionTimeoutHours) {
            this.props.sessionTimeoutHours(sessionTimeoutHours);
            return this;
        }

        public Builder splitTunnel(Boolean splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }

        public Builder splitTunnel(IResolvable splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }

        public Builder tagSpecifications(IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder transportProtocol(String transportProtocol) {
            this.props.transportProtocol(transportProtocol);
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        public Builder vpnPort(Number vpnPort) {
            this.props.vpnPort(vpnPort);
            return this;
        }

        public CfnClientVpnEndpoint build() {
            return new CfnClientVpnEndpoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.TagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceType();

        @NotNull
        public List<CfnTag> getTags();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            String resourceType;
            List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public TagSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FederatedAuthenticationRequestProperty
    extends JsiiSerializable {
        @NotNull
        public String getSamlProviderArn();

        @Nullable
        default public String getSelfServiceSamlProviderArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FederatedAuthenticationRequestProperty> {
            String samlProviderArn;
            String selfServiceSamlProviderArn;

            public Builder samlProviderArn(String samlProviderArn) {
                this.samlProviderArn = samlProviderArn;
                return this;
            }

            public Builder selfServiceSamlProviderArn(String selfServiceSamlProviderArn) {
                this.selfServiceSamlProviderArn = selfServiceSamlProviderArn;
                return this;
            }

            public FederatedAuthenticationRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DirectoryServiceAuthenticationRequestProperty
    extends JsiiSerializable {
        @NotNull
        public String getDirectoryId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DirectoryServiceAuthenticationRequestProperty> {
            String directoryId;

            public Builder directoryId(String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            public DirectoryServiceAuthenticationRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionLogOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getCloudwatchLogGroup() {
            return null;
        }

        @Nullable
        default public String getCloudwatchLogStream() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectionLogOptionsProperty> {
            Object enabled;
            String cloudwatchLogGroup;
            String cloudwatchLogStream;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder cloudwatchLogGroup(String cloudwatchLogGroup) {
                this.cloudwatchLogGroup = cloudwatchLogGroup;
                return this;
            }

            public Builder cloudwatchLogStream(String cloudwatchLogStream) {
                this.cloudwatchLogStream = cloudwatchLogStream;
                return this;
            }

            public ConnectionLogOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.ClientLoginBannerOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClientLoginBannerOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getBannerText() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClientLoginBannerOptionsProperty> {
            Object enabled;
            String bannerText;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder bannerText(String bannerText) {
                this.bannerText = bannerText;
                return this;
            }

            public ClientLoginBannerOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.ClientConnectOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClientConnectOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getLambdaFunctionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClientConnectOptionsProperty> {
            Object enabled;
            String lambdaFunctionArn;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder lambdaFunctionArn(String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            public ClientConnectOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClientAuthenticationRequestProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getActiveDirectory() {
            return null;
        }

        @Nullable
        default public Object getFederatedAuthentication() {
            return null;
        }

        @Nullable
        default public Object getMutualAuthentication() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClientAuthenticationRequestProperty> {
            String type;
            Object activeDirectory;
            Object federatedAuthentication;
            Object mutualAuthentication;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder activeDirectory(DirectoryServiceAuthenticationRequestProperty activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            public Builder activeDirectory(IResolvable activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            public Builder federatedAuthentication(FederatedAuthenticationRequestProperty federatedAuthentication) {
                this.federatedAuthentication = federatedAuthentication;
                return this;
            }

            public Builder federatedAuthentication(IResolvable federatedAuthentication) {
                this.federatedAuthentication = federatedAuthentication;
                return this;
            }

            public Builder mutualAuthentication(CertificateAuthenticationRequestProperty mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            public Builder mutualAuthentication(IResolvable mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            public ClientAuthenticationRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CertificateAuthenticationRequestProperty
    extends JsiiSerializable {
        @NotNull
        public String getClientRootCertificateChainArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CertificateAuthenticationRequestProperty> {
            String clientRootCertificateChainArn;

            public Builder clientRootCertificateChainArn(String clientRootCertificateChainArn) {
                this.clientRootCertificateChainArn = clientRootCertificateChainArn;
                return this;
            }

            public CertificateAuthenticationRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

