/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.route53.CfnHealthCheck;
import software.amazon.awscdk.services.route53.CfnHealthCheckProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_route53.CfnHealthCheck")
public class CfnHealthCheck
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnHealthCheck.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnHealthCheck(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnHealthCheck(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnHealthCheck(@NotNull Construct scope, @NotNull String id, @NotNull CfnHealthCheckProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrHealthCheckId() {
        return (String)Kernel.get((Object)this, (String)"attrHealthCheckId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getHealthCheckConfig() {
        return Kernel.get((Object)this, (String)"healthCheckConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthCheckConfig(@NotNull HealthCheckConfigProperty value) {
        Kernel.set((Object)this, (String)"healthCheckConfig", (Object)Objects.requireNonNull(value, "healthCheckConfig is required"));
    }

    public void setHealthCheckConfig(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"healthCheckConfig", (Object)Objects.requireNonNull(value, "healthCheckConfig is required"));
    }

    @Nullable
    public Object getHealthCheckTags() {
        return Kernel.get((Object)this, (String)"healthCheckTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthCheckTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"healthCheckTags", (Object)value);
    }

    public void setHealthCheckTags(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof HealthCheckTagProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.route53.CfnHealthCheck.HealthCheckTagProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"healthCheckTags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnHealthCheck> {
        private final Construct scope;
        private final String id;
        private final CfnHealthCheckProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnHealthCheckProps.Builder();
        }

        public Builder healthCheckConfig(HealthCheckConfigProperty healthCheckConfig) {
            this.props.healthCheckConfig(healthCheckConfig);
            return this;
        }

        public Builder healthCheckConfig(IResolvable healthCheckConfig) {
            this.props.healthCheckConfig(healthCheckConfig);
            return this;
        }

        public Builder healthCheckTags(IResolvable healthCheckTags) {
            this.props.healthCheckTags(healthCheckTags);
            return this;
        }

        public Builder healthCheckTags(List<? extends Object> healthCheckTags) {
            this.props.healthCheckTags(healthCheckTags);
            return this;
        }

        public CfnHealthCheck build() {
            return new CfnHealthCheck(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_route53.CfnHealthCheck.HealthCheckTagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckTagProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckTagProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public HealthCheckTagProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_route53.CfnHealthCheck.HealthCheckConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getAlarmIdentifier() {
            return null;
        }

        @Nullable
        default public List<String> getChildHealthChecks() {
            return null;
        }

        @Nullable
        default public Object getEnableSni() {
            return null;
        }

        @Nullable
        default public Number getFailureThreshold() {
            return null;
        }

        @Nullable
        default public String getFullyQualifiedDomainName() {
            return null;
        }

        @Nullable
        default public Number getHealthThreshold() {
            return null;
        }

        @Nullable
        default public String getInsufficientDataHealthStatus() {
            return null;
        }

        @Nullable
        default public Object getInverted() {
            return null;
        }

        @Nullable
        default public String getIpAddress() {
            return null;
        }

        @Nullable
        default public Object getMeasureLatency() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public List<String> getRegions() {
            return null;
        }

        @Nullable
        default public Number getRequestInterval() {
            return null;
        }

        @Nullable
        default public String getResourcePath() {
            return null;
        }

        @Nullable
        default public String getRoutingControlArn() {
            return null;
        }

        @Nullable
        default public String getSearchString() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckConfigProperty> {
            String type;
            Object alarmIdentifier;
            List<String> childHealthChecks;
            Object enableSni;
            Number failureThreshold;
            String fullyQualifiedDomainName;
            Number healthThreshold;
            String insufficientDataHealthStatus;
            Object inverted;
            String ipAddress;
            Object measureLatency;
            Number port;
            List<String> regions;
            Number requestInterval;
            String resourcePath;
            String routingControlArn;
            String searchString;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder alarmIdentifier(AlarmIdentifierProperty alarmIdentifier) {
                this.alarmIdentifier = alarmIdentifier;
                return this;
            }

            public Builder alarmIdentifier(IResolvable alarmIdentifier) {
                this.alarmIdentifier = alarmIdentifier;
                return this;
            }

            public Builder childHealthChecks(List<String> childHealthChecks) {
                this.childHealthChecks = childHealthChecks;
                return this;
            }

            public Builder enableSni(Boolean enableSni) {
                this.enableSni = enableSni;
                return this;
            }

            public Builder enableSni(IResolvable enableSni) {
                this.enableSni = enableSni;
                return this;
            }

            public Builder failureThreshold(Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            public Builder fullyQualifiedDomainName(String fullyQualifiedDomainName) {
                this.fullyQualifiedDomainName = fullyQualifiedDomainName;
                return this;
            }

            public Builder healthThreshold(Number healthThreshold) {
                this.healthThreshold = healthThreshold;
                return this;
            }

            public Builder insufficientDataHealthStatus(String insufficientDataHealthStatus) {
                this.insufficientDataHealthStatus = insufficientDataHealthStatus;
                return this;
            }

            public Builder inverted(Boolean inverted) {
                this.inverted = inverted;
                return this;
            }

            public Builder inverted(IResolvable inverted) {
                this.inverted = inverted;
                return this;
            }

            public Builder ipAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            public Builder measureLatency(Boolean measureLatency) {
                this.measureLatency = measureLatency;
                return this;
            }

            public Builder measureLatency(IResolvable measureLatency) {
                this.measureLatency = measureLatency;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder regions(List<String> regions) {
                this.regions = regions;
                return this;
            }

            public Builder requestInterval(Number requestInterval) {
                this.requestInterval = requestInterval;
                return this;
            }

            public Builder resourcePath(String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            public Builder routingControlArn(String routingControlArn) {
                this.routingControlArn = routingControlArn;
                return this;
            }

            public Builder searchString(String searchString) {
                this.searchString = searchString;
                return this;
            }

            public HealthCheckConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_route53.CfnHealthCheck.AlarmIdentifierProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlarmIdentifierProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getRegion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlarmIdentifierProperty> {
            String name;
            String region;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public AlarmIdentifierProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

