/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudformation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.cloudformation.CfnStackSet;
import software.amazon.awscdk.services.cloudformation.CfnStackSetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudformation.CfnStackSet")
public class CfnStackSet
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStackSet.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnStackSet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStackSet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStackSet(@NotNull Construct scope, @NotNull String id, @NotNull CfnStackSetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrStackSetId() {
        return (String)Kernel.get((Object)this, (String)"attrStackSetId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getManagedExecution() {
        return Kernel.get((Object)this, (String)"managedExecution", (NativeType)NativeType.forClass(Object.class));
    }

    public void setManagedExecution(@NotNull Object value) {
        Kernel.set((Object)this, (String)"managedExecution", (Object)Objects.requireNonNull(value, "managedExecution is required"));
    }

    @NotNull
    public String getPermissionModel() {
        return (String)Kernel.get((Object)this, (String)"permissionModel", (NativeType)NativeType.forClass(String.class));
    }

    public void setPermissionModel(@NotNull String value) {
        Kernel.set((Object)this, (String)"permissionModel", (Object)Objects.requireNonNull(value, "permissionModel is required"));
    }

    @NotNull
    public String getStackSetName() {
        return (String)Kernel.get((Object)this, (String)"stackSetName", (NativeType)NativeType.forClass(String.class));
    }

    public void setStackSetName(@NotNull String value) {
        Kernel.set((Object)this, (String)"stackSetName", (Object)Objects.requireNonNull(value, "stackSetName is required"));
    }

    @Nullable
    public String getAdministrationRoleArn() {
        return (String)Kernel.get((Object)this, (String)"administrationRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setAdministrationRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"administrationRoleArn", (Object)value);
    }

    @Nullable
    public Object getAutoDeployment() {
        return Kernel.get((Object)this, (String)"autoDeployment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoDeployment(@Nullable AutoDeploymentProperty value) {
        Kernel.set((Object)this, (String)"autoDeployment", (Object)value);
    }

    public void setAutoDeployment(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoDeployment", (Object)value);
    }

    @Nullable
    public String getCallAs() {
        return (String)Kernel.get((Object)this, (String)"callAs", (NativeType)NativeType.forClass(String.class));
    }

    public void setCallAs(@Nullable String value) {
        Kernel.set((Object)this, (String)"callAs", (Object)value);
    }

    @Nullable
    public List<String> getCapabilities() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"capabilities", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCapabilities(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"capabilities", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getExecutionRoleName() {
        return (String)Kernel.get((Object)this, (String)"executionRoleName", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutionRoleName(@Nullable String value) {
        Kernel.set((Object)this, (String)"executionRoleName", (Object)value);
    }

    @Nullable
    public Object getOperationPreferences() {
        return Kernel.get((Object)this, (String)"operationPreferences", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOperationPreferences(@Nullable OperationPreferencesProperty value) {
        Kernel.set((Object)this, (String)"operationPreferences", (Object)value);
    }

    public void setOperationPreferences(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"operationPreferences", (Object)value);
    }

    @Nullable
    public Object getParameters() {
        return Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"parameters", (Object)value);
    }

    public void setParameters(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"parameters", value);
    }

    @Nullable
    public Object getStackInstancesGroup() {
        return Kernel.get((Object)this, (String)"stackInstancesGroup", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStackInstancesGroup(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"stackInstancesGroup", (Object)value);
    }

    public void setStackInstancesGroup(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"stackInstancesGroup", value);
    }

    @Nullable
    public String getTemplateBody() {
        return (String)Kernel.get((Object)this, (String)"templateBody", (NativeType)NativeType.forClass(String.class));
    }

    public void setTemplateBody(@Nullable String value) {
        Kernel.set((Object)this, (String)"templateBody", (Object)value);
    }

    @Nullable
    public String getTemplateUrl() {
        return (String)Kernel.get((Object)this, (String)"templateUrl", (NativeType)NativeType.forClass(String.class));
    }

    public void setTemplateUrl(@Nullable String value) {
        Kernel.set((Object)this, (String)"templateUrl", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnStackSet> {
        private final Construct scope;
        private final String id;
        private final CfnStackSetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnStackSetProps.Builder();
        }

        public Builder permissionModel(String permissionModel) {
            this.props.permissionModel(permissionModel);
            return this;
        }

        public Builder stackSetName(String stackSetName) {
            this.props.stackSetName(stackSetName);
            return this;
        }

        public Builder administrationRoleArn(String administrationRoleArn) {
            this.props.administrationRoleArn(administrationRoleArn);
            return this;
        }

        public Builder autoDeployment(AutoDeploymentProperty autoDeployment) {
            this.props.autoDeployment(autoDeployment);
            return this;
        }

        public Builder autoDeployment(IResolvable autoDeployment) {
            this.props.autoDeployment(autoDeployment);
            return this;
        }

        public Builder callAs(String callAs) {
            this.props.callAs(callAs);
            return this;
        }

        public Builder capabilities(List<String> capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder executionRoleName(String executionRoleName) {
            this.props.executionRoleName(executionRoleName);
            return this;
        }

        public Builder managedExecution(Object managedExecution) {
            this.props.managedExecution(managedExecution);
            return this;
        }

        public Builder operationPreferences(OperationPreferencesProperty operationPreferences) {
            this.props.operationPreferences(operationPreferences);
            return this;
        }

        public Builder operationPreferences(IResolvable operationPreferences) {
            this.props.operationPreferences(operationPreferences);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder parameters(List<? extends Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder stackInstancesGroup(IResolvable stackInstancesGroup) {
            this.props.stackInstancesGroup(stackInstancesGroup);
            return this;
        }

        public Builder stackInstancesGroup(List<? extends Object> stackInstancesGroup) {
            this.props.stackInstancesGroup(stackInstancesGroup);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder templateBody(String templateBody) {
            this.props.templateBody(templateBody);
            return this;
        }

        public Builder templateUrl(String templateUrl) {
            this.props.templateUrl(templateUrl);
            return this;
        }

        public CfnStackSet build() {
            return new CfnStackSet(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudformation.CfnStackSet.StackInstancesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StackInstancesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDeploymentTargets();

        @NotNull
        public List<String> getRegions();

        @Nullable
        default public Object getParameterOverrides() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StackInstancesProperty> {
            Object deploymentTargets;
            List<String> regions;
            Object parameterOverrides;

            public Builder deploymentTargets(DeploymentTargetsProperty deploymentTargets) {
                this.deploymentTargets = deploymentTargets;
                return this;
            }

            public Builder deploymentTargets(IResolvable deploymentTargets) {
                this.deploymentTargets = deploymentTargets;
                return this;
            }

            public Builder regions(List<String> regions) {
                this.regions = regions;
                return this;
            }

            public Builder parameterOverrides(IResolvable parameterOverrides) {
                this.parameterOverrides = parameterOverrides;
                return this;
            }

            public Builder parameterOverrides(List<? extends Object> parameterOverrides) {
                this.parameterOverrides = parameterOverrides;
                return this;
            }

            public StackInstancesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudformation.CfnStackSet.ParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterKey();

        @NotNull
        public String getParameterValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterProperty> {
            String parameterKey;
            String parameterValue;

            public Builder parameterKey(String parameterKey) {
                this.parameterKey = parameterKey;
                return this;
            }

            public Builder parameterValue(String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            public ParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudformation.CfnStackSet.OperationPreferencesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OperationPreferencesProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getFailureToleranceCount() {
            return null;
        }

        @Nullable
        default public Number getFailureTolerancePercentage() {
            return null;
        }

        @Nullable
        default public Number getMaxConcurrentCount() {
            return null;
        }

        @Nullable
        default public Number getMaxConcurrentPercentage() {
            return null;
        }

        @Nullable
        default public String getRegionConcurrencyType() {
            return null;
        }

        @Nullable
        default public List<String> getRegionOrder() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OperationPreferencesProperty> {
            Number failureToleranceCount;
            Number failureTolerancePercentage;
            Number maxConcurrentCount;
            Number maxConcurrentPercentage;
            String regionConcurrencyType;
            List<String> regionOrder;

            public Builder failureToleranceCount(Number failureToleranceCount) {
                this.failureToleranceCount = failureToleranceCount;
                return this;
            }

            public Builder failureTolerancePercentage(Number failureTolerancePercentage) {
                this.failureTolerancePercentage = failureTolerancePercentage;
                return this;
            }

            public Builder maxConcurrentCount(Number maxConcurrentCount) {
                this.maxConcurrentCount = maxConcurrentCount;
                return this;
            }

            public Builder maxConcurrentPercentage(Number maxConcurrentPercentage) {
                this.maxConcurrentPercentage = maxConcurrentPercentage;
                return this;
            }

            public Builder regionConcurrencyType(String regionConcurrencyType) {
                this.regionConcurrencyType = regionConcurrencyType;
                return this;
            }

            public Builder regionOrder(List<String> regionOrder) {
                this.regionOrder = regionOrder;
                return this;
            }

            public OperationPreferencesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudformation.CfnStackSet.DeploymentTargetsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentTargetsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAccounts() {
            return null;
        }

        @Nullable
        default public List<String> getOrganizationalUnitIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentTargetsProperty> {
            List<String> accounts;
            List<String> organizationalUnitIds;

            public Builder accounts(List<String> accounts) {
                this.accounts = accounts;
                return this;
            }

            public Builder organizationalUnitIds(List<String> organizationalUnitIds) {
                this.organizationalUnitIds = organizationalUnitIds;
                return this;
            }

            public DeploymentTargetsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudformation.CfnStackSet.AutoDeploymentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoDeploymentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getRetainStacksOnAccountRemoval() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoDeploymentProperty> {
            Object enabled;
            Object retainStacksOnAccountRemoval;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder retainStacksOnAccountRemoval(Boolean retainStacksOnAccountRemoval) {
                this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
                return this;
            }

            public Builder retainStacksOnAccountRemoval(IResolvable retainStacksOnAccountRemoval) {
                this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
                return this;
            }

            public AutoDeploymentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

