/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.AlbController;
import software.amazon.awscdk.services.eks.AlbControllerOptions;
import software.amazon.awscdk.services.eks.AutoScalingGroupCapacityOptions;
import software.amazon.awscdk.services.eks.AutoScalingGroupOptions;
import software.amazon.awscdk.services.eks.AwsAuth;
import software.amazon.awscdk.services.eks.ClusterAttributes;
import software.amazon.awscdk.services.eks.ClusterProps;
import software.amazon.awscdk.services.eks.CoreDnsComputeType;
import software.amazon.awscdk.services.eks.DefaultCapacityType;
import software.amazon.awscdk.services.eks.EndpointAccess;
import software.amazon.awscdk.services.eks.FargateProfile;
import software.amazon.awscdk.services.eks.FargateProfileOptions;
import software.amazon.awscdk.services.eks.HelmChart;
import software.amazon.awscdk.services.eks.HelmChartOptions;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.eks.IngressLoadBalancerAddressOptions;
import software.amazon.awscdk.services.eks.KubernetesManifest;
import software.amazon.awscdk.services.eks.KubernetesManifestOptions;
import software.amazon.awscdk.services.eks.KubernetesVersion;
import software.amazon.awscdk.services.eks.Nodegroup;
import software.amazon.awscdk.services.eks.NodegroupOptions;
import software.amazon.awscdk.services.eks.ServiceAccount;
import software.amazon.awscdk.services.eks.ServiceAccountOptions;
import software.amazon.awscdk.services.eks.ServiceLoadBalancerAddressOptions;
import software.amazon.awscdk.services.iam.IOpenIdConnectProvider;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.ILayerVersion;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_eks.Cluster")
public class Cluster
extends Resource
implements ICluster {
    protected Cluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Cluster(@NotNull Construct scope, @NotNull String id, @NotNull ClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ICluster fromClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ClusterAttributes attrs) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterAttributes", (NativeType)NativeType.forClass(ICluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public AutoScalingGroup addAutoScalingGroupCapacity(@NotNull String id, @NotNull AutoScalingGroupCapacityOptions options) {
        return (AutoScalingGroup)Kernel.call((Object)this, (String)"addAutoScalingGroupCapacity", (NativeType)NativeType.forClass(AutoScalingGroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public KubernetesManifest addCdk8sChart(@NotNull String id, @NotNull Construct chart, @Nullable KubernetesManifestOptions options) {
        return (KubernetesManifest)((Object)Kernel.call((Object)this, (String)"addCdk8sChart", (NativeType)NativeType.forClass(KubernetesManifest.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(chart, "chart is required"), options}));
    }

    @Override
    @NotNull
    public KubernetesManifest addCdk8sChart(@NotNull String id, @NotNull Construct chart) {
        return (KubernetesManifest)((Object)Kernel.call((Object)this, (String)"addCdk8sChart", (NativeType)NativeType.forClass(KubernetesManifest.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(chart, "chart is required")}));
    }

    @NotNull
    public FargateProfile addFargateProfile(@NotNull String id, @NotNull FargateProfileOptions options) {
        return (FargateProfile)Kernel.call((Object)this, (String)"addFargateProfile", (NativeType)NativeType.forClass(FargateProfile.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public HelmChart addHelmChart(@NotNull String id, @NotNull HelmChartOptions options) {
        return (HelmChart)((Object)Kernel.call((Object)this, (String)"addHelmChart", (NativeType)NativeType.forClass(HelmChart.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")}));
    }

    @Override
    @NotNull
    public KubernetesManifest addManifest(@NotNull String id, Map<String, Object> ... manifest) {
        return (KubernetesManifest)((Object)Kernel.call((Object)this, (String)"addManifest", (NativeType)NativeType.forClass(KubernetesManifest.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(id, "id is required")}), Arrays.stream(manifest)).toArray(Object[]::new)));
    }

    @NotNull
    public Nodegroup addNodegroupCapacity(@NotNull String id, @Nullable NodegroupOptions options) {
        return (Nodegroup)Kernel.call((Object)this, (String)"addNodegroupCapacity", (NativeType)NativeType.forClass(Nodegroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @NotNull
    public Nodegroup addNodegroupCapacity(@NotNull String id) {
        return (Nodegroup)Kernel.call((Object)this, (String)"addNodegroupCapacity", (NativeType)NativeType.forClass(Nodegroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public ServiceAccount addServiceAccount(@NotNull String id, @Nullable ServiceAccountOptions options) {
        return (ServiceAccount)Kernel.call((Object)this, (String)"addServiceAccount", (NativeType)NativeType.forClass(ServiceAccount.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public ServiceAccount addServiceAccount(@NotNull String id) {
        return (ServiceAccount)Kernel.call((Object)this, (String)"addServiceAccount", (NativeType)NativeType.forClass(ServiceAccount.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void connectAutoScalingGroupCapacity(@NotNull AutoScalingGroup autoScalingGroup, @NotNull AutoScalingGroupOptions options) {
        Kernel.call((Object)this, (String)"connectAutoScalingGroupCapacity", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public String getIngressLoadBalancerAddress(@NotNull String ingressName, @Nullable IngressLoadBalancerAddressOptions options) {
        return (String)Kernel.call((Object)this, (String)"getIngressLoadBalancerAddress", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(ingressName, "ingressName is required"), options});
    }

    @NotNull
    public String getIngressLoadBalancerAddress(@NotNull String ingressName) {
        return (String)Kernel.call((Object)this, (String)"getIngressLoadBalancerAddress", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(ingressName, "ingressName is required")});
    }

    @NotNull
    public String getServiceLoadBalancerAddress(@NotNull String serviceName, @Nullable ServiceLoadBalancerAddressOptions options) {
        return (String)Kernel.call((Object)this, (String)"getServiceLoadBalancerAddress", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(serviceName, "serviceName is required"), options});
    }

    @NotNull
    public String getServiceLoadBalancerAddress(@NotNull String serviceName) {
        return (String)Kernel.call((Object)this, (String)"getServiceLoadBalancerAddress", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(serviceName, "serviceName is required")});
    }

    @NotNull
    public Role getAdminRole() {
        return (Role)Kernel.get((Object)this, (String)"adminRole", (NativeType)NativeType.forClass(Role.class));
    }

    @NotNull
    public AwsAuth getAwsAuth() {
        return (AwsAuth)((Object)Kernel.get((Object)this, (String)"awsAuth", (NativeType)NativeType.forClass(AwsAuth.class)));
    }

    @Override
    @NotNull
    public String getClusterArn() {
        return (String)Kernel.get((Object)this, (String)"clusterArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterCertificateAuthorityData() {
        return (String)Kernel.get((Object)this, (String)"clusterCertificateAuthorityData", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterEncryptionConfigKeyArn() {
        return (String)Kernel.get((Object)this, (String)"clusterEncryptionConfigKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterEndpoint() {
        return (String)Kernel.get((Object)this, (String)"clusterEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getClusterOpenIdConnectIssuer() {
        return (String)Kernel.get((Object)this, (String)"clusterOpenIdConnectIssuer", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getClusterOpenIdConnectIssuerUrl() {
        return (String)Kernel.get((Object)this, (String)"clusterOpenIdConnectIssuerUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public ISecurityGroup getClusterSecurityGroup() {
        return (ISecurityGroup)Kernel.get((Object)this, (String)"clusterSecurityGroup", (NativeType)NativeType.forClass(ISecurityGroup.class));
    }

    @Override
    @NotNull
    public String getClusterSecurityGroupId() {
        return (String)Kernel.get((Object)this, (String)"clusterSecurityGroupId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public IOpenIdConnectProvider getOpenIdConnectProvider() {
        return (IOpenIdConnectProvider)Kernel.get((Object)this, (String)"openIdConnectProvider", (NativeType)NativeType.forClass(IOpenIdConnectProvider.class));
    }

    @Override
    @NotNull
    public Boolean getPrune() {
        return (Boolean)Kernel.get((Object)this, (String)"prune", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)this, (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    @Nullable
    public AlbController getAlbController() {
        return (AlbController)((Object)Kernel.get((Object)this, (String)"albController", (NativeType)NativeType.forClass(AlbController.class)));
    }

    @Override
    @Nullable
    public ISecurityGroup getClusterHandlerSecurityGroup() {
        return (ISecurityGroup)Kernel.get((Object)this, (String)"clusterHandlerSecurityGroup", (NativeType)NativeType.forClass(ISecurityGroup.class));
    }

    @Nullable
    public AutoScalingGroup getDefaultCapacity() {
        return (AutoScalingGroup)Kernel.get((Object)this, (String)"defaultCapacity", (NativeType)NativeType.forClass(AutoScalingGroup.class));
    }

    @Nullable
    public Nodegroup getDefaultNodegroup() {
        return (Nodegroup)Kernel.get((Object)this, (String)"defaultNodegroup", (NativeType)NativeType.forClass(Nodegroup.class));
    }

    @Override
    @Nullable
    public Map<String, String> getKubectlEnvironment() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"kubectlEnvironment", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Override
    @Nullable
    public IRole getKubectlLambdaRole() {
        return (IRole)Kernel.get((Object)this, (String)"kubectlLambdaRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    public ILayerVersion getKubectlLayer() {
        return (ILayerVersion)Kernel.get((Object)this, (String)"kubectlLayer", (NativeType)NativeType.forClass(ILayerVersion.class));
    }

    @Override
    @Nullable
    public Size getKubectlMemory() {
        return (Size)((Object)Kernel.get((Object)this, (String)"kubectlMemory", (NativeType)NativeType.forClass(Size.class)));
    }

    @Override
    @Nullable
    public List<ISubnet> getKubectlPrivateSubnets() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"kubectlPrivateSubnets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public IRole getKubectlRole() {
        return (IRole)Kernel.get((Object)this, (String)"kubectlRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    public ISecurityGroup getKubectlSecurityGroup() {
        return (ISecurityGroup)Kernel.get((Object)this, (String)"kubectlSecurityGroup", (NativeType)NativeType.forClass(ISecurityGroup.class));
    }

    @Override
    @Nullable
    public ILayerVersion getOnEventLayer() {
        return (ILayerVersion)Kernel.get((Object)this, (String)"onEventLayer", (NativeType)NativeType.forClass(ILayerVersion.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Cluster> {
        private final Construct scope;
        private final String id;
        private final ClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ClusterProps.Builder();
        }

        public Builder version(KubernetesVersion version) {
            this.props.version(version);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder outputClusterName(Boolean outputClusterName) {
            this.props.outputClusterName(outputClusterName);
            return this;
        }

        public Builder outputConfigCommand(Boolean outputConfigCommand) {
            this.props.outputConfigCommand(outputConfigCommand);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder vpcSubnets(List<? extends SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder albController(AlbControllerOptions albController) {
            this.props.albController(albController);
            return this;
        }

        public Builder clusterHandlerEnvironment(Map<String, String> clusterHandlerEnvironment) {
            this.props.clusterHandlerEnvironment(clusterHandlerEnvironment);
            return this;
        }

        public Builder clusterHandlerSecurityGroup(ISecurityGroup clusterHandlerSecurityGroup) {
            this.props.clusterHandlerSecurityGroup(clusterHandlerSecurityGroup);
            return this;
        }

        public Builder coreDnsComputeType(CoreDnsComputeType coreDnsComputeType) {
            this.props.coreDnsComputeType(coreDnsComputeType);
            return this;
        }

        public Builder endpointAccess(EndpointAccess endpointAccess) {
            this.props.endpointAccess(endpointAccess);
            return this;
        }

        public Builder kubectlEnvironment(Map<String, String> kubectlEnvironment) {
            this.props.kubectlEnvironment(kubectlEnvironment);
            return this;
        }

        public Builder kubectlLayer(ILayerVersion kubectlLayer) {
            this.props.kubectlLayer(kubectlLayer);
            return this;
        }

        public Builder kubectlMemory(Size kubectlMemory) {
            this.props.kubectlMemory(kubectlMemory);
            return this;
        }

        public Builder mastersRole(IRole mastersRole) {
            this.props.mastersRole(mastersRole);
            return this;
        }

        public Builder onEventLayer(ILayerVersion onEventLayer) {
            this.props.onEventLayer(onEventLayer);
            return this;
        }

        public Builder outputMastersRoleArn(Boolean outputMastersRoleArn) {
            this.props.outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        public Builder placeClusterHandlerInVpc(Boolean placeClusterHandlerInVpc) {
            this.props.placeClusterHandlerInVpc(placeClusterHandlerInVpc);
            return this;
        }

        public Builder prune(Boolean prune) {
            this.props.prune(prune);
            return this;
        }

        public Builder secretsEncryptionKey(IKey secretsEncryptionKey) {
            this.props.secretsEncryptionKey(secretsEncryptionKey);
            return this;
        }

        public Builder serviceIpv4Cidr(String serviceIpv4Cidr) {
            this.props.serviceIpv4Cidr(serviceIpv4Cidr);
            return this;
        }

        public Builder defaultCapacity(Number defaultCapacity) {
            this.props.defaultCapacity(defaultCapacity);
            return this;
        }

        public Builder defaultCapacityInstance(InstanceType defaultCapacityInstance) {
            this.props.defaultCapacityInstance(defaultCapacityInstance);
            return this;
        }

        public Builder defaultCapacityType(DefaultCapacityType defaultCapacityType) {
            this.props.defaultCapacityType(defaultCapacityType);
            return this;
        }

        public Builder kubectlLambdaRole(IRole kubectlLambdaRole) {
            this.props.kubectlLambdaRole(kubectlLambdaRole);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Cluster build() {
            return new Cluster(this.scope, this.id, this.props.build());
        }
    }
}

