/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.FargatePlatformVersion;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.ITaskDefinition;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.targets.ContainerOverride;
import software.amazon.awscdk.services.events.targets.EcsTaskProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_events_targets.EcsTask")
public class EcsTask
extends JsiiObject
implements IRuleTarget {
    protected EcsTask(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsTask(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EcsTask(@NotNull EcsTaskProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule, @Nullable String _id) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required"), _id});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required")});
    }

    @Nullable
    public List<ISecurityGroup> getSecurityGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISecurityGroup.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsTask> {
        private final EcsTaskProps.Builder props = new EcsTaskProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder taskDefinition(ITaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder containerOverrides(List<? extends ContainerOverride> containerOverrides) {
            this.props.containerOverrides(containerOverrides);
            return this;
        }

        public Builder platformVersion(FargatePlatformVersion platformVersion) {
            this.props.platformVersion(platformVersion);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder taskCount(Number taskCount) {
            this.props.taskCount(taskCount);
            return this;
        }

        public EcsTask build() {
            return new EcsTask(this.props.build());
        }
    }
}

