/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lakeformation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.lakeformation.CfnPermissions;
import software.amazon.awscdk.services.lakeformation.CfnPermissionsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions")
public class CfnPermissions
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnPermissions.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnPermissions(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPermissions(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnPermissions(@NotNull Construct scope, @NotNull String id, @NotNull CfnPermissionsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDataLakePrincipal() {
        return Kernel.get((Object)this, (String)"dataLakePrincipal", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataLakePrincipal(@NotNull DataLakePrincipalProperty value) {
        Kernel.set((Object)this, (String)"dataLakePrincipal", (Object)Objects.requireNonNull(value, "dataLakePrincipal is required"));
    }

    public void setDataLakePrincipal(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"dataLakePrincipal", (Object)Objects.requireNonNull(value, "dataLakePrincipal is required"));
    }

    @NotNull
    public Object getResource() {
        return Kernel.get((Object)this, (String)"resource", (NativeType)NativeType.forClass(Object.class));
    }

    public void setResource(@NotNull ResourceProperty value) {
        Kernel.set((Object)this, (String)"resource", (Object)Objects.requireNonNull(value, "resource is required"));
    }

    public void setResource(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"resource", (Object)Objects.requireNonNull(value, "resource is required"));
    }

    @Nullable
    public List<String> getPermissions() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"permissions", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setPermissions(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"permissions", value);
    }

    @Nullable
    public List<String> getPermissionsWithGrantOption() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"permissionsWithGrantOption", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setPermissionsWithGrantOption(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"permissionsWithGrantOption", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnPermissions> {
        private final Construct scope;
        private final String id;
        private final CfnPermissionsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnPermissionsProps.Builder();
        }

        public Builder dataLakePrincipal(DataLakePrincipalProperty dataLakePrincipal) {
            this.props.dataLakePrincipal(dataLakePrincipal);
            return this;
        }

        public Builder dataLakePrincipal(IResolvable dataLakePrincipal) {
            this.props.dataLakePrincipal(dataLakePrincipal);
            return this;
        }

        public Builder resource(ResourceProperty resource) {
            this.props.resource(resource);
            return this;
        }

        public Builder resource(IResolvable resource) {
            this.props.resource(resource);
            return this;
        }

        public Builder permissions(List<String> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        public Builder permissionsWithGrantOption(List<String> permissionsWithGrantOption) {
            this.props.permissionsWithGrantOption(permissionsWithGrantOption);
            return this;
        }

        public CfnPermissions build() {
            return new CfnPermissions(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.TableWithColumnsResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableWithColumnsResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public List<String> getColumnNames() {
            return null;
        }

        @Nullable
        default public Object getColumnWildcard() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableWithColumnsResourceProperty> {
            String catalogId;
            List<String> columnNames;
            Object columnWildcard;
            String databaseName;
            String name;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder columnNames(List<String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            public Builder columnWildcard(ColumnWildcardProperty columnWildcard) {
                this.columnWildcard = columnWildcard;
                return this;
            }

            public Builder columnWildcard(IResolvable columnWildcard) {
                this.columnWildcard = columnWildcard;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public TableWithColumnsResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.TableWildcardProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableWildcardProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableWildcardProperty> {
            public TableWildcardProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.TableResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getTableWildcard() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableResourceProperty> {
            String catalogId;
            String databaseName;
            String name;
            Object tableWildcard;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder tableWildcard(TableWildcardProperty tableWildcard) {
                this.tableWildcard = tableWildcard;
                return this;
            }

            public Builder tableWildcard(IResolvable tableWildcard) {
                this.tableWildcard = tableWildcard;
                return this;
            }

            public TableResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.ResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDatabaseResource() {
            return null;
        }

        @Nullable
        default public Object getDataLocationResource() {
            return null;
        }

        @Nullable
        default public Object getTableResource() {
            return null;
        }

        @Nullable
        default public Object getTableWithColumnsResource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceProperty> {
            Object databaseResource;
            Object dataLocationResource;
            Object tableResource;
            Object tableWithColumnsResource;

            public Builder databaseResource(DatabaseResourceProperty databaseResource) {
                this.databaseResource = databaseResource;
                return this;
            }

            public Builder databaseResource(IResolvable databaseResource) {
                this.databaseResource = databaseResource;
                return this;
            }

            public Builder dataLocationResource(DataLocationResourceProperty dataLocationResource) {
                this.dataLocationResource = dataLocationResource;
                return this;
            }

            public Builder dataLocationResource(IResolvable dataLocationResource) {
                this.dataLocationResource = dataLocationResource;
                return this;
            }

            public Builder tableResource(TableResourceProperty tableResource) {
                this.tableResource = tableResource;
                return this;
            }

            public Builder tableResource(IResolvable tableResource) {
                this.tableResource = tableResource;
                return this;
            }

            public Builder tableWithColumnsResource(TableWithColumnsResourceProperty tableWithColumnsResource) {
                this.tableWithColumnsResource = tableWithColumnsResource;
                return this;
            }

            public Builder tableWithColumnsResource(IResolvable tableWithColumnsResource) {
                this.tableWithColumnsResource = tableWithColumnsResource;
                return this;
            }

            public ResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.DatabaseResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseResourceProperty> {
            String catalogId;
            String name;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public DatabaseResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.DataLocationResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataLocationResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public String getS3Resource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataLocationResourceProperty> {
            String catalogId;
            String s3Resource;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder s3Resource(String s3Resource) {
                this.s3Resource = s3Resource;
                return this;
            }

            public DataLocationResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.DataLakePrincipalProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataLakePrincipalProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDataLakePrincipalIdentifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataLakePrincipalProperty> {
            String dataLakePrincipalIdentifier;

            public Builder dataLakePrincipalIdentifier(String dataLakePrincipalIdentifier) {
                this.dataLakePrincipalIdentifier = dataLakePrincipalIdentifier;
                return this;
            }

            public DataLakePrincipalProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lakeformation.CfnPermissions.ColumnWildcardProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnWildcardProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getExcludedColumnNames() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnWildcardProperty> {
            List<String> excludedColumnNames;

            public Builder excludedColumnNames(List<String> excludedColumnNames) {
                this.excludedColumnNames = excludedColumnNames;
                return this;
            }

            public ColumnWildcardProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

