/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lex;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.lex.CfnBot;
import software.amazon.awscdk.services.lex.CfnBotProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot")
public class CfnBot
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBot.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnBot(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBot(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnBot(@NotNull Construct scope, @NotNull String id, @NotNull CfnBotProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDataPrivacy() {
        return Kernel.get((Object)this, (String)"dataPrivacy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataPrivacy(@NotNull Object value) {
        Kernel.set((Object)this, (String)"dataPrivacy", (Object)Objects.requireNonNull(value, "dataPrivacy is required"));
    }

    @NotNull
    public Number getIdleSessionTtlInSeconds() {
        return (Number)Kernel.get((Object)this, (String)"idleSessionTtlInSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setIdleSessionTtlInSeconds(@NotNull Number value) {
        Kernel.set((Object)this, (String)"idleSessionTtlInSeconds", (Object)Objects.requireNonNull(value, "idleSessionTtlInSeconds is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public Object getAutoBuildBotLocales() {
        return Kernel.get((Object)this, (String)"autoBuildBotLocales", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoBuildBotLocales(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"autoBuildBotLocales", (Object)value);
    }

    public void setAutoBuildBotLocales(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoBuildBotLocales", (Object)value);
    }

    @Nullable
    public Object getBotFileS3Location() {
        return Kernel.get((Object)this, (String)"botFileS3Location", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBotFileS3Location(@Nullable S3LocationProperty value) {
        Kernel.set((Object)this, (String)"botFileS3Location", (Object)value);
    }

    public void setBotFileS3Location(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"botFileS3Location", (Object)value);
    }

    @Nullable
    public Object getBotLocales() {
        return Kernel.get((Object)this, (String)"botLocales", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBotLocales(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"botLocales", (Object)value);
    }

    public void setBotLocales(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"botLocales", value);
    }

    @Nullable
    public Object getBotTags() {
        return Kernel.get((Object)this, (String)"botTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBotTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"botTags", (Object)value);
    }

    public void setBotTags(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"botTags", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getTestBotAliasTags() {
        return Kernel.get((Object)this, (String)"testBotAliasTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTestBotAliasTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"testBotAliasTags", (Object)value);
    }

    public void setTestBotAliasTags(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"testBotAliasTags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnBot> {
        private final Construct scope;
        private final String id;
        private final CfnBotProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnBotProps.Builder();
        }

        public Builder dataPrivacy(Object dataPrivacy) {
            this.props.dataPrivacy(dataPrivacy);
            return this;
        }

        public Builder idleSessionTtlInSeconds(Number idleSessionTtlInSeconds) {
            this.props.idleSessionTtlInSeconds(idleSessionTtlInSeconds);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder autoBuildBotLocales(Boolean autoBuildBotLocales) {
            this.props.autoBuildBotLocales(autoBuildBotLocales);
            return this;
        }

        public Builder autoBuildBotLocales(IResolvable autoBuildBotLocales) {
            this.props.autoBuildBotLocales(autoBuildBotLocales);
            return this;
        }

        public Builder botFileS3Location(S3LocationProperty botFileS3Location) {
            this.props.botFileS3Location(botFileS3Location);
            return this;
        }

        public Builder botFileS3Location(IResolvable botFileS3Location) {
            this.props.botFileS3Location(botFileS3Location);
            return this;
        }

        public Builder botLocales(IResolvable botLocales) {
            this.props.botLocales(botLocales);
            return this;
        }

        public Builder botLocales(List<? extends Object> botLocales) {
            this.props.botLocales(botLocales);
            return this;
        }

        public Builder botTags(IResolvable botTags) {
            this.props.botTags(botTags);
            return this;
        }

        public Builder botTags(List<? extends Object> botTags) {
            this.props.botTags(botTags);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder testBotAliasTags(IResolvable testBotAliasTags) {
            this.props.testBotAliasTags(testBotAliasTags);
            return this;
        }

        public Builder testBotAliasTags(List<? extends Object> testBotAliasTags) {
            this.props.testBotAliasTags(testBotAliasTags);
            return this;
        }

        public CfnBot build() {
            return new CfnBot(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.WaitAndContinueSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WaitAndContinueSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContinueResponse();

        @NotNull
        public Object getWaitingResponse();

        @Nullable
        default public Object getIsActive() {
            return null;
        }

        @Nullable
        default public Object getStillWaitingResponse() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WaitAndContinueSpecificationProperty> {
            Object continueResponse;
            Object waitingResponse;
            Object isActive;
            Object stillWaitingResponse;

            public Builder continueResponse(ResponseSpecificationProperty continueResponse) {
                this.continueResponse = continueResponse;
                return this;
            }

            public Builder continueResponse(IResolvable continueResponse) {
                this.continueResponse = continueResponse;
                return this;
            }

            public Builder waitingResponse(ResponseSpecificationProperty waitingResponse) {
                this.waitingResponse = waitingResponse;
                return this;
            }

            public Builder waitingResponse(IResolvable waitingResponse) {
                this.waitingResponse = waitingResponse;
                return this;
            }

            public Builder isActive(Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            public Builder isActive(IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            public Builder stillWaitingResponse(StillWaitingResponseSpecificationProperty stillWaitingResponse) {
                this.stillWaitingResponse = stillWaitingResponse;
                return this;
            }

            public Builder stillWaitingResponse(IResolvable stillWaitingResponse) {
                this.stillWaitingResponse = stillWaitingResponse;
                return this;
            }

            public WaitAndContinueSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.VoiceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VoiceSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public String getVoiceId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VoiceSettingsProperty> {
            String voiceId;

            public Builder voiceId(String voiceId) {
                this.voiceId = voiceId;
                return this;
            }

            public VoiceSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.StillWaitingResponseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StillWaitingResponseSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getFrequencyInSeconds();

        @NotNull
        public Object getMessageGroupsList();

        @NotNull
        public Number getTimeoutInSeconds();

        @Nullable
        default public Object getAllowInterrupt() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StillWaitingResponseSpecificationProperty> {
            Number frequencyInSeconds;
            Object messageGroupsList;
            Number timeoutInSeconds;
            Object allowInterrupt;

            public Builder frequencyInSeconds(Number frequencyInSeconds) {
                this.frequencyInSeconds = frequencyInSeconds;
                return this;
            }

            public Builder messageGroupsList(IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            public Builder messageGroupsList(List<? extends Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            public Builder timeoutInSeconds(Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            public Builder allowInterrupt(Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public Builder allowInterrupt(IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public StillWaitingResponseSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotValueSelectionSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotValueSelectionSettingProperty
    extends JsiiSerializable {
        @NotNull
        public String getResolutionStrategy();

        @Nullable
        default public Object getRegexFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotValueSelectionSettingProperty> {
            String resolutionStrategy;
            Object regexFilter;

            public Builder resolutionStrategy(String resolutionStrategy) {
                this.resolutionStrategy = resolutionStrategy;
                return this;
            }

            public Builder regexFilter(SlotValueRegexFilterProperty regexFilter) {
                this.regexFilter = regexFilter;
                return this;
            }

            public Builder regexFilter(IResolvable regexFilter) {
                this.regexFilter = regexFilter;
                return this;
            }

            public SlotValueSelectionSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotValueRegexFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotValueRegexFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getPattern();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotValueRegexFilterProperty> {
            String pattern;

            public Builder pattern(String pattern) {
                this.pattern = pattern;
                return this;
            }

            public SlotValueRegexFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotValueElicitationSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotValueElicitationSettingProperty
    extends JsiiSerializable {
        @NotNull
        public String getSlotConstraint();

        @Nullable
        default public Object getDefaultValueSpecification() {
            return null;
        }

        @Nullable
        default public Object getPromptSpecification() {
            return null;
        }

        @Nullable
        default public Object getSampleUtterances() {
            return null;
        }

        @Nullable
        default public Object getWaitAndContinueSpecification() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotValueElicitationSettingProperty> {
            String slotConstraint;
            Object defaultValueSpecification;
            Object promptSpecification;
            Object sampleUtterances;
            Object waitAndContinueSpecification;

            public Builder slotConstraint(String slotConstraint) {
                this.slotConstraint = slotConstraint;
                return this;
            }

            public Builder defaultValueSpecification(SlotDefaultValueSpecificationProperty defaultValueSpecification) {
                this.defaultValueSpecification = defaultValueSpecification;
                return this;
            }

            public Builder defaultValueSpecification(IResolvable defaultValueSpecification) {
                this.defaultValueSpecification = defaultValueSpecification;
                return this;
            }

            public Builder promptSpecification(PromptSpecificationProperty promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            public Builder promptSpecification(IResolvable promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            public Builder sampleUtterances(IResolvable sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            public Builder sampleUtterances(List<? extends Object> sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            public Builder waitAndContinueSpecification(WaitAndContinueSpecificationProperty waitAndContinueSpecification) {
                this.waitAndContinueSpecification = waitAndContinueSpecification;
                return this;
            }

            public Builder waitAndContinueSpecification(IResolvable waitAndContinueSpecification) {
                this.waitAndContinueSpecification = waitAndContinueSpecification;
                return this;
            }

            public SlotValueElicitationSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotTypeValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotTypeValueProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSampleValue();

        @Nullable
        default public Object getSynonyms() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotTypeValueProperty> {
            Object sampleValue;
            Object synonyms;

            public Builder sampleValue(SampleValueProperty sampleValue) {
                this.sampleValue = sampleValue;
                return this;
            }

            public Builder sampleValue(IResolvable sampleValue) {
                this.sampleValue = sampleValue;
                return this;
            }

            public Builder synonyms(IResolvable synonyms) {
                this.synonyms = synonyms;
                return this;
            }

            public Builder synonyms(List<? extends Object> synonyms) {
                this.synonyms = synonyms;
                return this;
            }

            public SlotTypeValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotTypeProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getExternalSourceSetting() {
            return null;
        }

        @Nullable
        default public String getParentSlotTypeSignature() {
            return null;
        }

        @Nullable
        default public Object getSlotTypeValues() {
            return null;
        }

        @Nullable
        default public Object getValueSelectionSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotTypeProperty> {
            String name;
            String description;
            Object externalSourceSetting;
            String parentSlotTypeSignature;
            Object slotTypeValues;
            Object valueSelectionSetting;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder externalSourceSetting(ExternalSourceSettingProperty externalSourceSetting) {
                this.externalSourceSetting = externalSourceSetting;
                return this;
            }

            public Builder externalSourceSetting(IResolvable externalSourceSetting) {
                this.externalSourceSetting = externalSourceSetting;
                return this;
            }

            public Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
                this.parentSlotTypeSignature = parentSlotTypeSignature;
                return this;
            }

            public Builder slotTypeValues(IResolvable slotTypeValues) {
                this.slotTypeValues = slotTypeValues;
                return this;
            }

            public Builder slotTypeValues(List<? extends Object> slotTypeValues) {
                this.slotTypeValues = slotTypeValues;
                return this;
            }

            public Builder valueSelectionSetting(SlotValueSelectionSettingProperty valueSelectionSetting) {
                this.valueSelectionSetting = valueSelectionSetting;
                return this;
            }

            public Builder valueSelectionSetting(IResolvable valueSelectionSetting) {
                this.valueSelectionSetting = valueSelectionSetting;
                return this;
            }

            public SlotTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getSlotTypeName();

        @NotNull
        public Object getValueElicitationSetting();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getMultipleValuesSetting() {
            return null;
        }

        @Nullable
        default public Object getObfuscationSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotProperty> {
            String name;
            String slotTypeName;
            Object valueElicitationSetting;
            String description;
            Object multipleValuesSetting;
            Object obfuscationSetting;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder slotTypeName(String slotTypeName) {
                this.slotTypeName = slotTypeName;
                return this;
            }

            public Builder valueElicitationSetting(SlotValueElicitationSettingProperty valueElicitationSetting) {
                this.valueElicitationSetting = valueElicitationSetting;
                return this;
            }

            public Builder valueElicitationSetting(IResolvable valueElicitationSetting) {
                this.valueElicitationSetting = valueElicitationSetting;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder multipleValuesSetting(MultipleValuesSettingProperty multipleValuesSetting) {
                this.multipleValuesSetting = multipleValuesSetting;
                return this;
            }

            public Builder multipleValuesSetting(IResolvable multipleValuesSetting) {
                this.multipleValuesSetting = multipleValuesSetting;
                return this;
            }

            public Builder obfuscationSetting(ObfuscationSettingProperty obfuscationSetting) {
                this.obfuscationSetting = obfuscationSetting;
                return this;
            }

            public Builder obfuscationSetting(IResolvable obfuscationSetting) {
                this.obfuscationSetting = obfuscationSetting;
                return this;
            }

            public SlotProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotPriorityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotPriorityProperty
    extends JsiiSerializable {
        @NotNull
        public Number getPriority();

        @NotNull
        public String getSlotName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotPriorityProperty> {
            Number priority;
            String slotName;

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder slotName(String slotName) {
                this.slotName = slotName;
                return this;
            }

            public SlotPriorityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotDefaultValueSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDefaultValueList();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotDefaultValueSpecificationProperty> {
            Object defaultValueList;

            public Builder defaultValueList(IResolvable defaultValueList) {
                this.defaultValueList = defaultValueList;
                return this;
            }

            public Builder defaultValueList(List<? extends Object> defaultValueList) {
                this.defaultValueList = defaultValueList;
                return this;
            }

            public SlotDefaultValueSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlotDefaultValueProperty
    extends JsiiSerializable {
        @NotNull
        public String getDefaultValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlotDefaultValueProperty> {
            String defaultValue;

            public Builder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public SlotDefaultValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SampleValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SampleValueProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SampleValueProperty> {
            String value;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public SampleValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SampleUtteranceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SampleUtteranceProperty
    extends JsiiSerializable {
        @NotNull
        public String getUtterance();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SampleUtteranceProperty> {
            String utterance;

            public Builder utterance(String utterance) {
                this.utterance = utterance;
                return this;
            }

            public SampleUtteranceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.SSMLMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SSMLMessageProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SSMLMessageProperty> {
            String value;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public SSMLMessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3Bucket();

        @NotNull
        public String getS3ObjectKey();

        @Nullable
        default public String getS3ObjectVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String s3Bucket;
            String s3ObjectKey;
            String s3ObjectVersion;

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder s3ObjectKey(String s3ObjectKey) {
                this.s3ObjectKey = s3ObjectKey;
                return this;
            }

            public Builder s3ObjectVersion(String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.ResponseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResponseSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMessageGroupsList();

        @Nullable
        default public Object getAllowInterrupt() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResponseSpecificationProperty> {
            Object messageGroupsList;
            Object allowInterrupt;

            public Builder messageGroupsList(IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            public Builder messageGroupsList(List<? extends Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            public Builder allowInterrupt(Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public Builder allowInterrupt(IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public ResponseSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.PromptSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxRetries();

        @NotNull
        public Object getMessageGroupsList();

        @Nullable
        default public Object getAllowInterrupt() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptSpecificationProperty> {
            Number maxRetries;
            Object messageGroupsList;
            Object allowInterrupt;

            public Builder maxRetries(Number maxRetries) {
                this.maxRetries = maxRetries;
                return this;
            }

            public Builder messageGroupsList(IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            public Builder messageGroupsList(List<? extends Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            public Builder allowInterrupt(Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public Builder allowInterrupt(IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public PromptSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.PostFulfillmentStatusSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PostFulfillmentStatusSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFailureResponse() {
            return null;
        }

        @Nullable
        default public Object getSuccessResponse() {
            return null;
        }

        @Nullable
        default public Object getTimeoutResponse() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PostFulfillmentStatusSpecificationProperty> {
            Object failureResponse;
            Object successResponse;
            Object timeoutResponse;

            public Builder failureResponse(ResponseSpecificationProperty failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            public Builder failureResponse(IResolvable failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            public Builder successResponse(ResponseSpecificationProperty successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            public Builder successResponse(IResolvable successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            public Builder timeoutResponse(ResponseSpecificationProperty timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            public Builder timeoutResponse(IResolvable timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            public PostFulfillmentStatusSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.PlainTextMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlainTextMessageProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlainTextMessageProperty> {
            String value;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public PlainTextMessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.OutputContextProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputContextProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public Number getTimeToLiveInSeconds();

        @NotNull
        public Number getTurnsToLive();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputContextProperty> {
            String name;
            Number timeToLiveInSeconds;
            Number turnsToLive;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder timeToLiveInSeconds(Number timeToLiveInSeconds) {
                this.timeToLiveInSeconds = timeToLiveInSeconds;
                return this;
            }

            public Builder turnsToLive(Number turnsToLive) {
                this.turnsToLive = turnsToLive;
                return this;
            }

            public OutputContextProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.ObfuscationSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ObfuscationSettingProperty
    extends JsiiSerializable {
        @NotNull
        public String getObfuscationSettingType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ObfuscationSettingProperty> {
            String obfuscationSettingType;

            public Builder obfuscationSettingType(String obfuscationSettingType) {
                this.obfuscationSettingType = obfuscationSettingType;
                return this;
            }

            public ObfuscationSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.MultipleValuesSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultipleValuesSettingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllowMultipleValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultipleValuesSettingProperty> {
            Object allowMultipleValues;

            public Builder allowMultipleValues(Boolean allowMultipleValues) {
                this.allowMultipleValues = allowMultipleValues;
                return this;
            }

            public Builder allowMultipleValues(IResolvable allowMultipleValues) {
                this.allowMultipleValues = allowMultipleValues;
                return this;
            }

            public MultipleValuesSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.MessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MessageProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomPayload() {
            return null;
        }

        @Nullable
        default public Object getImageResponseCard() {
            return null;
        }

        @Nullable
        default public Object getPlainTextMessage() {
            return null;
        }

        @Nullable
        default public Object getSsmlMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MessageProperty> {
            Object customPayload;
            Object imageResponseCard;
            Object plainTextMessage;
            Object ssmlMessage;

            public Builder customPayload(CustomPayloadProperty customPayload) {
                this.customPayload = customPayload;
                return this;
            }

            public Builder customPayload(IResolvable customPayload) {
                this.customPayload = customPayload;
                return this;
            }

            public Builder imageResponseCard(ImageResponseCardProperty imageResponseCard) {
                this.imageResponseCard = imageResponseCard;
                return this;
            }

            public Builder imageResponseCard(IResolvable imageResponseCard) {
                this.imageResponseCard = imageResponseCard;
                return this;
            }

            public Builder plainTextMessage(PlainTextMessageProperty plainTextMessage) {
                this.plainTextMessage = plainTextMessage;
                return this;
            }

            public Builder plainTextMessage(IResolvable plainTextMessage) {
                this.plainTextMessage = plainTextMessage;
                return this;
            }

            public Builder ssmlMessage(SSMLMessageProperty ssmlMessage) {
                this.ssmlMessage = ssmlMessage;
                return this;
            }

            public Builder ssmlMessage(IResolvable ssmlMessage) {
                this.ssmlMessage = ssmlMessage;
                return this;
            }

            public MessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.MessageGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MessageGroupProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMessage();

        @Nullable
        default public Object getVariations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MessageGroupProperty> {
            Object message;
            Object variations;

            public Builder message(MessageProperty message) {
                this.message = message;
                return this;
            }

            public Builder message(IResolvable message) {
                this.message = message;
                return this;
            }

            public Builder variations(IResolvable variations) {
                this.variations = variations;
                return this;
            }

            public Builder variations(List<? extends Object> variations) {
                this.variations = variations;
                return this;
            }

            public MessageGroupProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.KendraConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KendraConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getKendraIndex();

        @Nullable
        default public String getQueryFilterString() {
            return null;
        }

        @Nullable
        default public Object getQueryFilterStringEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KendraConfigurationProperty> {
            String kendraIndex;
            String queryFilterString;
            Object queryFilterStringEnabled;

            public Builder kendraIndex(String kendraIndex) {
                this.kendraIndex = kendraIndex;
                return this;
            }

            public Builder queryFilterString(String queryFilterString) {
                this.queryFilterString = queryFilterString;
                return this;
            }

            public Builder queryFilterStringEnabled(Boolean queryFilterStringEnabled) {
                this.queryFilterStringEnabled = queryFilterStringEnabled;
                return this;
            }

            public Builder queryFilterStringEnabled(IResolvable queryFilterStringEnabled) {
                this.queryFilterStringEnabled = queryFilterStringEnabled;
                return this;
            }

            public KendraConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.IntentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntentProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getDialogCodeHook() {
            return null;
        }

        @Nullable
        default public Object getFulfillmentCodeHook() {
            return null;
        }

        @Nullable
        default public Object getInputContexts() {
            return null;
        }

        @Nullable
        default public Object getIntentClosingSetting() {
            return null;
        }

        @Nullable
        default public Object getIntentConfirmationSetting() {
            return null;
        }

        @Nullable
        default public Object getKendraConfiguration() {
            return null;
        }

        @Nullable
        default public Object getOutputContexts() {
            return null;
        }

        @Nullable
        default public String getParentIntentSignature() {
            return null;
        }

        @Nullable
        default public Object getSampleUtterances() {
            return null;
        }

        @Nullable
        default public Object getSlotPriorities() {
            return null;
        }

        @Nullable
        default public Object getSlots() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntentProperty> {
            String name;
            String description;
            Object dialogCodeHook;
            Object fulfillmentCodeHook;
            Object inputContexts;
            Object intentClosingSetting;
            Object intentConfirmationSetting;
            Object kendraConfiguration;
            Object outputContexts;
            String parentIntentSignature;
            Object sampleUtterances;
            Object slotPriorities;
            Object slots;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder dialogCodeHook(DialogCodeHookSettingProperty dialogCodeHook) {
                this.dialogCodeHook = dialogCodeHook;
                return this;
            }

            public Builder dialogCodeHook(IResolvable dialogCodeHook) {
                this.dialogCodeHook = dialogCodeHook;
                return this;
            }

            public Builder fulfillmentCodeHook(FulfillmentCodeHookSettingProperty fulfillmentCodeHook) {
                this.fulfillmentCodeHook = fulfillmentCodeHook;
                return this;
            }

            public Builder fulfillmentCodeHook(IResolvable fulfillmentCodeHook) {
                this.fulfillmentCodeHook = fulfillmentCodeHook;
                return this;
            }

            public Builder inputContexts(IResolvable inputContexts) {
                this.inputContexts = inputContexts;
                return this;
            }

            public Builder inputContexts(List<? extends Object> inputContexts) {
                this.inputContexts = inputContexts;
                return this;
            }

            public Builder intentClosingSetting(IntentClosingSettingProperty intentClosingSetting) {
                this.intentClosingSetting = intentClosingSetting;
                return this;
            }

            public Builder intentClosingSetting(IResolvable intentClosingSetting) {
                this.intentClosingSetting = intentClosingSetting;
                return this;
            }

            public Builder intentConfirmationSetting(IntentConfirmationSettingProperty intentConfirmationSetting) {
                this.intentConfirmationSetting = intentConfirmationSetting;
                return this;
            }

            public Builder intentConfirmationSetting(IResolvable intentConfirmationSetting) {
                this.intentConfirmationSetting = intentConfirmationSetting;
                return this;
            }

            public Builder kendraConfiguration(KendraConfigurationProperty kendraConfiguration) {
                this.kendraConfiguration = kendraConfiguration;
                return this;
            }

            public Builder kendraConfiguration(IResolvable kendraConfiguration) {
                this.kendraConfiguration = kendraConfiguration;
                return this;
            }

            public Builder outputContexts(IResolvable outputContexts) {
                this.outputContexts = outputContexts;
                return this;
            }

            public Builder outputContexts(List<? extends Object> outputContexts) {
                this.outputContexts = outputContexts;
                return this;
            }

            public Builder parentIntentSignature(String parentIntentSignature) {
                this.parentIntentSignature = parentIntentSignature;
                return this;
            }

            public Builder sampleUtterances(IResolvable sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            public Builder sampleUtterances(List<? extends Object> sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            public Builder slotPriorities(IResolvable slotPriorities) {
                this.slotPriorities = slotPriorities;
                return this;
            }

            public Builder slotPriorities(List<? extends Object> slotPriorities) {
                this.slotPriorities = slotPriorities;
                return this;
            }

            public Builder slots(IResolvable slots) {
                this.slots = slots;
                return this;
            }

            public Builder slots(List<? extends Object> slots) {
                this.slots = slots;
                return this;
            }

            public IntentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.IntentConfirmationSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntentConfirmationSettingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDeclinationResponse();

        @NotNull
        public Object getPromptSpecification();

        @Nullable
        default public Object getIsActive() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntentConfirmationSettingProperty> {
            Object declinationResponse;
            Object promptSpecification;
            Object isActive;

            public Builder declinationResponse(ResponseSpecificationProperty declinationResponse) {
                this.declinationResponse = declinationResponse;
                return this;
            }

            public Builder declinationResponse(IResolvable declinationResponse) {
                this.declinationResponse = declinationResponse;
                return this;
            }

            public Builder promptSpecification(PromptSpecificationProperty promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            public Builder promptSpecification(IResolvable promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            public Builder isActive(Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            public Builder isActive(IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            public IntentConfirmationSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.IntentClosingSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntentClosingSettingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getClosingResponse();

        @Nullable
        default public Object getIsActive() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntentClosingSettingProperty> {
            Object closingResponse;
            Object isActive;

            public Builder closingResponse(ResponseSpecificationProperty closingResponse) {
                this.closingResponse = closingResponse;
                return this;
            }

            public Builder closingResponse(IResolvable closingResponse) {
                this.closingResponse = closingResponse;
                return this;
            }

            public Builder isActive(Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            public Builder isActive(IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            public IntentClosingSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.InputContextProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputContextProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputContextProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public InputContextProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.ImageResponseCardProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImageResponseCardProperty
    extends JsiiSerializable {
        @NotNull
        public String getTitle();

        @Nullable
        default public Object getButtons() {
            return null;
        }

        @Nullable
        default public String getImageUrl() {
            return null;
        }

        @Nullable
        default public String getSubtitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImageResponseCardProperty> {
            String title;
            Object buttons;
            String imageUrl;
            String subtitle;

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder buttons(IResolvable buttons) {
                this.buttons = buttons;
                return this;
            }

            public Builder buttons(List<? extends Object> buttons) {
                this.buttons = buttons;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder subtitle(String subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public ImageResponseCardProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GrammarSlotTypeSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3BucketName();

        @NotNull
        public String getS3ObjectKey();

        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GrammarSlotTypeSourceProperty> {
            String s3BucketName;
            String s3ObjectKey;
            String kmsKeyArn;

            public Builder s3BucketName(String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            public Builder s3ObjectKey(String s3ObjectKey) {
                this.s3ObjectKey = s3ObjectKey;
                return this;
            }

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public GrammarSlotTypeSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GrammarSlotTypeSettingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GrammarSlotTypeSettingProperty> {
            Object source;

            public Builder source(GrammarSlotTypeSourceProperty source) {
                this.source = source;
                return this;
            }

            public Builder source(IResolvable source) {
                this.source = source;
                return this;
            }

            public GrammarSlotTypeSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdatesSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FulfillmentUpdatesSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActive();

        @Nullable
        default public Object getStartResponse() {
            return null;
        }

        @Nullable
        default public Number getTimeoutInSeconds() {
            return null;
        }

        @Nullable
        default public Object getUpdateResponse() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FulfillmentUpdatesSpecificationProperty> {
            Object active;
            Object startResponse;
            Number timeoutInSeconds;
            Object updateResponse;

            public Builder active(Boolean active) {
                this.active = active;
                return this;
            }

            public Builder active(IResolvable active) {
                this.active = active;
                return this;
            }

            public Builder startResponse(FulfillmentStartResponseSpecificationProperty startResponse) {
                this.startResponse = startResponse;
                return this;
            }

            public Builder startResponse(IResolvable startResponse) {
                this.startResponse = startResponse;
                return this;
            }

            public Builder timeoutInSeconds(Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            public Builder updateResponse(FulfillmentUpdateResponseSpecificationProperty updateResponse) {
                this.updateResponse = updateResponse;
                return this;
            }

            public Builder updateResponse(IResolvable updateResponse) {
                this.updateResponse = updateResponse;
                return this;
            }

            public FulfillmentUpdatesSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FulfillmentUpdateResponseSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getFrequencyInSeconds();

        @NotNull
        public Object getMessageGroups();

        @Nullable
        default public Object getAllowInterrupt() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FulfillmentUpdateResponseSpecificationProperty> {
            Number frequencyInSeconds;
            Object messageGroups;
            Object allowInterrupt;

            public Builder frequencyInSeconds(Number frequencyInSeconds) {
                this.frequencyInSeconds = frequencyInSeconds;
                return this;
            }

            public Builder messageGroups(IResolvable messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            public Builder messageGroups(List<? extends Object> messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            public Builder allowInterrupt(Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public Builder allowInterrupt(IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public FulfillmentUpdateResponseSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.FulfillmentStartResponseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FulfillmentStartResponseSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getDelayInSeconds();

        @NotNull
        public Object getMessageGroups();

        @Nullable
        default public Object getAllowInterrupt() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FulfillmentStartResponseSpecificationProperty> {
            Number delayInSeconds;
            Object messageGroups;
            Object allowInterrupt;

            public Builder delayInSeconds(Number delayInSeconds) {
                this.delayInSeconds = delayInSeconds;
                return this;
            }

            public Builder messageGroups(IResolvable messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            public Builder messageGroups(List<? extends Object> messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            public Builder allowInterrupt(Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public Builder allowInterrupt(IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            public FulfillmentStartResponseSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.FulfillmentCodeHookSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FulfillmentCodeHookSettingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public Object getFulfillmentUpdatesSpecification() {
            return null;
        }

        @Nullable
        default public Object getPostFulfillmentStatusSpecification() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FulfillmentCodeHookSettingProperty> {
            Object enabled;
            Object fulfillmentUpdatesSpecification;
            Object postFulfillmentStatusSpecification;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecificationProperty fulfillmentUpdatesSpecification) {
                this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
                return this;
            }

            public Builder fulfillmentUpdatesSpecification(IResolvable fulfillmentUpdatesSpecification) {
                this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
                return this;
            }

            public Builder postFulfillmentStatusSpecification(PostFulfillmentStatusSpecificationProperty postFulfillmentStatusSpecification) {
                this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
                return this;
            }

            public Builder postFulfillmentStatusSpecification(IResolvable postFulfillmentStatusSpecification) {
                this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
                return this;
            }

            public FulfillmentCodeHookSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.ExternalSourceSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExternalSourceSettingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGrammarSlotTypeSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExternalSourceSettingProperty> {
            Object grammarSlotTypeSetting;

            public Builder grammarSlotTypeSetting(GrammarSlotTypeSettingProperty grammarSlotTypeSetting) {
                this.grammarSlotTypeSetting = grammarSlotTypeSetting;
                return this;
            }

            public Builder grammarSlotTypeSetting(IResolvable grammarSlotTypeSetting) {
                this.grammarSlotTypeSetting = grammarSlotTypeSetting;
                return this;
            }

            public ExternalSourceSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.DialogCodeHookSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DialogCodeHookSettingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DialogCodeHookSettingProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public DialogCodeHookSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.CustomPayloadProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomPayloadProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomPayloadProperty> {
            String value;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public CustomPayloadProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.ButtonProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ButtonProperty
    extends JsiiSerializable {
        @NotNull
        public String getText();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ButtonProperty> {
            String text;
            String value;

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ButtonProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lex.CfnBot.BotLocaleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BotLocaleProperty
    extends JsiiSerializable {
        @NotNull
        public String getLocaleId();

        @NotNull
        public Number getNluConfidenceThreshold();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getIntents() {
            return null;
        }

        @Nullable
        default public Object getSlotTypes() {
            return null;
        }

        @Nullable
        default public Object getVoiceSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BotLocaleProperty> {
            String localeId;
            Number nluConfidenceThreshold;
            String description;
            Object intents;
            Object slotTypes;
            Object voiceSettings;

            public Builder localeId(String localeId) {
                this.localeId = localeId;
                return this;
            }

            public Builder nluConfidenceThreshold(Number nluConfidenceThreshold) {
                this.nluConfidenceThreshold = nluConfidenceThreshold;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder intents(IResolvable intents) {
                this.intents = intents;
                return this;
            }

            public Builder intents(List<? extends Object> intents) {
                this.intents = intents;
                return this;
            }

            public Builder slotTypes(IResolvable slotTypes) {
                this.slotTypes = slotTypes;
                return this;
            }

            public Builder slotTypes(List<? extends Object> slotTypes) {
                this.slotTypes = slotTypes;
                return this;
            }

            public Builder voiceSettings(VoiceSettingsProperty voiceSettings) {
                this.voiceSettings = voiceSettings;
                return this;
            }

            public Builder voiceSettings(IResolvable voiceSettings) {
                this.voiceSettings = voiceSettings;
                return this;
            }

            public BotLocaleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

