/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lightsail;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.lightsail.CfnInstance;
import software.amazon.awscdk.services.lightsail.CfnInstanceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance")
public class CfnInstance
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInstance.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInstance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInstance(@NotNull Construct scope, @NotNull String id, @NotNull CfnInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public Number getAttrHardwareCpuCount() {
        return (Number)Kernel.get((Object)this, (String)"attrHardwareCpuCount", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public Number getAttrHardwareRamSizeInGb() {
        return (Number)Kernel.get((Object)this, (String)"attrHardwareRamSizeInGb", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public String getAttrInstanceArn() {
        return (String)Kernel.get((Object)this, (String)"attrInstanceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrIsStaticIp() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrIsStaticIp", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrLocationAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"attrLocationAvailabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLocationRegionName() {
        return (String)Kernel.get((Object)this, (String)"attrLocationRegionName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrNetworkingMonthlyTransferGbPerMonthAllocated() {
        return (String)Kernel.get((Object)this, (String)"attrNetworkingMonthlyTransferGbPerMonthAllocated", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPrivateIpAddress() {
        return (String)Kernel.get((Object)this, (String)"attrPrivateIpAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPublicIpAddress() {
        return (String)Kernel.get((Object)this, (String)"attrPublicIpAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrResourceType() {
        return (String)Kernel.get((Object)this, (String)"attrResourceType", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSshKeyName() {
        return (String)Kernel.get((Object)this, (String)"attrSshKeyName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getAttrStateCode() {
        return (Number)Kernel.get((Object)this, (String)"attrStateCode", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public String getAttrStateName() {
        return (String)Kernel.get((Object)this, (String)"attrStateName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSupportCode() {
        return (String)Kernel.get((Object)this, (String)"attrSupportCode", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUserName() {
        return (String)Kernel.get((Object)this, (String)"attrUserName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getBlueprintId() {
        return (String)Kernel.get((Object)this, (String)"blueprintId", (NativeType)NativeType.forClass(String.class));
    }

    public void setBlueprintId(@NotNull String value) {
        Kernel.set((Object)this, (String)"blueprintId", (Object)Objects.requireNonNull(value, "blueprintId is required"));
    }

    @NotNull
    public String getBundleId() {
        return (String)Kernel.get((Object)this, (String)"bundleId", (NativeType)NativeType.forClass(String.class));
    }

    public void setBundleId(@NotNull String value) {
        Kernel.set((Object)this, (String)"bundleId", (Object)Objects.requireNonNull(value, "bundleId is required"));
    }

    @NotNull
    public String getInstanceName() {
        return (String)Kernel.get((Object)this, (String)"instanceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceName(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceName", (Object)Objects.requireNonNull(value, "instanceName is required"));
    }

    @Nullable
    public Object getAddOns() {
        return Kernel.get((Object)this, (String)"addOns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAddOns(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"addOns", (Object)value);
    }

    public void setAddOns(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"addOns", value);
    }

    @Nullable
    public String getAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"availabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZone(@Nullable String value) {
        Kernel.set((Object)this, (String)"availabilityZone", (Object)value);
    }

    @Nullable
    public Object getHardware() {
        return Kernel.get((Object)this, (String)"hardware", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHardware(@Nullable HardwareProperty value) {
        Kernel.set((Object)this, (String)"hardware", (Object)value);
    }

    public void setHardware(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"hardware", (Object)value);
    }

    @Nullable
    public String getKeyPairName() {
        return (String)Kernel.get((Object)this, (String)"keyPairName", (NativeType)NativeType.forClass(String.class));
    }

    public void setKeyPairName(@Nullable String value) {
        Kernel.set((Object)this, (String)"keyPairName", (Object)value);
    }

    @Nullable
    public Object getNetworking() {
        return Kernel.get((Object)this, (String)"networking", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworking(@Nullable NetworkingProperty value) {
        Kernel.set((Object)this, (String)"networking", (Object)value);
    }

    public void setNetworking(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"networking", (Object)value);
    }

    @Nullable
    public String getUserData() {
        return (String)Kernel.get((Object)this, (String)"userData", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserData(@Nullable String value) {
        Kernel.set((Object)this, (String)"userData", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInstance> {
        private final Construct scope;
        private final String id;
        private final CfnInstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInstanceProps.Builder();
        }

        public Builder blueprintId(String blueprintId) {
            this.props.blueprintId(blueprintId);
            return this;
        }

        public Builder bundleId(String bundleId) {
            this.props.bundleId(bundleId);
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        public Builder addOns(IResolvable addOns) {
            this.props.addOns(addOns);
            return this;
        }

        public Builder addOns(List<? extends Object> addOns) {
            this.props.addOns(addOns);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder hardware(HardwareProperty hardware) {
            this.props.hardware(hardware);
            return this;
        }

        public Builder hardware(IResolvable hardware) {
            this.props.hardware(hardware);
            return this;
        }

        public Builder keyPairName(String keyPairName) {
            this.props.keyPairName(keyPairName);
            return this;
        }

        public Builder networking(NetworkingProperty networking) {
            this.props.networking(networking);
            return this;
        }

        public Builder networking(IResolvable networking) {
            this.props.networking(networking);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder userData(String userData) {
            this.props.userData(userData);
            return this;
        }

        public CfnInstance build() {
            return new CfnInstance(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.StateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StateProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCode() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StateProperty> {
            Number code;
            String name;

            public Builder code(Number code) {
                this.code = code;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public StateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.PortProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PortProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessDirection() {
            return null;
        }

        @Nullable
        default public String getAccessFrom() {
            return null;
        }

        @Nullable
        default public String getAccessType() {
            return null;
        }

        @Nullable
        default public List<String> getCidrListAliases() {
            return null;
        }

        @Nullable
        default public List<String> getCidrs() {
            return null;
        }

        @Nullable
        default public String getCommonName() {
            return null;
        }

        @Nullable
        default public Number getFromPort() {
            return null;
        }

        @Nullable
        default public List<String> getIpv6Cidrs() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        @Nullable
        default public Number getToPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PortProperty> {
            String accessDirection;
            String accessFrom;
            String accessType;
            List<String> cidrListAliases;
            List<String> cidrs;
            String commonName;
            Number fromPort;
            List<String> ipv6Cidrs;
            String protocol;
            Number toPort;

            public Builder accessDirection(String accessDirection) {
                this.accessDirection = accessDirection;
                return this;
            }

            public Builder accessFrom(String accessFrom) {
                this.accessFrom = accessFrom;
                return this;
            }

            public Builder accessType(String accessType) {
                this.accessType = accessType;
                return this;
            }

            public Builder cidrListAliases(List<String> cidrListAliases) {
                this.cidrListAliases = cidrListAliases;
                return this;
            }

            public Builder cidrs(List<String> cidrs) {
                this.cidrs = cidrs;
                return this;
            }

            public Builder commonName(String commonName) {
                this.commonName = commonName;
                return this;
            }

            public Builder fromPort(Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            public Builder ipv6Cidrs(List<String> ipv6Cidrs) {
                this.ipv6Cidrs = ipv6Cidrs;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder toPort(Number toPort) {
                this.toPort = toPort;
                return this;
            }

            public PortProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.NetworkingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPorts();

        @Nullable
        default public Number getMonthlyTransfer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkingProperty> {
            Object ports;
            Number monthlyTransfer;

            public Builder ports(IResolvable ports) {
                this.ports = ports;
                return this;
            }

            public Builder ports(List<? extends Object> ports) {
                this.ports = ports;
                return this;
            }

            public Builder monthlyTransfer(Number monthlyTransfer) {
                this.monthlyTransfer = monthlyTransfer;
                return this;
            }

            public NetworkingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.MonthlyTransferProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonthlyTransferProperty
    extends JsiiSerializable {
        @Nullable
        default public String getGbPerMonthAllocated() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonthlyTransferProperty> {
            String gbPerMonthAllocated;

            public Builder gbPerMonthAllocated(String gbPerMonthAllocated) {
                this.gbPerMonthAllocated = gbPerMonthAllocated;
                return this;
            }

            public MonthlyTransferProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public String getRegionName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LocationProperty> {
            String availabilityZone;
            String regionName;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder regionName(String regionName) {
                this.regionName = regionName;
                return this;
            }

            public LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.HardwareProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HardwareProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCpuCount() {
            return null;
        }

        @Nullable
        default public Object getDisks() {
            return null;
        }

        @Nullable
        default public Number getRamSizeInGb() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HardwareProperty> {
            Number cpuCount;
            Object disks;
            Number ramSizeInGb;

            public Builder cpuCount(Number cpuCount) {
                this.cpuCount = cpuCount;
                return this;
            }

            public Builder disks(IResolvable disks) {
                this.disks = disks;
                return this;
            }

            public Builder disks(List<? extends Object> disks) {
                this.disks = disks;
                return this;
            }

            public Builder ramSizeInGb(Number ramSizeInGb) {
                this.ramSizeInGb = ramSizeInGb;
                return this;
            }

            public HardwareProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.DiskProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DiskProperty
    extends JsiiSerializable {
        @NotNull
        public String getDiskName();

        @NotNull
        public String getPath();

        @Nullable
        default public String getAttachedTo() {
            return null;
        }

        @Nullable
        default public String getAttachmentState() {
            return null;
        }

        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public Object getIsSystemDisk() {
            return null;
        }

        @Nullable
        default public String getSizeInGb() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DiskProperty> {
            String diskName;
            String path;
            String attachedTo;
            String attachmentState;
            Number iops;
            Object isSystemDisk;
            String sizeInGb;

            public Builder diskName(String diskName) {
                this.diskName = diskName;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder attachedTo(String attachedTo) {
                this.attachedTo = attachedTo;
                return this;
            }

            public Builder attachmentState(String attachmentState) {
                this.attachmentState = attachmentState;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder isSystemDisk(Boolean isSystemDisk) {
                this.isSystemDisk = isSystemDisk;
                return this;
            }

            public Builder isSystemDisk(IResolvable isSystemDisk) {
                this.isSystemDisk = isSystemDisk;
                return this;
            }

            public Builder sizeInGb(String sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            public DiskProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.AutoSnapshotAddOnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoSnapshotAddOnProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSnapshotTimeOfDay() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoSnapshotAddOnProperty> {
            String snapshotTimeOfDay;

            public Builder snapshotTimeOfDay(String snapshotTimeOfDay) {
                this.snapshotTimeOfDay = snapshotTimeOfDay;
                return this;
            }

            public AutoSnapshotAddOnProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnInstance.AddOnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AddOnProperty
    extends JsiiSerializable {
        @NotNull
        public String getAddOnType();

        @Nullable
        default public Object getAutoSnapshotAddOnRequest() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AddOnProperty> {
            String addOnType;
            Object autoSnapshotAddOnRequest;
            String status;

            public Builder addOnType(String addOnType) {
                this.addOnType = addOnType;
                return this;
            }

            public Builder autoSnapshotAddOnRequest(AutoSnapshotAddOnProperty autoSnapshotAddOnRequest) {
                this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest;
                return this;
            }

            public Builder autoSnapshotAddOnRequest(IResolvable autoSnapshotAddOnRequest) {
                this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public AddOnProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

