/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lookoutmetrics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector;
import software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetectorProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector")
public class CfnAnomalyDetector
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAnomalyDetector.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAnomalyDetector(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAnomalyDetector(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAnomalyDetector(@NotNull Construct scope, @NotNull String id, @NotNull CfnAnomalyDetectorProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getAnomalyDetectorConfig() {
        return Kernel.get((Object)this, (String)"anomalyDetectorConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAnomalyDetectorConfig(@NotNull AnomalyDetectorConfigProperty value) {
        Kernel.set((Object)this, (String)"anomalyDetectorConfig", (Object)Objects.requireNonNull(value, "anomalyDetectorConfig is required"));
    }

    public void setAnomalyDetectorConfig(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"anomalyDetectorConfig", (Object)Objects.requireNonNull(value, "anomalyDetectorConfig is required"));
    }

    @NotNull
    public Object getMetricSetList() {
        return Kernel.get((Object)this, (String)"metricSetList", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMetricSetList(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"metricSetList", (Object)Objects.requireNonNull(value, "metricSetList is required"));
    }

    public void setMetricSetList(@NotNull List<Object> value) {
        Kernel.set((Object)this, (String)"metricSetList", Objects.requireNonNull(value, "metricSetList is required"));
    }

    @Nullable
    public String getAnomalyDetectorDescription() {
        return (String)Kernel.get((Object)this, (String)"anomalyDetectorDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setAnomalyDetectorDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"anomalyDetectorDescription", (Object)value);
    }

    @Nullable
    public String getAnomalyDetectorName() {
        return (String)Kernel.get((Object)this, (String)"anomalyDetectorName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAnomalyDetectorName(@Nullable String value) {
        Kernel.set((Object)this, (String)"anomalyDetectorName", (Object)value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyArn", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAnomalyDetector> {
        private final Construct scope;
        private final String id;
        private final CfnAnomalyDetectorProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAnomalyDetectorProps.Builder();
        }

        public Builder anomalyDetectorConfig(AnomalyDetectorConfigProperty anomalyDetectorConfig) {
            this.props.anomalyDetectorConfig(anomalyDetectorConfig);
            return this;
        }

        public Builder anomalyDetectorConfig(IResolvable anomalyDetectorConfig) {
            this.props.anomalyDetectorConfig(anomalyDetectorConfig);
            return this;
        }

        public Builder metricSetList(IResolvable metricSetList) {
            this.props.metricSetList(metricSetList);
            return this;
        }

        public Builder metricSetList(List<? extends Object> metricSetList) {
            this.props.metricSetList(metricSetList);
            return this;
        }

        public Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.props.anomalyDetectorDescription(anomalyDetectorDescription);
            return this;
        }

        public Builder anomalyDetectorName(String anomalyDetectorName) {
            this.props.anomalyDetectorName(anomalyDetectorName);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        public CfnAnomalyDetector build() {
            return new CfnAnomalyDetector(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIdList();

        @NotNull
        public List<String> getSubnetIdList();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            List<String> securityGroupIdList;
            List<String> subnetIdList;

            public Builder securityGroupIdList(List<String> securityGroupIdList) {
                this.securityGroupIdList = securityGroupIdList;
                return this;
            }

            public Builder subnetIdList(List<String> subnetIdList) {
                this.subnetIdList = subnetIdList;
                return this;
            }

            public VpcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.TimestampColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimestampColumnProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColumnFormat() {
            return null;
        }

        @Nullable
        default public String getColumnName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimestampColumnProperty> {
            String columnFormat;
            String columnName;

            public Builder columnFormat(String columnFormat) {
                this.columnFormat = columnFormat;
                return this;
            }

            public Builder columnName(String columnName) {
                this.columnName = columnName;
                return this;
            }

            public TimestampColumnProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.S3SourceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3SourceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFileFormatDescriptor();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public List<String> getHistoricalDataPathList() {
            return null;
        }

        @Nullable
        default public List<String> getTemplatedPathList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3SourceConfigProperty> {
            Object fileFormatDescriptor;
            String roleArn;
            List<String> historicalDataPathList;
            List<String> templatedPathList;

            public Builder fileFormatDescriptor(FileFormatDescriptorProperty fileFormatDescriptor) {
                this.fileFormatDescriptor = fileFormatDescriptor;
                return this;
            }

            public Builder fileFormatDescriptor(IResolvable fileFormatDescriptor) {
                this.fileFormatDescriptor = fileFormatDescriptor;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder historicalDataPathList(List<String> historicalDataPathList) {
                this.historicalDataPathList = historicalDataPathList;
                return this;
            }

            public Builder templatedPathList(List<String> templatedPathList) {
                this.templatedPathList = templatedPathList;
                return this;
            }

            public S3SourceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.RedshiftSourceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftSourceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getClusterIdentifier();

        @NotNull
        public String getDatabaseHost();

        @NotNull
        public String getDatabaseName();

        @NotNull
        public Number getDatabasePort();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getSecretManagerArn();

        @NotNull
        public String getTableName();

        @NotNull
        public Object getVpcConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftSourceConfigProperty> {
            String clusterIdentifier;
            String databaseHost;
            String databaseName;
            Number databasePort;
            String roleArn;
            String secretManagerArn;
            String tableName;
            Object vpcConfiguration;

            public Builder clusterIdentifier(String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            public Builder databaseHost(String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder databasePort(Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder secretManagerArn(String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder vpcConfiguration(VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public RedshiftSourceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.RDSSourceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RDSSourceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabaseHost();

        @NotNull
        public String getDatabaseName();

        @NotNull
        public Number getDatabasePort();

        @NotNull
        public String getDbInstanceIdentifier();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getSecretManagerArn();

        @NotNull
        public String getTableName();

        @NotNull
        public Object getVpcConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RDSSourceConfigProperty> {
            String databaseHost;
            String databaseName;
            Number databasePort;
            String dbInstanceIdentifier;
            String roleArn;
            String secretManagerArn;
            String tableName;
            Object vpcConfiguration;

            public Builder databaseHost(String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder databasePort(Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            public Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
                this.dbInstanceIdentifier = dbInstanceIdentifier;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder secretManagerArn(String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder vpcConfiguration(VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public RDSSourceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricSourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAppFlowConfig() {
            return null;
        }

        @Nullable
        default public Object getCloudwatchConfig() {
            return null;
        }

        @Nullable
        default public Object getRdsSourceConfig() {
            return null;
        }

        @Nullable
        default public Object getRedshiftSourceConfig() {
            return null;
        }

        @Nullable
        default public Object getS3SourceConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricSourceProperty> {
            Object appFlowConfig;
            Object cloudwatchConfig;
            Object rdsSourceConfig;
            Object redshiftSourceConfig;
            Object s3SourceConfig;

            public Builder appFlowConfig(AppFlowConfigProperty appFlowConfig) {
                this.appFlowConfig = appFlowConfig;
                return this;
            }

            public Builder appFlowConfig(IResolvable appFlowConfig) {
                this.appFlowConfig = appFlowConfig;
                return this;
            }

            public Builder cloudwatchConfig(CloudwatchConfigProperty cloudwatchConfig) {
                this.cloudwatchConfig = cloudwatchConfig;
                return this;
            }

            public Builder cloudwatchConfig(IResolvable cloudwatchConfig) {
                this.cloudwatchConfig = cloudwatchConfig;
                return this;
            }

            public Builder rdsSourceConfig(RDSSourceConfigProperty rdsSourceConfig) {
                this.rdsSourceConfig = rdsSourceConfig;
                return this;
            }

            public Builder rdsSourceConfig(IResolvable rdsSourceConfig) {
                this.rdsSourceConfig = rdsSourceConfig;
                return this;
            }

            public Builder redshiftSourceConfig(RedshiftSourceConfigProperty redshiftSourceConfig) {
                this.redshiftSourceConfig = redshiftSourceConfig;
                return this;
            }

            public Builder redshiftSourceConfig(IResolvable redshiftSourceConfig) {
                this.redshiftSourceConfig = redshiftSourceConfig;
                return this;
            }

            public Builder s3SourceConfig(S3SourceConfigProperty s3SourceConfig) {
                this.s3SourceConfig = s3SourceConfig;
                return this;
            }

            public Builder s3SourceConfig(IResolvable s3SourceConfig) {
                this.s3SourceConfig = s3SourceConfig;
                return this;
            }

            public MetricSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricSetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricSetProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMetricList();

        @NotNull
        public String getMetricSetName();

        @NotNull
        public Object getMetricSource();

        @Nullable
        default public List<String> getDimensionList() {
            return null;
        }

        @Nullable
        default public String getMetricSetDescription() {
            return null;
        }

        @Nullable
        default public String getMetricSetFrequency() {
            return null;
        }

        @Nullable
        default public Number getOffset() {
            return null;
        }

        @Nullable
        default public Object getTimestampColumn() {
            return null;
        }

        @Nullable
        default public String getTimezone() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricSetProperty> {
            Object metricList;
            String metricSetName;
            Object metricSource;
            List<String> dimensionList;
            String metricSetDescription;
            String metricSetFrequency;
            Number offset;
            Object timestampColumn;
            String timezone;

            public Builder metricList(IResolvable metricList) {
                this.metricList = metricList;
                return this;
            }

            public Builder metricList(List<? extends Object> metricList) {
                this.metricList = metricList;
                return this;
            }

            public Builder metricSetName(String metricSetName) {
                this.metricSetName = metricSetName;
                return this;
            }

            public Builder metricSource(MetricSourceProperty metricSource) {
                this.metricSource = metricSource;
                return this;
            }

            public Builder metricSource(IResolvable metricSource) {
                this.metricSource = metricSource;
                return this;
            }

            public Builder dimensionList(List<String> dimensionList) {
                this.dimensionList = dimensionList;
                return this;
            }

            public Builder metricSetDescription(String metricSetDescription) {
                this.metricSetDescription = metricSetDescription;
                return this;
            }

            public Builder metricSetFrequency(String metricSetFrequency) {
                this.metricSetFrequency = metricSetFrequency;
                return this;
            }

            public Builder offset(Number offset) {
                this.offset = offset;
                return this;
            }

            public Builder timestampColumn(TimestampColumnProperty timestampColumn) {
                this.timestampColumn = timestampColumn;
                return this;
            }

            public Builder timestampColumn(IResolvable timestampColumn) {
                this.timestampColumn = timestampColumn;
                return this;
            }

            public Builder timezone(String timezone) {
                this.timezone = timezone;
                return this;
            }

            public MetricSetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricProperty
    extends JsiiSerializable {
        @NotNull
        public String getAggregationFunction();

        @NotNull
        public String getMetricName();

        @Nullable
        default public String getNamespace() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricProperty> {
            String aggregationFunction;
            String metricName;
            String namespace;

            public Builder aggregationFunction(String aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public MetricProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.JsonFormatDescriptorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JsonFormatDescriptorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCharset() {
            return null;
        }

        @Nullable
        default public String getFileCompression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JsonFormatDescriptorProperty> {
            String charset;
            String fileCompression;

            public Builder charset(String charset) {
                this.charset = charset;
                return this;
            }

            public Builder fileCompression(String fileCompression) {
                this.fileCompression = fileCompression;
                return this;
            }

            public JsonFormatDescriptorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.FileFormatDescriptorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FileFormatDescriptorProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsvFormatDescriptor() {
            return null;
        }

        @Nullable
        default public Object getJsonFormatDescriptor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FileFormatDescriptorProperty> {
            Object csvFormatDescriptor;
            Object jsonFormatDescriptor;

            public Builder csvFormatDescriptor(CsvFormatDescriptorProperty csvFormatDescriptor) {
                this.csvFormatDescriptor = csvFormatDescriptor;
                return this;
            }

            public Builder csvFormatDescriptor(IResolvable csvFormatDescriptor) {
                this.csvFormatDescriptor = csvFormatDescriptor;
                return this;
            }

            public Builder jsonFormatDescriptor(JsonFormatDescriptorProperty jsonFormatDescriptor) {
                this.jsonFormatDescriptor = jsonFormatDescriptor;
                return this;
            }

            public Builder jsonFormatDescriptor(IResolvable jsonFormatDescriptor) {
                this.jsonFormatDescriptor = jsonFormatDescriptor;
                return this;
            }

            public FileFormatDescriptorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.CsvFormatDescriptorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CsvFormatDescriptorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCharset() {
            return null;
        }

        @Nullable
        default public Object getContainsHeader() {
            return null;
        }

        @Nullable
        default public String getDelimiter() {
            return null;
        }

        @Nullable
        default public String getFileCompression() {
            return null;
        }

        @Nullable
        default public List<String> getHeaderList() {
            return null;
        }

        @Nullable
        default public String getQuoteSymbol() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CsvFormatDescriptorProperty> {
            String charset;
            Object containsHeader;
            String delimiter;
            String fileCompression;
            List<String> headerList;
            String quoteSymbol;

            public Builder charset(String charset) {
                this.charset = charset;
                return this;
            }

            public Builder containsHeader(Boolean containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            public Builder containsHeader(IResolvable containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            public Builder delimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Builder fileCompression(String fileCompression) {
                this.fileCompression = fileCompression;
                return this;
            }

            public Builder headerList(List<String> headerList) {
                this.headerList = headerList;
                return this;
            }

            public Builder quoteSymbol(String quoteSymbol) {
                this.quoteSymbol = quoteSymbol;
                return this;
            }

            public CsvFormatDescriptorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.CloudwatchConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudwatchConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudwatchConfigProperty> {
            String roleArn;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public CloudwatchConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.AppFlowConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AppFlowConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getFlowName();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AppFlowConfigProperty> {
            String flowName;
            String roleArn;

            public Builder flowName(String flowName) {
                this.flowName = flowName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public AppFlowConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.AnomalyDetectorConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnomalyDetectorConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAnomalyDetectorFrequency();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnomalyDetectorConfigProperty> {
            String anomalyDetectorFrequency;

            public Builder anomalyDetectorFrequency(String anomalyDetectorFrequency) {
                this.anomalyDetectorFrequency = anomalyDetectorFrequency;
                return this;
            }

            public AnomalyDetectorConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

