/**
 * <h1>AWS Lambda Layer with kubectl (and helm)</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module exports a single class called <code>KubectlLayer</code> which is a <code>lambda.Layer</code> that bundles the <a href="https://kubernetes.io/docs/reference/kubectl/kubectl/"><code>kubectl</code></a> and the <a href="https://helm.sh/"><code>helm</code></a> command line.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>Helm Version: 1.20.0</li>
 * <li>Kubectl Version: 3.4.2</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object fn = new Function(...);
 * fn.addLayers(new KubectlLayer(stack, "KubectlLayer"));
 * </pre></blockquote>
 * <p>
 * <code>kubectl</code> will be installed under <code>/opt/kubectl/kubectl</code>, and <code>helm</code> will be installed under <code>/opt/helm/helm</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.lambdalayer.kubectl;
