package software.amazon.awscdk.services.codebuild;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.149Z")
public interface BuildEnvironment extends software.amazon.jsii.JsiiSerializable {
    /**
     * The image used for the builds.
     * @default LinuxBuildImage.UBUNTU_14_04_BASE
     */
    software.amazon.awscdk.services.codebuild.IBuildImage getBuildImage();
    /**
     * The image used for the builds.
     * @default LinuxBuildImage.UBUNTU_14_04_BASE
     */
    void setBuildImage(final software.amazon.awscdk.services.codebuild.IBuildImage value);
    /**
     * The type of compute to use for this build.
     * See the {@link ComputeType} enum for the possible values.
     * @default taken from {@link #buildImage#defaultComputeType}
     */
    software.amazon.awscdk.services.codebuild.ComputeType getComputeType();
    /**
     * The type of compute to use for this build.
     * See the {@link ComputeType} enum for the possible values.
     * @default taken from {@link #buildImage#defaultComputeType}
     */
    void setComputeType(final software.amazon.awscdk.services.codebuild.ComputeType value);
    /**
     * The environment variables that your builds can use.
     */
    java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables();
    /**
     * The environment variables that your builds can use.
     */
    void setEnvironmentVariables(final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> value);
    /**
     * Indicates how the project builds Docker images. Specify true to enable
     * running the Docker daemon inside a Docker container. This value must be
     * set to true only if this build project will be used to build Docker
     * images, and the specified build environment image is not one provided by
     * AWS CodeBuild with Docker support. Otherwise, all associated builds that
     * attempt to interact with the Docker daemon will fail.
     * @default false
     */
    java.lang.Boolean getPrivileged();
    /**
     * Indicates how the project builds Docker images. Specify true to enable
     * running the Docker daemon inside a Docker container. This value must be
     * set to true only if this build project will be used to build Docker
     * images, and the specified build environment image is not one provided by
     * AWS CodeBuild with Docker support. Otherwise, all associated builds that
     * attempt to interact with the Docker daemon will fail.
     * @default false
     */
    void setPrivileged(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link BuildEnvironment}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BuildEnvironment}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codebuild.IBuildImage _buildImage;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codebuild.ComputeType _computeType;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> _environmentVariables;
        @javax.annotation.Nullable
        private java.lang.Boolean _privileged;

        /**
         * Sets the value of BuildImage
         * @param value The image used for the builds.
         * @return {@code this}
         */
        public Builder withBuildImage(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.IBuildImage value) {
            this._buildImage = value;
            return this;
        }
        /**
         * Sets the value of ComputeType
         * @param value The type of compute to use for this build.
See the {@link ComputeType} enum for the possible values.
         * @return {@code this}
         */
        public Builder withComputeType(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.ComputeType value) {
            this._computeType = value;
            return this;
        }
        /**
         * Sets the value of EnvironmentVariables
         * @param value The environment variables that your builds can use.
         * @return {@code this}
         */
        public Builder withEnvironmentVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> value) {
            this._environmentVariables = value;
            return this;
        }
        /**
         * Sets the value of Privileged
         * @param value Indicates how the project builds Docker images. Specify true to enable
running the Docker daemon inside a Docker container. This value must be
set to true only if this build project will be used to build Docker
images, and the specified build environment image is not one provided by
AWS CodeBuild with Docker support. Otherwise, all associated builds that
attempt to interact with the Docker daemon will fail.
         * @return {@code this}
         */
        public Builder withPrivileged(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._privileged = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BuildEnvironment}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BuildEnvironment build() {
            return new BuildEnvironment() {
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codebuild.IBuildImage $buildImage = _buildImage;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codebuild.ComputeType $computeType = _computeType;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> $environmentVariables = _environmentVariables;
                @javax.annotation.Nullable
                private java.lang.Boolean $privileged = _privileged;

                @Override
                public software.amazon.awscdk.services.codebuild.IBuildImage getBuildImage() {
                    return this.$buildImage;
                }

                @Override
                public void setBuildImage(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.IBuildImage value) {
                    this.$buildImage = value;
                }

                @Override
                public software.amazon.awscdk.services.codebuild.ComputeType getComputeType() {
                    return this.$computeType;
                }

                @Override
                public void setComputeType(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.ComputeType value) {
                    this.$computeType = value;
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
                    return this.$environmentVariables;
                }

                @Override
                public void setEnvironmentVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> value) {
                    this.$environmentVariables = value;
                }

                @Override
                public java.lang.Boolean getPrivileged() {
                    return this.$privileged;
                }

                @Override
                public void setPrivileged(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$privileged = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.BuildEnvironment {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The image used for the builds.
         * @default LinuxBuildImage.UBUNTU_14_04_BASE
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codebuild.IBuildImage getBuildImage() {
            return this.jsiiGet("buildImage", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        }

        /**
         * The image used for the builds.
         * @default LinuxBuildImage.UBUNTU_14_04_BASE
         */
        @Override
        public void setBuildImage(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.IBuildImage value) {
            this.jsiiSet("buildImage", value);
        }

        /**
         * The type of compute to use for this build.
         * See the {@link ComputeType} enum for the possible values.
         * @default taken from {@link #buildImage#defaultComputeType}
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codebuild.ComputeType getComputeType() {
            return this.jsiiGet("computeType", software.amazon.awscdk.services.codebuild.ComputeType.class);
        }

        /**
         * The type of compute to use for this build.
         * See the {@link ComputeType} enum for the possible values.
         * @default taken from {@link #buildImage#defaultComputeType}
         */
        @Override
        public void setComputeType(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.ComputeType value) {
            this.jsiiSet("computeType", value);
        }

        /**
         * The environment variables that your builds can use.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
            return this.jsiiGet("environmentVariables", java.util.Map.class);
        }

        /**
         * The environment variables that your builds can use.
         */
        @Override
        public void setEnvironmentVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> value) {
            this.jsiiSet("environmentVariables", value);
        }

        /**
         * Indicates how the project builds Docker images. Specify true to enable
         * running the Docker daemon inside a Docker container. This value must be
         * set to true only if this build project will be used to build Docker
         * images, and the specified build environment image is not one provided by
         * AWS CodeBuild with Docker support. Otherwise, all associated builds that
         * attempt to interact with the Docker daemon will fail.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPrivileged() {
            return this.jsiiGet("privileged", java.lang.Boolean.class);
        }

        /**
         * Indicates how the project builds Docker images. Specify true to enable
         * running the Docker daemon inside a Docker container. This value must be
         * set to true only if this build project will be used to build Docker
         * images, and the specified build environment image is not one provided by
         * AWS CodeBuild with Docker support. Otherwise, all associated builds that
         * attempt to interact with the Docker daemon will fail.
         * @default false
         */
        @Override
        public void setPrivileged(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("privileged", value);
        }
    }
}
