package software.amazon.awscdk.services.codebuild;

/**
 * Represents a Docker image used for the CodeBuild Project builds.
 * Use the concrete subclasses, either:
 * {@link LinuxBuildImage} or {@link WindowsBuildImage}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.155Z")
public interface IBuildImage extends software.amazon.jsii.JsiiSerializable {
    /**
     * The default {@link ComputeType} to use with this image,
     * if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     */
    software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType();
    /**
     * The Docker image identifier that the build environment uses.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
     */
    java.lang.String getImageId();
    /**
     * The type of build environment.
     */
    java.lang.String getType();
    /**
     * Make a buildspec to run the indicated script
     */
    java.lang.Object runScriptBuildspec(final java.lang.String entrypoint);
    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * @param buildEnvironment the current build environment
     */
    java.util.List<java.lang.String> validate(final software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The default {@link ComputeType} to use with this image,
         * if one was not specified in {@link BuildEnvironment#computeType} explicitly.
         */
        @Override
        public software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
            return this.jsiiGet("defaultComputeType", software.amazon.awscdk.services.codebuild.ComputeType.class);
        }

        /**
         * The Docker image identifier that the build environment uses.
         * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
         */
        @Override
        public java.lang.String getImageId() {
            return this.jsiiGet("imageId", java.lang.String.class);
        }

        /**
         * The type of build environment.
         */
        @Override
        public java.lang.String getType() {
            return this.jsiiGet("type", java.lang.String.class);
        }

        /**
         * Make a buildspec to run the indicated script
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object runScriptBuildspec(final java.lang.String entrypoint) {
            return this.jsiiCall("runScriptBuildspec", java.lang.Object.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(entrypoint, "entrypoint is required")).toArray());
        }

        /**
         * Allows the image a chance to validate whether the passed configuration is correct.
         * @param buildEnvironment the current build environment
         */
        @Override
        public java.util.List<java.lang.String> validate(final software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
            return this.jsiiCall("validate", java.util.List.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required")).toArray());
        }
    }
}
