package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running Linux.
 * This class has a bunch of public constants that represent the most popular images.
 * If you need to use with an image that isn't in the named constants,
 * you can always instantiate it directly.
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.156Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.LinuxBuildImage")
public class LinuxBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {
    protected LinuxBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        UBUNTU_14_04_ANDROID_JAV_A8_24_4_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_ANDROID_JAVA8_24_4_1", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_ANDROID_JAV_A8_26_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_ANDROID_JAVA8_26_1_1", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_BASE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_BASE", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_DOCKER_17_09_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOCKER_17_09_0", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_DOTNET_CORE_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOTNET_CORE_1_1", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_DOTNET_CORE_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOTNET_CORE_2_0", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_DOTNET_CORE_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOTNET_CORE_2_1", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_GOLANG_1_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_GOLANG_1_10", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_NODEJS_10_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_NODEJS_10_1_0", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_NODEJS_6_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_NODEJS_6_3_1", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_NODEJS_8_11_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_NODEJS_8_11_0", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_OPEN_JDK_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_OPEN_JDK_8", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_OPEN_JDK_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_OPEN_JDK_9", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_PHP_5_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PHP_5_6", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_PHP_7_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PHP_7_0", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_PYTHON_2_7_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_2_7_12", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_PYTHON_3_3_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_3_6", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_PYTHON_3_4_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_4_5", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_PYTHON_3_5_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_5_2", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_PYTHON_3_6_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_6_5", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_RUBY_2_2_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_RUBY_2_2_5", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_RUBY_2_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_RUBY_2_3_1", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
        UBUNTU_14_04_RUBY_2_5_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_RUBY_2_5_1", software.amazon.awscdk.services.codebuild.LinuxBuildImage.class);
    }
    public LinuxBuildImage(final java.lang.String imageId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.of(java.util.Objects.requireNonNull(imageId, "imageId is required")).toArray());
    }

    /**
     * Make a buildspec to run the indicated script
     */
    @Override
    @javax.annotation.Nullable
    public java.lang.Object runScriptBuildspec(final java.lang.String entrypoint) {
        return this.jsiiCall("runScriptBuildspec", java.lang.Object.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(entrypoint, "entrypoint is required")).toArray());
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     */
    @Override
    public java.util.List<java.lang.String> validate(final software.amazon.awscdk.services.codebuild.BuildEnvironment _) {
        return this.jsiiCall("validate", java.util.List.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(_, "_ is required")).toArray());
    }
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_ANDROID_JAV_A8_24_4_1;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_ANDROID_JAV_A8_26_1_1;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_BASE;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_DOCKER_17_09_0;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_DOTNET_CORE_1_1;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_DOTNET_CORE_2_0;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_DOTNET_CORE_2_1;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_GOLANG_1_10;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_NODEJS_10_1_0;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_NODEJS_6_3_1;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_NODEJS_8_11_0;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_OPEN_JDK_8;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_OPEN_JDK_9;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_PHP_5_6;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_PHP_7_0;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_PYTHON_2_7_12;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_PYTHON_3_3_6;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_PYTHON_3_4_5;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_PYTHON_3_5_2;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_PYTHON_3_6_5;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_RUBY_2_2_5;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_RUBY_2_3_1;
    public final static software.amazon.awscdk.services.codebuild.LinuxBuildImage UBUNTU_14_04_RUBY_2_5_1;

    /**
     * The default {@link ComputeType} to use with this image,
     * if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     */
    @Override
    public software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return this.jsiiGet("defaultComputeType", software.amazon.awscdk.services.codebuild.ComputeType.class);
    }

    @Override
    public java.lang.String getImageId() {
        return this.jsiiGet("imageId", java.lang.String.class);
    }

    /**
     * The type of build environment.
     */
    @Override
    public java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }
}
