package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties of the {@link PipelineBuildAction CodeBuild build CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.158Z")
public interface PipelineBuildActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.CommonPipelineBuildActionProps, software.amazon.awscdk.services.codepipeline.api.CommonActionConstructProps {
    /**
     * The build project
     */
    software.amazon.awscdk.services.codebuild.ProjectRef getProject();
    /**
     * The build project
     */
    void setProject(final software.amazon.awscdk.services.codebuild.ProjectRef value);

    /**
     * @return a {@link Builder} of {@link PipelineBuildActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineBuildActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codebuild.ProjectRef _project;
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.String _artifactName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of Project
         * @param value The build project
         * @return {@code this}
         */
        public Builder withProject(final software.amazon.awscdk.services.codebuild.ProjectRef value) {
            this._project = java.util.Objects.requireNonNull(value, "project is required");
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for this build
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of ArtifactName
         * @param value The name of the build's output artifact
         * @return {@code this}
         */
        public Builder withArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this._artifactName = value;
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineBuildActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineBuildActionProps build() {
            return new PipelineBuildActionProps() {
                private software.amazon.awscdk.services.codebuild.ProjectRef $project = java.util.Objects.requireNonNull(_project, "project is required");
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                @javax.annotation.Nullable
                private java.lang.String $artifactName = _artifactName;
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public software.amazon.awscdk.services.codebuild.ProjectRef getProject() {
                    return this.$project;
                }

                @Override
                public void setProject(final software.amazon.awscdk.services.codebuild.ProjectRef value) {
                    this.$project = java.util.Objects.requireNonNull(value, "project is required");
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
                }

                @Override
                public java.lang.String getArtifactName() {
                    return this.$artifactName;
                }

                @Override
                public void setArtifactName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$artifactName = value;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.PipelineBuildActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The build project
         */
        @Override
        public software.amazon.awscdk.services.codebuild.ProjectRef getProject() {
            return this.jsiiGet("project", software.amazon.awscdk.services.codebuild.ProjectRef.class);
        }

        /**
         * The build project
         */
        @Override
        public void setProject(final software.amazon.awscdk.services.codebuild.ProjectRef value) {
            this.jsiiSet("project", java.util.Objects.requireNonNull(value, "project is required"));
        }

        /**
         * The source to use as input for this build
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for this build
         */
        @Override
        public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", java.util.Objects.requireNonNull(value, "inputArtifact is required"));
        }

        /**
         * The name of the build's output artifact
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getArtifactName() {
            return this.jsiiGet("artifactName", java.lang.String.class);
        }

        /**
         * The name of the build's output artifact
         */
        @Override
        public void setArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("artifactName", value);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
