package software.amazon.awscdk.services.codebuild;

/**
 * Represents a reference to a CodeBuild Project.
 * 
 * If you're managing the Project alongside the rest of your CDK resources,
 * use the {@link Project} class.
 * 
 * If you want to reference an already existing Project
 * (or one defined in a different CDK Stack),
 * use the {@link import} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.161Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.ProjectRef")
public abstract class ProjectRef extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.events.IEventRuleTarget {
    protected ProjectRef(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Import a Project defined either outside the CDK,
     * or in a different CDK Stack
     * (and exported using the {@link export} method).
     * @note if you're importing a CodeBuild Project for use in a CodePipeline, make sure the existing Project has permissions to access the S3 Bucket of that Pipeline - otherwise, builds in that Pipeline will always fail.
     * @return a reference to the existing Project
     * @param parent the parent Construct for this Construct
     * @param name the logical name of this Construct
     * @param props the properties of the referenced Project
     */
    public static software.amazon.awscdk.services.codebuild.ProjectRef import_(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.codebuild.ProjectRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.ProjectRef.class, "import", software.amazon.awscdk.services.codebuild.ProjectRef.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Convenience method for creating a new {@link PipelineBuildAction} build Action,
     * and adding it to the given Stage.
     * @return the newly created {@link PipelineBuildAction} build Action
     * @param stage the Pipeline Stage to add the new Action to
     * @param name the name of the newly created Action
     * @param props the properties of the new Action
     */
    public software.amazon.awscdk.services.codebuild.PipelineBuildAction addBuildToPipeline(final software.amazon.awscdk.services.codepipeline.api.IStage stage, final java.lang.String name, final software.amazon.awscdk.services.codebuild.CommonPipelineBuildActionProps props) {
        return this.jsiiCall("addBuildToPipeline", software.amazon.awscdk.services.codebuild.PipelineBuildAction.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(stage, "stage is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Allows using build projects as event rule targets.
     */
    @Override
    public software.amazon.awscdk.services.events.EventRuleTargetProps asEventRuleTarget(final java.lang.String _ruleArn, final java.lang.String _ruleId) {
        return this.jsiiCall("asEventRuleTarget", software.amazon.awscdk.services.events.EventRuleTargetProps.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(_ruleArn, "_ruleArn is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(_ruleId, "_ruleId is required"))).toArray());
    }

    /**
     * Export this Project. Allows referencing this Project in a different CDK Stack.
     */
    public software.amazon.awscdk.services.codebuild.ProjectRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.codebuild.ProjectRefProps.class);
    }

    /**
     * @return a CloudWatch metric associated with this build project.
     * @param metricName The name of the metric
     * @param props Customization properties
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Measures the number of builds triggered.
     * 
     * Units: Count
     * 
     * Valid CloudWatch statistics: Sum
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricBuilds(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricBuilds", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Measures the number of builds triggered.
     * 
     * Units: Count
     * 
     * Valid CloudWatch statistics: Sum
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricBuilds() {
        return this.jsiiCall("metricBuilds", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Measures the duration of all builds over time.
     * 
     * Units: Seconds
     * 
     * Valid CloudWatch statistics: Average (recommended), Maximum, Minimum
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricDuration(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricDuration", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Measures the duration of all builds over time.
     * 
     * Units: Seconds
     * 
     * Valid CloudWatch statistics: Average (recommended), Maximum, Minimum
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricDuration() {
        return this.jsiiCall("metricDuration", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Measures the number of builds that failed because of client error or
     * because of a timeout.
     * 
     * Units: Count
     * 
     * Valid CloudWatch statistics: Sum
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricFailedBuilds(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricFailedBuilds", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Measures the number of builds that failed because of client error or
     * because of a timeout.
     * 
     * Units: Count
     * 
     * Valid CloudWatch statistics: Sum
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricFailedBuilds() {
        return this.jsiiCall("metricFailedBuilds", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Measures the number of successful builds.
     * 
     * Units: Count
     * 
     * Valid CloudWatch statistics: Sum
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricSucceededBuilds(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricSucceededBuilds", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Measures the number of successful builds.
     * 
     * Units: Count
     * 
     * Valid CloudWatch statistics: Sum
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricSucceededBuilds() {
        return this.jsiiCall("metricSucceededBuilds", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Defines an event rule which triggers when a build fails.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildFailed(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.EventRuleProps options) {
        return this.jsiiCall("onBuildFailed", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(options)).toArray());
    }

    /**
     * Defines an event rule which triggers when a build fails.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildFailed(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        return this.jsiiCall("onBuildFailed", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)).toArray());
    }

    /**
     * Defines an event rule which triggers when a build fails.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildFailed(final java.lang.String name) {
        return this.jsiiCall("onBuildFailed", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
    }

    /**
     * Defines an event rule which triggers when a build starts.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildStarted(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.EventRuleProps options) {
        return this.jsiiCall("onBuildStarted", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(options)).toArray());
    }

    /**
     * Defines an event rule which triggers when a build starts.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildStarted(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        return this.jsiiCall("onBuildStarted", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)).toArray());
    }

    /**
     * Defines an event rule which triggers when a build starts.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildStarted(final java.lang.String name) {
        return this.jsiiCall("onBuildStarted", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
    }

    /**
     * Defines an event rule which triggers when a build completes successfully.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildSucceeded(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.EventRuleProps options) {
        return this.jsiiCall("onBuildSucceeded", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(options)).toArray());
    }

    /**
     * Defines an event rule which triggers when a build completes successfully.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildSucceeded(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        return this.jsiiCall("onBuildSucceeded", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)).toArray());
    }

    /**
     * Defines an event rule which triggers when a build completes successfully.
     */
    public software.amazon.awscdk.services.events.EventRule onBuildSucceeded(final java.lang.String name) {
        return this.jsiiCall("onBuildSucceeded", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
    }

    /**
     * Defines a CloudWatch event rule that triggers upon phase change of this
     * build project.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     */
    public software.amazon.awscdk.services.events.EventRule onPhaseChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.EventRuleProps options) {
        return this.jsiiCall("onPhaseChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(options)).toArray());
    }

    /**
     * Defines a CloudWatch event rule that triggers upon phase change of this
     * build project.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     */
    public software.amazon.awscdk.services.events.EventRule onPhaseChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        return this.jsiiCall("onPhaseChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)).toArray());
    }

    /**
     * Defines a CloudWatch event rule that triggers upon phase change of this
     * build project.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     */
    public software.amazon.awscdk.services.events.EventRule onPhaseChange(final java.lang.String name) {
        return this.jsiiCall("onPhaseChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
    }

    /**
     * Defines a CloudWatch event rule triggered when the build project state
     * changes. You can filter specific build status events using an event
     * pattern filter on the `build-status` detail field:
     * 
     *     const rule = project.onStateChange('OnBuildStarted', target);
     *     rule.addEventPattern({
     *       detail: {
     *         'build-status': [
     *           "IN_PROGRESS",
     *           "SUCCEEDED",
     *           "FAILED",
     *           "STOPPED"
     *         ]
     *       }
     *     });
     * 
     * You can also use the methods `onBuildFailed` and `onBuildSucceeded` to define rules for
     * these specific state changes.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     */
    public software.amazon.awscdk.services.events.EventRule onStateChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.EventRuleProps options) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(options)).toArray());
    }

    /**
     * Defines a CloudWatch event rule triggered when the build project state
     * changes. You can filter specific build status events using an event
     * pattern filter on the `build-status` detail field:
     * 
     *     const rule = project.onStateChange('OnBuildStarted', target);
     *     rule.addEventPattern({
     *       detail: {
     *         'build-status': [
     *           "IN_PROGRESS",
     *           "SUCCEEDED",
     *           "FAILED",
     *           "STOPPED"
     *         ]
     *       }
     *     });
     * 
     * You can also use the methods `onBuildFailed` and `onBuildSucceeded` to define rules for
     * these specific state changes.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     */
    public software.amazon.awscdk.services.events.EventRule onStateChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)).toArray());
    }

    /**
     * Defines a CloudWatch event rule triggered when the build project state
     * changes. You can filter specific build status events using an event
     * pattern filter on the `build-status` detail field:
     * 
     *     const rule = project.onStateChange('OnBuildStarted', target);
     *     rule.addEventPattern({
     *       detail: {
     *         'build-status': [
     *           "IN_PROGRESS",
     *           "SUCCEEDED",
     *           "FAILED",
     *           "STOPPED"
     *         ]
     *       }
     *     });
     * 
     * You can also use the methods `onBuildFailed` and `onBuildSucceeded` to define rules for
     * these specific state changes.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     */
    public software.amazon.awscdk.services.events.EventRule onStateChange(final java.lang.String name) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
    }

    /**
     * The ARN of this Project.
     */
    public java.lang.String getProjectArn() {
        return this.jsiiGet("projectArn", java.lang.String.class);
    }

    /**
     * The human-visible name of this Project.
     */
    public java.lang.String getProjectName() {
        return this.jsiiGet("projectName", java.lang.String.class);
    }

    /**
     * The IAM service Role of this Project. Undefined for imported Projects.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.Role getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codebuild.ProjectRef {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of this Project.
         */
        @Override
        public java.lang.String getProjectArn() {
            return this.jsiiGet("projectArn", java.lang.String.class);
        }

        /**
         * The human-visible name of this Project.
         */
        @Override
        public java.lang.String getProjectName() {
            return this.jsiiGet("projectName", java.lang.String.class);
        }

        /**
         * The IAM service Role of this Project. Undefined for imported Projects.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }

        /**
         * Returns the rule target specification.
         * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
         * @param ruleArn The ARN of the CloudWatch Event Rule that would trigger this target.
         * @param ruleUniqueId A unique ID for this rule. Can be used to implement idempotency.
         */
        @Override
        public software.amazon.awscdk.services.events.EventRuleTargetProps asEventRuleTarget(final java.lang.String ruleArn, final java.lang.String ruleUniqueId) {
            return this.jsiiCall("asEventRuleTarget", software.amazon.awscdk.services.events.EventRuleTargetProps.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(ruleArn, "ruleArn is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(ruleUniqueId, "ruleUniqueId is required"))).toArray());
        }
    }
}
