package software.amazon.awscdk.services.codebuild;

/**
 * Properties of a reference to a CodeBuild Project.
 * @see ProjectRef.export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.163Z")
public interface ProjectRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The human-readable name of the CodeBuild Project we're referencing.
     * The Project must be in the same account and region as the root Stack.
     */
    java.lang.String getProjectName();
    /**
     * The human-readable name of the CodeBuild Project we're referencing.
     * The Project must be in the same account and region as the root Stack.
     */
    void setProjectName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link ProjectRefProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ProjectRefProps}
     */
    final class Builder {
        private java.lang.String _projectName;

        /**
         * Sets the value of ProjectName
         * @param value The human-readable name of the CodeBuild Project we're referencing.
The Project must be in the same account and region as the root Stack.
         * @return {@code this}
         */
        public Builder withProjectName(final java.lang.String value) {
            this._projectName = java.util.Objects.requireNonNull(value, "projectName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProjectRefProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ProjectRefProps build() {
            return new ProjectRefProps() {
                private java.lang.String $projectName = java.util.Objects.requireNonNull(_projectName, "projectName is required");

                @Override
                public java.lang.String getProjectName() {
                    return this.$projectName;
                }

                @Override
                public void setProjectName(final java.lang.String value) {
                    this.$projectName = java.util.Objects.requireNonNull(value, "projectName is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.ProjectRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The human-readable name of the CodeBuild Project we're referencing.
         * The Project must be in the same account and region as the root Stack.
         */
        @Override
        public java.lang.String getProjectName() {
            return this.jsiiGet("projectName", java.lang.String.class);
        }

        /**
         * The human-readable name of the CodeBuild Project we're referencing.
         * The Project must be in the same account and region as the root Stack.
         */
        @Override
        public void setProjectName(final java.lang.String value) {
            this.jsiiSet("projectName", java.util.Objects.requireNonNull(value, "projectName is required"));
        }
    }
}
