package software.amazon.awscdk.services.codebuild;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.163Z")
public interface S3BucketBuildArtifactsProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the output bucket.
     */
    software.amazon.awscdk.services.s3.BucketRef getBucket();
    /**
     * The name of the output bucket.
     */
    void setBucket(final software.amazon.awscdk.services.s3.BucketRef value);
    /**
     * The name of the build output ZIP file or folder inside the bucket.
     * 
     * The full S3 object key will be "<path>/build-ID/<name>" or
     * "<path>/<artifactsName>" depending on whether `includeBuildId` is set to true.
     */
    java.lang.String getName();
    /**
     * The name of the build output ZIP file or folder inside the bucket.
     * 
     * The full S3 object key will be "<path>/build-ID/<name>" or
     * "<path>/<artifactsName>" depending on whether `includeBuildId` is set to true.
     */
    void setName(final java.lang.String value);
    /**
     * Indicates if the build ID should be included in the path. If this is set to true,
     * then the build artifact will be stored in "<path>/<build-id>/<name>".
     * @default true
     */
    java.lang.Boolean getIncludeBuildId();
    /**
     * Indicates if the build ID should be included in the path. If this is set to true,
     * then the build artifact will be stored in "<path>/<build-id>/<name>".
     * @default true
     */
    void setIncludeBuildId(final java.lang.Boolean value);
    /**
     * If this is true, all build output will be packaged into a single .zip file.
     * Otherwise, all files will be uploaded to <path>/<name>
     * @default true - files will be archived
     */
    java.lang.Boolean getPackageZip();
    /**
     * If this is true, all build output will be packaged into a single .zip file.
     * Otherwise, all files will be uploaded to <path>/<name>
     * @default true - files will be archived
     */
    void setPackageZip(final java.lang.Boolean value);
    /**
     * The path inside of the bucket for the build output .zip file or folder.
     * If a value is not specified, then build output will be stored at the root of the
     * bucket (or under the <build-id> directory if `includeBuildId` is set to true).
     */
    java.lang.String getPath();
    /**
     * The path inside of the bucket for the build output .zip file or folder.
     * If a value is not specified, then build output will be stored at the root of the
     * bucket (or under the <build-id> directory if `includeBuildId` is set to true).
     */
    void setPath(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link S3BucketBuildArtifactsProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link S3BucketBuildArtifactsProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.BucketRef _bucket;
        private java.lang.String _name;
        @javax.annotation.Nullable
        private java.lang.Boolean _includeBuildId;
        @javax.annotation.Nullable
        private java.lang.Boolean _packageZip;
        @javax.annotation.Nullable
        private java.lang.String _path;

        /**
         * Sets the value of Bucket
         * @param value The name of the output bucket.
         * @return {@code this}
         */
        public Builder withBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
            this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
            return this;
        }
        /**
         * Sets the value of Name
         * @param value The name of the build output ZIP file or folder inside the bucket.

The full S3 object key will be "<path>/build-ID/<name>" or
"<path>/<artifactsName>" depending on whether `includeBuildId` is set to true.
         * @return {@code this}
         */
        public Builder withName(final java.lang.String value) {
            this._name = java.util.Objects.requireNonNull(value, "name is required");
            return this;
        }
        /**
         * Sets the value of IncludeBuildId
         * @param value Indicates if the build ID should be included in the path. If this is set to true,
then the build artifact will be stored in "<path>/<build-id>/<name>".
         * @return {@code this}
         */
        public Builder withIncludeBuildId(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._includeBuildId = value;
            return this;
        }
        /**
         * Sets the value of PackageZip
         * @param value If this is true, all build output will be packaged into a single .zip file.
Otherwise, all files will be uploaded to <path>/<name>
         * @return {@code this}
         */
        public Builder withPackageZip(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._packageZip = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path inside of the bucket for the build output .zip file or folder.
If a value is not specified, then build output will be stored at the root of the
bucket (or under the <build-id> directory if `includeBuildId` is set to true).
         * @return {@code this}
         */
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3BucketBuildArtifactsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public S3BucketBuildArtifactsProps build() {
            return new S3BucketBuildArtifactsProps() {
                private software.amazon.awscdk.services.s3.BucketRef $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                private java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $includeBuildId = _includeBuildId;
                @javax.annotation.Nullable
                private java.lang.Boolean $packageZip = _packageZip;
                @javax.annotation.Nullable
                private java.lang.String $path = _path;

                @Override
                public software.amazon.awscdk.services.s3.BucketRef getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
                    this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public void setName(final java.lang.String value) {
                    this.$name = java.util.Objects.requireNonNull(value, "name is required");
                }

                @Override
                public java.lang.Boolean getIncludeBuildId() {
                    return this.$includeBuildId;
                }

                @Override
                public void setIncludeBuildId(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$includeBuildId = value;
                }

                @Override
                public java.lang.Boolean getPackageZip() {
                    return this.$packageZip;
                }

                @Override
                public void setPackageZip(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$packageZip = value;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$path = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.S3BucketBuildArtifactsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the output bucket.
         */
        @Override
        public software.amazon.awscdk.services.s3.BucketRef getBucket() {
            return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.BucketRef.class);
        }

        /**
         * The name of the output bucket.
         */
        @Override
        public void setBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
            this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
        }

        /**
         * The name of the build output ZIP file or folder inside the bucket.
         * 
         * The full S3 object key will be "<path>/build-ID/<name>" or
         * "<path>/<artifactsName>" depending on whether `includeBuildId` is set to true.
         */
        @Override
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * The name of the build output ZIP file or folder inside the bucket.
         * 
         * The full S3 object key will be "<path>/build-ID/<name>" or
         * "<path>/<artifactsName>" depending on whether `includeBuildId` is set to true.
         */
        @Override
        public void setName(final java.lang.String value) {
            this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
        }

        /**
         * Indicates if the build ID should be included in the path. If this is set to true,
         * then the build artifact will be stored in "<path>/<build-id>/<name>".
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getIncludeBuildId() {
            return this.jsiiGet("includeBuildID", java.lang.Boolean.class);
        }

        /**
         * Indicates if the build ID should be included in the path. If this is set to true,
         * then the build artifact will be stored in "<path>/<build-id>/<name>".
         * @default true
         */
        @Override
        public void setIncludeBuildId(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("includeBuildID", value);
        }

        /**
         * If this is true, all build output will be packaged into a single .zip file.
         * Otherwise, all files will be uploaded to <path>/<name>
         * @default true - files will be archived
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPackageZip() {
            return this.jsiiGet("packageZip", java.lang.Boolean.class);
        }

        /**
         * If this is true, all build output will be packaged into a single .zip file.
         * Otherwise, all files will be uploaded to <path>/<name>
         * @default true - files will be archived
         */
        @Override
        public void setPackageZip(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("packageZip", value);
        }

        /**
         * The path inside of the bucket for the build output .zip file or folder.
         * If a value is not specified, then build output will be stored at the root of the
         * bucket (or under the <build-id> directory if `includeBuildId` is set to true).
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * The path inside of the bucket for the build output .zip file or folder.
         * If a value is not specified, then build output will be stored at the root of the
         * bucket (or under the <build-id> directory if `includeBuildId` is set to true).
         */
        @Override
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }
    }
}
