package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running Windows.
 * This class has a bunch of public constants that represent the most popular images.
 * If you need to use with an image that isn't in the named constants,
 * you can always instantiate it directly.
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.164Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.WindowsBuildImage")
public class WindowsBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {
    protected WindowsBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        WIN_SERVER_CORE_2016_BASE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "WIN_SERVER_CORE_2016_BASE", software.amazon.awscdk.services.codebuild.WindowsBuildImage.class);
    }
    public WindowsBuildImage(final java.lang.String imageId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.of(java.util.Objects.requireNonNull(imageId, "imageId is required")).toArray());
    }

    /**
     * Make a buildspec to run the indicated script
     */
    @Override
    @javax.annotation.Nullable
    public java.lang.Object runScriptBuildspec(final java.lang.String entrypoint) {
        return this.jsiiCall("runScriptBuildspec", java.lang.Object.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(entrypoint, "entrypoint is required")).toArray());
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     */
    @Override
    public java.util.List<java.lang.String> validate(final software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
        return this.jsiiCall("validate", java.util.List.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required")).toArray());
    }
    public final static software.amazon.awscdk.services.codebuild.WindowsBuildImage WIN_SERVER_CORE_2016_BASE;

    /**
     * The default {@link ComputeType} to use with this image,
     * if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     */
    @Override
    public software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return this.jsiiGet("defaultComputeType", software.amazon.awscdk.services.codebuild.ComputeType.class);
    }

    @Override
    public java.lang.String getImageId() {
        return this.jsiiGet("imageId", java.lang.String.class);
    }

    /**
     * The type of build environment.
     */
    @Override
    public java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }
}
